/*
 * 
 * Licensed Materials - Property of IBM
 *
 * Open Platform Trust Services - An open source TCG PTS
 *
 * (C) Copyright International Business Machines Corp. 2007
 *
 */
package com.ibm.trl.tcg.pts.vulnerability.deb;

import java.sql.SQLException;
import java.sql.Timestamp;

import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML.Tag;
import javax.swing.text.html.HTMLEditorKit.ParserCallback;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.ibatis.sqlmap.client.SqlMapClient;
import com.ibm.trl.tcg.pts.ibatis.SqlConfigVul;
import com.ibm.trl.tcg.pts.ibatis.dto.Debians;

/**
 * Parse metadata of Debian Security Advisory (2000-2007). This class is used in
 * GetInsertDebianInfo.
 * 
 * @author Megumi Nakamura
 */
public class DebianListParser extends ParserCallback {

	/* Logger */
	private Log log = LogFactory.getLog(this.getClass());

	private boolean start = false;

	private boolean end = false;

	private boolean oneline = false;

	private String urlBase = null;

	private Debians debians = null;

	private SqlMapClient sqlMapVul = SqlConfigVul.getSqlMapInstance();

	/**
	 * Constructor.
	 * 
	 * @param urlBase
	 *            http://www.debian.org/security/YEAR/, YEAR is from 2000 to
	 *            2007
	 */
	public DebianListParser(String urlBase) {
		super();
		this.urlBase = urlBase;

		end = false;
		start = false;
		oneline = false;
	}

	/**
	 * start tag handler of ParserCallback.
	 */
	public void handleStartTag(Tag tag, MutableAttributeSet attr, int pos) {
		if (tag.toString().equalsIgnoreCase("h1")) {
			start = true;
			if (log.isDebugEnabled()) {
				log.debug("START=true");
			}

			try {
				sqlMapVul.startTransaction();
			} catch (SQLException ex) {
				do {
					log.error("SQLSTATE: " + ex.getSQLState());
					log.error("ERR-CODE: " + ex.getErrorCode());
					log.error("ERR-MSEG: " + ex.getMessage());
					ex = ex.getNextException();
				} while (null != ex);
			}
		}
	}

	/**
	 * end tag handler of ParserCallback.
	 */
	public void handleEndTag(Tag tag, int pos) {
	}

	/**
	 * simple tag handler of ParserCallback.
	 */
	public void handleSimpleTag(Tag tag, MutableAttributeSet attr, int pos) {
		if (start && tag.toString().equalsIgnoreCase("br")) {
			oneline = false;
			if (log.isDebugEnabled()) {
				log.debug("ONE LINE=false");
			}
		}
	}

	/**
	 * text handler of ParserCallback.
	 */
	public void handleText(char[] data, int pos) {
		String dataString = new String(data);

		if (log.isDebugEnabled()) {
			log.debug("NEW " + dataString);
		}

		if (start) {
			if (data[0] == '[') { // Date
				dataString = dataString.substring(1, dataString.length() - 1);
				debians = new Debians();
				debians.setDebianReportedOn(changeDateFormat(dataString));
				oneline = true;
				if (log.isDebugEnabled()) {
					log.debug("DATE "
							+ debians.getDebianReportedOn().toString());
				}
			} else if (oneline && data[0] == 'D' && data[1] == 'S'
					&& data[2] == 'A') { // DSA-ID, PackageName
				String[] idpkg = dataString.split(" ");
				debians.setDebianDsaId(idpkg[0]);
				if (urlBase.indexOf("2000") > 0) {
					if (idpkg[0].equalsIgnoreCase("DSA-010")) {
						debians.setDebianUrl(urlBase + "20001225b");
					} else if (idpkg[0].equalsIgnoreCase("DSA-009")) {
						debians.setDebianUrl(urlBase + "20001225a");
					} else if (idpkg[0].equalsIgnoreCase("DSA-008")) {
						debians.setDebianUrl(urlBase + "20001225");
					} else if (idpkg[0].equalsIgnoreCase("DSA-007")) {
						debians.setDebianUrl(urlBase + "20001220");
					} else if (idpkg[0].equalsIgnoreCase("DSA-006")) {
						debians.setDebianUrl(urlBase + "20001219");
					} else if (idpkg[0].equalsIgnoreCase("DSA-005")) {
						debians.setDebianUrl(urlBase + "20001217a");
					} else if (idpkg[0].equalsIgnoreCase("DSA-004")) {
						debians.setDebianUrl(urlBase + "20001217");
					} else if (idpkg[0].equalsIgnoreCase("DSA-003")) {
						debians.setDebianUrl(urlBase + "20001201");
					} else if (idpkg[0].equalsIgnoreCase("DSA-002")) {
						debians.setDebianUrl(urlBase + "20001130");
					} else if (idpkg[0].equalsIgnoreCase("DSA-001")) {
						debians.setDebianUrl(urlBase + "20001129");
					}
				} else {
					debians.setDebianUrl(urlBase + idpkg[0].toLowerCase());
				}
				debians.setDebianPackageName(idpkg[1]);
			} else if (oneline) {
				if (dataString.indexOf("- ") > 0) {
					dataString = dataString.substring(3);
					debians.setDebianSummary(dataString);
					try {
						sqlMapVul.insert("insertDebianFromList", debians);
						sqlMapVul.commitTransaction();
						if (log.isDebugEnabled()) {
							log.debug("IIDB " + debians.getDebianPackageName()
									+ " " + debians.getDebianDsaId());
						}

					} catch (SQLException ex) {
						do {
							log.error("SQLSTATE: " + ex.getSQLState());
							log.error("ERR-CODE: " + ex.getErrorCode());
							log.error("ERR-MSEG: " + ex.getMessage());
							ex = ex.getNextException();
						} while (null != ex);
					}
				} else {
					if (log.isDebugEnabled()) {
						log.debug("NG? " + dataString);
					}
				}
			} else if (start && !end) {
				end = true;
				if (log.isDebugEnabled()) {
					log.debug("END=true");
				}
			} else if (start && end) {
				start = false;
				if (log.isDebugEnabled()) {
					log.debug("START=false");
				}
				try {
					sqlMapVul.commitTransaction();
					sqlMapVul.endTransaction();
				} catch (SQLException e) {
					e.printStackTrace();
				}
			}
		}
	}

	/**
	 * Change month of three characters(Jan-Dec) to digit string(01-12).
	 * 
	 * @param orgDate
	 *            The month of three characters(Jan-Dec)
	 * @return The month of digit string(01-12)
	 */
	private Timestamp changeDateFormat(String orgDate) {
		String[] dateArray = orgDate.split(" ");
		if (dateArray[1].equalsIgnoreCase("Jan")) {
			dateArray[1] = "01";
		} else if (dateArray[1].equalsIgnoreCase("Feb")) {
			dateArray[1] = "02";
		} else if (dateArray[1].equalsIgnoreCase("Mar")) {
			dateArray[1] = "03";
		} else if (dateArray[1].equalsIgnoreCase("Apr")) {
			dateArray[1] = "04";
		} else if (dateArray[1].equalsIgnoreCase("May")) {
			dateArray[1] = "05";
		} else if (dateArray[1].equalsIgnoreCase("Jun")) {
			dateArray[1] = "06";
		} else if (dateArray[1].equalsIgnoreCase("Jul")) {
			dateArray[1] = "07";
		} else if (dateArray[1].equalsIgnoreCase("Aug")) {
			dateArray[1] = "08";
		} else if (dateArray[1].equalsIgnoreCase("Sep")) {
			dateArray[1] = "09";
		} else if (dateArray[1].equalsIgnoreCase("Oct")) {
			dateArray[1] = "10";
		} else if (dateArray[1].equalsIgnoreCase("Nov")) {
			dateArray[1] = "11";
		} else if (dateArray[1].equalsIgnoreCase("Dec")) {
			dateArray[1] = "12";
		}
		String date = dateArray[2] + "-" + dateArray[1] + "-" + dateArray[0]
				+ " 00:00:00";
		return Timestamp.valueOf(date);

	}

	/**
	 * comment handler of ParserCallback.
	 */
	public void handleComment(char[] data, int pos) {
	}

}
