/*
 * 
 * Licensed Materials - Property of IBM
 *
 * Open Platform Trust Services - An open source TCG PTS
 *
 * (C) Copyright International Business Machines Corp. 2007
 *
 */
package tcdemo;

import java.io.File;
import java.util.Properties;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SecurityProperties {

	private Properties prop;
	private String lang = "jp";
	//private String propertyFilename = "SecurityProperties.properties";
	private String propertyFilename = "SecurityProperties_ja_JP.xml";

	private String[][] spTable;
	
	public SecurityProperties(String securityPropertiesFilename) throws Exception {
		File file = new File(securityPropertiesFilename);
		if (file.exists()) {
			propertyFilename = securityPropertiesFilename;			
		}
		else {
			throw new Exception("Security Properties " + securityPropertiesFilename + " not exist");
			
		}
	}

	public void init() {
		
	    try {
	        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
	        DocumentBuilder builder = dbf.newDocumentBuilder();
	        Document doc = builder.parse(new File(propertyFilename));
	        Element root = doc.getDocumentElement();

	        NodeList nl = doc.getElementsByTagName("Property");
	        int num = nl.getLength();
			spTable = new String[num][4];
	        for (int i=0;i<num;i++) {
	        	Element p = (Element) nl.item(i);
	        	
	    		spTable[i][0] = p.getAttribute("name");
	    		spTable[i][1] = p.getAttribute("policy");
	    		spTable[i][2] = p.getTextContent();
	    		spTable[i][3] = p.getAttribute("description");
	        	
	        }

	        System.out.print(root.getFirstChild().getNodeValue());
	      } catch (Exception e) {
	        e.printStackTrace();
	      }
		
		
		//int i=0;
		
		/*
		try {
			prop = new Properties();
			prop.load(new FileInputStream(propertyFilename));
			
			int num = new Integer(prop.getProperty("num"));
			spTable = new String[num][4];
			
			for (int i=0;i<num;i++) {
				String urn = prop.getProperty(i + ".urn");
				System.out.println("URN " + urn);

				spTable[i][0] = prop.getProperty(i + ".name." + lang);
				spTable[i][1] = prop.getProperty(i + ".policy." + lang);
				spTable[i][2] = prop.getProperty(i + ".this." + lang);
				spTable[i][3] = prop.getProperty(i + ".description." + lang);
			}
			
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		*/
		
		
		// TODO Auto-generated method stub
		
	}

	public String[][] getSecurityPropertyList() {
		return spTable;
	}

}
