--
-- Create PostgreSQL tables for Integrity Information
--
-- 2007-10-17 Nakamegu
-- 2007-11-01 Munetoh add distributions table
--

CREATE TABLE distributions (
	id SERIAL PRIMARY KEY,
	name VARCHAR(45) NOT NULL DEFAULT 'na',
	version VARCHAR(45) NOT NULL DEFAULT 'na',
	arch VARCHAR(45) NOT NULL DEFAULT 'na',
	vendor VARCHAR(45) NOT NULL DEFAULT 'na',
	build BIGINT NOT NULL DEFAULT 0,
	summary VARCHAR(255) NOT NULL DEFAULT 'na',
	previous_version VARCHAR(45),
	vulnerability INTEGER NOT NULL DEFAULT 0
);

CREATE TABLE packages (
	id SERIAL PRIMARY KEY,
	name VARCHAR(45) NOT NULL DEFAULT 'na',
	version VARCHAR(45) NOT NULL DEFAULT 'na',
	arch VARCHAR(45) DEFAULT 'na',
	vendor VARCHAR(45) NOT NULL DEFAULT 'na',
	build BIGINT NOT NULL DEFAULT 0,
	summary VARCHAR(255) NOT NULL DEFAULT 'na',
	vulnerability INTEGER NOT NULL DEFAULT 0,
	obsolete INTEGER NOT NULL DEFAULT 0,
	behavior_model VARCHAR(255),
	runtime_model VARCHAR(255),
	java_ve_module VARCHAR(255),
	c_ve_module VARCHAR(255),
	oval VARCHAR(255),
	cve VARCHAR(500),
	cvss_min VARCHAR(45) default NULL,
	cvss_max VARCHAR(45) default NULL,
	used_distribution_id VARCHAR(255),
	package_size INTEGER DEFAULT 0,
	package_dependency_num  INTEGER DEFAULT 0,
	package_dependency_name VARCHAR(255),
	rpmreponame VARCHAR(45),
	rpmfilename VARCHAR(255),
	rpmfilepath VARCHAR(255),
	rimmfilename VARCHAR(255),
	rimmfilepath VARCHAR(255)
);

CREATE TABLE measurements (
	id SERIAL PRIMARY KEY,
	digest VARCHAR(40),
	alg VARCHAR(45),
	name VARCHAR(255),
	package_id INTEGER,
	vulnerability INTEGER NOT NULL DEFAULT 0,
	obsolete INTEGER NOT NULL DEFAULT 0
);

CREATE INDEX digest ON measurements USING btree (digest);
CREATE INDEX name ON packages USING btree (name);

GRANT all on distributions to ptsadmin;
GRANT all on distributions_id_seq to ptsadmin;
GRANT all on packages to ptsadmin;
GRANT all on packages_id_seq to ptsadmin;
GRANT all on measurements to ptsadmin;
GRANT all on measurements_id_seq to ptsadmin;

GRANT select on distributions to ptsuser;
GRANT select on distributions_id_seq to ptsuser;
GRANT select on packages to ptsuser;
GRANT select on packages_id_seq to ptsuser;
GRANT select on measurements to ptsuser;
GRANT select on measurements_id_seq to ptsuser;

