--
-- Create PostgreSQL tables for Validation Service
--
-- 2007-10-17 Nakamegu
--

CREATE TABLE users (
	id SERIAL PRIMARY KEY,
	login varchar(80) UNIQUE NOT NULL,
	password varchar(255) NOT NULL
);

CREATE TABLE distributions (
	id SERIAL PRIMARY KEY,
	name varchar(255) NOT NULL,
	short varchar(10) NOT NULL
);

CREATE TABLE architectures (
	id SERIAL PRIMARY KEY,
	name varchar(20) UNIQUE NOT NULL
);

CREATE TABLE vendors (
	id SERIAL PRIMARY KEY,
	name varchar(255) UNIQUE NOT NULL
);

CREATE TABLE platforms (
	id SERIAL PRIMARY KEY,
	vendor_id int NOT NULL,
	name varchar(255),
	model varchar(255) UNIQUE NOT NULL
);

CREATE TABLE bioses (
	id SERIAL PRIMARY KEY,
	bios_ver varchar(45) NOT NULL,
	platform_id int
);


GRANT all on users to ptsadmin;
GRANT all on users_id_seq to ptsadmin;
GRANT all on distributions to ptsadmin;
GRANT all on distributions_id_seq to ptsadmin;
GRANT all on architectures to ptsadmin;
GRANT all on architectures_id_seq to ptsadmin;
GRANT all on vendors to ptsadmin;
GRANT all on vendors_id_seq to ptsadmin;
GRANT all on platforms to ptsadmin;
GRANT all on platforms_id_seq to ptsadmin;
GRANT all on bioses to ptsadmin;
GRANT all on bioses_id_seq to ptsadmin;

GRANT select on users to ptsuser;
GRANT select on users_id_seq to ptsuser;
GRANT select on distributions to ptsuser;
GRANT select on distributions_id_seq to ptsuser;
GRANT select on architectures to ptsuser;
GRANT select on architectures_id_seq to ptsuser;
GRANT select on vendors to ptsuser;
GRANT select on vendors_id_seq to ptsuser;
GRANT select on platforms to ptsuser;
GRANT select on platforms_id_seq to ptsuser;
GRANT select on bioses to ptsuser;
GRANT select on bioses_id_seq to ptsuser;

