#!/bin/sh
#
##
## Licensed Materials - Property of IBM
## Open Platform Trust Services - An open source TCG PTS
## (C) Copyright International Business Machines Corp. 2007
##
#
# Collect Package info of Debian/Knoppix
# 
#  $ditroname/packagelist.txt
#  $ditroname/tm3-data.txt
#  $ditroname/data/*.matadata
#  $ditroname/data/*.sha1.filelist
#  $ditroname/data/*.md5.filelist
#

if [ $# -lt 1 ]
then
	echo "USAGE: $0 distribution_name"
	exit
fi

echo "Collect Package info of $1"

mkdir -p $1/data

echo "  package list..."
dpkg -l > $1/packagelist.txt

echo "  treemap data..."
perl deb-tm3.pl $1

echo "  metadata..."
perl deb-meta.pl $1/data

echo "  md5 digests..."
perl deb-file.pl md5 $1/data

echo "  sha1 digests..."
perl deb-file.pl sha1 $1/data

tar cvfz $1.tgz ./$1/*

echo "Collect Package info of $1 ...done"

sync
