#!/bin/sh
#
##
## Licensed Materials - Property of IBM
## Open Platform Trust Services - An open source TCG PTS
## (C) Copyright International Business Machines Corp. 2007
##
#
# Collect Package info of RedHat/CentOS/SuSE
# 
#  $ditroname/packagelist.txt
#  $ditroname/tm3-data.txt
#  $ditroname/data/*.matadata
#  $ditroname/data/*.sha1.filelist
#  $ditroname/data/*.md5.filelist
#

if [ $# -lt 1 ]
then
	echo "USAGE: $0 distribution_name"
	exit
fi

echo "Collect Package info of $1"

mkdir -p $1/data

echo "  package list..."
rpm -qa > $1/packagelist.txt

echo "  treemap data..."
perl rpm-tm3.pl $1

echo "  metadata..."
perl rpm-meta.pl $1/data

echo "  md5 digests..."
perl rpm-file.pl md5 $1/data

echo "  sha1 digests..."
perl rpm-file.pl sha1 $1/data

tar cvfz $1.tgz ./$1/*

echo "Collect Package info of $1 ...done"

sync
