/*
 * 
 * Licensed Materials - Property of IBM
 *
 * Open Platform Trust Services - An open source TCG PTS
 *
 * (C) Copyright International Business Machines Corp. 2011
 *
 */

package com.ibm.trl.tcg.pts.attestation;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

// import com.ibm.trl.tcg.pts.Target.localUserInfo;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;

/**
 * 
 * We just support SSH public key authentication, not password authentication.
 * 
 * 
 * @author Seiji Munetoh (munetoh@users.sourceforge.jp)
 *
 */
public class SSH {
	/* Logger */
	private Log log = LogFactory.getLog(this.getClass());
	
	/* SSH connection */
	private JSch _jsch;
	private Session _ssh_session = null;
	private ChannelExec _ssh_channel = null;
	private OutputStream _ssh_out = null;
	private InputStream _ssh_in = null;
	
	/* SSH pubkey auth */
	private String _idRsaFile;
	
	/* target */
	private String _hostname;
	private String _sshUsername;
	private int _sshPort;
	
	public SSH(String hostname, String sshUsername, int sshPort) throws Exception {				
		/* check */
		if (hostname.equals("")) {
			throw new Exception("hostname is null");
		}
		
		/* setup JSCH */
		_jsch = new JSch();
		_hostname = hostname;
		_sshUsername = sshUsername;
		_sshPort = sshPort;
		
		/* pubkey auth */
		_idRsaFile =  System.getProperty("user.home") + File.separator +  ".ssh/id_rsa";

		// if id_rsa files is missing user must setup the SSH key for the pubkey auth
		_jsch.addIdentity(_idRsaFile);
	}

	public void open() throws JSchException, IOException {
		_ssh_session=_jsch.getSession(_sshUsername, _hostname, _sshPort);
		 
		localUserInfo lui=new localUserInfo();
		
		_ssh_session.setUserInfo(lui);
		_ssh_session.connect();
		
		log.info("SSH session - Connected to " + _hostname +  ":" + _sshPort);
		
		_ssh_channel = (ChannelExec) _ssh_session.openChannel("exec");
		_ssh_channel.setCommand("/usr/sbin/ptsc -m");
		_ssh_out = _ssh_channel.getOutputStream();
		_ssh_in = _ssh_channel.getInputStream();
		_ssh_channel.connect();

		log.info("SSH session/channel - Connected to " + _hostname +  ":" + _sshPort);		
	}
	
	/**
	 * 
	 */
	public void close() {
		if (_ssh_channel != null) {
			_ssh_channel.disconnect();
			_ssh_channel = null;
			log.info("SSH Channel - disconnected");
		}
		if (_ssh_session != null) {
			_ssh_session.disconnect();
			_ssh_session = null;
			log.info("SSH Session - disconnected");
		}
	}
	

	/**
	 * 
	 */
	private class localUserInfo implements UserInfo{
		String passwd;
		public String getPassword(){ return passwd; }
		public boolean promptYesNo(String str){return true;}
		public String getPassphrase(){ return null; }
		public boolean promptPassphrase(String message){return true; }
		public boolean promptPassword(String message){return true;}
		public void showMessage(String message){}
	}

	/**
	 * 
	 * @return
	 */
	public OutputStream getOutputStream() {
		return _ssh_out;
	}

	/**
	 * 
	 * @return
	 */
	public InputStream getInputStream() {
		return _ssh_in;
	}
}
