package com.ibm.trl.tcg.pts.engine;

import java.util.Properties;

import com.ibm.trl.tcg.pts.tools.HexTool;

/**
 * 
 * Hold validation result of each events (measurements)
 * 
 * @author Seiji Munetoh (munetoh@users.sourceforge.jp)
 *
 */
public class IntegrityProperties extends Properties {

	/**
	 * 
	 */
	private static final long serialVersionUID = 9088789792224766939L;

	public int eventIndex = 0;

	/**
	 * 
	 * TODO save RM level too
	 * 
	 * @param event
	 * @param result
	 */
	public void setIntegrityProp(Event event, int level, String result) {
		this.setProperty(eventIndex + ".pcrindex", Long.toString(event.getPcrIndex()));
		this.setProperty(eventIndex + ".eventtype", Long.toString(event.getEventType()));
		this.setProperty(eventIndex + ".digest", HexTool.getHexString(event.getDigest()));
		this.setProperty(eventIndex + ".eventdata.string", event.getEventDataString());
		this.setProperty(eventIndex + ".level", Integer.toString(level));
		this.setProperty(eventIndex + ".result", result);
		eventIndex++;		
	}

	public int getEventNum() {
		return eventIndex;
	}


	public String getPcrIndexString(int eventIndex) {
		return this.getProperty(eventIndex + ".pcrindex");
	}

	public String getEventTypeString(int eventIndex) {
		return this.getProperty(eventIndex + ".eventtype");
	}
	
	public String getDigestString(int eventIndex) {
		return this.getProperty(eventIndex + ".digest");
	}
	
	public String getEventDataString(int eventIndex) {
		return this.getProperty(eventIndex + ".eventdata.string");
	}
	
	public String getStatusString(int eventIndex) {
		return this.getProperty(eventIndex + ".result");
	}




}
