/*
 * 
 * Licensed Materials - Property of IBM
 *
 * Open Platform Trust Services - An open source TCG PTS
 *
 * (C) Copyright International Business Machines Corp. 2007, 2011
 *
 */
package com.ibm.trl.tcg.pts.engine;

import com.ibm.trl.tcg.pts.tools.Base64Tool;
import com.ibm.trl.tcg.pts.tools.BlobTool;

/**
 * @author Seiji Munetoh (munetoh@users.sourceforge.jp)
 * 
 */
public class PCPlatformSpecificEvent {


	/**
	 *  PC Platform BIOS measurements => Properties
	 * 
	 * 
	 * @param properties
	 * @param event
	 * @throws Exception
	 */
	public static void setProperties(PlatformProperties properties, Event event) throws Exception {

		/* check */
		if (event == null) {
			throw new Exception("getProperty() is called with null Event");
		}

		byte[] data = event.getEventData();
		int type = (int) BlobTool.UINT32(data, 0);

		byte[] pcEventData = new byte[(data.length - 8)];

		for (int i = 0; i < pcEventData.length; i++)
			pcEventData[i] = data[i + 8];

		switch (type) {
		case 0x0001:
			properties.setProperty("bios.smbios", Base64Tool.encode(pcEventData));
		case 0x0002:
			properties.setProperty("bios.bis.certificate", "TBD");
		case 0x0003:
			properties.setProperty("bios.postbios.rom.strings", "TBD");
		case 0x0004:
			properties.setProperty("bios.escd", "TBD");
		case 0x0005:
			properties.setProperty("bios.cmos", Base64Tool.encode(pcEventData));
		case 0x0006:
			properties.setProperty("bios.nvram", Base64Tool.encode(pcEventData));
		case 0x0007:
			properties.setProperty("bios.optionrom.execute", "TBD");
		case 0x0008:
			properties.setProperty("bios.optionrom.config", "TBD");
		case 0x000A:
			properties.setProperty("bios.optionrom.microcode.update", "TBD");
		case 0x000B:
			properties.setProperty("bios.scrtm.version.string", "TBD");
		case 0x000C:
			properties.setProperty("bios.scrtm.contents", "TBD");
		case 0x000D:
			properties.setProperty("bios.post.contents", "TBD");
		case 0x000E:
			properties.setProperty("bios.hostplatform.manufecture.tableofdevices", "TBD");
		default:
			properties.setProperty("bios.unknowntype", "TBD");
		}
	}
}
