/*
 * 
 * Licensed Materials - Property of IBM
 *
 * Open Platform Trust Services - An open source TCG PTS
 *
 * (C) Copyright International Business Machines Corp. 2007, 2011
 *
 */
package com.ibm.trl.tcg.pts.engine;

import java.io.FileOutputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.ibm.trl.tcg.pts.tools.Base64Tool;


/**
 * Hold Platform Properties generated from binary measurements
 * 
 * @author Seiji Munetoh (munetoh@users.sourceforge.jp)
 * 
 */
public class PlatformProperties  extends Properties {
	/**
	 * 
	 */
	private static final long serialVersionUID = 2074407598861034699L;

	/* Logger */
	private Log log = LogFactory.getLog(this.getClass());


	/**
	 * 
	 */
	public PlatformProperties() {
	}

	/**
	 * Initialize Properties
	 * Reset TPM PCRs
	 */
	public void init() {
		int i;
		/* Reset PCR */
		byte[] pcr = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00 };
		byte[] pcr2 = { (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff,
				(byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff,
				(byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff,
				(byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff,
				(byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff, };

		String b64zero = Base64Tool.encode(pcr);
		String b64ff = Base64Tool.encode(pcr2);
		for (i = 0; i < 16; i++) {
			this.setProperty("tpm.pcr." + i, b64zero);
		}
		for (i = 16; i < 24; i++) {
			this.setProperty("tpm.pcr." + i, b64ff);
		}
	}

	
	/**
	 * 
	 */
	public void printProperties() {
		Enumeration<Object> keys = this.keys();
		
		/* sort */
		Vector<String> keySorted = new Vector<String>();
		while(keys.hasMoreElements()){
			keySorted.add((String)keys.nextElement());
		}
		Collections.sort(keySorted);		
		Enumeration<String> keys2 = keySorted.elements();
		
		/* print out */
		int i = 0;
		while (keys2.hasMoreElements()) {
			String key = (String)keys2.nextElement();
			String value = (String) this.get(key);
			System.out.println(i + " " + key + " = " + value);
			i++;
		}
	}


	/**
	 * 
	 * check name/value is exist or not
	 * 
	 * @param name
	 * @param value
	 * @return true  - valid
	 *         false - invalid
	 * @throws Exception
	 */
	public boolean verifyProperty(String name, String value) throws Exception {
		/* check */
		if (name == null) {
			return false;
		}
		if (value == null) {
			return false;
		}
		
		
		String value2 = this.getProperty(name);
		if (value2 == null) {
			return false;
		}
		
		if (value2.equals(value)) {
			return true;
		}
		return false;
	}


	/**
	 * @param resultFilename
	 * @param option (0: no index,1: with index) 
	 */

	public void saveProperties(String filename) {
		if (filename == null) {
			log.error("saveProperties() filename is null");
			return;
		}
		
		try {
			FileOutputStream fos = new FileOutputStream(filename);
			
			this.store(fos, "generated by jOpenPTS");
			
			fos.close();
		} catch (Exception e) {
			e.printStackTrace();
		}
		if (log.isDebugEnabled()) {
			log.debug("Save Properties : " + filename);
		}
	}
}
