/*
 * 
 * Licensed Materials - Property of IBM
 *
 * Open Platform Trust Services - An open source TCG PTS
 *
 * (C) Copyright International Business Machines Corp. 2007
 *
 */
package com.ibm.trl.tcg.pts.integrity;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.ibm.trl.tcg.pts.tools.Base64Tool;
import com.ibm.trl.tcg.pts.tools.DigestTool;
import com.ibm.trl.tcg.pts.tools.HexTool;

public class PcrComposite {
	/* Logger */
	private Log log = LogFactory.getLog(this.getClass());
	
	private byte[] _select; // TCPA_PCR_SELECT

	private byte[][] _pcrValues;

	private boolean[] _pcrSelect;

	private int _pcrNums;

	private int _selectedPcrNums;

	private int _sizeOfSelect;

	private byte[] _pcrComposite;

	private byte[] _pcrCompositeHash;

	private boolean updateComposite = true;

	private byte[] _extraData;

	private int[] _selectedPcrIndex;

	private byte[][] _selectedPcrValue;

	/**
	 * 
	 * 
	 * 
	 * @param pcrNums
	 */
	public void setPcrNumber(int pcrNums) {
		_pcrNums = pcrNums;
		_sizeOfSelect = _pcrNums / 8;  // TODO
		//_sizeOfSelect = 2; // TODO 

		_select = new byte[2 + _sizeOfSelect];
		_select[0] = 0;
		_select[1] = (byte) _sizeOfSelect;

		_pcrSelect = new boolean[pcrNums];
		_pcrValues = new byte[pcrNums][20];

		for (int i = 0; i < pcrNums; i++)
			_pcrSelect[i] = false;
		updateComposite = true;
	}

	public void selectPcr(int pcrindex, byte[] pcrValue) {
		if (pcrindex > _pcrNums) {
			// log.debug("pcrNum " + _pcrNums);
			// log.debug("pcrindex " + pcrindex);
		}
		_pcrSelect[pcrindex] = true;
		_pcrValues[pcrindex] = pcrValue;
		updateComposite = true;
	}

	public void setExtraData(byte[] nonce) {
		_extraData = nonce;
	}

	public byte[] getPcrSelect() {
		if (updateComposite == true)
			update();
		return _select;
	}

	public int getSizeOfSelect() {
		if (updateComposite == true)
			update();
		return _sizeOfSelect;
	}

	public int getSelectedPcrNums() {
		if (updateComposite == true)
			update();
		return _selectedPcrNums;
	}

	public int getPcrIndex(int i) {
		if (updateComposite == true)
			update();
		return _selectedPcrIndex[i];
	}

	public byte[] getPcrValue(int i) {
		if (updateComposite == true)
			update();
		return _selectedPcrValue[i];
	}

	public byte[] getDigestValue() {
		if (updateComposite == true)
			update();
		return _pcrCompositeHash;
	}

	public byte[] getExternalData() {
		if (updateComposite == true)
			update();
		return _extraData;
	}

	private void update() {
		/* selected PCRs */
		int valueSize = 0;
		int maskbit = 1;
		int mask = 0;
		_selectedPcrNums = 0;

		/* 1st pass */
		for (int i = 0; i < _pcrNums; i++) {
			if (_pcrSelect[i] == true) {
				valueSize += 20;
				mask |= maskbit;
				_selectedPcrNums++;
			}
			maskbit <<= 1;
		}

		/* select */
		// _sizeOfSelect = 2; // TODO 
		for (int i = 0; i < _sizeOfSelect; i++) {
			// select[2+sizeOfSelect-i-1] = (byte) (mask & 0xFF);
			_select[2 + i] = (byte) (mask & 0xFF);
			mask >>= 8;
		}

		// _base64PcrSelect = Base64Tool.encode(select);

		_pcrComposite = new byte[2 + _sizeOfSelect + 4 + valueSize];
		int loc = 0;
		for (loc = 0; loc < (2 + _sizeOfSelect); loc++) {
			_pcrComposite[loc] = _select[loc];
		}
		_pcrComposite[loc] = 0;
		loc++;
		_pcrComposite[loc] = 0;
		loc++;
		_pcrComposite[loc] = (byte) (valueSize >> 8 & 0xFF);
		loc++;
		_pcrComposite[loc] = (byte) (valueSize & 0xFF);
		loc++;

		_selectedPcrIndex = new int[_selectedPcrNums];
		_selectedPcrValue = new byte[_selectedPcrNums][20];

		/* 2nd */
		int k = 0;
		for (int i = 0; i < _pcrNums; i++) {
			if (_pcrSelect[i] == true) {
				for (int j = 0; j < 20; j++) {
					_pcrComposite[loc + j] = _pcrValues[i][j];
				}

				_selectedPcrIndex[k] = i;
				_selectedPcrValue[k] = _pcrValues[i];

				// pc.selectPcr(i,pcr);

				loc += 20;
				k++;

				log.debug(" pcr " + i + " " + HexTool.getHexString(_pcrValues[i]) 
						+ " " + Base64Tool.encode(_pcrValues[i]));
				// HexTool.printHex(pcr);
				// log.debug(" ");
			}
		}
		

		
		_pcrCompositeHash = DigestTool.SHA1(_pcrComposite);
	
		log.debug("_pcrComposite     :" + HexTool.getHexString(_pcrComposite));
		log.debug("_pcrCompositeHash :" + HexTool.getHexString(_pcrCompositeHash));	
		
		updateComposite = false;
	}

	public String toString() {
		String str = "PCR_COMPOSITE\n";
		str += "PCR_SELECTION      " + HexTool.getHexString(_select) + "\n";
		str += "PCR_COMPOSITE      " + HexTool.getHexString(_pcrComposite)
				+ "\n";
		str += "PCR_COMPOSITE_HASH " + HexTool.getHexString(_pcrCompositeHash)
				+ "\n";
		return str;
	}

	public boolean validate(byte[] quoteInfo) {
		if (updateComposite == true)
			update();

		// TODO check 0-8
		for (int i = 0; i < 20; i++) {
			if (quoteInfo[8 + i] != _pcrCompositeHash[i]) {
				log.debug("pcrCompositeHash is not match");
				log.debug("    pcrCompositeHash : " + HexTool.getHexString(_pcrCompositeHash));
				return false;
			}
		}
		for (int i = 0; i < 20; i++) {
			if (quoteInfo[28 + i] != _extraData[i]) {
				log.debug("extraData is not match");
				log.debug("    extraData : " + HexTool.getHexString(_extraData));
				return false;
			}
		}
		return true;

	}
	
	public boolean validate2(byte[] quoteInfo2) {
		if (updateComposite == true)
			update();

		// TODO check 0-8
		for (int i = 0; i < 20; i++) {
			if (quoteInfo2[32 + i] != _pcrCompositeHash[i]) {
				log.debug("pcrCompositeHash is not match");
				log.debug("    pcrCompositeHash : " + HexTool.getHexString(_pcrCompositeHash));
				return false;
			}
		}
		for (int i = 0; i < 20; i++) {
			if (quoteInfo2[6 + i] != _extraData[i]) {
				log.debug("extraData is not match");
				log.debug("    extraData : " + HexTool.getHexString(_extraData));
				return false;
			}
		}
		return true;

	}

	public boolean selected(int pcrindex) {

		return _pcrSelect[pcrindex];
	}
}
