/*
 * 
 * Licensed Materials - Property of IBM
 *
 * Open Platform Trust Services - An open source TCG PTS
 *
 * (C) Copyright International Business Machines Corp. 2007
 *
 */
package com.ibm.trl.tcg.pts.integrity;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

/**
 * 
 * @author Seiji Munetoh (munetoh@users.sourceforge.jp)
 * 
 */
public class SaxErrorHandler implements ErrorHandler {
	/* Logger */
	private Log log = LogFactory.getLog(this.getClass());

	public boolean rc = true;

	public void fatalError(SAXParseException e) {
		log.error("Fatal Error: " + e.getLineNumber() + " line");
		log.error(e.getMessage());
		rc = false;
	}

	public void error(SAXParseException e) {
		log.error("Error: " + e.getLineNumber() + " line");
		log.error(e.getMessage());
		rc = false;
	}

	public void warning(SAXParseException e) {
		log.error("Warning: " + e.getLineNumber() + " line");
		log.error(e.getMessage());
		rc = false;
	}
}
