/*
 * 
 * Licensed Materials - Property of IBM
 *
 * Open Platform Trust Services - An open source TCG PTS
 *
 * (C) Copyright International Business Machines Corp. 2007, 2011
 *
 */
package com.ibm.trl.tcg.pts.tools;

import java.math.BigInteger;

/**
 * @author Seiji Munetoh (munetoh@users.sourceforge.jp)
 * 
 */
public class HexTool {

	/**
	 * @param eventdata
	 */
	public static void printHex(byte data) {
		int d = data;
		if (d < 0) {
			d += 256;
		}
		if (d < 16) {
			System.out.print("0");
		}
		System.out.print(Integer.toString(d, 16));
	}

	/**
	 * @param eventdata
	 */
	public static String getHexString(byte data) {
		int d = data;
		String str = "";

		if (d < 0) {
			d += 256;
		}
		if (d < 16) {
			str += "0";
		}
		str += Integer.toString(d, 16);
		return str;
	}

	/**
	 * UpperCase
	 * 
	 * @param data
	 * @return
	 */
	public static String getHEXString(byte data) {
		int d = data;
		String str = "";

		if (d < 0) {
			d += 256;
		}
		if (d < 16) {
			str += "0";
		}
		str += Integer.toString(d, 16).toUpperCase();
		return str;
	}

	/**
	 * @param eventdata
	 */
	public static void printHex(byte[] data) {
		for (int i = 0; i < data.length; i++) {
			int d = data[i];
			if (d < 0) {
				d += 256;
			}
			if (d < 16) {
				System.out.print("0");
			}
			System.out.print(Integer.toString(d, 16));
		}
	}

	/**
	 * @param digest2
	 * @return
	 */
	public static String getHexString(byte[] data) {
		String str = "";
		for (int i = 0; i < data.length; i++) {
			int d = data[i];
			if (d < 0) {
				d += 256;
			}
			if (d < 16) {
				str += "0";
			}
			str += Integer.toString(d, 16);
		}
		return str;
	}

	/**
	 * 
	 * Upper
	 * 
	 * @param digest2
	 * @return
	 */
	public static String getHEXString(byte[] data, String sep) {
		if (sep == null)
			sep = "";
		String str = "";
		for (int i = 0; i < data.length; i++) {
			int d = data[i];
			if (d < 0) {
				d += 256;
			}
			if (d < 16) {
				str += "0";
			}
			str += Integer.toString(d, 16).toUpperCase() + sep;
		}
		return str;
	}

	/**
	 * Hex String => BI => byte[]
	 * @param hexString
	 * @return
	 */
	public static byte[] getBytesBI(String hexString) {
		byte[] buf = new BigInteger(hexString, 16).toByteArray();

		if (buf[0] == 0) {
			/* delete top null byte */
			byte[] buf2 = new byte[buf.length - 1];
			for (int i = 0; i < buf.length - 1; i++) {
				buf2[i] = buf[i + 1];
			}
			return buf2;
		} else {
			return buf;
		}
	}
	
	/**
	 * Hex String => substring  => byte[]
	 * @param hexString
	 * @return
	 */
	public static byte[] getBytes(String hexString) {
		byte[] bytes = new byte[hexString.length() / 2];

		for (int i = 0; i < bytes.length; i++) {
			String c =  hexString.substring(i * 2, (i +1) * 2);
			bytes[i] = (byte) Integer.parseInt(c,16);
		}
		return bytes;
	}

	
	
	
	public static int getByte(String hexString) {
		int i = 0;
		char c[] = hexString.toCharArray();
		
		i = (Character.digit(c[0], 16)) * 16 + (Character.digit(c[1], 16));
		return i;
	}

	public static String getHexString(byte[] data, int offset, int size) {
		String str = "";
		
		if (offset > data.length) {
			return null;
		}
		if (offset + size > data.length) {
			size = data.length - offset;
		}
		
		for (int i = offset; i < data.length; i++) {
			int d = data[i];
			if (d < 0) {
				d += 256;
			}
			if (d < 16) {
				str += "0";
			}
			str += Integer.toString(d, 16);
		}
		return str;
	}

}
