/*
 * 
 * Licensed Materials - Property of IBM
 *
 * Open Platform Trust Services - An open source TCG PTS
 *
 * (C) Copyright International Business Machines Corp. 2007, 2011
 *
 */
package com.ibm.trl.tcg.pts.tools;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.RSAPublicKeySpec;


/**
 * Signature Tool
 * 
 * 
 * @author Seiji Munetoh (munetoh@users.sourceforge.jp)
 * 
 */
public class SignatureTool {
	/* Logger */
	//private Log log = LogFactory.getLog(this.getClass());
	
	/**
	 * 
	 * IBM JRE 1.6.0.9  Quote2 -> Fail
	 * SUN JRE 1.6.0_25 Quote2 -> Fail
	 * 
	 */
	
	public static boolean validate(byte[] pubKey, byte[] message,
			byte[] signature) throws Exception {

		/* Setup RSA PubKey */
		byte[] pubExp = { 0x00, 0x01, 0x00, 0x01 };

		/* RSA Modulus */			
		BigInteger biM = new BigInteger(1, pubKey);
		
		//log.debug("pubKey : ");
		//log.debug("pubKey : " + biM.toString(16));
		
		BigInteger biE = new BigInteger(pubExp);
		RSAPublicKeySpec rpks = new RSAPublicKeySpec(biM, biE);
		KeyFactory kf = KeyFactory.getInstance("RSA");

		PublicKey key = (PublicKey) kf.generatePublic(rpks);

		/* Verify Signature */

		Signature sig = Signature.getInstance("SHA1withRSA");
		sig.initVerify(key);
		sig.update(message);
		boolean rc =  sig.verify(signature);
		
		if (rc == false) {
			// TODO dump debug info (code?)
		}
		
		return rc;
	}
}
