/*
 * 
 * Licensed Materials - Property of IBM
 *
 * Open Platform Trust Services - An open source TCG PTS
 *
 * (C) Copyright International Business Machines Corp. 2011
 *
 */

package com.ibm.trl.tcg.pts.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.UUID;

/**
 * 
 * @author Seiji Munetoh (munetoh@users.sourceforge.jp)
 *
 */
public class UuidTool {

	/**
	 * @throws IOException 
	 * @throws IOException 
	 * @throws FileNotFoundException 
	 * read UUID file 
	 * 
	 * ae8b2bb6-2a7d-11e0-9a67-0016eac2e834
	 * 
	 * @param filename
	 * @return
	 * @throws  
	 */
	public static UUID readUuidFile(String filename) throws FileNotFoundException, IOException  {
		UUID uuid = null;

		FileReader in = new FileReader(filename);
		BufferedReader br = new BufferedReader(in);
		String line;

		line = br.readLine();
		
		uuid = UUID.fromString(line);
		
		br.close();
		in.close();			
		
		return uuid;
	}

	public static void saveUuidFile(UUID u, String uuidFilename) throws IOException {
		File uuid_file = new File(uuidFilename);
		FileWriter filewriter = new FileWriter(uuid_file);
		filewriter.write(u.toString());
		filewriter.close();
	}
}
