/*
 * 
 * Licensed Materials - Property of IBM
 *
 * Open Platform Trust Services - An open source TCG PTS
 *
 * (C) Copyright International Business Machines Corp. 2011
 *
 */

package com.ibm.trl.tcg.pts.verifier.cui;

import java.io.FileNotFoundException;
import java.io.IOException;

//import org.apache.commons.logging.Log;
//import org.apache.commons.logging.LogFactory;

import com.ibm.trl.tcg.pts.integrity.VerificationResult;
import com.ibm.trl.tcg.pts.verifier.Target;
import com.ibm.trl.tcg.pts.verifier.TargetList;

/**
 * 
 * jopenpts -i localhost
 * jopenpts -i -f localhost
 * ./jopenpts-test -i -f -s -S 6680 -l munetoh localhost
 * 
 * 
 * 
 * @author Seiji Munetoh (munetoh@users.sourceforge.jp)
 *
 */
public class CUI {
	
	
	/**
	 * TODO CUI is same with C version 
	 * 
	 * 
	 * @param args
	 */
	private static void usage(String[] args) {
		System.out.println("OpenPTS command");
		System.out.println("");
		System.out.println("Usage: jopenpts [options] {-i [-f]|[-v]-D} <target>");
		System.out.println("");
		System.out.println("Commands:");
		System.out.println("  -i [-f]               Initialize [forcibly]the PTS verifier with target(collector)");
		System.out.println("  -v                    Verify target(collector) integrity against know measure");
		//System.out.println("  -D                    Display the configulation (target/ALL)");
		System.out.println("");
		System.out.println("Miscellaneous:");
		System.out.println("  -h                    Show this help message");
		// TODO control log4j settings?
		System.out.println("  -V                    Verbose mode. Multiple -V options increase the verbosity.");
		System.out.println("  ");
		System.out.println("Options:");

		//System.out.println("  -c configfile         Set configulation file. defalt is /etc/ptscd.conf");
		//System.out.println("  -f                    Force init, delete existing target(collector) info");
		//System.out.println("  -s                    use SSH tunnel (port forward)");
		//System.out.println("  -S port               setup SSH tunnel, set local port");
		//System.out.println("  -S port               setup SSH tunnel, set local port");
		System.out.println("  -l username           ssh username [ssh default]");
		System.out.println("  -p port               ssh port number [ssh default]");
	}
	
	/**
	 * @param args
	 * @throws n 
	 * @throws FileNotFoundException 
	 */
	public static void main(String[] args) {
		int init = 0;
		int verify = 0;
		int display = 0;
		//int port = 6678;
		int force = 0;
		int verbose = 0;
		String hostname = null;
		//int ssh_mode = 0;
		//int ssh_port = 0;
		String username = null;
		
		int i;
        for (i=0; i< args.length; ++i) {
            if ("-i".equals(args[i])) {
            	init = 1;
            } else if ("-v".equals(args[i])) {
                verify = 1;
            } else if ("-f".equals(args[i])) {
            	force = 1;
            } else if ("-V".equals(args[i])) {
            	verbose += 1;
            //} else if ("-s".equals(args[i])) {
            //	ssh_mode = 1;
            //} else if ("-p".equals(args[i])) {
            //	ssh_port = Integer.parseInt(args[++i]);
            } else if ("-l".equals(args[i])) {
            	username = args[++i]; 
            } else if ("-D".equals(args[i])) {
            	display = 1;
            } else if ("-h".equals(args[i])) {
            	usage(args);
            	return;
            } else if (args[i].startsWith("-")) {
            	System.err.println("bad arg " + args[i]);
            	usage(args);
            	return;
            } else {
            	if (i == args.length - 1) {
            		/* last => hostname */
            		hostname = args[i];
            	} else {
            		System.err.println("bad arg");
            		usage(args);
            		return;
            	}
            }
        }
        
        if (username == null) {
        	/* use user account as the SSH username */
        	username = System.getProperty("user.name");
        }


        if (init == 1) {
        	/* enroll with target(collector) */
			try {
				TargetList tl;

				/* get target list (also init openpts configs) */
				tl = new TargetList();				
				if (tl.isInitialized() == false) {
					return;
				}

				/* lookup the target */
				Target t = tl.getTarget(hostname);
				
				if (t == null) {
					/* new target */
					// t = new Target(tl._dir , hostname, username, 22);
					t = tl.addTarget( hostname, username, 22);
				} else {
					/* already exist */					
					if (force == 0) {
		    			System.out.println("Target         : " + hostname);
		    			System.out.println("port           : " + t._ssh_port);
		    			System.out.println("Collector UUID : " + t._uuid.toString());
		    			System.out.println("Manifest UUID  : " + t._rm_uuid.toString());
		    			System.out.println("policy file    : " + t._policy_filename);
		    			System.out.println("property file  : " + t._prop_filename);
		    			System.out.println("status         : " + "already exist");
		    			System.out.println("Reasons");
						System.out.println(" [ERROR] target is already exist. use -f option to override current target setting");						
						return;
					}					
				}
				
				
				boolean rc = t.enroll(force);
				
				if (rc == true) {
	    			System.out.println("Target         : " + hostname);
	    			System.out.println("port           : " + t._ssh_port);
	    			System.out.println("Collector UUID : " + t._uuid.toString());
	    			System.out.println("Manifest UUID  : " + t._rm_uuid.toString());
	    			System.out.println("policy file    : " + t._policy_filename);
	    			System.out.println("status         : " + "successfuly initialized");
				} else {
	    			System.out.println("Target         : " + hostname);
	    			System.out.println("port           : " + t._ssh_port);
	    			System.out.println("Collector UUID : " + t._uuid.toString());
	    			System.out.println("Manifest UUID  : " + t._rm_uuid.toString());
	    			System.out.println("status         : " + "initialization was failed");
					t.printReason();
					return;	
				}
    			
			} catch (FileNotFoundException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
        } else if (display == 1) {
        	/* show list of target */
			try {
				TargetList tl;

				/* get target list (also init openpts configs) */
				tl = new TargetList();				
				if (!tl.isInitialized()) {
					System.err.println("openpts/jopenpts is not initialied");
					return;
				}
				/* */
				tl.printAll();
				return;
				
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
        } else if (verify == 1) {
        	/* verify targte */
        	// System.out.println("verify " + hostname);

        	Target t = null;
    		try {
    			TargetList tl = new TargetList();
    			
    			/* lookup the localhost */
    			t = tl.getTarget(hostname);
    			t.initSsh();
    			
    			int rc = t.verify();
    			
    			System.out.println("Target         : " + hostname);
        		System.out.println("ssh port       : " + t._ssh_port);
        		System.out.println("ssh username   : " + t._ssh_username);
    			System.out.println("Collector UUID : " + t._uuid.toString());
    			System.out.println("Manifest UUID  : " + t._rm_uuid.toString());
    			System.out.println("policy file    : " + t._policy_filename);
    			System.out.println("property file  : " + t._prop_filename);
    			
    			if (rc == VerificationResult.VALID) {
    				/* OK */
    				System.out.println("integrity      : " + "valid");
    			} else if (rc == VerificationResult.INVALID) {
					System.out.println("integrity      : " + "invalid");
					t.printReason();
					return;
    			} else if (rc == VerificationResult.UNVERIFIED) {
					System.out.println("integrity      : " + "unverified");
					t.printReason();
					return;
    			} else {
    				
    			}
    			
    		} catch (Exception e) {
    			System.err.println("Exception Error");
    			if (t != null) {
    				t.printReason();
    			}
    			e.printStackTrace();
    		}
        } else {
        	// TODO
        }
	}
}