/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.common.net;

public class ReadWriteBuffer {
    public static final int DEFAULT_BLOCK_SIZE = 4096;
    private byte[] buffer;
    private int blocksize;
    private int readp = 0;
    private int writep = 0;

    public ReadWriteBuffer() {
        this.blocksize = 4096;
        this.buffer = new byte[this.blocksize];
    }

    public ReadWriteBuffer(int bs) {
        this.blocksize = bs;
        this.buffer = new byte[this.blocksize];
    }

    public void write(byte b) {
        this.write(b & 0xFF);
    }

    public void write(int i) {
        this.expand();
        this.buffer[this.writep++] = (byte)(i & 0xFF);
    }

    public void write(byte[] b) {
        for (int i = 0; i < b.length; ++i) {
            this.write(b[i]);
        }
    }

    public void write(String str) {
        this.write(str.getBytes());
    }

    public int read() {
        this.reduce();
        if (this.readp == this.writep) {
            return -1;
        }
        return this.buffer[this.readp++] & 0xFF;
    }

    public int read(byte[] bf) {
        boolean p = false;
        for (int i = 0; i < bf.length; ++i) {
            int d = this.read();
            if (d < 0) {
                return i;
            }
            bf[i] = (byte)(d & 0xFF);
        }
        return bf.length;
    }

    protected void expand() {
        if (this.writep == this.buffer.length) {
            byte[] newBuffer = new byte[this.buffer.length + this.blocksize];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
            this.buffer = newBuffer;
        }
    }

    protected void reduce() {
        if (this.readp >= this.blocksize * 3) {
            byte[] newBuffer = new byte[this.buffer.length - this.blocksize * 3];
            System.arraycopy(this.buffer, this.blocksize * 3, newBuffer, 0, this.buffer.length - this.blocksize * 3);
            this.buffer = newBuffer;
            this.readp -= this.blocksize * 3;
            this.writep -= this.blocksize * 3;
        }
    }
}

