/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.common.net.async;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.TooManyListenersException;
import org.logical_paradox.common.net.ReadWriteBuffer;
import org.logical_paradox.common.net.async.AsyncEvent;
import org.logical_paradox.common.net.async.AsyncEventListener;

public abstract class CAsyncSocket
implements AsyncEventListener {
    public static final int SEND_BUFFER_SIZE = 4096;
    public static final int RECEIVE_BUFFER_SIZE = 4096;
    protected SelectableChannel channel = null;
    protected AsyncEventListener listener = null;
    private ReadWriteBuffer sendBuffer = new ReadWriteBuffer();
    private ReadWriteBuffer receiveBuffer = new ReadWriteBuffer();

    public void addEventListener(AsyncEventListener l) throws TooManyListenersException {
        if (this.listener != null) {
            throw new TooManyListenersException("AsyncEventListener\u306f\u65e2\u306b\u767b\u9332\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        this.listener = l;
    }

    public void removeEventListener() {
        this.listener = null;
    }

    public SelectionKey register(Selector s, int o) throws ClosedChannelException {
        SelectionKey skey = this.channel.register(s, o);
        skey.attach(this.listener);
        return skey;
    }

    public void configureBlocking(boolean mode) throws IOException {
        if (this.channel != null) {
            this.channel.configureBlocking(mode);
        }
    }

    public SelectableChannel getSelectableChannel() {
        return this.channel;
    }

    protected void readMessage(SocketChannel src) {
        ByteBuffer rb = ByteBuffer.allocate(4096);
        try {
            src.read(rb);
            rb.flip();
            Charset charset = Charset.forName("MS932");
            CharsetDecoder csdecoder = charset.newDecoder();
            CharBuffer cb = csdecoder.decode(rb);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void sendMessage(byte[] b) {
        this.sendBuffer.write(b);
        this.onSend(new AsyncEvent(this, this.channel));
    }

    public void onReceive(AsyncEvent o) {
        try {
            SocketChannel channel = (SocketChannel)o.getChannel();
            ByteBuffer byteBuffer = ByteBuffer.allocate(4096);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onSend(AsyncEvent o) {
        byte[] sendbuf = new byte[4096];
        int sendsize = 0;
        while ((sendsize = this.sendBuffer.read(sendbuf)) > 0) {
            Object var7_6;
            ByteBuffer bb = null;
            try {
                try {
                    bb = ByteBuffer.wrap(sendbuf, 0, sendsize);
                    ((SocketChannel)o.getChannel()).write(bb);
                }
                catch (Exception e) {
                    var7_6 = null;
                    if (bb == null) continue;
                    bb.clear();
                    bb = null;
                    continue;
                }
                var7_6 = null;
                if (bb == null) continue;
                bb.clear();
            }
            catch (Throwable throwable) {
                var7_6 = null;
                if (bb != null) {
                    bb.clear();
                    bb = null;
                }
                throw throwable;
            }
            bb = null;
        }
        return;
    }
}

