/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.common.session;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.logical_paradox.common.session.IllegalSessionStateException;
import org.logical_paradox.common.session.Session;
import org.logical_paradox.common.session.SessionUnbounder;
import org.logical_paradox.common.util.StringUtils;

public class SessionManager {
    public static final int SESSION_ID_LENGTH = 32;
    public static final int DEFAULT_SESSION_CHECK_INTERVAL = 1000;
    public final HashMap sessions = new HashMap();
    private final SessionUnbounder unbounder;
    private long sessionLifeTime;

    public SessionManager() {
        this(1000);
    }

    public SessionManager(int itv) {
        this.unbounder = new SessionUnbounder(this, itv);
        this.unbounder.start();
    }

    public SessionManager(int itv, long lifetime) {
        this(itv);
        this.sessionLifeTime = lifetime;
    }

    public Session getSession() throws IllegalSessionStateException {
        String sessionId = null;
        while (this.sessions.get(sessionId = this.getSessionId()) != null) {
        }
        Session session = null;
        session = this.sessionLifeTime == 0L ? new Session(sessionId) : new Session(sessionId, this.sessionLifeTime);
        this.sessions.put(sessionId, session);
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session getSession(String sessionId) throws IllegalSessionStateException {
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            Session session = (Session)this.sessions.get(sessionId);
            if (session == null) {
                return this.getSession();
            }
            return session;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session getSession(String sessionId, boolean createMode) throws IllegalSessionStateException {
        if (createMode) {
            return this.getSession(sessionId);
        }
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            return (Session)this.sessions.get(sessionId);
        }
    }

    public synchronized boolean isExists(String sessionId) {
        return this.sessions.get(sessionId) != null;
    }

    public synchronized void removeSession(String sessionId) {
        Session session = (Session)this.sessions.get(sessionId);
        if (session == null) {
            return;
        }
        session.unbound();
        this.sessions.remove(sessionId);
    }

    public void removeAllSessions(List sessions) {
        Iterator it = sessions.iterator();
        while (it.hasNext()) {
            Session session = (Session)it.next();
            this.removeSession(session.getSessionId());
        }
    }

    synchronized Map getAllSessions() {
        return this.sessions;
    }

    private String getSessionId() {
        return StringUtils.randomText(32, true);
    }
}

