/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.common.util;

import java.util.ArrayList;
import org.logical_paradox.common.lang.Random;

public class StringUtils {
    public static final String RANDOM_TEXT_SEED = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    public static final Random r = new Random(1);

    private StringUtils() {
    }

    public static final boolean isEmpty(String msg) {
        return msg == null || msg.trim().length() == 0;
    }

    public static final boolean isNotEmpty(String msg) {
        return !StringUtils.isEmpty(msg);
    }

    public static final String toString(String str) {
        return str != null ? str : "";
    }

    public static final String formatColumns(long num, int cols) {
        String n = "" + num;
        if (n.length() >= cols) {
            return n;
        }
        String base = StringUtils.sequence('0', cols - 1) + n;
        if (base.length() == cols) {
            return base;
        }
        return base.substring(base.length() - cols);
    }

    public static final boolean isIntStr(String msg) {
        boolean rc = true;
        try {
            Integer.parseInt(msg);
        }
        catch (NumberFormatException ne) {
            rc = false;
        }
        return rc;
    }

    public static final boolean isLongStr(String msg) {
        boolean rc = true;
        try {
            Long.parseLong(msg);
        }
        catch (NumberFormatException ne) {
            rc = false;
        }
        return rc;
    }

    public static final String trimControlChars(String str) {
        StringBuffer sb = new StringBuffer();
        char[] characters = str.toCharArray();
        for (int i = 0; i < characters.length; ++i) {
            if (characters[i] < ' ') continue;
            sb.append(characters[i]);
        }
        return sb.toString();
    }

    public static final String[] trimEmptyLines(String[] lines) {
        ArrayList<String> l = new ArrayList<String>();
        for (int i = 0; i < lines.length; ++i) {
            if (StringUtils.isEmpty(lines[i])) continue;
            l.add(lines[i]);
        }
        return l.toArray(new String[0]);
    }

    public static Integer[] searchWordIndexes(String text, String word) {
        ArrayList<Integer> locations = new ArrayList<Integer>();
        int bgn = 0;
        do {
            if ((bgn = text.indexOf(word, bgn)) < 0 || bgn >= text.length()) continue;
            locations.add(new Integer(bgn));
            ++bgn;
        } while (bgn >= 0);
        return locations.toArray(new Integer[0]);
    }

    public static final String randomText(int length, boolean fixed) {
        StringBuffer sb = new StringBuffer();
        if (!fixed) {
            length = (int)(Math.random() * 8.0) + 1;
        }
        for (int i = 0; i < length; ++i) {
            sb.append(RANDOM_TEXT_SEED.charAt((int)(Math.random() * (double)RANDOM_TEXT_SEED.length())));
        }
        return sb.toString();
    }

    public static final String randomTextRange(int minlength, int maxlength) {
        int range = r.nextInt() % (maxlength - minlength) + 1;
        int length = r.nextInt() % range + minlength;
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            sb.append(RANDOM_TEXT_SEED.charAt(r.nextInt() % RANDOM_TEXT_SEED.length()));
        }
        return sb.toString();
    }

    public static final String formatColumns(int num, int cols) {
        String n = "" + num;
        if (n.length() >= cols) {
            return n;
        }
        String base = StringUtils.sequence('0', cols - 1) + n;
        if (base.length() == cols) {
            return base;
        }
        return base.substring(base.length() - cols);
    }

    public static final String sequence(char c, int count) {
        StringBuffer sb = new StringBuffer();
        String cc = "" + c + c;
        while (count > 1) {
            sb.append(cc);
            count -= 2;
        }
        if (count % 2 == 1) {
            sb.append(c);
        }
        return sb.toString();
    }

    public static final String format64bit(long l) {
        String bit64String = "0000000000000000000000000000000000000000000000000000000000000000" + Long.toBinaryString(l);
        return bit64String.substring(bit64String.length() - 64, bit64String.length());
    }
}

