/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.koike.core.indexer;

import java.util.Iterator;
import org.logical_paradox.koike.core.KoikeConfig;
import org.logical_paradox.koike.core.document.DocumentAccessor;
import org.logical_paradox.koike.core.indexer.IndexAccessException;
import org.logical_paradox.koike.core.indexer.IndexAccessor;
import org.logical_paradox.koike.core.logging.LogFactory;
import org.logical_paradox.koike.core.logging.Logger;
import org.logical_paradox.koike.core.parser.Parser;
import org.logical_paradox.koike.core.parser.Term;

public class IndexerThread
extends Thread {
    private IndexAccessor idxAccessor;
    private DocumentAccessor docAccessor;
    private Iterator ri;
    private final KoikeConfig config;
    private Logger log = LogFactory.getLogger();
    private final Parser parser;

    public IndexerThread(KoikeConfig cfg) throws Exception {
        this.config = cfg;
        this.idxAccessor = this.config.getInterfaceFactory().getIndexAccessor();
        this.docAccessor = this.config.getInterfaceFactory().getDocumentAccessor();
        this.ri = this.config.getInterfaceFactory().getRemoteQueueIterator();
        this.parser = new Parser(this.config.getNgramTermLength());
    }

    public void run() {
        this.log.write("**** \u30b9\u30ec\u30c3\u30c9[" + this.toString() + "]\u304c\u30a4\u30f3\u30c7\u30af\u30b7\u30f3\u30b0\u3092\u958b\u59cb\u3057\u307e\u3057\u305f");
        boolean loopc = true;
        try {
            while (loopc) {
                String digest = null;
                while ((digest = this.getDigest()) != null) {
                    String contents = null;
                    try {
                        this.log.write("\u30c0\u30a4\u30b8\u30a7\u30b9\u30c8[" + digest + "]\u3092\u89e3\u6790\u3057\u3066\u3044\u307e\u3059");
                        contents = this.docAccessor.getDocument(digest).getDocument();
                        Term[] terms = this.parser.parse(contents);
                        this.transfer(digest, terms);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.log.write("\u30c0\u30a4\u30b8\u30a7\u30b9\u30c8[" + digest + "]\u304c\u30b3\u30f3\u30c6\u30f3\u30c4\u7ba1\u7406\u30b7\u30b9\u30c6\u30e0\u306b\u3042\u308a\u307e\u305b\u3093");
                    }
                }
                if (!this.config.isWaitOnEmpty()) {
                    this.log.write("waitonempty\u30d5\u30e9\u30b0\u304ctrue\u306e\u305f\u3081\u3001\u30a4\u30f3\u30c7\u30af\u30b7\u30f3\u30b0\u3092\u7d42\u4e86\u3057\u307e\u3059");
                    loopc = false;
                    continue;
                }
                Thread.sleep(2000L);
            }
        }
        catch (InterruptedException ie) {
            this.tearDown();
        }
        this.log.write("**** \u30b9\u30ec\u30c3\u30c9[" + this.toString() + "]\u304c\u30a4\u30f3\u30c7\u30af\u30b7\u30f3\u30b0\u3092\u7d42\u4e86\u3057\u307e\u3057\u305f");
    }

    protected String getDigest() {
        Iterator iterator = this.ri;
        synchronized (iterator) {
            if (!this.ri.hasNext()) {
                return null;
            }
            return (String)this.ri.next();
        }
    }

    protected void transfer(String digest, Term[] terms) throws Exception {
        this.idxAccessor.addTerm(digest, terms);
    }

    protected void tearDown() {
        this.log.write("**** \u30b9\u30ec\u30c3\u30c9\u304c\u505c\u6b62\u3057\u307e\u3059 ****");
        try {
            IndexAccessor indexAccessor = this.idxAccessor;
            synchronized (indexAccessor) {
                if (this.idxAccessor != null && !this.idxAccessor.isClosed()) {
                    this.idxAccessor.close();
                    this.idxAccessor = null;
                }
            }
        }
        catch (IndexAccessException e) {
            this.log.write("**** \u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u30b7\u30b9\u30c6\u30e0\u3068\u306e\u63a5\u7d9a\u30a4\u30f3\u30bf\u30fc\u30d5\u30a7\u30fc\u30b9\u306e\u30af\u30ed\u30fc\u30ba\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
        }
        try {
            DocumentAccessor e = this.docAccessor;
            synchronized (e) {
                if (this.docAccessor != null && !this.docAccessor.isClosed()) {
                    this.docAccessor.close();
                    this.docAccessor = null;
                }
            }
        }
        catch (Exception e) {
            this.log.write("**** \u30c9\u30ad\u30e5\u30e1\u30f3\u30c8\u30ea\u30bd\u30fc\u30b9\u306e\u63a5\u7d9a\u30a4\u30f3\u30bf\u30fc\u30d5\u30a7\u30fc\u30b9\u306e\u30af\u30ed\u30fc\u30ba\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
        }
        this.log.write("**** \u30b9\u30ec\u30c3\u30c9\u304c\u505c\u6b62\u3057\u307e\u3057\u305f ****");
    }
}

