/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.koike.core.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.logical_paradox.koike.core.search.Location;

public class InvertedIndex {
    private final String nodeId;
    private final int blockno;
    private long documents;
    private HashMap locationMap = new HashMap();

    public InvertedIndex(String nodeId_, int blockno_, long documents_) {
        this.nodeId = nodeId_;
        this.blockno = blockno_;
        this.documents = documents_;
    }

    public InvertedIndex(InvertedIndex iidx) {
        this.nodeId = new String(iidx.getNodeId());
        this.blockno = iidx.getBlockNo();
        this.documents = iidx.getDocumentAvailability();
        this.locationMap = (HashMap)iidx.locationMap.clone();
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public int getBlockNo() {
        return this.blockno;
    }

    public void setDocumentAvailability(long doc) {
        this.setDocumentAvailability(doc, true);
    }

    public void setDocumentAvailability(long doc, boolean filter) {
        if (filter) {
            this.filterLocations(doc);
        }
        this.documents = doc;
    }

    public long getDocumentAvailability() {
        return this.documents;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof InvertedIndex)) {
            return false;
        }
        InvertedIndex iidx = (InvertedIndex)o;
        return iidx.blockno == this.blockno && iidx.nodeId.equals(this.nodeId);
    }

    public int hashCode() {
        return this.nodeId.hashCode() * this.blockno + this.blockno / 2;
    }

    public void addLocation(Location location) {
        HashMap hashMap = this.locationMap;
        synchronized (hashMap) {
            Integer docno = new Integer(location.getDocno());
            ArrayList<Location> locations = (ArrayList<Location>)this.locationMap.get(docno);
            if (locations == null) {
                locations = new ArrayList<Location>();
            }
            locations.add(location);
            this.locationMap.put(docno, locations);
        }
    }

    public void removeLocation(Location location) {
        HashMap hashMap = this.locationMap;
        synchronized (hashMap) {
            int docno = location.getDocno();
            Integer docnoKey = new Integer(docno);
            ArrayList locations = (ArrayList)this.locationMap.get(docnoKey);
            if (locations == null) {
                return;
            }
            locations.remove(location);
            if (locations.size() == 0) {
                long filter = ~(1 << docno - this.blockno * 64);
                this.documents &= filter;
                this.locationMap.remove(docnoKey);
            } else {
                this.locationMap.put(docnoKey, locations);
            }
        }
    }

    public Location getLocation(int docno, int offset) {
        HashMap hashMap = this.locationMap;
        synchronized (hashMap) {
            ArrayList locations = (ArrayList)this.locationMap.get(new Integer(docno));
            if (locations == null || locations.size() == 0) {
                return null;
            }
            Location key = new Location(this.nodeId, docno, offset);
            int index = locations.indexOf(key);
            if (index < 0) {
                return null;
            }
            return (Location)locations.get(index);
        }
    }

    public boolean hasLocations() {
        return this.locationMap.size() > 0;
    }

    public boolean hasLocationsOf(int docno) {
        ArrayList locations = (ArrayList)this.locationMap.get(new Integer(docno));
        return locations != null && locations.size() > 0;
    }

    public Iterator iteratorLocations() {
        return new LocationIterator(this.locationMap);
    }

    protected void filterLocations(long documents) {
        long filter = 1L;
        int docno = this.blockno * 64;
        int i = 0;
        while (i < 64) {
            if ((documents & filter) == 0L) {
                HashMap hashMap = this.locationMap;
                synchronized (hashMap) {
                    Integer key = new Integer(docno);
                    ArrayList locations = (ArrayList)this.locationMap.get(key);
                    if (locations != null) {
                        locations.clear();
                        this.locationMap.remove(key);
                    }
                }
            }
            ++i;
            filter <<= 1;
            ++docno;
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        return new InvertedIndex(this);
    }

    class LocationIterator
    implements Iterator {
        private final ArrayList values = new ArrayList();
        private final Iterator listIterator;

        protected LocationIterator(Map m) {
            Map map = m;
            synchronized (map) {
                Iterator it = m.values().iterator();
                while (it.hasNext()) {
                    List locations = (List)it.next();
                    if (locations == null) continue;
                    this.values.addAll(locations);
                }
            }
            this.listIterator = this.values.iterator();
        }

        public void remove() {
            this.listIterator.remove();
        }

        public boolean hasNext() {
            return this.listIterator.hasNext();
        }

        public Object next() {
            return this.listIterator.next();
        }
    }
}

