/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.koike.tools.isys;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import org.logical_paradox.koike.core.indexer.IndexAccessException;
import org.logical_paradox.koike.core.indexer.IndexAccessor;
import org.logical_paradox.koike.core.parser.Term;
import org.logical_paradox.koike.core.search.InvertedIndex;
import org.logical_paradox.koike.core.search.KoikeIndexResultSet;
import org.logical_paradox.koike.core.search.Location;
import org.logical_paradox.koike.tools.isys.StubProperty;

public class StubIndexAccessor
implements IndexAccessor {
    private Properties index = new Properties();
    public static final String STUB_INDEX_DATADIR = StubProperty.getProperty("data.stub");
    public static final String STUB_INDEX_DATAFILE = String.valueOf(STUB_INDEX_DATADIR) + File.separator + "stub.index";
    private boolean closed = false;

    public boolean isClosed() {
        return this.closed;
    }

    public void close() throws IndexAccessException {
        try {
            this.index.store(new FileOutputStream(STUB_INDEX_DATAFILE), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IndexAccessException(e);
        }
        this.closed = true;
    }

    public void load() throws FileNotFoundException, IOException {
        this.index = new Properties();
        this.index.load(new FileInputStream(STUB_INDEX_DATAFILE));
    }

    public synchronized void addTerm(String digest, Term[] term) throws IndexAccessException {
        if (digest.indexOf(":") != digest.lastIndexOf(":") || digest.indexOf(":") < 0) {
            throw new IndexAccessException();
        }
        String[] tokens = digest.split(":");
        String nodeId = tokens[0];
        int docno = Integer.parseInt(tokens[1]);
        int i = 0;
        while (i < term.length) {
            String locations = (String)this.index.get(term[i].getTerm());
            if (locations == null) {
                locations = "";
            }
            StringBuffer sb = new StringBuffer(locations);
            Term t = term[i];
            Iterator it = t.iterator();
            while (it.hasNext()) {
                Integer pos = (Integer)it.next();
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(String.valueOf(nodeId) + ":" + docno + ":" + pos);
            }
            this.index.put(t.getTerm(), sb.toString());
            ++i;
        }
    }

    public Object removeTerm(String key) throws IndexAccessException {
        return this.index.remove(key);
    }

    public KoikeIndexResultSet getValue(String key) throws IndexAccessException {
        String value = (String)this.index.get(key);
        if (value == null) {
            return null;
        }
        KoikeIndexResultSet rs = new KoikeIndexResultSet();
        String[] values = value.split(",");
        int i = 0;
        while (i < values.length) {
            String[] tokens = values[i].split(":");
            String nodeId = tokens[0];
            int docno = Integer.parseInt(tokens[1]);
            int pos = Integer.parseInt(tokens[2]);
            int blkno = docno / 64;
            long documents = 1 << docno - blkno * 64;
            InvertedIndex iidx = rs.getInvertedIndex(nodeId, blkno);
            if (iidx != null) {
                documents |= iidx.getDocumentAvailability();
            } else {
                iidx = new InvertedIndex(nodeId, blkno, 0L);
            }
            iidx.setDocumentAvailability(documents);
            iidx.addLocation(new Location(nodeId, docno, pos));
            rs.addInvertedIndex(iidx);
            ++i;
        }
        return rs;
    }
}

