/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: MySQLInvertedIndexRegistrar.java,v 1.1 2005/11/29 16:46:21 rampil Exp $
 */
package org.logical_paradox.koike.rss.index;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logical_paradox.common.util.StringUtils;
import org.logical_paradox.koike.core.indexer.IndexAccessException;
import org.logical_paradox.koike.core.parser.Term;
import org.logical_paradox.rss.util.DocumentIdGenerator;

/**
 * ]uCfbNXo^Xbh
 * p[U[ғĂԂɓ삷\D
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class MySQLInvertedIndexRegistrar extends Thread {
	/** K[ */
	private static final Log log = LogFactory.getLog(MySQLInvertedIndexRegistrar.class);
	/** o^Ώۍꎫ */
	private HashMap queue = new HashMap();
	/** f[^x[Xڑ */
	private final Connection con;

	/** base64 encoder/decoder */
	private final Base64 base64 = new Base64();


	/**
	 * RXgN^D
	 * @param c f[^x[Xڑ
	 */
	public MySQLInvertedIndexRegistrar(Connection c) {
		con = c;
		setDaemon(true);
	}
	/**
	 * XbhCD
	 */
	public void run() {
		try {
			while(true) {
				synchronized(queue) {
					while(queue.size() == 0) {
						queue.wait();
					}
					try {
						// o^(])
						register();
					} catch(Exception iae) {
						// ̍̓o^ɎsC\Ȍ菈𑱍s
						// ͖Ă
						log.warn("̓o^ɗO܂:", iae);
					}
				}
			}
		} catch(InterruptedException e) {
			// Xbh̒~
		}
	}
	/**
	 * L[ɓo^D
	 * L[ɓo^ƁCK؂ȃ^C~Oœo^ND
	 * @param digest 肷_CWFXg
	 * @param term ̔z
	 */
	protected void add(String digest, Term[] term) throws IndexAccessException {
		synchronized(queue) {
			// R[hԍ(documentԍ)ɑΉL[o
			// L[݂ȂꍇCV쐬
			long recordNo = DocumentIdGenerator.getDocumentNo(digest);
			Long queueId = new Long(recordNo);
			HashMap recordQueue = (HashMap)queue.get(queueId);
			if(recordQueue == null) {
				recordQueue = new HashMap();
			}
			for(int i = 0; i < term.length; i++) {
				String locations = (String)recordQueue.get(term);
				if(locations == null) {
					locations = "";
				}
				for(Iterator it = term[i].iterator(); it.hasNext();) {
					Integer offset = (Integer)it.next();
					if(StringUtils.isEmpty(locations) == false) {
						locations = locations + ",";
					}
					locations += offset;
					recordQueue.put(term[i].getTerm(), locations);
				}
			}
			queue.put(queueId, recordQueue);
			// L[ő҂ĂXbhN
			queue.notifyAll();
		}
	}
	/**
	 * f[^x[Xɓo^D
	 */
	protected void register() throws IndexAccessException {
		// L[Rs[
		HashMap map = null;
		synchronized(queue) {
			map = (HashMap)queue.clone();
			for(Iterator it = queue.keySet().iterator(); it.hasNext();) {
				Long qid = (Long)it.next();
				HashMap rq = (HashMap)queue.get(qid);
				if(rq != null) {
					map.put(qid, rq.clone());
					rq.clear();
				}
			}
			queue.clear();
		}

		for(Iterator it = map.keySet().iterator(); it.hasNext();) {
			Long qid = (Long)it.next();
			HashMap rq = (HashMap)map.get(qid);
			if(rq == null || rq.size() == 0) {
				// ML[݂Ȃꍇ͉Ȃ
				continue;	
			}

			// f[^x[Xɓ]uCfbNXo^SQL̍\z
			// 萔ł߂Ƃ
			StringBuffer sb = new StringBuffer();
			sb.append("insert into inverted_index values");
			int length = rq.keySet().size();

			for(int i = 0; i < length; i++) {
				if(i > 0) {
					sb.append(",");
				}
				sb.append("(?,?,?)");
			}
			PreparedStatement pstmt = null;
			try {
				pstmt = con.prepareStatement(sb.toString());
			} catch(SQLException se) {
				log.error("o^ɃG[܂:", se);
				return;
			}

			try {
				int paramCnt = 1;
				for(Iterator qit = rq.keySet().iterator(); qit.hasNext();) {
					String key = (String)qit.next();
					String value = (String)rq.get(key);
	
					// 
					String term = new String(base64.encode(key.getBytes()));
					pstmt.setString(paramCnt++, term);
					// R[hԍ
					pstmt.setLong(paramCnt++, qid.longValue());
					// ʒu
					pstmt.setString(paramCnt++, value);
				}

				// ̐ݒ肪̂ňxcommit
				pstmt.executeUpdate();
				pstmt.close();

				// ̃hLg̑ML[NA
				rq.clear();
			} catch(Exception se) {
				log.warn("o^Ɏs: ", se);
				// o^ɎsꍇCPɓo^𖳎
			}
		}
		// ML[ŜNA
		map.clear();
	}
	/**
	 * Xbh~D
	 */
	protected void shutdown() {
		interrupt();
	}
}
