/*
 * $Id: IndexTermWordListTableModel.java,v 1.1 2005/11/14 14:15:51 rampil Exp $
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 *
 */
package org.logical_paradox.koike.rss.tools.itb;

import javax.swing.table.AbstractTableModel;

import org.logical_paradox.koike.rss.tools.itb.search.QueryRecord;

/**
 * ʈꗗ̃e[uf
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class IndexTermWordListTableModel extends AbstractTableModel {
	/** wb_` */
	private static final String HEADER_LABELS[] = {"term", "locations"};

	/** ێĂ1ʗp̌ */
	private QueryRecord[] searchResult;


	/**
	 * ڐԂD
	 * @return ڐ
	 */
	public int getColumnCount() {
		return HEADER_LABELS.length;
	}

	/**
	 * ݂̃R[hԂD
	 * @return R[h
	 */
	public int getRowCount() {
		return searchResult == null ? 0 : searchResult.length;
	}

	/**
	 * tB[hҏWۂԂD
	 * @param rowIndex sԍ
	 * @param columnIndex ڔԍ
	 * @return false(ɕҏWs)
	 */
	public boolean isCellEditable(int rowIndex, int columnIndex) {
		return false;
	}

	/**
	 * wb_̍ږԂD
	 * @param columnIndex ڔԍ
	 * @return ږ
	 */
	public String getColumnName(int columnIndex) {
		return HEADER_LABELS[columnIndex];
	}

	/**
	 * R[hlԂD
	 * @param rowIndex sԍ
	 * @param columnIndex ڔԍ
	 * @return 
	 */
	public Object getValueAt(int rowIndex, int columnIndex) {
		if(searchResult == null || searchResult.length <= rowIndex) {
			return "";
		}
		QueryRecord r = searchResult[rowIndex];
		String rc = "";
		switch(columnIndex) {
			case 0:
				rc = r.getTerm();
				break;
			case 1:
				rc =r.getLocation();
				break;
			default:
				break;
		}

		return rc;
	}

	/**
	 * (1ʕ)ݒ肷D
	 * @param qrs 
	 */
	public void setResults(QueryRecord[] qrs) {
		searchResult = qrs;
	}
}
