/*
 * $Id: MySQLSelect.java,v 1.4 2005/11/30 13:24:37 rampil Exp $
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 *
 */
package org.logical_paradox.koike.rss.tools.itb.search.impl;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logical_paradox.koike.rss.tools.DataSourceException;
import org.logical_paradox.koike.rss.tools.itb.BrowserProperties;
import org.logical_paradox.koike.rss.tools.itb.search.Query;
import org.logical_paradox.koike.rss.tools.itb.search.QueryRecord;
import org.logical_paradox.koike.rss.tools.itb.search.Select;

/**
 * MySQLɐڑ^CṽR[hZN^
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.4 $
 */
public class MySQLSelect implements Select {
	/** JDBChCoNX */
	public static final String JDBC_DRIVER = "com.mysql.jdbc.Driver";
	/** ꌟNG[ */
	public static final String INDEX_TERM_QUERY = "SELECT term, docno, location FROM inverted_index";
	/** ꌏ擾NG[ */
	public static final String COUNT_TERM_QUERY = "SELECT count(*) as c FROM inverted_index";
	/** K[ */
	private static final Log log = LogFactory.getLog(MySQLSelect.class);

	/** JDBCڑ */
	private Connection con;

	/** base64 encoder/decoder */
	private Base64 base64 = new Base64();

	/**
	 * f[^\[XƂ̐ڑI[vD
	 * @param connstr ڑ
	 * @throws DataSourceException f[^\[XƂ̐ڑɎs
	 */
	public void open(String connstr) throws DataSourceException {
		try {
			Class.forName(JDBC_DRIVER);
			con = DriverManager.getConnection(connstr);
		} catch(Exception e) {
			throw new DataSourceException(e);
		}
	}
	/**
	 * f[^\[XƂ̐ڑD
	 * @throws DataSourceException f[^\[XƂ̐ؒfɎs
	 */
	public void close() throws DataSourceException {
		if(con != null) {
			try {
				con.close();
			} catch(Exception e) {
				throw new DataSourceException(e);
			}
			con = null;
		}
	}

	/**
	 * ʂԂD
	 * @param q NG[
	 * @return ʃR[h(܂ɑꍇCKɃJbg)
	 * @throws DataSourceException f[^\[XƂ̐ڑɎs
	 */
	public QueryRecord[] executeQuery(Query q) throws DataSourceException {
		PreparedStatement pstmt = null;

		if(q.getTerm() != null && q.getTerm().trim().length() > 0) {
			try {
				String term = new String(base64.encode(q.getTerm().getBytes()));
				pstmt = con.prepareStatement(INDEX_TERM_QUERY + " WHERE term=?");
				pstmt.setString(1, term);
			} catch(SQLException e) {
				throw new DataSourceException(e);
			}
		} else {
			int from = q.getFrom() == Query.NaN ? 0 : q.getFrom();
			int to = q.getTo() == Query.NaN ? BrowserProperties.getIntegerProperty("select.param.rows").intValue() : q.getTo();

			// VNG[ݒ肷
			q.setFrom(from);
			q.setTo(to);
			try {
				pstmt = con.prepareStatement(INDEX_TERM_QUERY + " LIMIT ?,?");
				pstmt.setInt(1, from);
				pstmt.setInt(2, to - from);
			} catch(SQLException e) {
				throw new DataSourceException(e);
			}
		}

		ResultSet rs = null;
		ArrayList results = new ArrayList();
		try {
			rs = pstmt.executeQuery();
			while(rs.next()) {
				QueryRecord qr = new QueryRecord();
				qr.setTerm(new String(base64.decode(rs.getString("term").getBytes())));
				qr.setLocation(rs.getString("location"));

				results.add(qr);
			}
		} catch(SQLException e) {
			try {
				if(rs != null) {
					rs.close();
				}
				if(pstmt != null) {
					pstmt.close();
				}
			} catch(SQLException e1) {
			}
		} finally {
			rs = null;
			pstmt = null;
		}

		return (QueryRecord[])results.toArray(new QueryRecord[0]);
	}

	/**
	 * wŃqbg錟ʐԂD
	 * @param q NG[
	 * @return 
	 * @throws DataSourceException f[^\[XƂ̐ڑɎs
	 */
	public int countQuery(Query q) throws DataSourceException {
		ResultSet rs = null;
		Statement st = null;
		int count = 0;

		try {
			st = con.createStatement();
			rs = st.executeQuery(COUNT_TERM_QUERY);

			if(rs.next()) {
				count = rs.getInt("c");
			}
		} catch(SQLException e) {
			try {
				if(rs != null) {
					rs.close();
				}
				if(st != null) {
					st.close();
				}
			} catch(SQLException e1) {
			} finally {
				rs = null;
				st = null;
			}
		}

		return count;
	}

}
