/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.encoding.soapenc;

import java.io.IOException;
import java.io.Writer;
import org.apache.soap.Constants;
import org.apache.soap.util.xml.DOMUtils;
import org.apache.soap.util.xml.NSStack;
import org.apache.soap.util.xml.QName;
import org.apache.soap.util.xml.XMLJavaMappingRegistry;
import org.w3c.dom.Element;

public class SoapEncUtils {
    public static void generateArrayHeader(String string, Class clazz, Object object, Writer writer, NSStack nSStack, XMLJavaMappingRegistry xMLJavaMappingRegistry, QName qName, String string2) throws IllegalArgumentException, IOException {
        SoapEncUtils.generateStructureHeader(string, clazz, object, writer, nSStack, xMLJavaMappingRegistry, qName, string2, false);
    }

    public static void generateNullArray(String string, Class clazz, Object object, Writer writer, NSStack nSStack, XMLJavaMappingRegistry xMLJavaMappingRegistry, QName qName, String string2) throws IllegalArgumentException, IOException {
        SoapEncUtils.generateStructureHeader(string, clazz, object, writer, nSStack, xMLJavaMappingRegistry, qName, string2, true);
    }

    public static void generateNullStructure(String string, Class clazz, Object object, Writer writer, NSStack nSStack, XMLJavaMappingRegistry xMLJavaMappingRegistry) throws IllegalArgumentException, IOException {
        SoapEncUtils.generateStructureHeader(string, clazz, object, writer, nSStack, xMLJavaMappingRegistry, null, null, true);
    }

    public static void generateStructureHeader(String string, Class clazz, Object object, Writer writer, NSStack nSStack, XMLJavaMappingRegistry xMLJavaMappingRegistry) throws IllegalArgumentException, IOException {
        SoapEncUtils.generateStructureHeader(string, clazz, object, writer, nSStack, xMLJavaMappingRegistry, null, null, false);
    }

    private static void generateStructureHeader(String string, Class clazz, Object object, Writer writer, NSStack nSStack, XMLJavaMappingRegistry xMLJavaMappingRegistry, QName qName, String string2, boolean bl) throws IllegalArgumentException, IOException {
        String string3;
        QName qName2 = xMLJavaMappingRegistry.queryElementType(clazz, "http://schemas.xmlsoap.org/soap/encoding/");
        writer.write(String.valueOf('<') + object.toString());
        String string4 = nSStack.getPrefixFromURI("http://www.w3.org/1999/XMLSchema-instance", writer);
        String string5 = nSStack.getPrefixFromURI(qName2.getNamespaceURI(), writer);
        writer.write(String.valueOf(' ') + string4 + ':' + "type" + "=\"" + string5 + ':' + qName2.getLocalPart() + '\"');
        if (string == null || !string.equals("http://schemas.xmlsoap.org/soap/encoding/")) {
            string3 = nSStack.getPrefixFromURI("http://schemas.xmlsoap.org/soap/envelope/", writer);
            writer.write(String.valueOf(' ') + string3 + ':' + "encodingStyle" + "=\"" + "http://schemas.xmlsoap.org/soap/encoding/" + '\"');
        }
        if (qName != null) {
            string3 = nSStack.getPrefixFromURI(qName.getNamespaceURI(), writer);
            String string6 = String.valueOf(string3) + ':' + qName.getLocalPart() + '[' + string2 + ']';
            String string7 = nSStack.getPrefixFromURI("http://schemas.xmlsoap.org/soap/encoding/", writer);
            writer.write(String.valueOf(' ') + string7 + ':' + "arrayType" + "=\"" + string6 + '\"');
        }
        if (bl) {
            writer.write(String.valueOf(' ') + string4 + ':' + "null" + "=\"" + Constants.ATTRVAL_TRUE + "\"/");
        }
        writer.write(62);
    }

    public static QName getAttributeValue(Element element, String string, String string2, String string3, boolean bl) throws IllegalArgumentException {
        String string4 = DOMUtils.getAttributeNS(element, string, string2);
        if (string4 != null) {
            int n = string4.indexOf(58);
            if (n != -1) {
                String string5 = string4.substring(0, n);
                String string6 = string4.substring(n + 1);
                String string7 = DOMUtils.getNamespaceURIFromPrefix(element, string5);
                if (string7 != null) {
                    return new QName(string7, string6);
                }
                throw new IllegalArgumentException("Unable to resolve namespace URI for '" + string5 + "'.");
            }
            throw new IllegalArgumentException("The value of the '" + string + ':' + string2 + "' attribute must be " + "namespace-qualified.");
        }
        if (bl) {
            throw new IllegalArgumentException("The '" + string + ':' + string2 + "' attribute must be " + "specified for every " + string3 + '.');
        }
        return null;
    }

    public static QName getTypeQName(Element element) throws IllegalArgumentException {
        QName qName = SoapEncUtils.getAttributeValue(element, "http://www.w3.org/1999/XMLSchema-instance", "type", null, false);
        if (qName != null) {
            return qName;
        }
        qName = SoapEncUtils.getAttributeValue(element, "http://www.w3.org/2000/10/XMLSchema-instance", "type", null, false);
        if (qName != null) {
            return qName;
        }
        qName = SoapEncUtils.getAttributeValue(element, "http://www.w3.org/2001/XMLSchema-instance", "type", null, false);
        return qName;
    }

    public static boolean isNull(Element element) {
        String string = DOMUtils.getAttributeNS(element, "http://www.w3.org/1999/XMLSchema-instance", "null");
        return string != null && string.equals(Constants.ATTRVAL_TRUE);
    }
}

