/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

//
//	Xe[^XLOOf[^ANZXNX
//			ύX
//				2004.01.08	VK쐬	񞊒q
//
package jp.co.ntt.lms.lo;

// java AIP
import java.util.*;
import java.sql.*;
import java.sql.SQLException;

import org.apache.commons.lang.StringEscapeUtils;

// XMS API
import jp.co.ntt.lms.xmo.DataAccess;
import jp.co.ntt.lms.lo.LoLogRecord;

import jp.co.ntt.lms.xmo.Environment;

import jp.co.ntt.lms.xmo.util.*;

/**
 * Xe[^XLOO@f[^ANZXNXłB<BR>
 * @version 0.0.0.1 2004/01/08
 * @author T.Nijou
 */
public class LoLogDataAccess
{

	/** e[uێ܂ */
	private static final String TABLE_NAME = "LOLog";

	/** LOe[uێ܂ */
	private static final String RELATION_TABLE_NAME = "LO";

	/** e[u` */
	private static final String FULLSCORE 			= "fullscore";			// _
	private static final String STUDY_START_DATE 	= "study_start_date";	// wKJn
	private static final String RESIDANCETIME 		= "residanceTime";		// ݐϑ؍ݎ
	private static final String PASSDAY 			= "passday";			// i
	private static final String STUDY_END_DATE 		= "study_end_date";		// C
	private static final String HIGHTSCORE 			= "highScore";			// ō_
	private static final String LOWSSCORE 			= "lowsScore";			// Œ_
	private static final String EXECISE_POINT 		= "execise_point";		// _
	private static final String USERID 				= "UserID";				// [UID
	private static final String LOID 				= "LOID";				// LOID
	private static final String CONDITION_KEY 		= "condition_key";		// ConditionKey
	private static final String ACCESS_CNT 			= "Access_cnt";			// ANZX
	private static final String LAST_ACCESS 		= "last_access";		// ŏIANZX

	/** LORelatione[ũe[uƃtB[hێ܂ */
	private static final String TABLE_LORELATION = "LORelation";
	private static final String CHILDID = "childID";					// childID
	private static final String PARENTID = "parentID";					// parentID

	private static final String TABLE_LO = "LO";

	/** LOe[u` */
	private static final String REAL_LOID = "RealLOID";					// RealLOID

	// Xe[^X
	/** iXe[^X */
	public static final char STATUS_PASSED = 'p';
	/** CXe[^X */
	public static final char STATUS_COMPLETED = 'c';
	/** siACAwK */
	public static final char STATUS_FAILED = 'f';

	/**
	 * RXgN^
	 **/
	public LoLogDataAccess() {
	}

	/**
	 * Xe[^XLOOe[u֓o^s܂
	 * @param objLoLog Of[^NX
	 * @exception SQLException DBɎsꍇ
	 * @exception LOException LOƎO
	 */
	public void insert( LoLogRecord[] objLoLog )
		throws LOException
	{
		// f[^ANZXNXCX^X܂
		DataAccess objDataAccess = new DataAccess(TABLE_NAME);
		try {
			// gUNVJn
			objDataAccess.trans();

			// o^s܂(z񐔕[v)
			for( int i = 0; i < objLoLog.length; i++ ) {
				insertActionCheck( objLoLog[i], objDataAccess );
			}

			// R~bg
			objDataAccess.commit();
		}
		catch( SQLException e ) {
			e.printStackTrace();
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			// f[^x[XG[ݒ
			throw new LOException( e.getMessage() );
		}
	}

	/**
	 * Xe[^XLOOe[u֓o^s܂
	 * @param objLoLog Of[^NX
 	 * @param objDataAccess f[^ANZXNX
	 * @exception SQLException DBɎsꍇ
	 * @exception LOException LOƎO
	 */
	public void insert( LoLogRecord[] objLoLog, DataAccess objDataAccess)
		throws LOException
	{
		try {

			// o^s܂(z񐔕[v)
			for( int i = 0; i < objLoLog.length; i++ ) {
				insertActionCheck( objLoLog[i], objDataAccess );
			}

		}
		catch( SQLException e ) {
			e.printStackTrace();
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			// f[^x[XG[ݒ
			throw new LOException( e.getMessage() );
		}
	}

	/**
	 * Xe[^XLOOe[u֓o^s܂
	 * @param objLoLog Of[^NX
	 * @exception SQLException DBɎsꍇ
	 * @exception LOException LOƎO
	 */
	public void insert( LoLogRecord objLoLog )
		throws LOException
	{
		// f[^ANZXNXCX^X܂
		DataAccess objDataAccess = new DataAccess(TABLE_NAME);
		try {
			// gUNVJn
			objDataAccess.trans();

			// o^s܂(z񐔕[v)
			insertActionCheck( objLoLog, objDataAccess );

			// R~bg
			objDataAccess.commit();
		}
		catch( SQLException e ) {
			e.printStackTrace();
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			// f[^x[XG[ݒ
			throw new LOException( e.getMessage() );
		}
	}

	/**
	 * Xe[^XLOOe[uւ̓o^s܂
	 * @param objLoLog Of[^NX
	 * @exception SQLException DBG[
	 */
	private void insertAction( LoLogRecord objLoLog, DataAccess objDataAccess )
		throws SQLException
	{
		try
		{
			// o^SQLspHashtable
			Hashtable htbData = new Hashtable();

			// DBɓo^f[^nbVe[uɊi[܂
			if(objLoLog.getFullScore() != null){
				if(!objLoLog.getFullScore().equals("")){
					htbData.put( FULLSCORE, objLoLog.getFullScore() );
				}
			}

			if(objLoLog.getStudyStartDate() != null){
				if(!objLoLog.getStudyStartDate().equals("")){
					htbData.put( STUDY_START_DATE, objLoLog.getStudyStartDate() );
				}
			}

			if(objLoLog.getResidanceTime() != null){
				if(!objLoLog.getResidanceTime().equals("")){
					htbData.put( RESIDANCETIME, objLoLog.getResidanceTime() );
				}
			}

			if(objLoLog.getPassday() != null){
				if(!objLoLog.getPassday().equals("")){
					htbData.put( PASSDAY, objLoLog.getPassday() );
				}
			}

			if(objLoLog.getStudyEndDate() != null){
				if(!objLoLog.getStudyEndDate().equals("")){
					htbData.put( STUDY_END_DATE, objLoLog.getStudyEndDate() );
				}
			}

			if(objLoLog.getAccessCnt() != null){
				if(!objLoLog.getAccessCnt().equals("")){
					htbData.put( ACCESS_CNT, objLoLog.getAccessCnt() );
				}
			}

			if(objLoLog.getLastAccess() != null ){
				if(!objLoLog.getLastAccess().equals("")){
					htbData.put( LAST_ACCESS, objLoLog.getLastAccess() );
				}
			}

			if(objLoLog.getHighScore() != null ){
				if(!objLoLog.getHighScore().equals("")){
					htbData.put( HIGHTSCORE, objLoLog.getHighScore() );
				}
			}

			if(objLoLog.getLowScore() != null ){
				if(!objLoLog.getLowScore().equals("")){
					htbData.put( LOWSSCORE, objLoLog.getLowScore() );
				}
			}

			if(objLoLog.getExecisePoint() != null ){
				if(!objLoLog.getExecisePoint().equals("")){
					htbData.put( EXECISE_POINT, objLoLog.getExecisePoint() );
				}
			}

			if(objLoLog.getUserID() != null ){
				if(!objLoLog.getUserID().equals("")){
					htbData.put( USERID, objLoLog.getUserID() );
				}
			}

			if(objLoLog.getLoID() != null ){
				if(!objLoLog.getLoID().equals("")){
					htbData.put( LOID, objLoLog.getLoID() );
				}
			}

			// o^pSQL𐶐܂
			String strSQL = objDataAccess.getInsertSQL( htbData, TABLE_NAME );

			// o^s
			objDataAccess.execute( strSQL );
		}
		catch ( SQLException se )
		{
			se.printStackTrace();
			DebugLog.write( this.getClass(), se, DebugLog.HIGHT );
			// f[^x[XG[ݒ
			throw new SQLException( se.getMessage() );
		}
	}

	/**
	 * Xe[^XLOOe[uւ̓o^s܂
	 * @param htbData Of[^
	 * @exception SQLException DBG[
	 */
	private void insertAction( Hashtable htbData, DataAccess objDataAccess )
		throws SQLException
	{

		// o^pSQL𐶐܂
		String strSQL = objDataAccess.getInsertSQL( htbData, TABLE_NAME );

		// o^s
		objDataAccess.execute( strSQL );
	}

	/**
	 * Xe[^XLOOe[uւ̓o^s܂(d`FbNtj
	 * @param htbData Of[^
	 * @exception SQLException DBG[
	 */
	private void insertActionCheck( Hashtable htbData, DataAccess objDataAccess )
		throws SQLException
	{
		// [UIDLOIDꃌR[h݂Ȃꍇ̂݃CT[gB
		if( getLoLog( (String)htbData.get( USERID ), (String)htbData.get( LOID ), objDataAccess ) == null ) {
			// o^
			insertAction( htbData, objDataAccess );
		}
	}

	/**
	 * Xe[^XLOOe[uւ̓o^s܂(d`FbNtj
	 * @param objLoLog Of[^NX
	 * @exception SQLException DBG[
	 */
	private void insertActionCheck( LoLogRecord objLoLog, DataAccess objDataAccess )
		throws SQLException
	{
		// [UIDLOIDꃌR[h݂Ȃꍇ̂݃CT[gB
		if( getLoLog( objLoLog.getUserID(), objLoLog.getLoID(), objDataAccess ) == null ) {
			// o^
			insertAction( objLoLog, objDataAccess );
		}
	}
	/**
	 * Xe[^XLOOe[u֍XVs܂
	 * @param objLoLog Of[^NX
	 * @exception SQLException DBɎsꍇ
	 * @exception LOException LOƎO
	 */
	public void update( Hashtable htbParam )
		throws LOException
	{
		// f[^ANZXNXCX^X܂
		DataAccess objDataAccess = new DataAccess(TABLE_NAME);
		try {
			// gUNVJn
			objDataAccess.trans();

			// LOf[^null̂Ƃ
			if( htbParam != null ) {
				updateAction( htbParam, objDataAccess );
			}

			// R~bg
			objDataAccess.commit();
		}
		catch( SQLException e ) {
			e.printStackTrace();
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			// f[^x[XG[ݒ
			throw new LOException( e.getMessage() );
		}
	}

	/**
	 * Xe[^XLOOe[uւ̍XVs܂
	 * @param objLoLog Of[^NX
	 * @exception SQLException DBG[
	 */
	private void updateAction( Hashtable htParam, DataAccess objDataAccess )
		throws SQLException
	{
		// XVp̃f[^Zbg܂
		Hashtable htbData = setData( htParam );

		//SQLҏW܂
		String strExecisePoint = "";
		String strPassDay = "";
		String strEndDay = "";
		String strSQL = "";
		String strAccessCnt = "";
		String strLastAccess = "";
		StringBuffer sbSQL = new StringBuffer();
		//Xe[^XXVp
		if(htParam.get( "EDIT_SELF" )!=null){
			sbSQL.append("Update " + TABLE_NAME + " Set ");
			//_
			strExecisePoint = (String)htParam.get( EXECISE_POINT );
			sbSQL.append(strExecisePoint);
			//i
			strPassDay = (String)htParam.get( PASSDAY );
			if(sbSQL!=null && strPassDay!=null){
				sbSQL.append(" , " + strPassDay);
			}
			//I
			strEndDay = (String)htParam.get( STUDY_END_DATE );
			if(sbSQL!=null && strEndDay!=null){
				sbSQL.append(" , " + strEndDay);
			}
			//ANZX
			strAccessCnt = (String)htParam.get( ACCESS_CNT );
			if(sbSQL!=null && strAccessCnt!=null){
				sbSQL.append(" , " + strAccessCnt);
			}
			//ŏIANZX
			strLastAccess = (String)htParam.get( LAST_ACCESS );

			if(sbSQL!=null && strLastAccess!=null){
				sbSQL.append(" , " + strLastAccess);
			}
			strSQL = sbSQL.toString();
		}
		//̑
		else{
			strSQL = objDataAccess.getUpdateSQL(htbData, TABLE_NAME);
		}

		// ̎擾
		String strCondition = (String)htParam.get( CONDITION_KEY );
		if( strCondition != null ) {
			strSQL += strCondition;
		}

		// XVs
		objDataAccess.execute( strSQL );
	}

	/**
	 * Xe[^XLOOe[uւ̍XVs܂
	 * @param htbParam XV
	 * @param strUserID [UID
	 * @param strLoID LOID
	 */
	public void updateAction(	Hashtable htbParam,
								String strUserID,
								String strLoID,
								DataAccess objDataAccess )
		throws SQLException
	{
		String strCondition = createCondition( strUserID, strLoID );
		String strSQL = objDataAccess.getUpdateSQL( htbParam, TABLE_NAME );
		strSQL += strCondition;

		// XVs
		objDataAccess.execute( strSQL );

	}

	/**
	 * Xe[^XOo^܂͍XV܂B<BR>
	 * @param objLoLog XVe
	 * @param strUserID [UID
	 * @param strLoID LOID
	 * @exception LOException LOƎO
	 */
	public void insertUpdate(	LoLogRecord objLoLog,
								String strUserID,
								String strLoID )
		throws LOException
	{
		// f[^ANZXNXCX^X܂
		DataAccess objDataAccess = new DataAccess(TABLE_NAME);
		try {
			// gUNVJn
			objDataAccess.trans();

			insertUpdate( objLoLog, strUserID, strLoID, objDataAccess );

			// R~bg
			objDataAccess.commit();
		}
		catch( SQLException e ) {
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			// f[^x[XG[ݒ
			throw new LOException( e.getMessage() );
		}
	}

	/**
	 * Xe[^XOo^܂͍XV܂B<BR>
	 * gUNV͏ʂs܂B
	 * @param objLoLog XVe
	 * @param strUserID [UID
	 * @param strLoID LOID
	 * @exception SQLException DBG[
	 */
	public void insertUpdate(	LoLogRecord objLoLog,
								String strUserID,
								String strLoID,
								DataAccess objDataAccess )
		throws SQLException
	{
		// o^܂͍XVpHashtable쐬
		Hashtable htbData = setData( objLoLog );

		// o^XVU蕪܂
		if( getLoLog( strUserID, strLoID, objDataAccess ) == null ) {
			// o^
			insertAction( htbData, objDataAccess );
		}
		else {
			updateAction( htbData, strUserID, strLoID, objDataAccess );
		}

	}

	/**
	 * Xe[^XLOOe[u֍XVs܂
	 * @param objLoLog Of[^NX
	 * @exception SQLException DBɎsꍇ
	 * @exception LOException LOƎO
	 */
	public void delete( Hashtable htbParam )
		throws LOException
	{
		// f[^ANZXNXCX^X܂
		DataAccess objDataAccess = new DataAccess(TABLE_NAME);
		try {
			// gUNVJn
			objDataAccess.trans();

			// 폜s܂
			deleteAction( htbParam, objDataAccess );

			// R~bg
			objDataAccess.commit();
		}
		catch( LOException le ) {
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			throw le;
		}
		catch( SQLException e ) {
			e.printStackTrace();
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			// f[^x[XG[ݒ
			throw new LOException( e.getMessage() );
		}
	}

	/**
	 * Xe[^XLOOe[uւ̍폜s܂
	 * @param objLoLog Of[^NX
	 * @exception SQLException DBG[
	 * @exception LOException LOƎO
	 */
	private void deleteAction( Hashtable htParam, DataAccess objDataAccess )
		throws SQLException, LOException
	{
		// SQL̑gݗ
		StringBuffer sbSQL = new StringBuffer();
		sbSQL.append( "DELETE FROM " + TABLE_NAME );

		// ̎擾
		String strCondition = (String)htParam.get( CONDITION_KEY );
		if( strCondition != null ) {
			sbSQL.append( strCondition );
		}
		// 폜s
		objDataAccess.execute( sbSQL.toString() );
	}

	/**
	 * [UIDLOIDw肵ăR[h폜܂B
	 * @param strUserID [UID
	 * @param strLoID LOID
	 * @exception SQLException
	 */
	public void delete( String strUserID, String strLoID, DataAccess objDataAccess )
		throws SQLException
	{
		StringBuffer sbSQL = new StringBuffer();
		sbSQL.append( "DELETE FROM " + TABLE_NAME );
		sbSQL.append( " WHERE " + USERID + "='" + StringEscapeUtils.escapeSql(strUserID) + "' AND " );
		sbSQL.append( LOID + "='" + StringEscapeUtils.escapeSql(strLoID) + "'" );

		objDataAccess.execute( new String( sbSQL ) );
	}

	/**
	 * LOLoge[u֌s܂B<BR>
	 * ȉ̏HashtableɊi[ēnĂB
	 * <PRE>
	 *             key                     
	 *          ---------------------------------------------
	 *             CONDITION_KEY           
	 *          ---------------------------------------------
	 * </PRE>
	 * @param htData 
	 * @return String (Iꍇ̂)
	 * @exception XMOException f[^x[XG[ꍇ
	 */
	public Vector select( Hashtable htbParam )
		throws LOException
	{
		// ߂l
		Vector vecReturn = new Vector();
		// f[^ANZXNXCX^X܂
		DataAccess objDataAccess = new DataAccess(TABLE_NAME);
		try {
			// gUNVJn
			objDataAccess.trans();

			// LOf[^null̂Ƃ
			if( htbParam != null ) {
				vecReturn = selectAction( htbParam, objDataAccess );
			}

			// R~bg
			objDataAccess.commit();
		}
		catch( SQLException e ) {
			e.printStackTrace();
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			// f[^x[XG[ݒ
			throw new LOException( e.getMessage() );
		}
		return vecReturn;
	}


	/**
	 * [UIDLOIDw肵āAs܂
	 * @param strUserID [UID
	 * @param strLoID LOID
	 * @return LoLogRecord[]  ʂȂꍇnull
	 * @exception LOException LOƎO
	 */
	public LoLogRecord getLoLog( String strUserID, String strLoID )
		throws LOException
	{
		if( strUserID == null && strLoID == null ) {
			return null;
		}

		DataAccess objDataAccess = new DataAccess(TABLE_NAME);
		LoLogRecord objRecord = null;
		try {
			// gUNVJn
			objDataAccess.trans();
			// SQLgݗ
			StringBuffer sbSQL = new StringBuffer();
			sbSQL.append("SELECT * FROM ");
			sbSQL.append(TABLE_NAME);
			sbSQL.append(" WHERE ");
			sbSQL.append( USERID );
			sbSQL.append( "='" );
			sbSQL.append( StringEscapeUtils.escapeSql(strUserID) );
			sbSQL.append( "' AND " );
			sbSQL.append( LOID );
			sbSQL.append( "='" );
			sbSQL.append( StringEscapeUtils.escapeSql(strLoID) );
			sbSQL.append( "'" );
			// s܂
			ResultSet rs = objDataAccess.executeQuery(sbSQL.toString());
			while(rs.next()) {
				objRecord = new LoLogRecord();
				objRecord.setFullScore( rs.getString( FULLSCORE ) );
				objRecord.setStudyStartDate( XMODate.parseTime(rs.getTimestamp( STUDY_START_DATE )) );
				objRecord.setResidanceTime( rs.getString( RESIDANCETIME ) );
				objRecord.setPassday( XMODate.parseTime(rs.getTimestamp( PASSDAY ) ));
				objRecord.setStudyEndDate( XMODate.parseTime(rs.getTimestamp( STUDY_END_DATE ) ));
				objRecord.setHighScore( rs.getString( HIGHTSCORE ) );
				objRecord.setLowScore( rs.getString( LOWSSCORE ) );
				objRecord.setExecisePoint( rs.getString( EXECISE_POINT ) );
				objRecord.setUserID( rs.getString( USERID ) );
				objRecord.setLoID( rs.getString( LOID ) );
				objRecord.setAccessCnt( rs.getString( ACCESS_CNT ) );
				objRecord.setLastAccess( XMODate.parseTime(rs.getTimestamp( LAST_ACCESS )) );
			}
			objDataAccess.commit();
		}
		catch( SQLException e ) {
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			// f[^x[XG[ݒ
			throw new LOException( e.getMessage() );
		}
		return objRecord;
	}

	/**
	 * [UIDLOIDw肵āAs܂<BR>
	 * ̃\bhgpۂ̓gUNV͏ʂŊǗ܂B
	 * @param strUserID [UID
	 * @param strLoID LOID
	 * @return LoLogRecord[]  ʂȂꍇnull
	 * @excetption SQLException DBG[
	 */
	public LoLogRecord getLoLog( String strUserID, String strLoID, DataAccess objDataAccess )
		throws SQLException
	{
		if( strUserID == null && strLoID == null ) {
			return null;
		}

		// SQLgݗ
		StringBuffer sbSQL = new StringBuffer();
		sbSQL.append("SELECT * FROM ");
		sbSQL.append(TABLE_NAME);
		try{
			//XMS.init@C[hNX̃CX^X
			Environment objEnv=new Environment();
			//SQLServeȑꍇ
			if(objEnv.getDBType().equals( objEnv.DB_SQLSERVER )){
				sbSQL.append(" WITH (TABLOCKX) ");
			}
			sbSQL.append(" WHERE ");
			sbSQL.append( USERID );
			sbSQL.append( "='" );
			sbSQL.append( StringEscapeUtils.escapeSql(strUserID) );
			sbSQL.append( "' AND " );
			sbSQL.append( LOID );
			sbSQL.append( "='" );
			sbSQL.append( StringEscapeUtils.escapeSql(strLoID) );
			sbSQL.append( "'" );
			//Oracleꍇ OR PostgreSQLꍇ
			if(objEnv.getDBType().equals( objEnv.DB_ORACLE ) || objEnv.getDBType().equals( objEnv.DB_POSTGRE )){ 
				sbSQL.append( " FOR UPDATE" );
			}
			
		}
		catch(Exception ex)
		{

		}
		// s܂
		DebugLog.write( this.getClass(), sbSQL.toString(), DebugLog.ROW );
		ResultSet rs = objDataAccess.executeQuery(sbSQL.toString());
		LoLogRecord objData = null;

		while(rs.next()) {
			objData = new LoLogRecord();
			objData.setFullScore( rs.getString( FULLSCORE ) );
			objData.setStudyStartDate( XMODate.parseTime(rs.getTimestamp( STUDY_START_DATE )) );
			objData.setResidanceTime( rs.getString( RESIDANCETIME ) );
			objData.setPassday( XMODate.parseTime(rs.getTimestamp( PASSDAY ) ));
			objData.setStudyEndDate( XMODate.parseTime(rs.getTimestamp( STUDY_END_DATE ) ));
			objData.setHighScore( rs.getString( HIGHTSCORE ) );
			objData.setLowScore( rs.getString( LOWSSCORE ) );
			objData.setExecisePoint( rs.getString( EXECISE_POINT ) );
			objData.setUserID( rs.getString( USERID ) );
			objData.setLoID( rs.getString( LOID ) );
			objData.setAccessCnt( rs.getString( ACCESS_CNT ) );

			objData.setLastAccess( XMODate.parseTime(rs.getTimestamp( LAST_ACCESS )) );
		}
		return objData;
	}

	/**
	 * Rs[LOIDw肵āAs܂
	 * Ɏ擾LOIDRs[LOIDɒuAf[^Zbg܂B
	 * ʂ͕ƂȂ邽߁A߂l͔zLoLogRecordƂȂ܂B
	 * ̃\bhgpۂ̓gUNV͏ʂŊǗ܂B
	 * @param strLoID Rs[LOID
	 * @param strCopyLoID Rs[LOID
	 * @param objDataAccess f[^ANZXIuWFNg
	 * @return LoLogRecord[]  ʂȂꍇnull
	 * @excetption SQLException DBG[
	 */
	public LoLogRecord[] getCopyLoLog( String strLoID, String strCopyLoID, DataAccess objDataAccess )
		throws SQLException
	{
		if( strLoID == null && strCopyLoID == null ) {
			return null;
		}

		// SQLgݗ
		StringBuffer sbSQL = new StringBuffer();
		sbSQL.append("SELECT * FROM ");
		sbSQL.append(TABLE_NAME);
		try{
			//XMS.init@C[hNX̃CX^X
			Environment objEnv=new Environment();
			//SQLServeȑꍇ
			if(objEnv.getDBType().equals( objEnv.DB_SQLSERVER )){
				sbSQL.append(" WITH (TABLOCKX) ");
			}

			sbSQL.append(" WHERE ");
			sbSQL.append( LOID );
			sbSQL.append( "='" );
			sbSQL.append( StringEscapeUtils.escapeSql(strLoID) );
			sbSQL.append( "'" );

			//Oracleꍇ OR PostgreSQLꍇ
			if(objEnv.getDBType().equals( objEnv.DB_ORACLE ) || objEnv.getDBType().equals( objEnv.DB_POSTGRE )){ 
				sbSQL.append( " FOR UPDATE" );
			}
		}
		catch(Exception ex)
		{

		}

		// s܂
		DebugLog.write( this.getClass(), sbSQL.toString(), DebugLog.ROW );
		ResultSet rs = objDataAccess.executeQuery(sbSQL.toString());
		LoLogRecord objData = null;
		Vector vecLoLogRecord = new Vector();
		while(rs.next()) {

			// LoLogf[^擾
			String strFullScore = rs.getString( FULLSCORE );
			String strStudyStartDate = XMODate.parseTime(rs.getTimestamp( STUDY_START_DATE ));
			String strResidenceTime = rs.getString( RESIDANCETIME );
			String strPassDay = XMODate.parseTime(rs.getTimestamp( PASSDAY ));
			String strStudyEndDate = XMODate.parseTime(rs.getTimestamp( STUDY_END_DATE ));
			String strHighScore = rs.getString( HIGHTSCORE );
			String strLowScore = rs.getString( LOWSSCORE );
			String strExecisePoint = rs.getString( EXECISE_POINT );
			String strUserID = rs.getString( USERID );
			//Rs[LOIDɒu
			String strLOID = strCopyLoID;
			String strAccessCnt = rs.getString( ACCESS_CNT );
			String strLastAccess = XMODate.parseTime(rs.getTimestamp( LAST_ACCESS ));
			// LoLogf[^Zbg
			objData = new LoLogRecord();
			objData.setFullScore( strFullScore );
			objData.setStudyStartDate( strStudyStartDate );
			objData.setResidanceTime( strResidenceTime );
			objData.setPassday( strPassDay );
			objData.setStudyEndDate( strStudyEndDate );
			objData.setHighScore( strHighScore );
			objData.setLowScore( strLowScore );
			objData.setExecisePoint( strExecisePoint );
			objData.setUserID( strUserID );
			objData.setLoID( strLOID );
			objData.setAccessCnt( strAccessCnt );
			objData.setLastAccess( strLastAccess );

			//objDataVectorɃZbg
			vecLoLogRecord.add(objData);
		}

		//vecLoLogRecord̒gALoLogRecord[]zɃRs[B
		LoLogRecord[] objLoLogRecord = new LoLogRecord[vecLoLogRecord.size()];
		vecLoLogRecord.copyInto( objLoLogRecord );

		return objLoLogRecord;
	}

	/**
	 * s\bhłB<BR>
	 * p[^̃`FbNуgUNV̊Ǘ
	 * ʃ\bhōsĂB<BR>
	 * @param htbParam 
	 * @return Vector 
	 * @exception SQLException DBG[ꍇ
	 */
	private Vector selectAction( Hashtable htParam, DataAccess objDataAccess )
		throws SQLException
	{

		// SQL̑gݗ
		StringBuffer sbSQL = new StringBuffer();
		sbSQL.append( "SELECT * FROM " + TABLE_NAME );
		// ̎擾
		String strCondition = (String)htParam.get( CONDITION_KEY );

		if( strCondition != null ) {
			sbSQL.append( strCondition );
		}
		else {
			sbSQL.append( createCondition( htParam ) );
		}

		// NG[s܂
		ResultSet rs = objDataAccess.executeQuery(sbSQL.toString());

		Vector vecReturn = new Vector();
		Vector vecRet = new Vector();
		while(rs.next()) {
			String strFullScore = rs.getString( FULLSCORE );
			String strStudyStartDate = XMODate.parseTime(rs.getTimestamp( STUDY_START_DATE ));
			String strResidenceTime = rs.getString( RESIDANCETIME );
			String strPassDay = XMODate.parseTime(rs.getTimestamp( PASSDAY ));
			String strStudyEndDate = XMODate.parseTime(rs.getTimestamp( STUDY_END_DATE ));
			String strHighScore = rs.getString( HIGHTSCORE );
			String strLowScore = rs.getString( LOWSSCORE );
			String strExecisePoint = rs.getString( EXECISE_POINT );
			String strUserID = rs.getString( USERID );
			String strLOID = rs.getString( LOID );
			String strAccessCnt = rs.getString( ACCESS_CNT );
			String strLastAccess = rs.getString( LAST_ACCESS );
			LoLogRecord objData = new LoLogRecord();
			objData.setFullScore( strFullScore );
			objData.setStudyStartDate( strStudyStartDate );
			objData.setResidanceTime( strResidenceTime );
			objData.setPassday( strPassDay );
			objData.setStudyEndDate( strStudyEndDate );
			objData.setHighScore( strHighScore );
			objData.setLowScore( strLowScore );
			objData.setExecisePoint( strExecisePoint );
			objData.setUserID( strUserID );
			objData.setLoID( strLOID );
			objData.setAccessCnt( strAccessCnt );
			objData.setLastAccess( strLastAccess );

			vecReturn.add( objData );
		}

		vecRet.add(vecReturn);

		return vecRet;

	}

	/**
	 * Xe[^XԂ܂B<BR>
	 * gUNV̊Ǘ͏ʂōsĂB
	 * @param strUserID [UID
	 * @param strLoID LOID
	 * @return boolean[] Xe[^X
	 * <PRE>
	 *      boolean[0] :: itɓtĂ邩ǂiĂ: trueAĂȂ or R[hȂ: false)
	 *      boolean[1] :: tɓtĂ邩ǂiĂ: trueAĂȂ or R[hȂ: false)
	 * </PRE>
	 * @exception SQLException DBG[
	 */
	public boolean[] getStatus( String strUserID, String strLoID, DataAccess objDataAccess )
		throws SQLException
	{
		StringBuffer sbSQL = new StringBuffer();
		// SQL̍쐬
		sbSQL.append( "SELECT " );
		sbSQL.append( STUDY_END_DATE );
		sbSQL.append( "," );
		sbSQL.append( PASSDAY );
		sbSQL.append( "," );
		sbSQL.append( STUDY_START_DATE );
		sbSQL.append( " FROM " );
		sbSQL.append( TABLE_NAME );
		sbSQL.append( " WHERE " );
		sbSQL.append( USERID );
		sbSQL.append( "='" );
		sbSQL.append( StringEscapeUtils.escapeSql(strUserID) );
		sbSQL.append( "' AND " );
		sbSQL.append( LOID );
		sbSQL.append( "='" );
		sbSQL.append( StringEscapeUtils.escapeSql(strLoID) );
		sbSQL.append( "'" );

		// ߂l
		boolean[] blStatus = new boolean[3];
		blStatus[0] = false;
		blStatus[1] = false;
		blStatus[2] = false;

		// 
		ResultSet rs = objDataAccess.executeQuery( sbSQL.toString() );
		String strPassDay = null;
		String strStudyEndDate = null;
		String strStudyStartDate = null;
		if( rs.next() ) {
			strStudyEndDate = rs.getString( STUDY_END_DATE );
			strPassDay = rs.getString( PASSDAY );
			strStudyStartDate = rs.getString( STUDY_START_DATE );
		}

		// ito^Ăꍇpassed
		if( strPassDay != null && !strPassDay.equals( "" ) ) {
			blStatus[0] = true;
		}

		// Cto^Ăꍇcompleted
		if( strStudyEndDate != null && !strStudyEndDate.equals( "" ) ) {
			blStatus[1] = true;
		}

		// wKJnto^Ăꍇcompleted
		if( strStudyStartDate != null && !strStudyStartDate.equals( "" ) ) {
			blStatus[2] = true;
		}

		return blStatus;

	}

	/**
	 * iĂ邩ǂԂ܂B
	 * gUNV̊Ǘ͏ʂōsĂB
	 * @param strUserID [UID
	 * @param strLoID LOID
	 * @return boolean true: iĂ false: iĂȂ
	 * @exception SQLException DBG[
	 */
	public boolean isPassed( String strUserID, String strLoID, DataAccess objDataAccess )
		throws SQLException
	{
		StringBuffer sbSQL = new StringBuffer();
		// SQL̍쐬
		sbSQL.append( "SELECT " );
		sbSQL.append( PASSDAY );
		sbSQL.append( " FROM " );
		sbSQL.append( TABLE_NAME );
		sbSQL.append( " WHERE " );
		sbSQL.append( USERID );
		sbSQL.append( "='" );
		sbSQL.append( StringEscapeUtils.escapeSql(strUserID) );
		sbSQL.append( "' AND " );
		sbSQL.append( LOID );
		sbSQL.append( "='" );
		sbSQL.append( StringEscapeUtils.escapeSql(strLoID) );
		sbSQL.append( "'" );

		// 
		ResultSet rs = objDataAccess.executeQuery( sbSQL.toString() );
		String strPassDay = "";
		if( rs.next() ) {
			strPassDay = rs.getString( PASSDAY );
		}
		else {
			// 0̏ꍇ͖wK
			return false;
		}

		// Cto^Ăꍇpassed
		if( strPassDay != null && !strPassDay.equals( "" ) ) {
			return true;
		}

		return false;

	}

	/**
	 * Ă邩ǂԂ܂B
	 * gUNV̊Ǘ͏ʂōsĂB
	 * @param strUserID [UID
	 * @param strLoID LOID
	 * @return boolean true: Ă false: ĂȂ
	 * @exception SQLException DBG[
	 */
	public boolean isCompleted( String strUserID, String strLoID, DataAccess objDataAccess )
		throws SQLException
	{
		StringBuffer sbSQL = new StringBuffer();
		// SQL̍쐬
		sbSQL.append( "SELECT " );
		sbSQL.append( STUDY_END_DATE );
		sbSQL.append( " FROM " );
		sbSQL.append( TABLE_NAME );
		sbSQL.append( " WHERE " );
		sbSQL.append( USERID );
		sbSQL.append( "='" );
		sbSQL.append( StringEscapeUtils.escapeSql(strUserID) );
		sbSQL.append( "' AND " );
		sbSQL.append( LOID );
		sbSQL.append( "='" );
		sbSQL.append( StringEscapeUtils.escapeSql(strLoID) );
		sbSQL.append( "'" );

		// 
		ResultSet rs = objDataAccess.executeQuery( sbSQL.toString() );
		String strStudyEndDate = "";
		if( rs.next() ) {
			strStudyEndDate = rs.getString( STUDY_END_DATE );
		}
		else {
			// 0̏ꍇ͖wK
			return false;
		}

		// Cto^Ăꍇcompleted
		if( strStudyEndDate != null && !strStudyEndDate.equals( "" ) ) {
			return true;
		}

		return false;

	}

	/**
	 * p[^œnĂLOIDɑΉRealLOID̃OĂUserIDLOLoge[u
	 * oÃXgStringzŕԋp܂B
	 * gUNV̊Ǘ͏ʂōsĂB
	 * @param strLoID LOID
	 * @param objDataAccess f[^x[XANZXIuWFNg
	 * @return String[] UserIDXg(擾s̏ꍇ͋Stringzԋp)
	 * @exception SQLException DBG[
	 */
	public String[] getUserList( String strLoID, DataAccess objDataAccess )
		throws SQLException
	{
		StringBuffer sbSQL = new StringBuffer();
		// qLÕ[UXg擾SQL̍쐬
		sbSQL.append( "SELECT DISTINCT " );
		sbSQL.append( TABLE_NAME + "." + USERID );
		sbSQL.append( " FROM " );
		sbSQL.append( TABLE_NAME );
		sbSQL.append( " INNER JOIN ");
		sbSQL.append( TABLE_LO );
		sbSQL.append( " ON " );
		sbSQL.append( TABLE_NAME + "." + LOID );
		sbSQL.append( " = " );
		sbSQL.append( TABLE_LO + "." + REAL_LOID );
		sbSQL.append( " INNER JOIN " );
		sbSQL.append( TABLE_LORELATION );
		sbSQL.append( " ON " );
		sbSQL.append( TABLE_LO + "." + LOID);
		sbSQL.append( " = " );
		sbSQL.append( TABLE_LORELATION + "." + CHILDID );
		sbSQL.append( " WHERE " );
		sbSQL.append( TABLE_LORELATION + "." + PARENTID + " = '" + StringEscapeUtils.escapeSql(strLoID) + "'" );
		sbSQL.append( " OR " );
		sbSQL.append( TABLE_LORELATION + "." + CHILDID + " = '" + StringEscapeUtils.escapeSql(strLoID) + "'"  );

		// [UXg̎擾
		ResultSet rs = objDataAccess.executeQuery( sbSQL.toString() );

		Vector vecUserList = new Vector();
		while( rs.next() ) {
			vecUserList.add(rs.getString( USERID ));
		}

		// g̃Õ[UXg擾


		String[] strUserList = new String[vecUserList.size()];

		vecUserList.copyInto(strUserList);

		//[UXg̕ԋp
		return strUserList;

	}

	/**
	 * p[^œnĂUserID,LOIDKeyɂāA_Aō_AŒᓾ_A_AݐϊwK
	 * wKJn(ԌÂ)̂ꂼ̍v𒊏o
	 * gUNV̊Ǘ͏ʂōsĂB
	 * @param strLoID	LOID
	 * @param strUserID UserID
	 * @param objDataAccess f[^x[XANZXIuWFNg
	 * @return LoLogRecord Xe[^XLOOIuWFNgԋp
	 * @exception SQLException DBG[
	 */
	public LoLogRecord getTotal( String strUserID, String strLoID, DataAccess objDataAccess )
		throws SQLException
	{

		StringBuffer sbSQL = new StringBuffer();
		// etB[h̍vl擾SQL̍쐬
		sbSQL.append( "SELECT " );
		sbSQL.append( "SUM(" );
		sbSQL.append( EXECISE_POINT );
		sbSQL.append( ") As SUMexecise_point, " );
		sbSQL.append( "SUM(" );
		sbSQL.append( HIGHTSCORE );
		sbSQL.append( ") As SUMhighScore, " );
		sbSQL.append( "SUM(" );
		sbSQL.append( LOWSSCORE );
		sbSQL.append( ") As SUMlowsScore, " );
		sbSQL.append( "SUM(" );
		sbSQL.append( FULLSCORE );
		sbSQL.append( ") As SUMfullscore, " );
		try{
			//XMS.init@C[hNX̃CX^X
			Environment objEnv=new Environment();
			//SQLServeȑꍇ
			if(objEnv.getDBType().equals( objEnv.DB_SQLSERVER )){
				sbSQL.append( "ISNULL(SUM(" );
			//Oraclȅꍇ
			}else if(objEnv.getDBType().equals( objEnv.DB_ORACLE )){
				sbSQL.append( "NVL(SUM(" );
			//PostgreSQL̏ꍇ	
			}else if(objEnv.getDBType().equals( objEnv.DB_POSTGRE )){
				sbSQL.append( "COALESCE(SUM(" );
			}
			sbSQL.append( RESIDANCETIME );
			sbSQL.append( "), 0) AS  SUMresidanceTime, " );
			sbSQL.append( "MIN(" );
			sbSQL.append( STUDY_START_DATE );
			sbSQL.append( ") As MINstudy_start_date, " );
			//SQLServeȑꍇ
			if(objEnv.getDBType().equals( objEnv.DB_SQLSERVER )){
				sbSQL.append( "ISNULL(SUM(" );
			}
			//Oraclȅꍇ
			else if(objEnv.getDBType().equals( objEnv.DB_ORACLE )){
				sbSQL.append( "NVL(SUM(" );			
			//PostgreSQL̏ꍇ	
			}else if(objEnv.getDBType().equals( objEnv.DB_POSTGRE )){
				sbSQL.append( "COALESCE(SUM(" );
			}
		}
		catch(Exception ex)
		{

		}
		sbSQL.append( ACCESS_CNT );
		sbSQL.append( "), 0)  AS SUMAccessCnt, " );
		sbSQL.append( "MAX(" );
		sbSQL.append( LAST_ACCESS );
		sbSQL.append( ") As MAXLastAccess," );

// 2005.03.10 LOXe[^X[AbvύX NTT]ig(Y.URATA) ADD start
		sbSQL.append( "MAX(" );
		sbSQL.append( PASSDAY );
		sbSQL.append( ") As MAXPassday, " );
		sbSQL.append( "MAX(" );
		sbSQL.append( STUDY_END_DATE );
		sbSQL.append( ") As MAXstudy_end_date" );
// 2005.03.10 ADD end

		sbSQL.append( " FROM " );
		sbSQL.append( TABLE_NAME );

		sbSQL.append( " INNER JOIN ");
		sbSQL.append( RELATION_TABLE_NAME );
		sbSQL.append( " ON " );
		sbSQL.append( TABLE_NAME );
		sbSQL.append( "." );
		sbSQL.append( LOID );
		sbSQL.append( " = " );
		sbSQL.append( RELATION_TABLE_NAME );
		sbSQL.append( "." );
		sbSQL.append( REAL_LOID );
		sbSQL.append( " INNER JOIN ");
		sbSQL.append( TABLE_LORELATION );
		sbSQL.append( " ON " );
		sbSQL.append( RELATION_TABLE_NAME );
		sbSQL.append( "." );
		sbSQL.append( LOID );
		sbSQL.append( " = " );
		sbSQL.append( TABLE_LORELATION );
		sbSQL.append( "." );
		sbSQL.append( CHILDID );

		sbSQL.append( " Where " );
		sbSQL.append( TABLE_LORELATION );
		sbSQL.append( ".");
		sbSQL.append( PARENTID );
		sbSQL.append( " = '" );
		sbSQL.append( StringEscapeUtils.escapeSql(strLoID) );
		sbSQL.append( "'" );
		sbSQL.append( " And " );
		sbSQL.append( TABLE_NAME );
		sbSQL.append( "." );
		sbSQL.append( USERID );
		sbSQL.append( " = '" );
		sbSQL.append( StringEscapeUtils.escapeSql(strUserID) );
		sbSQL.append( "'" );
		// etB[h̍vl̎擾
		DebugLog.write( this.getClass(), sbSQL.toString(), DebugLog.ROW );
		ResultSet rs = objDataAccess.executeQuery( sbSQL.toString() );

		// Xe[^XLOONX
		LoLogRecord objLoLogRecord = new LoLogRecord();
		objLoLogRecord.initialize();

		if( rs.next() ) {

			// lIDݒ
			objLoLogRecord.setUserID(strUserID);

			// LOIDݒ
			objLoLogRecord.setLoID(strLoID);

			// _ݒ
			objLoLogRecord.setExecisePoint(rs.getString( "SUMexecise_point" ));
			if( objLoLogRecord.getExecisePoint() == null ) {
				objLoLogRecord.setExecisePoint("");
			}

			// ō_ݒ
			objLoLogRecord.setHighScore(rs.getString( "SUMhighScore" ));
			if( objLoLogRecord.getHighScore() == null ) {
				objLoLogRecord.setHighScore("");
			}

			// Œ_ݒ
			objLoLogRecord.setLowScore(rs.getString( "SUMlowsScore" ));
			if( objLoLogRecord.getLowScore() == null ) {
				objLoLogRecord.setLowScore("");
			}

			// _ݒ
			objLoLogRecord.setFullScore(rs.getString( "SUMfullscore" ));
			if( objLoLogRecord.getFullScore() == null ) {
				objLoLogRecord.setFullScore("");
			}

			// Jnݒ
			objLoLogRecord.setStudyStartDate(XMODate.parseTime(rs.getTimestamp( "MINstudy_start_date" )));

			// ݌v؍ݎԐݒ
			objLoLogRecord.setResidanceTime(rs.getString( "SUMresidanceTime" ));

			// ANZX񐔐ݒ
			objLoLogRecord.setAccessCnt(rs.getString( "SUMAccessCnt" ));
			if( objLoLogRecord.getAccessCnt() == null ) {
				objLoLogRecord.setAccessCnt("");
			}

			// ŏIANZXݒ
			objLoLogRecord.setLastAccess(XMODate.parseTime(rs.getTimestamp( "MAXLastAccess" )));
			if( objLoLogRecord.getLastAccess() == null ) {
				objLoLogRecord.setLastAccess("");
			}

// 2005.03.10 LOXe[^X[AbvύX NTT]ig(Y.URATA) ADD start
			// iݒ
			objLoLogRecord.setPassday(XMODate.parseTime(rs.getTimestamp( "MAXPassday" )));
			if( objLoLogRecord.getPassday() == null ) {
				objLoLogRecord.setPassday("");
			}
			
			// ݒ
			objLoLogRecord.setStudyEndDate(XMODate.parseTime(rs.getTimestamp( "MAXstudy_end_date" )));
			if( objLoLogRecord.getStudyEndDate() == null ) {
				objLoLogRecord.setStudyEndDate("");
			}				
// 2005.03.10 ADD end
		}

		// Xe[^XLOOIuWFNgԋp
		return objLoLogRecord;

	}

	/**
	 * LOLoge[u wK񐔎擾
	 * @param strUserID 
	 * @param strLOID 
	 * @param objDataAccess
	 */
	public int getStudyCount( String strUserID, String strLOID, DataAccess objDataAccess)
		throws SQLException
	{
		int intSutudyCnt = 0;

		// SQL̑gݗ
		StringBuffer sbSQL = new StringBuffer();
		sbSQL.append("SELECT ");
		sbSQL.append(ACCESS_CNT);
		sbSQL.append(" FROM ");
		sbSQL.append(TABLE_NAME);
		sbSQL.append(" WHERE ");
		sbSQL.append(LOID);
		sbSQL.append(" = '");
		sbSQL.append(StringEscapeUtils.escapeSql(strLOID));
		sbSQL.append("' AND ");
		sbSQL.append(USERID);
		sbSQL.append(" = '");
		sbSQL.append(StringEscapeUtils.escapeSql(strUserID));
		sbSQL.append("'");

		ResultSet rs = objDataAccess.executeQuery(sbSQL.toString());

		while( rs.next() ) {
			// URL擾
			intSutudyCnt = rs.getInt( ACCESS_CNT );
		}

		return intSutudyCnt;
	}
	/**
	 * LOLoge[u ŏIANZX擾
	 * @param strUserID 
	 * @param strLOID 
	 * @param objDataAccess
	 */

	public Timestamp getLastAccess( String strUserID, String strLOID, DataAccess objDataAccess)
		throws SQLException

	{

		Timestamp tsLastAccess = null;

		// SQL̑gݗ
		StringBuffer sbSQL = new StringBuffer();
		sbSQL.append("SELECT ");
		sbSQL.append(LAST_ACCESS);
		sbSQL.append(" FROM ");
		sbSQL.append(TABLE_NAME);
		sbSQL.append(" WHERE ");
		sbSQL.append(LOID);
		sbSQL.append(" = '");
		sbSQL.append(StringEscapeUtils.escapeSql(strLOID));
		sbSQL.append("' AND ");
		sbSQL.append(USERID);
		sbSQL.append(" = '");
		sbSQL.append(StringEscapeUtils.escapeSql(strUserID));
		sbSQL.append("'");

		ResultSet rs = objDataAccess.executeQuery(sbSQL.toString());

		while( rs.next() ) {
			// ŏIANZX擾

			tsLastAccess =  rs.getTimestamp( LAST_ACCESS );

		}

		return tsLastAccess;
	}
	/**
	 * o^AXṼf[^gݗĂ܂
	 * @param htData
	 * @return Hashtable
	 */
	private Hashtable setData( Hashtable htbParam ) {
		Hashtable htbData = new Hashtable();
		putData( htbData, htbParam, FULLSCORE );
		putData( htbData, htbParam, STUDY_START_DATE );
		putData( htbData, htbParam, RESIDANCETIME );
		putData( htbData, htbParam, PASSDAY );
		putData( htbData, htbParam, STUDY_END_DATE );
		putData( htbData, htbParam, HIGHTSCORE );
		putData( htbData, htbParam, LOWSSCORE );
		putData( htbData, htbParam, EXECISE_POINT );
		putData( htbData, htbParam, USERID );
		putData( htbData, htbParam, LOID );
		putData( htbData, htbParam, ACCESS_CNT );
		putData( htbData, htbParam, LAST_ACCESS );

		return htbData;
	}

	/**
	 * o^AXṼf[^LoLogRecord쐬܂
	 * @param objLoLogRecord
	 */
	private Hashtable setData( LoLogRecord objRecord ) {
		Hashtable htbData = new Hashtable();
		putData( htbData, FULLSCORE, objRecord.getFullScore() );
		putData( htbData, STUDY_START_DATE, objRecord.getStudyStartDate() );
		putData( htbData, RESIDANCETIME, objRecord.getResidanceTime() );
		putData( htbData, PASSDAY, objRecord.getPassday() );
		putData( htbData, STUDY_END_DATE, objRecord.getStudyEndDate() );
		putData( htbData, HIGHTSCORE, objRecord.getHighScore() );
		putData( htbData, LOWSSCORE, objRecord.getLowScore() );
		putData( htbData, EXECISE_POINT, objRecord.getExecisePoint() );
		putData( htbData, USERID, objRecord.getUserID() );
		putData( htbData, LOID, objRecord.getLoID() );
		putData( htbData, ACCESS_CNT, objRecord.getAccessCnt() );

		putData( htbData, LAST_ACCESS, objRecord.getLastAccess() );

		return htbData;
	}

	/**
	 * SHashtableɒǉ郁\bhł
	 */
	private void putData( Hashtable htbData, Hashtable htbParam, String strKey ) {
		String strValue = (String)htbParam.get( strKey );

		if( strValue != null ) {
			htbData.put( strKey, strValue );
		}
	}

	/**
	 * SHashtableɒǉ郁\bhł
	 */
	private void putData( Hashtable htbData, String strKey, String strValue ) {
		if( strKey == null || strValue == null ) {
			return;
		}
		htbData.put( strKey, strValue );
	}

	/**
	 * Hashtable烆[UIDLOID擾ď쐬܂
	 */
	private String createCondition( Hashtable htbData ) {
		String strUserID = (String)htbData.get( USERID );
		String strLoID = (String)htbData.get( LOID );
		return createCondition( strUserID, strLoID );
	}

	/**
	 * [UIDLOID쐬܂
	 */
	private String createCondition( String strUserID, String strLoID ) {

		String strUserIDCon = null;
		String strLoIDCon = null;
		StringBuffer sbCondition = new StringBuffer();
		if( strUserID != null ) {
			strUserIDCon = USERID + " ='" + StringEscapeUtils.escapeSql(strUserID) + "'";
		}
		if( strLoID != null ) {
			strLoIDCon = LOID + " ='" + StringEscapeUtils.escapeSql(strLoID) + "'";
		}

		if( strUserIDCon != null || strLoIDCon != null ) {
			sbCondition.append( " WHERE " );
			if( strUserIDCon != null ) {
				sbCondition.append( strUserIDCon );
				if( strLoIDCon != null ) {
					sbCondition.append( " AND " );
				}
			}
			if( strLoIDCon != null ) {
				sbCondition.append( strLoIDCon );
			}
		}

		return sbCondition.toString();
	}

	/**
	 * LOIDRealLOID擾܂B
	 * 擾ɎsꍇnullԂ܂B
	 */
	public String getRealLOID( String strLoID, DataAccess objDataAccess )
		throws SQLException
	{
		String strRealLOID = null;

		// SQL̑gݗ
		StringBuffer sbSQL = new StringBuffer();
		sbSQL.append( "SELECT " );
		sbSQL.append( REAL_LOID );
		sbSQL.append( " FROM " );
		sbSQL.append( RELATION_TABLE_NAME );
		sbSQL.append( " WHERE " );
		sbSQL.append( LOID);
		sbSQL.append( " = '");
		sbSQL.append( StringEscapeUtils.escapeSql(strLoID) );
		sbSQL.append( "'" );

		ResultSet rs = objDataAccess.executeQuery(sbSQL.toString());

		while(rs.next()) {
			strRealLOID = ChangeEncode.setChar( rs.getString( REAL_LOID ) );
		}

		return strRealLOID;
	}
}