/////////////////////////////////////////////////////////////////
//Copyright (C) 2005 NTT CORPORATION.
//
//LoInfo IuWFNgXgNX
//
//ύX
//2005.02.03  VK쐬  X@qu
//
//@\
//
//ɏ]ALoInfo IuWFNg̃Xg𐶐܂B
//
/////////////////////////////////////////////////////////////////
package jp.co.ntt.lms.lo.lom.learnableinfo;

import java.io.File;
import java.util.*;
import java.util.regex.*;

import org.apache.commons.lang.StringEscapeUtils;

import jp.co.ntt.lms.lo.scorm.*;
import jp.co.ntt.lms.xmo.Environment;
import jp.co.ntt.lms.xmo.Lo.*;
import jp.co.ntt.lms.xmo.GroupAndPeople.GroupAndPeopleClient;
import jp.co.ntt.lms.xmo.Roles.RolesClient;
import jp.co.ntt.lms.xmo.RoleAssignments.RoleAssignmentsClient;
import jp.co.ntt.lms.xmo.Assignments.AssignmentsClient;
import jp.co.ntt.lms.xmo.LoRelation.*;
import jp.co.ntt.lms.xmo.People.PeopleClient;

/**
 * ɏ]ALoInfo IuWFNg̃Xg𐶐NXłB
 * @author s-mori
 * @version 1.0
 */
public class LoInfoFactory {

	/** [UATCǗ[ID */
	private static final String FUNCTION_LO_ASSIGNUSER = "9";

	/** LOATCǗ[ID */
	private static final String FUNCTION_LO_ASSIGNLO = "13";

	/** [gO[ṽO[vID */
	private static final String GROUP_ID_ROOT = "GR000000";

	/** [g[Ũ[UID */
	private static final String USER_ID_ROOT = "PE000000";

	/** ReiLO^Cv */
	private static final String LO_TYPE_CONTAINER = "0";

	/** [gReiLOID */
	private static final String LO_ID_ROOT = "LO0";
	
	
	/**
	 * RXgN^B
	 * CX^X𐶐܂B
	 */
	public LoInfoFactory(){
	}
	
	/**
	 * LOǗ̂郍[擾܂B
	 * S[R[h擾Afunction = 9,13 ̂ݎo
	 * @return LOǗ̂郍[ID̃Xg
	 * @throws Exception 
	 */
	private List getLoManagableRoleIdList() throws Exception{
	
		RolesClient rlClient = new RolesClient();
		rlClient.select();
		
		List loManageRoleId = new ArrayList();
		while(rlClient.next()){
			for(int i = 0; i < rlClient.getFunctionCount(); i++){
				if(rlClient.getFunction(i).equals(FUNCTION_LO_ASSIGNUSER) || rlClient.getFunction(i).equals(FUNCTION_LO_ASSIGNLO)){
					loManageRoleId.add(rlClient.getRoleID());
					break;
				}
			}
		}
		
		return loManageRoleId;
	}
	
	/**
	 * RoleAssignment e[uA[UO[vɑ΂LOǗ[[U擾܂B
	 * @param parentGroupId eO[vi[UO[vjID
	 * @param loManagableRoleIdList LOǗ̂郍[ID̃Xg
	 * @return eO[v΂LOǗ[[UID̃Xg
	 * @throws Exception
	 */
	private List getManagableUserIdList(String parentGroupId, List loManagableRoleIdList) throws Exception{
		if(parentGroupId == null || parentGroupId.equals("")){
			throw new NullPointerException("Parent group ID is null.");
		}
		if(loManagableRoleIdList == null){
			throw new NullPointerException("Managable role ID list is null.");
		}
		
		RoleAssignmentsClient raClient = new RoleAssignmentsClient();
		StringBuffer sbuf = new StringBuffer("");
		for(int i = 0; i < loManagableRoleIdList.size(); i++){
			sbuf.append(",'");
			sbuf.append(StringEscapeUtils.escapeSql((String)loManagableRoleIdList.get(i)));
			sbuf.append("'");
		}
		raClient.setCondition("groupid = '" + StringEscapeUtils.escapeSql(parentGroupId) + "' and role_id in (" + sbuf.substring(1) + ") and user_id <> '" + USER_ID_ROOT + "'");
		
		raClient.select();
		
		List managableUserIdList = new ArrayList();
		while(raClient.next()){
			// 擾[UID폜[UłȂ΁AXgɒǉ
			if(this.isValidUser(raClient.getUserID())){				
				managableUserIdList.add(raClient.getUserID());
			}
		}
		
		return managableUserIdList;
	}
	
	
	/**
	 * [UID̐ẽO[vID擾܂B
	 * @param userId [UID
	 * @return [UO[vID
	 * @throws Exception
	 */
	private String getParentGroupId(String userId) throws Exception{
		if(userId == null || userId.equals("")){
			throw new NullPointerException("User ID is null.");
		}		
		
		// GroupAndPeople e[uA̐ẽO[v擾
		GroupAndPeopleClient gpClient = new GroupAndPeopleClient();
		gpClient.setWhereChildID(userId);
		gpClient.select();
		if(gpClient.next()){
			return gpClient.getParentID();
		}else{
			return null;
		}
		
	}

	/**
	 * Assignments e[uALOǗ[[UǗ\ materialID 擾܂B
	 * @param managableUserIdList LOǗ[[UID̃Xg
	 * @return [UǗ\ materialID ̃Xg
	 * @throws Exception
	 */
	private List getManagableMaterialIdList(List managableUserIdList) throws Exception{
		if(managableUserIdList == null){
			throw new NullPointerException("Managable user ID list is null.");
		}
		
		List materialIdList = new ArrayList();
		
		AssignmentsClient asClient = new AssignmentsClient();
		for(int i = 0; i < managableUserIdList.size(); i++){
			asClient.setCondition("membershipid like '%" + StringEscapeUtils.escapeSql((String)managableUserIdList.get(i)) + "%' and management_authority = '1'");
			asClient.select();
			while(asClient.next()){
				materialIdList.add(asClient.getMaterialID().trim());
			}
			asClient.clear();
		}
		
		return materialIdList;
		
	}
	
	

	
	/**
	 * parentLoId ȉ LO  LoInfo ̃XgƂĎ擾܂B
	 * ̃\bh́AōċAĂяoAqLOׂĎ擾܂B
	 * @param parentLoId eLOID
	 * @return qLO LoInfo IuWFNg̃Xg
	 * @throws Exception
	 */
	private List getDescendantLoInfoList(String parentLoId) throws Exception{
		if(parentLoId == null || parentLoId.equals("")){
			throw new NullPointerException("Parent LOID is null.");
		}
		
		List list = new ArrayList();
		
		// LoRelationDataIuWFNg쐬
		LoRelationClient lrClient = new LoRelationClient();
		lrClient.setWhereParentID(parentLoId);
		lrClient.select();
		while(lrClient.next()){

			LoInfo loInfo = this.getLoInfo(lrClient.getChildID());
			
			// Xgɒǉ
			list.add(loInfo);
		}
		
		// ŁAXg̊eoɑ΂čċA
		for(int i = 0; i < list.size(); i++){
			LoInfo info = (LoInfo)list.get(i);
			List childList = this.getDescendantLoInfoList(info.getRelationData().getChildID());
			list.addAll(childList);
		}
		
		
		return list;
	}
	
		
	/**
	 * LoInfo IuWFNg쐬܂B
	 * @param loId LOID
	 * @return LOID ɑΉ LoInfo IuWFNg
	 * @throws Exception
	 */
	private LoInfo getLoInfo(String loId) throws Exception{
		if(loId == null || loId.equals("")){
			throw new NullPointerException("LOID is null.");
		}

		LoInfo loInfo = new LoInfo();
		
		// LoIuWFNg쐬
		LoClient loClient = new LoClient();
		loClient.setWhereLoID(loId);
		loClient.select();
		if(loClient.next()){
			// 폜tOĂAnull߂
			if(loClient.getDeleteFlag().equals("1")){
				return null;
			}
			loInfo.setLoData(loClient.getLoData());
		}else{
			return null;
		}

		// LOExtendIuWFNg쐬
		loClient = new LoClient();
		loClient.selectLoExtend(loId);
		if(loClient.isExistLoExtend()){
			loInfo.setLoExtendRecord(loClient.getLoExtendRecord());
		}
		
		// LoRelationDataIuWFNg쐬
		LoRelationClient lrClient = new LoRelationClient();
		lrClient.setWhereChildID(loId);
		lrClient.select();
		if(lrClient.next()){
			
			LoRelationData lrData = new LoRelationData();
			lrData.setMaterialID(lrClient.getmaterialID());
			lrData.setParentID(lrClient.getParentID());
			lrData.setChildID(lrClient.getChildID());

			loInfo.setRelationData(lrData);
			
		}

		// manifestList IuWFNg쐬
		loInfo.setManifestList(this.getManifestList(loId));

		return loInfo;

	}
	

	/**
	 * ManifestList IuWFNg𐶐܂B
	 * @param loID LOID
	 * @return LOID ɑΉManifestListIuWFNg
	 * @throws Exception
	 */
	private ManifestList getManifestList(String loID) throws Exception {

		// SCORMLO e[u materialID 擾
		String materialID = null;
		Environment environment = new Environment();
		String serverName = environment.getLoServerName();
		ScormLoClient slClient = new ScormLoClient(serverName);
				
		slClient.getData(loID);
		if(slClient.getDataLength() == 0){
			return null;
		}
		
		ScormLoData loData = (ScormLoData)slClient.getDataInfo(0);

		// ID̎擾
		materialID = loData.getMaterialID();
		
		// scorm.ini Ǎ
		ScormLoEnv scormEnv = new ScormLoEnv();
		
		// manifest o^ĂpX(material_path)擾
		File manifestDirectory = new File(scormEnv.getMaterialPath() + File.separator + materialID);

		// 
		ManifestListFactory factory = new ManifestListFactory();
		return factory.makeManifestList(manifestDirectory);
		
	}

	/**
	 * w肵[UIDLȃ[Uǂ𔻕ʂ܂B
	 * Lȃ[UƂ́ADBɑ݂A폜tOĂȂ[Uw܂B
	 * @param userId [UID
	 * @return Lȃ[Ułꍇtrue
	 * @throws Exception
	 */
	private boolean isValidUser(String userId) throws Exception{
		if(userId == null || userId.equals("")){
			throw new NullPointerException("User ID is null.");
		}
		PeopleClient pClient = new PeopleClient();
		pClient.setWhereUserID(userId);
		pClient.select();
		return(pClient.next() && pClient.getDeleteFlag().equals("0"));
		
	}
	
	
	/**
	 * Ǘ\[UIDꗗA̐lXǗ\LÕXg擾܂B
	 * @param managableUserIdList LOǗ[ŨXg
	 * @return e[UǗ\LÓALoInfoIuWFNg̃Xg
	 * @throws Exception
	 */
	private List getLoInfoList(List managableUserIdList) throws Exception{
		
		// assignments e[uALOǗ[[UǗ\ materialID 擾
		List managableMaterialIdList = this.getManagableMaterialIdList(managableUserIdList);
		
		// materialID ȉ LO  LoInfo ̃XgƂĎ擾
		List loInfoList = new ArrayList();
		for(int i = 0; i < managableMaterialIdList.size(); i++){
			
			// ChildID 擾
			String materialId = (String)managableMaterialIdList.get(i);
			Pattern pattern = Pattern.compile("^LO[0-9]+");
			Matcher matcher = pattern.matcher(materialId);
			String childId = matcher.replaceFirst("");
			
			// gu[gReiłȂvu[g̃ReiłȂvꍇ́A
			// g LoInfo 쐬 (root̏ꍇ͉łok)
			LoInfo myLoInfo = this.getLoInfo(childId);
			if(!myLoInfo.getRelationData().getParentID().equals(LO_ID_ROOT) || !myLoInfo.getLoData().getLoType().equals(LO_TYPE_CONTAINER)){
				loInfoList.add(myLoInfo);
			}
			
			
			loInfoList.addAll(this.getDescendantLoInfoList(childId));
		}

		// d͂
		Map htTemp = new Hashtable();
		List mergedLoInfoList = new ArrayList();
		for(int i = 0; i < loInfoList.size(); i++){
			// LoInfo 擾
			LoInfo tempInfo = (LoInfo)loInfoList.get(i);

			// Vo LoInfo ȂAXgɒǉ
			if(htTemp.get(tempInfo.getLoData().getLoID()) == null){
				htTemp.put(tempInfo.getLoData().getLoID(), "1");
				mergedLoInfoList.add(tempInfo);
			}
			
		}
		
		return mergedLoInfoList;
	}
	
	
	/**
	 * w肳ꂽLOǗ[UǗ\ LO ALoInfo IuWFNg List `Ŏ擾܂B
	 * @param managingUserId Ǘ҂̃[UID
	 * @return Ǘ҂Ǘ\ LÓALoInfoIuWFNg̃Xg
	 * @throws Exception
	 */
	public List getManagableLoInfoList(String managingUserId) throws Exception{
		if(managingUserId == null || managingUserId.equals("")){
			throw new NullPointerException("Manager user ID is null.");
		}

		// [UID̗L`FbN
		if(!this.isValidUser(managingUserId)){
			throw new Exception("Invalid manager user ID.");
		}

		// root̏ꍇ́AׂĂLoɑ΂LoInfo쐬
		if(managingUserId.equals(USER_ID_ROOT)){
			List loInfoList = new ArrayList();
			LoClient loClient = new LoClient();
			if(loClient.select()){
				while(loClient.next()){
					loInfoList.add(this.getLoInfo(loClient.getLoID()));
				}
			}

			return loInfoList;
		}else{
			
			// p[^œnꂽ[UIDAǗ\[UIDꗗɒǉ
			List managableUserIdList = new ArrayList();
			managableUserIdList.add(managingUserId);
			
			// Ǘ\[UIDꗗA̐lXǗ\LÕXg擾
			List loInfoList = this.getLoInfoList(managableUserIdList);
			return loInfoList;

		}
	}
	
	
	/**
	 * w肳ꂽu[Uu\ LO ALoInfo IuWFNg List `Ŏ擾܂B
	 * @param learningUserId wK҂̃[UID
	 * @return wK҂u\LÓALoInfoIuWFNg̃Xg
	 * @throws Exception
	 */
	public List getLearnableLoInfoList(String learningUserId) throws Exception{
		if(learningUserId == null || learningUserId.equals("")){
			throw new NullPointerException("Learner user ID is null.");
		}
		
		// [UID̗L`FbN
		if(!this.isValidUser(learningUserId)){
			throw new Exception("Invalid learner user ID.");
		}
		
		
		// LOǗ̂郍[̎擾
		List loManagableRoleIdList = this.getLoManagableRoleIdList();

		// eO[vID擾
		String parentGroupId = this.getParentGroupId(learningUserId);
		
		// root̏ꍇ parentGroupId  null ƂȂ̂ŁAGROUP_ID_ROOT őpB
		if(parentGroupId == null){
			parentGroupId = GROUP_ID_ROOT;
		}

		// RoleAssignment e[uA[UO[vɑ΂LOǗ[[U擾
		List managableUserIdList = this.getManagableUserIdList(parentGroupId, loManagableRoleIdList);

		// Ǘ\[UIDꗗA̐lXǗ\LÕXg擾
		List loInfoList = this.getLoInfoList(managableUserIdList);

		return loInfoList;
		
	}
	

	
	
}
