/*
 * 쐬: 2005/02/17
 */
package jp.co.ntt.lms.xmf.actions.xmo.evaluate;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

import java.net.URLEncoder;
import java.util.Date;
import java.text.SimpleDateFormat;

import jp.co.ntt.lms.xmo.Evaluate.EvaluateClient;
import jp.co.ntt.lms.xmo.Lo.LoClient;
import jp.co.ntt.lms.xmf.common.CommonFunction;

/**
 * @author ~ _i
 */
public class EvaluateAction extends Action {
	
	public ActionForward execute(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		// bZ[W\[X擾
		MessageResources resCnt = getResources(request, "msg.xmf.xmo.Evaluate.MessageResources");

		// LbV
		response.setHeader("cache-control", "no-cache");

		/////////////////////////////////////////////////////////////
		// ep[^擾
		/////////////////////////////////////////////////////////////
		String strAction       = (String)request.getParameter("ACTION");

		// SystemURL
		String strSystemURL = (String)request.getAttribute("SYSTEM_URL");
		if(strSystemURL == null)
		{
			strSystemURL = (String)request.getParameter("SYSTEM_URL");
			if(strSystemURL == null)
			{
				String strMessage = "";
		
				strMessage = URLEncoder.encode("VXeURLw肳Ă܂B", "UTF-8");

				response.sendRedirect("../Message/Messageerror.vm?message=" + strMessage);
			}
		}

		// LoID
		String strLoID = (String)request.getAttribute("LO_ID");
		if(strLoID == null)
		{
			strLoID = (String)request.getParameter("LO_ID");
			if(strLoID == null)
			{
				// G[y[Wo
				String strMessage = "";
		
				strMessage = URLEncoder.encode(resCnt.getMessage("STR_ERRMSG_LOID"), "UTF-8");

				response.sendRedirect("../Message/Messageerror.vm?message=" + strMessage);
			}
		}

		// UserID
		String strUserID = (String)request.getAttribute("USER_ID");
		if(strUserID == null)
		{
			strUserID = (String)request.getParameter("USER_ID");
			if(strUserID == null)
			{
				String strMessage = "";
			
				strMessage = URLEncoder.encode(resCnt.getMessage("STR_ERRMSG_USERID"), "UTF-8");

				response.sendRedirect("../Message/Messageerror.vm?message=" + strMessage);
			}
		}

		// Score
		String strScore        = (String)request.getParameter("SCORE");

		// Comment
		String strCustomMsgDir = (String)request.getParameter("CUSTOM_MSG_DIR");
		if(strCustomMsgDir == null)
		{
			strCustomMsgDir = "";
		}



		/////////////////////////////////////////////////////////////
		// ]e[uǉ
		/////////////////////////////////////////////////////////////
		if(strAction != null && strAction.equals("on"))
		{
			// RealLOID擾
			String strRealLOID = "";
			LoClient objLoClient = new LoClient();
			if(objLoClient.getRealLOIDFromLOID(strLoID)){
				strRealLOID = objLoClient.getRealLOIDResult();
			}
			else{
				// ܂Ȃꍇ
				if( objLoClient.isErr() ) {
					// G[̏ꍇ
					response.sendRedirect( objLoClient.getURL() );
				}
				else {
					String strMessage =  objLoClient.getMessage();
					response.sendRedirect( CommonFunction.getParamErrURL( strMessage, null, true ) );
				}
			}

			EvaluateClient objEc = new EvaluateClient();

			objEc.setLoID(strRealLOID);
			objEc.setUserID(strUserID);
			Date objDate = new Date();
			SimpleDateFormat objDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
			String strDate = objDateFormat.format(objDate);
			objEc.setScoreDate(strDate);
			objEc.setScore(strScore);
			objEc.setCustomMsgDir(strCustomMsgDir);

			// o^\bhs
			if(!objEc.insert())
			{
				// o^܂Ȃꍇ
				if(objEc.isErr())
				{
					// G[̏ꍇ
					response.sendRedirect( objEc.getURL() );
				}
				else
				{
					String strMessage =  objEc.getMessage();
					response.sendRedirect(CommonFunction.getParamErrURL(strMessage, null, true));
				}
			}
		}
		
		request.setAttribute("strAction", strAction);
		request.setAttribute("strLoID", strLoID);
		request.setAttribute("strUserID", strUserID);
		request.setAttribute("strSystemURL", strSystemURL);
		request.setAttribute("strCustomMsgDir", strCustomMsgDir);

		return mapping.findForward("success");
	}
}
