/////////////////////////////////////////////////////////////////
//Copyright (C) 2005 NTT CORPORATION.
//
//	c[擾 Velocity ToolNX
//
//		ύX
//			2005.02.19  VK쐬   
//
//	@\
//
//	̃NX̓c[擾NXłB
//
////////////////////////////////////////////////////////////////

package jp.co.ntt.lms.xmf.tools.xmo.Base;

import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import jp.co.ntt.lms.lo.LoComData;
import jp.co.ntt.lms.lo.LoTopClient;
import jp.co.ntt.lms.lo.MaterialNode;
import jp.co.ntt.lms.lo.MaterialNodeList;
import jp.co.ntt.lms.xmf.tools.ToolBase;
import jp.co.ntt.lms.xmo.Environment;
import jp.co.ntt.lms.xmo.XMOException;
import jp.co.ntt.lms.xmo.Base.XMSBaseClient;
import jp.co.ntt.lms.xmo.Base.Gui.BaseDisplayData;
import jp.co.ntt.lms.xmo.Groups.GroupsClient;
import jp.co.ntt.lms.xmo.Groups.GroupsData;
import jp.co.ntt.lms.xmo.Lo.LoClient;
import jp.co.ntt.lms.xmo.Lo.LoData;
import jp.co.ntt.lms.xmo.LoRelation.LoRelationClient;
import jp.co.ntt.lms.xmo.Method.MethodClient;
import jp.co.ntt.lms.xmo.Method.MethodData;
import jp.co.ntt.lms.xmo.util.HtmlEscape;

/**
 * c[擾Velocity ToolNX
 * 
 * ̃NX̓c[̏ꗗ擾NXłB
 * 
 * @author  
 * @version 1.0
 */
public class TreeViewTool extends ToolBase
{

    /**
     * c[\̃[gɕ\ꗗ擾郁\bhłB
     * 
     * @param strTreeType
     *            c[^Cv
     * @param strUserID
     *            [UID
     * @return Vector [g
     */
    public Vector getRootList(String strTreeType, String strUserID)
            throws XMOException, Exception
    {
        return GetRootList.getRootList(context, strTreeType, strUserID);
    }

    /**
     * ʂ̃O[v擾B
     * 
     * @param request NGXg
     * @return O[v킷XML
     */
    public String getChildGroups(HttpServletRequest request)
    {
        HttpSession session = request.getSession();

        // p[^擾
        String strParentID = request.getParameter("ParentID");
        String strUserID = request.getParameter("userId");

        // LbV
        //response.setHeader( "cache-control", "no-cache" );

        try
        {
            StringBuffer strGetLine = new StringBuffer();
            strGetLine.append("<childlenlist>\n");

            // O[vǗXMO̎擾
            GroupsClient objGroups = new GroupsClient();

            String GROUP_TREE_ROOT = getContextString("GROUP_TREE_ROOT");
            if (strParentID.equals(GROUP_TREE_ROOT))
            {
                Vector vecRootList = null;
                try
                {
                    String GROUP_TYPE = getContextString("GROUP_TYPE");
                    vecRootList = getRootList(GROUP_TYPE, strUserID);
                }
                catch (XMOException xe)
                {
                    xe.printStackTrace();
                    return "";
                }
                // [gZbVɊi[
                Hashtable htbRootInfo = new Hashtable();
                String ROOT_INFO = getContextString("ROOT_INFO");
                session.setAttribute(ROOT_INFO, htbRootInfo);

                int intGRResult = vecRootList.size();
                for (int i = 0; i < intGRResult; i++)
                {
                    GroupsData objGroupsData = (GroupsData) vecRootList.get(i);

                    // ZbVɓꂽHastableGroupIDL[ɂĐeIDi[B
                    htbRootInfo.put(objGroupsData.getGroupID(), objGroupsData
                            .getParentID());

                    String strGroupName = objGroupsData.getGroupName();
                    String strType = objGroupsData.getGroupType();
                    String strGroupID = objGroupsData.getGroupID();

                    //ŏIR[h̏ꍇ
                    if (i == intGRResult - 1)
                    {
                        strType = strType + "^L";
                    }

                    strGetLine.append("<child title=\"");
                    strGetLine.append(HtmlEscape.escape(strGroupName));
                    strGetLine.append("\" iconid=\"group\" id=\"");
                    strGetLine.append(strGroupID);
                    strGetLine.append("\" type=\"");
                    strGetLine.append(strType);
                    strGetLine.append("\" />\n");
                }
            }
            else
            {

                XMSBaseClient objBase = new XMSBaseClient();

                // 
                int intResult = 0;
                int intCounter = 0;
                String strName = "";
                String strType = "";
                String strID = "";
                String strIconID = "";
                if (objBase.selectGroupAndPeopleBaseDisplay(strParentID))
                {
                    BaseDisplayData[] objDisplayList = objBase.getBaseDisplay();
                    //擾
                    intResult = objDisplayList.length;
                    // ܂ꍇ
                    for (int i = 0; i < objDisplayList.length; i++)
                    {

                        BaseDisplayData objDisplay = objDisplayList[i];

                        strName = objDisplay.getTitle();
                        strType = objDisplay.getType();
                        strID = objDisplay.getID();
                        strIconID = "person";
                        if (strID.substring(0, 2).equals("GR"))
                        {
                            strIconID = "group";
                        }
                        intCounter++;
                        //ŏIR[hȊO
                        if (intCounter == intResult)
                        {
                            strType = strType + "^L";
                        }

                        strGetLine.append("<child title=\"");
                        strGetLine.append(HtmlEscape.escape(strName));
                        strGetLine.append("\" iconid=\"" + strIconID
                                + "\" id=\"");
                        strGetLine.append(strID);
                        strGetLine.append("\" type=\"");
                        strGetLine.append(strType);
                        strGetLine.append("\" />\n");
                    }
                }
            }

            strGetLine.append("</childlenlist>\n");
            //out.write( strGetLine.toString() );
            return strGetLine.toString();
        }
        catch (Exception e)
        {
            e.printStackTrace();
            return "";
        }
    }

    /**
     * ʂ̏擾B
     * 
     * @param request NGXg
     * @return ʂ̏킷XML
     * @throws Exception
     */
    public String getChildMatSt(HttpServletRequest request) throws Exception
    {

        HttpSession session = request.getSession();

        // p[^擾
        String strMaterialPath = request.getParameter("MaterialPath");

        ///////////////////////////////////////////
        // ZbVϐ̎擾
        // EisLeaner wKҎ C
        ///////////////////////////////////////////
        String LEANER = getContextString("LEANER");
        String strLearner = (String) session.getAttribute(LEANER);

        ///////////////////////////////////////////
        // ZbVϐ̃`FbN
        ///////////////////////////////////////////
        if (strLearner == null)
        {
            //response.sendRedirect( LOGIN_URL );
            return "";
        }

        // 擾pXAޕ̃pX݂̂擾
        StringTokenizer objToken = new StringTokenizer(strMaterialPath, ":");
        while (objToken.hasMoreTokens())
        {
            objToken.nextToken();
            strMaterialPath = objToken.nextToken();
        }

        // ޕ̃pXLOID擾Ȁڍ׏擾܂
        String strLoID = "";
        objToken = new StringTokenizer(strMaterialPath, "/");
        int intCount = 0;
        StringBuffer strMatPath = new StringBuffer();
        while (objToken.hasMoreTokens())
        {
            if (intCount == 0)
            {
                strLoID = objToken.nextToken();
            }
            else
            {
                strMatPath.append("/");
                strMatPath.append(objToken.nextToken());
            }
            intCount++;
        }

        // LOXMONCAg̃CX^X𐶐܂
        LoClient objLoClient = new LoClient();
        // LOIDɐݒ肵܂
        objLoClient.setWhereLoID(strLoID);

        // s
        if (!objLoClient.select())
        {
            // Ɏsꍇ
            // ɃG[Lq
            // ͓ɉȂ
            return "";
        }

        // ʂ̎擾
        String strMaterialID = "";
        String strLoType = "";
        String strRealLOID = null;
        if (objLoClient.next())
        {
            // ގʂ̎擾
            strLoType = objLoClient.getLoType();
            strRealLOID = objLoClient.getRealLOID();
        }

        try
        {
            StringBuffer strGetLine = new StringBuffer();
            strGetLine.append("<childlenlist>\n");

            // ގʂLoTopClientCX^X
            // LOT[o̎擾
            Environment objEnv = new Environment();
            String strLoServerName = objEnv.getLoServerName();
            // LONXCX^X܂
            LoTopClient objLoTopClient = new LoTopClient(strLoServerName,
                    strLoType);

            // LO狳ޏڍ׏擾
            if (objLoTopClient.getData(strRealLOID))
            {
                if (objLoTopClient.getDataLength() > 0)
                {
                    LoComData objData = objLoTopClient.getDataInfo(0);
                    // ID̎擾
                    strMaterialID = objData.getMaterialID();
                }
            }

            // ރpXgݗĂȂ
            strMaterialPath = "/" + strMaterialID + strMatPath.toString();

            // ލ\擾\bhR[܂
            // p[^̏
            Hashtable objParams = new Hashtable();
            objParams.put("MATID", strMaterialID);
            objParams.put("MatPath", strMaterialPath);

            if (!objLoTopClient.getMaterialStruct(objParams))
            {
                // ɃG[Lq
                return "";
            }

            MaterialNode objNode = (MaterialNode) objLoTopClient
                    .getMaterialStruct();
            if (objNode != null)
            {
                MaterialNodeList objNodeList = objNode.getChildList();
                int intCnt = 0;
                int intChildListCount = objNodeList.getChildCount();
                objNodeList.first();
                while (objNodeList.hasNext())
                {
                    MaterialNode objNodetemp = objNodeList.next();
                    String strIconID = "";
                    switch (objNodetemp.getNodeType())
                    {
                    // R[X̏ꍇ
                    case MaterialNode.COURSE_NODE:
                        strIconID = "course";
                        break;
                    // ubN̏ꍇ
                    case MaterialNode.BLOCK_NODE:
                        strIconID = "block";
                        break;
                    // AȔꍇ
                    case MaterialNode.AU_NODE:
                        strIconID = "au";
                        break;
                    default:
                        break;
                    }

                    //ŏIR[hłꍇ
                    if (intChildListCount - 1 == intCnt)
                    {
                        //L^GifACRgp邽߂̎ʎqZbg
                        strLoType = "L" + strLoType;
                    }

                    strGetLine.append("<child title=\""
                            + objNodetemp.getTitle() + "\" iconid=\""
                            + strIconID + "\" id=\"" + objNodetemp.getAuID()
                            + "\"  type=\"" + strLoType + "\"/>\n");

                    intCnt++;
                }
            }

            strGetLine.append("</childlenlist>\n");

            return strGetLine.toString();
        }
        catch (Exception e)
        {
            e.printStackTrace();
            return "";
        }
    }

    /**
     * ʂ̏擾B
     * 
     * @param request NGXg
     * @return ʂ̏킷XML
     */
    public String getChildMaterial(HttpServletRequest request)
    {

        HttpSession session = request.getSession();

        // p[^擾
        String strParentID = request.getParameter("ParentID");
        String strUserID = request.getParameter("userId");

        ///////////////////////////////////////////
        // ZbVϐ̎擾
        // EisLeaner wKҎ C
        ///////////////////////////////////////////
        String LEANER = getContextString("LEANER");
        String strLearner = (String) session.getAttribute(LEANER);

        ///////////////////////////////////////////
        // ZbVϐ̃`FbN
        ///////////////////////////////////////////
        if (strLearner == null)
        {
            //response.sendRedirect( LOGIN_URL );
            return "";
        }

        int intLRResult = 0;
        try
        {
            StringBuffer strGetLine = new StringBuffer();
            strGetLine.append("<childlenlist>\n");

            String LO_TREE_ROOT = getContextString("LO_TREE_ROOT");
            if (strParentID.equals(LO_TREE_ROOT))
            {
                Vector vecRootList = null;
                try
                {
                    String LO_TYPE = getContextString("LO_TYPE");
                    vecRootList = getRootList(LO_TYPE, strUserID);
                }
                catch (XMOException xe)
                {
                    xe.printStackTrace();
                    return "";
                }

                // [gZbVɊi[
                Hashtable htbRootInfo = new Hashtable();
                String ROOT_INFO = getContextString("ROOT_INFO");
                session.setAttribute(ROOT_INFO, htbRootInfo);

                intLRResult = vecRootList.size();
                for (int i = 0; i < intLRResult; i++)
                {
                    LoData objLoData = (LoData) vecRootList.get(i);

                    // ZbVɓꂽHastableLOIDL[ɂĐeIDi[B
                    htbRootInfo.put(objLoData.getLoID(), objLoData
                            .getParentID());

                    // LOID̎擾
                    String strLoID = objLoData.getLoID();
                    String strLoName = objLoData.getLoTytle();
                    String strLoType = objLoData.getLoType();
                    String strIconID = "";
                    // LOʂɂăACRIDU蕪
                    if (strLoType.equals("0"))
                    {
                        strIconID = "container";
                    }
                    else
                    {
                        strIconID = "course";
                    }

                    //Kw̍ŏIR[h̏ꍇ
                    if (i == intLRResult - 1)
                    {
                        strLoType = "L" + strLoType;
                    }
                    strGetLine.append("<child title=\"");
                    strGetLine.append(HtmlEscape.escape(strLoName));
                    strGetLine.append("\" iconid=\"");
                    strGetLine.append(strIconID);
                    strGetLine.append("\" id=\"");
                    strGetLine.append(strLoID);
                    strGetLine.append("\" type=\"");
                    strGetLine.append(strLoType);
                    strGetLine.append("\" />\n");
                }
            }
            else
            {

                XMSBaseClient objBase = new XMSBaseClient();

                // 
                int intResult = 0;
                int intCounter = 0;
                String strName = "";
                String strType = "";
                String strID = "";
                String strIconID = "";
                if (objBase.selectLoBaseDisplay(strParentID))
                {
                    BaseDisplayData[] objDisplayList = objBase.getBaseDisplay();
                    //擾
                    intResult = objDisplayList.length;
                    // ܂ꍇ
                    for (int i = 0; i < objDisplayList.length; i++)
                    {

                        BaseDisplayData objDisplay = objDisplayList[i];

                        strName = objDisplay.getTitle();
                        strType = objDisplay.getType();
                        strID = objDisplay.getID();
                        strIconID = "course";
                        if (strType.equals("0"))
                        {
                            strIconID = "container";
                        }
                        intCounter++;
                        //ŏIR[hȊO
                        if (intCounter == intResult)
                        {
                            strType = "L" + strType;
                        }

                        strGetLine.append("<child title=\"");
                        strGetLine.append(HtmlEscape.escape(strName));
                        strGetLine.append("\" iconid=\"");
                        strGetLine.append(strIconID);
                        strGetLine.append("\" id=\"");
                        strGetLine.append(strID);
                        strGetLine.append("\" type=\"");
                        strGetLine.append(strType);
                        strGetLine.append("\" />\n");
                    }
                }
            }

            strGetLine.append("</childlenlist>\n");

            return strGetLine.toString();
        }
        catch (Exception e)
        {
            e.printStackTrace();
            return "";
        }
    }

    /**
     * ʂ̃\bh擾B
     * 
     * @param request NGXg
     * @return ʂ̃\bh킷XML
     */
    public String getChildMethods(HttpServletRequest request)
    {

        HttpSession session = request.getSession();

        // p[^擾
        String strParentID = request.getParameter("ParentID");
        String strUserID = request.getParameter("userId");

        ///////////////////////////////////////////
        // ZbVϐ̎擾
        // EisLeaner wKҎ C
        ///////////////////////////////////////////
        String LEANER = getContextString("LEANER");
        String strLearner = (String) session.getAttribute(LEANER);

        ///////////////////////////////////////////
        // ZbVϐ̃`FbN
        ///////////////////////////////////////////
        if (strLearner == null)
        {
            //response.sendRedirect( LOGIN_URL );
            return "";
        }

        int intLRResult = 0;
        try
        {
            StringBuffer strGetLine = new StringBuffer();
            strGetLine.append("<childlenlist>\n");

            String METHOD_TREE_ROOT = getContextString("METHOD_TREE_ROOT");
            if (strParentID.equals(METHOD_TREE_ROOT))
            {
                Vector vecRootList = null;
                try
                {
                    String METHOD_TYPE = getContextString("METHOD_TYPE");
                    vecRootList = getRootList(METHOD_TYPE, strUserID);
                }
                catch (XMOException xe)
                {
                    xe.printStackTrace();
                    return "";
                }

                // [gZbVɊi[
                Hashtable htbRootInfo = new Hashtable();
                String ROOT_INFO = getContextString("ROOT_INFO");
                session.setAttribute(ROOT_INFO, htbRootInfo);

                intLRResult = vecRootList.size();
                for (int i = 0; i < intLRResult; i++)
                {
                    LoData objLoData = (LoData) vecRootList.get(i);

                    // ZbVɓꂽHastableLOIDL[ɂĐeIDi[B
                    htbRootInfo.put(objLoData.getLoID(), objLoData.getParentID());

                    // LOID̎擾
                    String strLoID = objLoData.getLoID();
                    String strLoName = objLoData.getLoTytle();
                    String strLoType = objLoData.getLoType();
                    String strIconID = "";
                    // LOʂɂăACRIDU蕪
                    if (strLoType.equals("0"))
                    {
                        strIconID = "container";
                    }
                    else
                    {
                        strIconID = "course";
                    }

                    //Kw̍ŏIR[h̏ꍇ
                    if (i == intLRResult - 1)
                    {
                        strLoType = "L" + strLoType;
                    }
                    strGetLine.append("<child title=\"");
                    strGetLine.append(HtmlEscape.escape(strLoName));
                    strGetLine.append("\" iconid=\"");
                    strGetLine.append(strIconID);
                    strGetLine.append("\" id=\"");
                    strGetLine.append(strLoID);
                    strGetLine.append("\" type=\"");
                    strGetLine.append(strLoType);
                    strGetLine.append("\" />\n");
                }
            }
            else
            {
            	String strLoName;
            	String strLoID;
            	String strLoType;
            	String strMethodID;
            	
				// LO[VǗXMO̎擾
            	LoRelationClient objXMO = new LoRelationClient();
            	MethodClient objMethodClient = new MethodClient();
				objXMO.setParentID(strParentID);

				if (objXMO.select())
				{
					intLRResult = objXMO.getResultCount();
					// O[vǗXMO̎擾
					LoClient objLo = new LoClient();
	
					int intCounter = 0;
					while (objXMO.next())
					{
						intCounter++;
						
						// LoID̎擾
						strLoID = objXMO.getChildID();
						
						// LO̎擾
						objLo.clear();
						objLo.setWhereLoID(strLoID);
						if (!objLo.select())
							continue;
						if (!objLo.next())
							continue;
						
						strLoType = objLo.getLoType();
						if (intCounter == intLRResult)
							strLoType = "L" + strLoType;
						strLoName = objLo.getLoTytle();
						
						// \bh擾
						objMethodClient.clear();
						objMethodClient.setWhereLoID(strLoID);
						if (!objMethodClient.select())
							continue;
						if (objMethodClient.getResultCount() <= 0)
							continue;
						
						MethodData[] arrayMethod = objMethodClient.getResultList();
						strMethodID = arrayMethod[0].getMethodLOID();

						// ReiƂ̑LOʂ邽strLoTypeǉ
						strGetLine.append("<child title=\"");
						strGetLine.append(HtmlEscape.escape(strLoName));
						strGetLine.append("\" iconid=\"container\" id=\"");
						strGetLine.append(strLoID);
						strGetLine.append("\" type=\"");
						strGetLine.append(strLoType);
						strGetLine.append("\" methodId=\"");
						strGetLine.append(strMethodID);
						strGetLine.append("\" />\n");
					}
				}
            }

            strGetLine.append("</childlenlist>\n");

            return strGetLine.toString();
        }
        catch (Exception e)
        {
            e.printStackTrace();
            return "";
        }
    }
}