/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

//
//	ύX t@Ng[NX
//			ύX
//				2004.07.21 VK쐬 A.Shimoma
//								
//
package jp.co.ntt.lms.xmo.Lo;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;

import org.apache.commons.lang.StringEscapeUtils;

import jp.co.ntt.lms.xmo.DataAccess;
import jp.co.ntt.lms.xmo.MessageData;
import jp.co.ntt.lms.xmo.XMOException;
import jp.co.ntt.lms.xmo.Message.Message;
import jp.co.ntt.lms.xmo.util.DebugLog;

/**
 *
 * ̃NX͑ύXΏLOɂsNX肵܂B
 * 
 * ύXΏLOA
 *   Ȃ̏ꍇAChangeTypeNoCopyLo
 *   ̏ꍇAChangeTypeBaseLo
 *   ̏ꍇAChangeTypeReferenceLo
 * s܂B
 * 
 * @author A.Shimoma
 * 
 */
public class ChangeTypeFactory implements LoTable, LoMessage {

	/**
	 * LOID
	 */
	String loID = null;
	/**
	 * LOTYPE
	 */
	String loType = null;
	/**
	 * ALOID
	 */
	String realLoID = null;
	/**
	 * [UID
	 */
	String userID = null;
	/**
	 * QƂꍇɎgpŏLOID
	 */
	String newLoID = null;
	/**
	 * DBANZX
	 */
	String condition = null;
	/**
	 * QƃXg
	 */
	Vector copyList = null;
	/**
	 * f[^ANZXNX̃CX^X
	 */
	DataAccess objDataAccess = null;
	/**
	 * kne[uANZXNX
	 */
	LoDataAccess objLoDataAccess = null;
	/**
	 * 
	 */
	ChangeTypeAbstract changeType = null;

	/**
	 * 
	 * @param strLoID
	 * @param strUserID
	 * @param dataAccess
	 * @return
	 * @throws XMOException
	 */
	ChangeTypeAbstract getFactory(String strLoID, String strUserID, DataAccess dataAccess) throws XMOException {
		loID = strLoID;
		userID = strUserID;
		objDataAccess = dataAccess;
		init();
		return factory();
	}

	/**
	 * B
	 * ̏ł́ALO̎擾LOQƏ̎擾s܂B
	 * @throws XMOException
	 * 
	 */
	private void init() throws XMOException {

		// p̕gݗĂ
		condition = " WHERE " + LO_ID + "='" + StringEscapeUtils.escapeSql(loID) + "'";
		objLoDataAccess = new LoDataAccess();
		// LO擾
		getLoInfo();
		// LOQƏ擾
		getCopyList();

	}

	/**
	 * ύXΏۂLOݒ肵܂B
	 * @throws XMOException
	 */
	private void getLoInfo() throws XMOException {

		Hashtable htbCondition = null;
		htbCondition = new Hashtable();
		htbCondition.put( CONDITION_KEY, condition );
		Vector vecLoType = objLoDataAccess.select( htbCondition );
		if( vecLoType.size() > 0 ) {
			LoData objTemp = (LoData)vecLoType.get(0);
			loType = objTemp.getLoType();
			realLoID = objTemp.getRealLOID();
		}
	}

	/**
	 * ύXLOɎQƂݒ肵܂B
	 * @throws XMOException
	 */
	private void getCopyList() throws XMOException {

		try {

			// ύXLOɎQƂ݂邩A`FbNB
			copyList = objLoDataAccess.getCopyList(realLoID, objDataAccess);

		} catch (SQLException se) {
			DebugLog.write( this.getClass(), se, DebugLog.HIGHT );
			throw new XMOException(getMessageData(DB_ERR));
		}
	}

	/**
	 * bZ[WIuWFNg쐬܂B
	 * 
	 * @param strMessageID bZ[WID
	 * @return MessageData bZ[WIuWFNg OnullԂ܂
	 */
	MessageData getMessageData( String strMessageID) {

		MessageData objMessage = null;
		try {
			objMessage = Message.getInstance().getMessageData( strMessageID, MSG_FIEL_PATH, MSG_FILE_NAME );
		}
		catch( Exception e ) {

		}
		return objMessage;
	}

	/**
	 * ɎTuNXԂ܂B
	 * 
	 * @return ChangeTypeAbstract̃TuNX
	 * @throws XMOException
	 */
	private ChangeTypeAbstract factory() throws XMOException {

		// QƂ݂Ȃꍇ
		if(copyList.size()==1){
			changeType = new ChangeTypeNoCopyLo();
		}
		// QƂ݂AύXΏLȌꍇ
		else if (loID.equals(realLoID)) {
			changeType = new ChangeTypeBaseLo();
		}
		// QƂ݂AύXΏLOꂽLOłꍇA
		else {
			changeType = new ChangeTypeReferenceLo();
		}

		// ύXւ̃p[^p
		setParams();
		// ύXŎgpIuWFNg̃CX^X
		changeType.getInstance();

		return changeType;
	}

	/**
	 * ύXɕKvȃf[^̐ݒs܂B
	 *
	 */
	private void setParams() {
		// LOIDݒ
		changeType.setLoID(loID);
		// [UIDݒ
		changeType.setUserID(userID);
		// ALOIDݒ
		changeType.setRealLoID(realLoID);
		// LO^Cvݒ
		changeType.setLoType(loType);
		// ݒ
		changeType.setCondition(condition);
		// QƃXgݒ
		changeType.setCopyList(copyList);
		// f[^ANZXIuWFNgݒ 
		changeType.setDataAccess(objDataAccess);
	}
}
