/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

//
// XML[eBeBNX
// 
//
//	ύX
//	2004/01/08 VK쐬	T.Nishiki 
//
package jp.co.ntt.lms.xms.common.util;

import java.util.ArrayList;
import java.util.List;

import jp.co.ntt.lms.xms.framework.XmsException;
import jp.co.ntt.lms.xms.framework.XmsInnerException;

import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * XML[eBeBENXB<br>
 * 
 * @author T.Nishiki
 */
public final class XmlUtil {

	/**
	 * m[hB<br>
	 * @param contextNode JnƂȂm[hB
	 * @param str L[ƂȂm[hEpXB
	 * @return ʂƂĊYm[h̔zB
	 *          Ym[hȂꍇAvf̂Ȃz߂B
	 * @throws XmsException ɃG[ꍇB
	 */
	public static Node[] selectNodes(Node contextNode, String str)
		throws XmsException {
			
		List pathList  = null;
		List resultList  = null;
		Node[] returnNodes = null;
		try {
			// m[hEpXXbVŋ؂B
			pathList = StringUtil.split( str, "/" );
			// {B
			resultList = selectNodes(contextNode, pathList);
			// ListzɕϊB
			returnNodes = new Node[ resultList.size() ];
			for ( int i = 0; i < returnNodes.length; i++ ) {
				returnNodes[i] = (Node)resultList.get( i ) ;
			}
		} catch ( XmsException e ) {
			throw e;
		} catch ( Exception e ) {
			throw new XmsInnerException( e );
		}
		return returnNodes;
	}
	
	/**
	 * m[hB<br>
	 * @param contextNode JnƂȂm[hB
	 * @param str L[ƂȂm[hEpXB
	 * @return ʂƂĊYm[hB
	 *          Ym[hȂꍇAnull߂B
	 * @throws XmsException ɃG[ꍇB
	 */
	public static Node selectNode(Node contextNode, String str)
			throws XmsException {
		List pathList   = null;
		List resultList = null;
		Node returnNode = null;
		try {
			// m[hEpXXbVŋ؂B
			pathList = StringUtil.split( str, "/" );
			// {B
			resultList = selectNodes(contextNode, pathList);
			
			// ʂ̂A擪vf݂̂𗘗pB
			if (resultList.size() > 0 ) {
				returnNode = (Node)resultList.get(0);
			}
		} catch ( XmsException e ) {
			throw e;
		} catch ( Exception e ) {
			throw new XmsInnerException( e );
		}
		return returnNode;
	}
	
	/**
	 * l擾܂B<br>
	 * w肵m[hɎw肵̂̑ꍇȂl߂B
	 * LɓĂ͂܂ȂꍇAnull߂B
	 * 
	 * @param node 擾m[hB
	 * @param name lmF鑮́B
	 * @return w肵̒l߂B
	 *          ݂ȂAw肵̂̑ȂꍇA
	 *          null߂B
	 */
	public static String getAttributeValue( Node node, String name )
			throws XmsException {
		// ̃\bh̖߂l
		String attributeValue = null;
		// }bvB
		NamedNodeMap attributes = null;
		// m[hB
		Node   attributeNode = null;
		try {
			// }bv擾
			attributes = node.getAttributes();
			if ( attributes != null ) {
				// 擾
				attributeNode = attributes.getNamedItem( name );
				if ( attributeNode != null ) {
					attributeValue = attributeNode.getNodeValue();
				}
			}
		} catch ( Exception e ) {
			throw new XmsInnerException( e );
		}
		return attributeValue;
	}
	
	/**
	 * m[hEXgw肵́El̑m[h擾B<br>
	 * @param nodeList mFm[hB
	 * @param targetName mF鑮́B
	 * @param targetValue mF鑮lB
	 * @return w肵̒l߂B
	 *          ݂ȂAw肵̂̑ȂꍇA
	 *          null߂B
	 * @throws XmsException
	 */
	public static Node searchNodeByAttribute( NodeList nodeList, String targetName, String targetValue )
			throws XmsException {

		// lmFp
		String attributeValue = null;
		/// ̃\bh̖߂l
		Node returnNode = null;
		try {
			for ( int i = 0 ; i < nodeList.getLength(); i++ ) {
				Node node = nodeList.item(i);
				attributeValue = getAttributeValue(node, targetName );
				if ( attributeValue == null ) {
					continue;
				}
				
				if ( attributeValue.equals( targetValue ) == true ) {
					returnNode = node;
					break;
				}
			}
		} catch ( Exception e ) {
			throw new XmsInnerException( e );
		}
		return returnNode;
	}

	
	/**
	 * m[hz񂩂w肵́El̑m[h擾B<br>
	 * @param nodes mFm[hB
	 * @param targetName mF鑮́B
	 * @param targetValue mF鑮lB
	 * @return w肵̒l߂B
	 *          ݂ȂAw肵̂̑ȂꍇA
	 *          null߂B
	 * @throws XmsException
	 */
	public static Node searchNodeByAttribute( Node[] nodes, String targetName, String targetValue )
			throws XmsException {

		// lmFp
		String attributeValue = null;
		/// ̃\bh̖߂l
		Node returnNode = null;
		try {
			for ( int i = 0 ; i < nodes.length; i++ ) {
				Node node = nodes[i];
				attributeValue = getAttributeValue(node, targetName );
				if ( attributeValue == null ) {
					continue;
				}
				
				if ( attributeValue.equals( targetValue ) == true ) {
					returnNode = node;
					break;
				}
			}
		} catch ( Exception e ) {
			throw new XmsInnerException( e );
		}
		return returnNode;
	}

	/**
	 * m[hB<br>
	 * @param contextNode JnƂȂm[hB
	 * @param pathList L[ƂȂm[hvfƂ郊XgB
	 * @return ʂƂĊYm[h̃XgB
	 *          Ym[hȂꍇAvf̂ȂXg߂B
	 * @throws XmsException ɃG[ꍇB
	 */
	private static List selectNodes(Node contextNode, List pathList)
		throws XmsException {
		
		// ߂p̃Xg
		List returnList = null;
		// 擪m[hi̎qvfpj
		String topPath = null;
		// ̎qvfXg
		NodeList children = null;
		// 擪m[hXgiċApj
		List childPathList = null;
		try {
			// ߂p̃XgŏĂB
			returnList = new ArrayList();
			// m[hXg̐擪擾
			topPath = (String)pathList.get(0);
			// 擪m[hXg擾
			childPathList = pathList.subList(1, pathList.size() );
			
			// eɊւ炸A̎qvf擾A
			// ̂A擪m[hƈvm[h擾B
			// vvfAċAp̃m[hXg΁A
			// ɂ̗̉vfɂčċA{A
			// ̌ʂ𓝍ʂ߂B
			// vvfAċAp̃m[hXgȂ΁A
			// ̈vvfAYvfƂāA܂Ƃ߂Ė߂B
			children = contextNode.getChildNodes();
			for ( int i = 0; i < children.getLength(); i++ ) {
				// qvfPP`FbN
				Node childNode = null;
				String childNodeName = null;
				childNode = children.item(i);
				// text()擾w肵ĂꍇA擾m[hTEXTł΁AǉB
				if (( topPath.equals( "text()" ) == true)
					&& (childNode.getNodeType() == Node.TEXT_NODE ) ) {
					returnList.add( childNode );
					continue;
				}
				// =============================================================
				// vf̖O擾
				childNodeName = childNode.getNodeName();
				// vf̖OvȂΖ
				if ( childNodeName.equals(topPath) == false ) {
					continue;
				}
				// =============================================================
				// vAAċAp̃m[hXgȂ΁A
				// vm[h߂lɊ܂߂B
				if ( childPathList.size() == 0 ) {
					returnList.add( childNode );
					continue;
				}
				// =============================================================
				// qvfɑ΂čċA{A
				// ̌ʂ𕹍B
				List childRetuernedList = null;
				childRetuernedList = selectNodes( childNode, childPathList ); 
				returnList.addAll(childRetuernedList);			
			}
		} catch (Exception e ) {
			throw new XmsInnerException( e );
		}
		return returnList;
	}


}
