/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

//
// ƖUNX
// 
//	ύX
//	2004/01/08 VK쐬	T.Nishiki
//  2007/09    `FbNύX yasu
//
package jp.co.ntt.lms.xms.framework;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jp.co.ntt.lms.xmo.util.DebugLog;
import jp.co.ntt.lms.xms.common.user.User;

/**
 * ƖUNXB<br>
 * 
 * @author T.Nishiki
 */
public class XmsBusinessControl {


	/**
	 *  ƖUsB
	 * @param xmsRequest NGXgEIuWFNgB
	 * @param xmsResponse X|XEIuWFNgB
	 * @throws XmsException ɗOꍇB
	 */
	public void processRequest(XmsRequest xmsRequest, XmsResponse xmsResponse)
		throws XmsException {

		DebugLog.write(XmsBusinessControl.class,
			"HEAD processRequest()", DebugLog.ROW );

		// NANVNX
		XmsBusinessAction action = null;
		// ANVNXsʃf[^B
		XmsBusinessBean bean    = null;
		try {
			
			////////////////////////////////////////////////////////////////
			//`FbN
			checkPermission(xmsRequest);
			////////////////////////////////////////////////////////////////
			// sNX̑I
			action = getBusinessAction(xmsRequest);
			if ( action != null ) {
				// s
				action.perform(xmsRequest, xmsResponse);
				// ԋplIuWFNgʏoB
				bean = xmsResponse.getBusinessBean();
		
				// XR[vɂʏIuWFNg̐ݒ
				if( bean != null ) {
					HttpServletRequest request = null;
					request = xmsRequest.getRequest();
					// XR[vZbV̏ꍇ
					if( xmsResponse.getScope() == XmsResponse.SESSION ) {
						
						HttpSession session = request.getSession();
						session.setAttribute(xmsResponse.getBusinessBeanName(), bean);
					}
					// XR[vNGXg̏ꍇ
					else if( xmsResponse.getScope() == XmsResponse.REQUEST ) {
						request.setAttribute(xmsResponse.getBusinessBeanName(), bean);
					}
				}
			}

		} catch (XmsException e) {
			throw e;
		} catch ( Exception e ) {
			throw new XmsSystemException(e);
		} finally {
			DebugLog.write(XmsBusinessControl.class,
				"TAIL processRequest()", DebugLog.ROW );
		}
	}
	
	
	/**
	 * NGXgɑΉANVNX擾B<br>
	 * w肵NGXgANVID擾A
	 * ΉANVNXECX^X𐶐Ė߂B
	 * NXݒ肵ĂȂꍇAnull߂B
	 * 
	 * @param xmsRequest HTTPNGXgB
	 * @return XmsScreenAction ANVIDɑΉANVNXB
	 * @throws XmsException ANVID܂܂ȂꍇA
	 * ΉANVNX݂ȂꍇB
	 */
	private XmsBusinessAction getBusinessAction( XmsRequest xmsRequest )
			throws XmsException {

		// ANVhc
		String actionId = null;
		// ANVNX
		String className = null;
		// ANVNX[hp
		Class actionClass = null;
		// NANVNX
		XmsBusinessAction action = null;

		try {
			// ANVhc擾B
			actionId = xmsRequest.getParameter(Constant.REQUEST_ACTION_ID);
			// sNX̑I
			className =
				XmsBusinessXMLPerser.getBusinessActionName( actionId );
			if ( className != null ) {
				actionClass = Class.forName(className);
				action = (XmsBusinessAction) actionClass.newInstance();
			} else {
				action = null;
			}
		} catch (XmsException e) {
			throw e;
		} catch (Exception e) {
			throw new XmsSystemException(e);
		}
		DebugLog.write(this.getClass(), action, DebugLog.MID);
		return action;
	}
	
	/**
	* [U[NGXgANVs錠邩肷B<br>
	*
	* @param xmsRequest NGXgEIuWFNgB
	* @throws XmsSystemException ȂꍇA͏ɗOꍇB
	*/
	private void checkPermission(XmsRequest xmsRequest)
		throws XmsException {
		
		boolean permission = isPermittedUser(xmsRequest);
		if ( permission == false ) {
			throw new XmsSystemException( "No Authority to perform Action." );
		}
		
		try {
			// ANVhc擾B
			String actionId = xmsRequest.getParameter(Constant.REQUEST_ACTION_ID);
			XmsPermissionCheck check = null;
			// sNX̑I
			String className =
				XmsBusinessXMLPerser.getPermissionCheckName( actionId );
			if ( className != null ) {
				Class checkClass = Class.forName(className);
				check = (XmsPermissionCheck) checkClass.newInstance();
			} else {
				check = null;
			}
			
			if (check != null) {
				boolean result = check.execute(xmsRequest);
				if (result == false) {
					throw new XmsSystemException( "Not permitted to perform this action." );
				}
			}
		} catch (XmsException e) {
			throw e;
		} catch (Exception e) {
			throw new XmsSystemException(e);
		}
	}

	/**
	 * NGXg[UɎw肵ANVs錠邩肷B<br>
	 * 
	 * @param xmsRequest NGXgEIuWFNgB
	 * @return [UɌtrueAȂꍇfalse߂B
	 * @throws XmsException ɗOꍇB
	 */
	private boolean isPermittedUser(XmsRequest xmsRequest)
		throws XmsException {

		// ̃\bh̖߂l		
		boolean isPermitted = true;
		// ANVhc
		String actionId = null;
		// Xg
		List permittedList = null;
		
		// 샆[Ǔ
		Set xmoIdsOfCurrentUser = null;

		try {
			// ANVhc擾B
			actionId = xmsRequest.getParameter(Constant.REQUEST_ACTION_ID);
			permittedList = XmsBusinessXMLPerser.getPermittedList( actionId );
			
			if ( permittedList == null || permittedList.size() == 0 ) {
				// w̏ꍇA
				isPermitted = true;
			} else {
				// w肪ꍇA[Ǔ擾A
				// Pł܂܂Ă邩肷B
				xmoIdsOfCurrentUser = this.getXmoIdsOfCurrentUser(xmsRequest);
				// [Ǔ̏WAݒ肵Ă錠̃Xg
				// ʂƂȂvf݂̂cZ{A
				// ZPvfł΁AƂB
				xmoIdsOfCurrentUser.retainAll(permittedList);
				isPermitted = (xmoIdsOfCurrentUser.size() > 0);
			}
		} catch ( XmsException e ) {
			throw e;	
		} catch (Exception e) {
			throw new XmsSystemException(e);
		}
		return isPermitted;
	}

	/**
	 * ݂̃[UێĂi蓖ĂĂjwln̂hc̏W߂B<br>
	 * ZbVo^郆[UIuWFNg擾A
	 * ̃IuWFNgwln̂hc擾A擾hcvfƂSet߂B
	 * ZbV擾łȂꍇAwln肠ĂȂꍇA
	 * vfSet߂B
	 * @param xmsRequest NGXgEIuWFNgB
	 * @return wln̂hc̏W
	 * @throws XmsException ɗOꍇ
	 * @see User
	 */
	private Set getXmoIdsOfCurrentUser(XmsRequest xmsRequest)
		throws XmsException {
		// ̃\bh̖߂l
		Set xmoIds = null;
		// HTTPNGXg
		HttpServletRequest request = null;
		// HTTPZbV
		HttpSession session = null;
		// [UIuWFNg
		User user = null;
		
		try {
			xmoIds = new HashSet();
			// ZbV̎擾
			request = xmsRequest.getRequest();
			session = request.getSession(false);
			if ( session != null ) {
				// [UIuWFNg擾
				user = (User)session.getAttribute(Constant.KEY_USER);
				// 擾łꍇ̓IuWFNghc擾
				if (user != null ) {
					xmoIds.addAll( user.getXMOIds() );
				}
			}
		} catch ( XmsException e ) {
			throw e;	
		} catch (Exception e) {
			throw new XmsSystemException(e);
		}
		return xmoIds;
	}
}
