/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/
package jp.co.ntt.lms.installer.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Properties;
import java.util.logging.Logger;

/**
 * t@CɊ֘A郆[eBeBENXB
 * @author T.Nishiki
 */
public class FileUtil {
	/**
	 * Oo̓IuWFNgB
	 */
	private static Logger _logger;

	/**
	 * X^eBbNECjVCUB<br>
	 * Oo̓IuWFNg擾܂B
	 */
	static {
		_logger = LoggerUtil.getLogger(FileUtil.class);
	}

	/**
	 * t@CRs[܂B<br>
	 * @param fromFile Rs[̃t@CB
	 * @param toFile Rs[t@CB
	 * @throws IOException Rs[ɎsꍇB
	 */
	public static void copyFile(File fromFile, File toFile)
			throws IOException {
		// \bhJn^O
		String logMessge = null;
		if (LoggerUtil.isLoggableMethod(_logger)) {
			logMessge = "copyFile("
				+ "File<" + fromFile.getAbsolutePath() + ">"
				+ ", File<" + toFile.getAbsolutePath() + ">)";
			LoggerUtil.methodHead(_logger, logMessge);
		}

		// ȉRs[
		BufferedInputStream inputStream = null;
		BufferedOutputStream outputStream = null;
		boolean successFlag = false;
		try {
			File toDir = toFile.getParentFile();
			if (toDir.exists() == false) {
				toDir.mkdirs();
			}
			// o͐tH_쐬
			toFile.getParentFile().mkdirs();
			// Xg[I[v
			inputStream = new BufferedInputStream(
				new FileInputStream(fromFile));
			outputStream = new BufferedOutputStream(
				new FileOutputStream(toFile));
			// Rs[
			byte[] buffer = new byte[1024 * 10];
			while (true) {
				int length = inputStream.read(buffer);
				if (length <= 0) {
					break;
				}
				outputStream.write(buffer, 0, length);
			}
			successFlag = true;
		}
		catch (IOException e) {
			LoggerUtil.throwable(_logger, e);
			throw e;
		}
		finally {
			IOException e = null;
			// ̓Xg[̃N[Y
			try {
				close(inputStream, successFlag);
			}
			// OĂX[͌ɂB
			catch (IOException ie) {
				e = ie;
			}
			// o̓Xg[̃N[Y
			close(outputStream, successFlag);
			// ̓Xg[ŗOĂ΃X[B
			if (e != null) {
				throw e;
			}
		}
		// \bhI^O
		if (LoggerUtil.isLoggableMethod(_logger)) {
			LoggerUtil.methodTail(_logger, logMessge);
		}
	}

	/**
	 * w肳ꂽt@C܂̓fBNg폜܂B<br>
	 * fBNg̏ꍇAɎqt@C^fBNg폜܂B
	 * @param file 폜Ώۂ̃fBNgB
	 * @throws IOException 폜ɎsꍇB
	 */
	public static void delete(File file) throws IOException {
		// \bhJn^O
		LoggerUtil.methodHead(_logger, "delete(" + file + ")");

		// fBNg̏ꍇAɎq폜܂B
		if (file.isDirectory()) {
			File[] children = file.listFiles();
			for (int i = 0; i < children.length; i++) {
				delete(children[i]);
			}
		}
		boolean result = file.delete();
		if (result == false) {
			throw new IOException(
				"Cannot delete File[" + file + "]");
		}
		// \bhI^O
		LoggerUtil.methodTail(_logger, "delete(" + file + ")");
	}

	/**
	 * ̓Xg[܂B<br>
	 * w肳ꂽ̓Xg[̃N[Y݂܂B
	 * ̍ہAOX[ꂽꍇA̎wɂA
	 * ̃\bhOX[邩ۂf܂B<br>
	 * @param stream N[Y݂̓Xg[B
	 * @param throwFlag N[YŗOꍇÃ\bhO
	 *         X[ꍇtrueAX[Ȃꍇfalsew肵܂B
	 * @throws IOException N[YɗOAA
	 *          throwFlagtruȅꍇB
	 */
	public static void close(InputStream stream, boolean throwFlag)
		throws IOException {

		if (stream != null) {
			try {
				stream.close();
			}
			// OꍇA̎wɏ]AX[邩f܂B
			catch (IOException e) {
				LoggerUtil.throwable(_logger, e);
				if (throwFlag) {
					throw e;
				}
			}
		}
	}

	/**
	 * o̓Xg[܂B<br>
	 * w肳ꂽo̓Xg[̃N[Y݂܂B
	 * ̍ہAOX[ꂽꍇA̎wɂA
	 * ̃\bhOX[邩ۂf܂B<br>
	 * @param stream N[Y݂o̓Xg[B
	 * @param throwFlag N[YŗOꍇÃ\bhO
	 *         X[ꍇtrueAX[Ȃꍇfalsew肵܂B
	 * @throws IOException N[YɗOAA
	 *          throwFlagtruȅꍇB
	 */
	public static void close(OutputStream stream, boolean throwFlag)
		throws IOException {

		if (stream != null) {
			try {
				stream.close();
			}
			// OꍇA̎wɏ]AX[邩f܂B
			catch (IOException e) {
				LoggerUtil.throwable(_logger, e);
				if (throwFlag) {
					throw e;
				}
			}
		}
	}

	/**
	 * ̓Xg[܂B<br>
	 * w肳ꂽ̓Xg[̃N[Y݂܂B
	 * ̍ہAOX[ꂽꍇA̎wɂA
	 * ̃\bhOX[邩ۂf܂B<br>
	 * @param reader N[Y݂镶̓Xg[B
	 * @param throwFlag N[YŗOꍇÃ\bhO
	 *         X[ꍇtrueAX[Ȃꍇfalsew肵܂B
	 * @throws IOException N[YɗOAA
	 *          throwFlagtruȅꍇB
	 */
	public static void close(Reader reader, boolean throwFlag)
		throws IOException {

		if (reader != null) {
			try {
				reader.close();
			}
			// OꍇA̎wɏ]AX[邩f܂B
			catch (IOException e) {
				LoggerUtil.throwable(_logger, e);
				if (throwFlag) {
					throw e;
				}
			}
		}
	}

	/**
	 * o̓Xg[܂B<br>
	 * w肳ꂽo̓Xg[̃N[Y݂܂B
	 * ̍ہAOX[ꂽꍇA̎wɂA
	 * ̃\bhOX[邩ۂf܂B<br>
	 * @param writer N[Y݂镶o̓Xg[B
	 * @param throwFlag N[YŗOꍇÃ\bhO
	 *         X[ꍇtrueAX[Ȃꍇfalsew肵܂B
	 * @throws IOException N[YɗOAA
	 *          throwFlagtruȅꍇB
	 */
	public static void close(Writer writer, boolean throwFlag)
		throws IOException {

		if (writer != null) {
			try {
				writer.close();
			}
			// OꍇA̎wɏ]AX[邩f܂B
			catch (IOException e) {
				LoggerUtil.throwable(_logger, e);
				if (throwFlag) {
					throw e;
				}
			}
		}
	}

	/**
	 * w肵t@CvpeBƂēǂݍ݂܂B
	 * @param file vpeBƂēǂݍރt@CB
	 * @param throwFileNotFound fileŎw肵t@CǂݍƂāA
	 *         FileNotFoundExceptionX[ꂽƂA
	 *         OX[ꍇtrueA
	 *         X[Properties߂ꍇfalsen܂B
	 * @return file琶ꂽvpeBB
	 *          t@C݂AAthrowFileNotFoundfalsȅꍇA
	 *          ̃vpeB߂܂B
	 * @throws IOException ǍɎsꍇB
	 */
	public static Properties loadAsProperties(
			File file, boolean throwFileNotFound)
			throws IOException {
		// \bhJn^O
		LoggerUtil.methodHead(_logger,
			"loadAsProperties(" + file + "," + throwFileNotFound + ")");
		// ̃\bh̖߂l
		Properties properties = null;
		// t@C̓ǂݍݗp
		InputStream stream = null;
		// tO
		boolean successFlag = false;
		try {
			properties = new Properties();
			// t@C̓Xg[擾
			try {
				stream = new BufferedInputStream(new FileInputStream(file));
				// vpeBƂă[h
				properties.load(stream);
			}
			catch (FileNotFoundException e) {
				// t@CȂƂA̎wɂX[𔻒f
				if (throwFileNotFound) {
					throw e;
				}
			}
			// tryubNI[܂ŒB΁AB
			successFlag = true;
		}
		finally {
			close(stream, successFlag);
		}
		// \bhI^O
		LoggerUtil.methodTail(_logger,
			"loadAsProperties(" + file + "," + throwFileNotFound + ")",
			properties);
		return properties;
	}

	/**
	 * w肵t@CvpeBƂēǂݍ݂܂B
	 * @param file vpeBƂēǂݍރt@CB
	 * @return file琶ꂽvpeB߂܂B
	 *          t@C݂Ȃꍇ́ÃvpeB߂܂B
	 * @throws IOException ǍɎsꍇB
	 */
	public static Properties loadAsProperties(File file)
			throws IOException {
		// \bhJn^O
		LoggerUtil.methodHead(_logger, "loadAsProperties(" + file + ")");
		// ̃\bh̖߂l
		Properties properties = null;
			properties = FileUtil.loadAsProperties(file, false);
		// \bhI^O
		LoggerUtil.methodTail(_logger, "loadAsProperties(" + file + ")");
		return properties;
	}
}
