/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ntt.lms.installer.lms;

import java.io.File;
import java.util.Properties;
import java.util.logging.Logger;
import jp.co.ntt.lms.installer.core.InstallerAction;
import jp.co.ntt.lms.installer.core.InstallerActionValue;
import jp.co.ntt.lms.installer.core.InstallerException;
import jp.co.ntt.lms.installer.core.InstallerValues;
import jp.co.ntt.lms.installer.core.util.InstallerCheckUtil;
import jp.co.ntt.lms.installer.core.util.InstallerPropertiesUtil;
import jp.co.ntt.lms.installer.core.util.InstallerUiUtil;
import jp.co.ntt.lms.installer.lms.ScormInputValue;
import jp.co.ntt.lms.installer.util.FileUtil;
import jp.co.ntt.lms.installer.util.LoggerUtil;
import jp.co.ntt.lms.installer.util.StringUtil;

public class ScormInputAction
implements InstallerAction {
    private static Logger _logger = LoggerUtil.getLogger(class$jp$co$ntt$lms$installer$lms$ScormInputAction == null ? (class$jp$co$ntt$lms$installer$lms$ScormInputAction = ScormInputAction.class$("jp.co.ntt.lms.installer.lms.ScormInputAction")) : class$jp$co$ntt$lms$installer$lms$ScormInputAction);
    static /* synthetic */ Class class$jp$co$ntt$lms$installer$lms$ScormInputAction;

    public boolean isSkipped(InstallerValues installerValues) throws InstallerException {
        LoggerUtil.methodHead(_logger, "isSkipped(InstallerValues)");
        boolean bl = false;
        try {
            bl = !installerValues.getOptionLOSelected("scorm");
        }
        catch (Exception exception) {
            LoggerUtil.throwable(_logger, exception);
            throw new InstallerException(exception);
        }
        LoggerUtil.methodTail(_logger, "isSkipped(InstallerValues)", bl);
        return bl;
    }

    public InstallerActionValue action(InstallerValues installerValues) throws InstallerException {
        LoggerUtil.methodHead(_logger, "action(InstallerValues)");
        ScormInputValue scormInputValue = null;
        try {
            ScormInputValue scormInputValue2 = this.getDefaultValue(installerValues);
            InstallerUiUtil.outputMessageAsTitle(installerValues, "ScormInputAction.welcome");
            while (!this.confirmInputValue(installerValues, scormInputValue = this.readInputValue(installerValues, scormInputValue2))) {
            }
            File file = new File(scormInputValue.getMaterialInstallPath());
            installerValues.addMadeDirectory(file);
        }
        catch (InstallerException installerException) {
            throw installerException;
        }
        catch (Exception exception) {
            LoggerUtil.throwable(_logger, exception);
            throw new InstallerException(exception);
        }
        LoggerUtil.methodTail(_logger, "action(InstallerValues)", scormInputValue);
        return scormInputValue;
    }

    private ScormInputValue readInputValue(InstallerValues installerValues, ScormInputValue scormInputValue) throws InstallerException {
        LoggerUtil.methodHead(_logger, "readInputValue(InstallerValues)");
        ScormInputValue scormInputValue2 = null;
        try {
            scormInputValue2 = new ScormInputValue();
            String[] stringArray = scormInputValue.getServerNames();
            boolean bl = false;
            String string = null;
            string = stringArray[0];
            String string2 = null;
            while (InstallerCheckUtil.isEmptyViolation(string2 = InstallerUiUtil.askUserInput(installerValues, "ScormInputAction.prompt.serverName", string), installerValues, "ScormInputAction.error.serverName.empty")) {
            }
            scormInputValue2.addServerName(string2);
            String string3 = scormInputValue.getServerPort();
            String string4 = InstallerUiUtil.askUserInput(installerValues, "ScormInputAction.prompt.serverPort", string3);
            scormInputValue2.setServerPort(string4);
            String string5 = scormInputValue.getApplicationBaseURI();
            String string6 = null;
            while (InstallerCheckUtil.isEmptyViolation(string6 = InstallerUiUtil.askUserInput(installerValues, "ScormInputAction.prompt.applicationBaseURI", string5), installerValues, "ScormInputAction.error.applicationBaseURI.empty")) {
            }
            scormInputValue2.setApplicationBaseURI(string6);
            String string7 = null;
            while (InstallerCheckUtil.isEmptyViolation(string7 = InstallerUiUtil.askUserInput(installerValues, "ScormInputAction.prompt.materialInstallPath", scormInputValue.getMaterialInstallPath()), installerValues, "ScormInputAction.error.materialInstallPath.empty") || InstallerCheckUtil.isFilePath(string7, installerValues, "ScormInputAction.error.materialInstallPath.file")) {
            }
            scormInputValue2.setMaterialInstallPath(string7);
        }
        catch (InstallerException installerException) {
            throw installerException;
        }
        catch (Exception exception) {
            LoggerUtil.throwable(_logger, exception);
            throw new InstallerException(exception);
        }
        LoggerUtil.methodTail(_logger, "readInputValue(InstallerValues)", scormInputValue2);
        return scormInputValue2;
    }

    private boolean confirmInputValue(InstallerValues installerValues, ScormInputValue scormInputValue) throws InstallerException {
        LoggerUtil.methodHead(_logger, "confirmInputValue(InstallerValues, ScormInputValue)");
        boolean bl = false;
        try {
            InstallerUiUtil.outputConfirmTitle(installerValues, "ScormInputAction.confirm.title");
            String[] stringArray = scormInputValue.getServerNames();
            for (int i = 0; i < stringArray.length; ++i) {
                Object[] objectArray = new Object[]{new Integer(i + 1)};
                InstallerUiUtil.outputConfirm(installerValues, "ScormInputAction.confirm.serverName", objectArray, stringArray[i]);
            }
            InstallerUiUtil.outputConfirm(installerValues, "ScormInputAction.confirm.serverPort", scormInputValue.getServerPort());
            InstallerUiUtil.outputConfirm(installerValues, "ScormInputAction.confirm.applicationBaseURI", scormInputValue.getApplicationBaseURI());
            InstallerUiUtil.outputConfirm(installerValues, "ScormInputAction.confirm.materialInstallPath", scormInputValue.getMaterialInstallPath());
            bl = InstallerUiUtil.askUserConfirm(installerValues, "ScormInputAction.confirm");
        }
        catch (Exception exception) {
            LoggerUtil.throwable(_logger, exception);
            throw new InstallerException(exception);
        }
        LoggerUtil.methodTail(_logger, "confirmInputValue(InstallerValues, ScormInputValue)", bl);
        return bl;
    }

    private ScormInputValue getDefaultValue(InstallerValues installerValues) throws InstallerException {
        LoggerUtil.methodHead(_logger, "getDefaultValue(InstallerValues)");
        ScormInputValue scormInputValue = null;
        try {
            String string;
            String string2;
            scormInputValue = new ScormInputValue();
            File file = installerValues.getFileOnSystem(scormInputValue.getTargetFileKey());
            Properties properties = FileUtil.loadAsProperties(file);
            Properties properties2 = InstallerPropertiesUtil.load(installerValues, scormInputValue.getTargetFileKey());
            int n = 0;
            while (!StringUtil.isEmpty(string2 = properties.getProperty("scorm_name_" + (n + 1)))) {
                string = InstallerPropertiesUtil.determineInitialValue(properties, properties2, "scorm_name_" + (n + 1));
                scormInputValue.addServerName(string);
                ++n;
            }
            String string3 = InstallerPropertiesUtil.determineInitialValue(properties, properties2, "start_scorm_lo_server_url");
            string2 = "";
            string = "";
            if (!StringUtil.isEmpty(string3)) {
                try {
                    int n2;
                    int n3;
                    int n4 = string3.indexOf("http://$SERVERNAME$");
                    if (n4 >= 0) {
                        string3 = string3.substring(n4 + "http://$SERVERNAME$".length());
                    }
                    if ((n3 = string3.indexOf("FrameworkServlet?action_id=scorm.start&COMD=$COMD$&USERID=$USERID$&LOID=$LOID$&ManifestID=$MANIFESTID$&ForeignLOID=$FOREIGNLOID$&StudentName=$STUDENTNAME$&AuthKey=$AUTHKEY$&StudyInfoURL=$STUDYINFO_URL$&StudySession=$STUDYSESSION$&LoginSession=$LOGINSESSION$&EndURL=$END_URL$&study_start_date=$START_DATETIME$")) >= 0) {
                        string3 = string3.substring(0, n3);
                    }
                    if ((n2 = string3.indexOf("/")) == 0) {
                        string = string3;
                        string2 = "80";
                    } else {
                        string = string3.substring(n2);
                        string2 = string3.substring(1, n2);
                    }
                }
                catch (Exception exception) {
                    string2 = "";
                    string = "";
                }
            }
            scormInputValue.setServerPort(string2);
            scormInputValue.setApplicationBaseURI(string);
            String string4 = InstallerPropertiesUtil.determineInitialValue(properties, properties2, "material_temp");
            scormInputValue.setMaterialInstallPath(string4);
        }
        catch (InstallerException installerException) {
            throw installerException;
        }
        catch (Exception exception) {
            LoggerUtil.throwable(_logger, exception);
            throw new InstallerException(exception);
        }
        LoggerUtil.methodTail(_logger, "getDefaultValue(InstallerValues)", scormInputValue);
        return scormInputValue;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

