/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

//
//	LoServerNX
//			ύX
//				2004.01.08	VK쐬	ܖؓc ׎j
//

package jp.co.ntt.lms.lo;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;

import org.apache.commons.lang.StringEscapeUtils;

import jp.co.ntt.lms.Common.status.PropagateControl;
import jp.co.ntt.lms.Common.status.StatusPropagation;
import jp.co.ntt.lms.Common.status.prerequisite.Prerequisite;
import jp.co.ntt.lms.Common.status.prerequisite.PrerequisiteException;
import jp.co.ntt.lms.Common.status.prerequisite.PrerequisiteParseException;
import jp.co.ntt.lms.lo.util.LoLogSQLMaker;
import jp.co.ntt.lms.xmo.DataAccess;
import jp.co.ntt.lms.xmo.Environment;
import jp.co.ntt.lms.xmo.MessageData;
import jp.co.ntt.lms.xmo.XMOPropertyDef;
import jp.co.ntt.lms.xmo.Assignments.AssignUsableList;
import jp.co.ntt.lms.xmo.Assignments.AssignmentsClient;
import jp.co.ntt.lms.xmo.Assignments.AssignmentsTable;
import jp.co.ntt.lms.xmo.Base.XMSBaseClient;
import jp.co.ntt.lms.xmo.GroupAndPeople.GroupAndPeopleClient;
import jp.co.ntt.lms.xmo.GroupAndPeople.GroupAndPeopleTable;
import jp.co.ntt.lms.xmo.Lo.LoClient;
import jp.co.ntt.lms.xmo.LoRelation.LoRelationClient;
import jp.co.ntt.lms.xmo.RoleAssignments.RoleAssignmentsClient;
import jp.co.ntt.lms.xmo.util.ChangeEncode;
import jp.co.ntt.lms.xmo.util.DebugLog;

/**
 * LoServerNX
 *
 * <PRE>
 *   Lo̊{@\ʉNXB
 *   Lo̊{@\C^tF[XNXLB
 *   ʂLoTopNXAʂ͊eLoNXB
 *   iIȋNԂmۂ邽java.rmi.server.UnicastRemoteObjectNX
 *   p܂B
 * </PRE>
 *
 */
public class LoServer extends UnicastRemoteObject
		implements LoTop, LoPropertyDef, LoMessage
{
	////////////////////////////////////////////////////////////////////////////
	// ϐ
	////////////////////////////////////////////////////////////////////////////
	protected MenuMaker    mobjMenuMakerIF;
	protected LearnManager mobjLearnManagerIF;
	protected Setup        mobjSetupIF;

	private static final String ERR_URL = "/view/lo/Com/Err.vm";

	////////////////////////////////////////////////////////////////////////////
	// Oϐ
	////////////////////////////////////////////////////////////////////////////

	////////////////////////////////////////////////////////////////////////////
	// O֐
	////////////////////////////////////////////////////////////////////////////
	/**
	 * RXgN^
	 *
	 */
	public LoServer() throws RemoteException
	{
		super();
	}

	/**
	 * j[擾
	 *
	 * @param Hashtable p[^Xg
	 * @return Vector bZ[Wf[^ƃj[f[^
	 */
	public Vector getMenuList(Hashtable htbParam)
	{
		Vector vecRet     = new Vector();
		Object objRet     = null;
		MessageData objMd = null;
		try
		{
			if(mobjMenuMakerIF != null)
			{
				String strIsStartOnly = "";
				if (htbParam.containsKey("START_ONLY"))
				{
					strIsStartOnly = (String)htbParam.get( "START_ONLY" );
				}
				
				if (strIsStartOnly.equals("on"))
				{
					htbParam.put( LEARNER_ASSIGN, "on" );
					htbParam.put( LEARN_AUTH, "on" );
					htbParam.put( PRERE_FLG, "on" );
				}
				else
				{
					// ǗATCAwKATC擾܂
					checkAssign( htbParam );
					// wKAOQƌ擾܂
					checkAuth( htbParam );
					// wK\s܂B
					checkPossibleLearn( htbParam );
				}
				// ̏ꍇAbZ[Wf[^NULLƂ
				objRet = mobjMenuMakerIF.makeMenu(htbParam);
				vecRet.add(objRet);
			}
		}
		catch(LOException le)
		{
			DebugLog.write( this.getClass(), le, DebugLog.HIGHT );
			// G[bZ[WIuWFNg𐶐
			objMd = createSystemErrMessage(le.getMessage());
		}
		vecRet.add(0, objMd);
		return vecRet;
	}

	/**
	 * ZbgAbv
	 *
	 * @param Hashtable p[^Xg
	 * @return Vector bZ[Wf[^NULL
	 */
	public Vector setUp(Hashtable htbParam)
	{
		Vector vecRet     = new Vector();
		Object objRet     = null;
		MessageData objMd = null;
		try
		{
			if(mobjSetupIF != null)
			{
				// ̏ꍇAbZ[Wf[^NULLƂ
				mobjSetupIF.setUp(htbParam);
			}
		}
		catch(LOException le)
		{
			objMd = le.getMessageData();	
			if(objMd == null)				
			{
				// G[bZ[WIuWFNg𐶐
				objMd = createSystemErrMessage(le.getMessage());
			}
		}
		vecRet.add(0, objMd);
		return vecRet;
	}

	/**
	 * wKJn
	 *
	 * @param Hashtable p[^Xg
	 * @return Vector bZ[Wf[^ƊwKJnURL
	 */
	public Vector startLearn(Hashtable htbParam)
	{
		Vector vecRet     = new Vector();
		Object objRet     = null;
		MessageData objMd = null;
		DataAccess objDataAccess = new DataAccess();
		try
		{
			// gUNV̊Jn
			objDataAccess.trans();
			
			// ̏ꍇAbZ[Wf[^NULLƂ
			if( mobjLearnManagerIF != null )
			{
				objRet = mobjLearnManagerIF.startLearn(htbParam, objDataAccess);
				vecRet.add(objRet);
			}
			
			// OX[Ȃꍇ̓R~bg
			objDataAccess.commit();
		}
		catch(LOException le)
		{
			// O̓[obN
			try { objDataAccess.rollback(); } catch(Exception e) {}
			// G[bZ[WIuWFNg𐶐
			objMd = createSystemErrMessage(le.getMessage());
		}
		catch(SQLException se)
		{
			// O̓[obN
			try { objDataAccess.rollback(); } catch(Exception e) {}
			// G[bZ[WIuWFNg𐶐
			objMd = createSystemErrMessage(se.getMessage());
		}

		//Xe[^X`dǉ
		//(Lꍇ̂)
		if (objMd == null)
		{
			// [UID̎擾
			String strUserID = (String)htbParam.get( USER );
			// LOID̎擾
			String strLoID = (String)htbParam.get( LOID );
			try
			{
				propagateStatus(strUserID, strLoID);
			}
			catch (LOException e)
			{
				// G[bZ[WIuWFNg𐶐
				objMd = createSystemErrMessage(e.getMessage());
			}
		}
		
		vecRet.add(0, objMd);
		return vecRet;
	}

	/**
	 * wKI
	 *
	 * @param Hashtable p[^Xg
	 * @return Vector bZ[Wf[^ƊwKIf[^
	 */
	public Vector endLearn(Hashtable htbParam)
	{

		Vector vecRet     = new Vector();
		Object objRet     = null;
		MessageData objMd = null;
		DataAccess objDataAccess = new DataAccess();
		try
		{
			// gUNV̊Jn
			objDataAccess.trans();
			
			if(mobjLearnManagerIF != null)
			{
				// ̏ꍇAbZ[Wf[^NULLƂ
				objRet = mobjLearnManagerIF.endLearn(htbParam, objDataAccess);
				vecRet.add(objRet);
			}
			
			// OX[Ȃꍇ̓R~bg
			objDataAccess.commit();
		}
		catch(LOException le)
		{
			// O̓[obN
			try { objDataAccess.rollback(); } catch(Exception e) {}
			// G[bZ[WIuWFNg𐶐
			objMd = le.getMessageData();
			if(objMd == null){
				objMd = createSystemErrMessage(le.getMessage());
			}
		}
		catch(SQLException se)
		{
			// O̓[obN
			try { objDataAccess.rollback(); } catch(Exception e) {}
			// G[bZ[WIuWFNg𐶐
			objMd = createSystemErrMessage(se.getMessage());
		}

		//Xe[^X`dǉ
		//(Lꍇ̂)
		if (objMd == null)
		{
			// [UID̎擾
			String strUserID = (String)htbParam.get( USER );
			// LOID̎擾
			String strLoID = (String)htbParam.get( LOID );
			try
			{
			    if (strUserID != null && strLoID != null)
			    {
					propagateStatus(strUserID, strLoID);
			    }
			}
			catch (LOException e)
			{
				// G[bZ[WIuWFNg𐶐
				objMd = createSystemErrMessage(e.getMessage());
			}
		}

		vecRet.add(0, objMd);
		return vecRet;
	}

	/**
	 * O擾
	 *
	 * @param Hashtable p[^Xg
	 * @return Vector bZ[Wf[^ƃOR[hXg
	 */
	public Vector getLoLog(Hashtable htbParam)
	{
		Vector vecRet     = new Vector();
		MessageData objMd = null;
		DataAccess objDataAccess = new DataAccess();
		try
		{

			// gUNV̊Jn
			objDataAccess.trans();

			// NG[ID̎擾
			String strQueryID = (String)htbParam.get(QUERY_ID);
			if( strQueryID == null ) {
				throw new LOException( "NG[IDw肵ĂB" );
			}
			// NG[̎擾
			Vector vecQueryCondition = (Vector)htbParam.get(LOG_CONDITION);
			if( vecQueryCondition == null ) {
				// w肳ĂȂꍇAVector쐬܂B
				vecQueryCondition = new Vector();
			}

			LoLogEnvironment objEnv = LoLogEnvironment.getInstance();

			String strQuery = objEnv.getQueryString( strQueryID );

			// NG[ID LOG0101 ܂ LOG0201 ̏ꍇ͏ɂēISQL쐬܂
			if( strQueryID.equals( LOG0101 ) || strQueryID.equals( LOG0201 ) ) {
				LoLogSQLMaker objSqlMaker = new LoLogSQLMaker( strQueryID, strQuery, vecQueryCondition );
				strQuery = objSqlMaker.makeQuery();
			}
			PreparedStatement objStatement = objDataAccess.prepareStatement(strQuery);
			// ̐ݒ
			for( int i = 0; i < vecQueryCondition.size(); i++  ) {
				objStatement.setString( i+1, (String)vecQueryCondition.get(i) );
			}
			// NG[̎s
			ResultSet rs = objStatement.executeQuery();

			ResultSetMetaData meta = rs.getMetaData();
			int intColCount = meta.getColumnCount();

			Vector vecResult = new Vector();
			while( rs.next() ) {
				String[] strResult = new String[intColCount];
				for( int i = 0; i < intColCount; i++ ) {
					strResult[i] = ChangeEncode.setChar( rs.getString( i + 1 ) );
				}
				vecResult.add( strResult );
			}

			String[][] strResult = new String[vecResult.size()][intColCount];
			vecResult.copyInto( strResult );

			// R~bg
			objDataAccess.commit();

			// ʂi[
			vecRet.add( strResult );

		}
		catch(SQLException se)
		{
			DebugLog.write( this.getClass(), se, DebugLog.HIGHT );
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			// G[bZ[WIuWFNg𐶐
			objMd = createSystemErrMessage("f[^x[XG[܂B");
		}
		catch(LOException le)
		{
			DebugLog.write( this.getClass(), le, DebugLog.HIGHT );
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			// G[bZ[WIuWFNg𐶐
			objMd = createSystemErrMessage(le.getMessage());
		}
		catch(Exception e)
		{
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			objMd = createSystemErrMessage(e.getMessage());
		}
		vecRet.add(0, objMd);
		return vecRet;
	}

	/**
	 * Xe[^X`dR[h̎擾
	 *
	 * @param Hashtable p[^Xg
	 * @return Vector bZ[Wf[^PropagateRelationR[hXg
	 */
	public Vector getPropagateRelation(Hashtable htbParam)
	{
		Vector vecRet     = new Vector(2);
		MessageData objMd = null;
		DataAccess objDataAccess = new DataAccess();
		try
		{

			// gUNV̊Jn
			objDataAccess.trans();

			// RELATEDID̎擾
			String strRelatedID = (String)htbParam.get(RELATEDID);
			if( strRelatedID == null ) {
				throw new LOException( "LoIDw肵ĂB" );
			}

			PropagateRelationDataAccess objRelationDataAccess = new PropagateRelationDataAccess();
			// PROPAGATERELATIONe[uRelatedIDƂLOID擾
			String[] result = objRelationDataAccess.getRelatedID( strRelatedID, objDataAccess );
			if ( result == null || result.length == 0 ){
				PropagateRelationRecord[] objRecords = new PropagateRelationRecord[0];
				vecRet.add( objRecords );
			}
			else{
				PropagateRelationRecord[] objRecords = new PropagateRelationRecord[result.length];
				for( int i=0; i<result.length; i++){
					objRecords[i] = new PropagateRelationRecord( result[i], strRelatedID );
				}
				vecRet.add( objRecords );
			}
			// R~bg
			objDataAccess.commit();
			// ʂi[
		}
		catch(LOException le)
		{
			DebugLog.write( this.getClass(), le, DebugLog.HIGHT );
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			// G[bZ[WIuWFNg𐶐
			objMd = createSystemErrMessage(le.getMessage());
		}
		catch(SQLException se)
		{
			DebugLog.write( this.getClass(), se, DebugLog.HIGHT );
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			// G[bZ[WIuWFNg𐶐
			objMd = createSystemErrMessage(se.getMessage());
		}
		vecRet.add(0, objMd);
		return vecRet;
	}

	/**
	 * ލ\擾<BR>
	 * <PR>
	 *	ލ\擾郁\bh(hNXꍇ
	 *  hNX̃\bhI[o[Ch܂
	 * </PR>
	 * @param Hashtable p[^Xg
	 * @return Vector bZ[Wf[^Ƌލ\f[^
	 */
	public Vector getMaterialStruct(Hashtable htbParams)
	{
		Vector vecRet     = new Vector();
		Object objRet     = null;
		MessageData objMd = null;
		vecRet.add(objMd);
		vecRet.add(objRet);
		return vecRet;
	}

	private void propagateStatus(String userID, String loID) throws LOException
	{
		// QLOIDXg擾܂
		LoClient objLoClient = null;
		try
		{
			objLoClient = new LoClient();
			if(!objLoClient.getListFromRealLOID( loID ))
			{
				throw new LOException("QLOIDXg̎擾s܂B");
			}
		}
		catch (Exception e)
		{
			throw new LOException("QLOIDXg̎擾ɃG[܂B");
		}
		String[] strRefList = objLoClient.getRefListResult();
		// QƃXgXe[^X`d
		for(int i = 0; i < strRefList.length; i++)
		{
			// Xe[^X`
			StatusPropagation objStatus = new StatusPropagation( userID, strRefList[i] );
			PropagateControl.getInstance().addPropagate(objStatus);
		}
	}
	
	/**
	 * [UIDXg擾(ʃO擾Ɏgp)
	 *
	 * @param String [UIDO[vID
	 * @return String[] [UIDXg
	 */
	private String[] expandGroup(String strUserID)
		throws Exception
	{
		String[] strRet  = null;
		// Pڂ[UIDȂΑ߂
		if(strUserID.indexOf("GR") == -1)
		{
			strRet    = new String[1];
			strRet[0] = strUserID;
			return strRet;
		}
		// O[vȂ΍ċAďo
		Vector vecList = new Vector();
		getUserIDList(strUserID, vecList);

		// VectorString[]ɕϊ
		strRet = new String[vecList.size()];
		for(int i = 0; i < vecList.size(); i++)
		{
			strRet[i] = (String)vecList.get(i);
		}
		return strRet;
	}

	/**
	 * LoIDXg擾(ʃO擾Ɏgp)
	 *
	 * @param String LoID
	 * @return String[] LoIDXg
	 */
	private String[] expandLo(String strLoID)
		throws Exception
	{
		String[] strRet = null;
		Vector vecList = new Vector();
		getLoIDList(strLoID, vecList);
		strRet = new String[vecList.size()];
		for(int i = 0; i < vecList.size(); i++)
		{
			strRet[i] = (String)vecList.get(i);
		}
		return strRet;
	}

	/**
	 * [UIDXg擾ċA(ʃO擾Ɏgp)
	 *
	 * @param String [UID
	 * @param Vector [UIDXg
	 * @return void
	 */
	private void getUserIDList(String strUserID, Vector vecList)
		throws Exception
	{
		GroupAndPeopleClient objGapc = new GroupAndPeopleClient();
		objGapc.setWhereParentID(strUserID);
		if(!objGapc.select())
		{
			DebugLog.write(this.getClass(), "O[vEl擾s", DebugLog.ROW);
		}
		while(objGapc.next())
		{
			strUserID = objGapc.getChildID();
			if(objGapc.isGroup())
			{
				getUserIDList(strUserID, vecList);
			}
			else
			{
				vecList.add(strUserID);
			}
		}
	}

	/**
	 * LoIDXg擾ċA(ʃO擾Ɏgp)
	 *
	 * @param String LoID
	 * @param Vector LoIDXg
	 * @return void
	 */
	private void getLoIDList(String strLoID, Vector vecList)
		throws Exception
	{
		LoRelationClient objLrc = new LoRelationClient();
		objLrc.setWhereParentID(strLoID);
		if(!objLrc.select())
		{
			DebugLog.write(this.getClass(), "Lo֘A擾s", DebugLog.ROW);
		}
		while(objLrc.next())
		{
			String strLoChildID = objLrc.getChildID();
			getLoIDList(strLoChildID, vecList);
		}
		vecList.add(strLoID);
	}


	/**
	 * Lo^Cv݃`FbN\bh
	 *
	 * @param String LoType
	 * @return boolean LoType̗L
	 */
	protected boolean getLoType(String loType) 
		throws LOException {

		boolean isLoType = false;

		if (loType.length() == 0) {
			DebugLog.write(this.getClass(), "p[^G[", DebugLog.ROW);
			throw new LOException(SYSTEM_ERR);
		}
		String strCondition = " WHERE " + LO_TYPE + " = " + "'" + StringEscapeUtils.escapeSql(loType) + "' ";
		
		DataAccess objDataAccess = new DataAccess(LO_TYPE);

		try {

			objDataAccess.trans();
			StringBuffer sbSQL = new StringBuffer();
			sbSQL.append("SELECT " + LO_TYPE + " FROM " + LO_TYPE);
			sbSQL.append(strCondition);
			ResultSet rs = objDataAccess.executeQuery(sbSQL.toString());
			if (rs.next()) {
				isLoType = true;
			}

		} catch (SQLException se) {
			DebugLog.write(this.getClass(), "f[^x[XG[", DebugLog.ROW);
			throw new LOException(DB_ERR);
		}
		return isLoType;
	}

// 牺͊eLǒʏs

	/**
	 * ރXg擾
	 *
	 * @param Hashtable p[^Xg
	 * @return Vector bZ[Wf[^ƋރXg
	 */
	public Vector getMaterialList(Hashtable htbParam)
	{
		Vector vecRet     = new Vector();
		Object objRet     = null;
		MessageData objMd = null;
		vecRet.add(objMd);
		vecRet.add(objRet);
		return vecRet;
	}

	/**
	 * \bhXg擾
	 *
	 * @param Hashtable p[^Xg
	 * @return Vector bZ[Wf[^ƃ\bhXg
	 */
	public Vector getMethodList(Hashtable htbParam)
	{
		Vector vecRet     = new Vector();
		Object objRet     = null;
		MessageData objMd = null;
		vecRet.add(objMd);
		vecRet.add(objRet);
		return vecRet;
	}

	/**
	 * j[Xg擾
	 *
	 * @param Hashtable p[^Xg
	 * @return Vector bZ[Wf[^Əj[f[^
	 */
	public Vector getDefaultMenu(Hashtable htbParam)
	{
		Vector vecRet     = new Vector();
		Object objRet     = null;
		MessageData objMd = null;
		vecRet.add(objMd);
		vecRet.add(objRet);
		return vecRet;
	}

	/**
	 * ꃍO擾
	 *
	 * @param Hashtable p[^Xg
	 * @return Vector bZ[Wf[^ƃOR[hXg
	 */
	public Vector getIndividualLog(Hashtable htbParam)
	{
		Vector vecRet     = new Vector();
		Object objRet     = null;
		MessageData objMd = null;
		vecRet.add(objMd);
		vecRet.add(objRet);
		return vecRet;
	}

	/**
	 * ʃO폜
	 *
	 * @param Hashtable p[^Xg
	 * @return Vector bZ[Wf[^ƃOR[hXg
	 */
	public Vector deleteIndividualLog(Hashtable htbParam)
	{
		Vector vecRet     = new Vector();
		Object objRet     = null;
		MessageData objMd = null;
		vecRet.add(objMd);
		vecRet.add(objRet);
		return vecRet;
	}

	/**
	 * ʃOXV eLO(TuNX)Ŏ܂B
	 * 
	 * @param htbParam p[^Xg
	 * @return Vector bZ[Wf[^ƃOR[hXg
	 */
	public Vector changeTypeUpdateIndividualLog(Hashtable htbParam) {

		Vector vecRet     = new Vector();
		Object objRet     = null;
		MessageData objMd = null;
		vecRet.add(objMd);
		vecRet.add(objRet);
		return vecRet;
	}

	/**
	 * s
	 *
	 * @param String
	 * @param Hashtable p[^Xg
	 * @return Vector bZ[Wf[^Ǝsʃf[^
	 */
	public Vector execute(String strParam, Hashtable htbParam)
	{
		Vector vecRet     = new Vector();
		Object objRet     = null;
		MessageData objMd = null;
		vecRet.add(objMd);
		vecRet.add(objRet);
		return vecRet;
	}

	/**
	 * f[^擾
	 *
	 * @param String
	 * @param Hashtable p[^Xg
	 * @return Vector bZ[Wf[^Ǝsʃf[^
	 */
	public Vector getData(Hashtable htbParam)
	{
		Vector vecRet     = new Vector();
		Object objRet     = null;
		MessageData objMd = null;
		vecRet.add(objMd);
		vecRet.add(objRet);
		return vecRet;
	}

	/**
	 * VXeG[bZ[W𐶐
	 */
	protected MessageData createSystemErrMessage( String strMessage ) {

		if( strMessage == null ) {
			strMessage = "";
		}

		MessageData objMessage = new MessageData();
		// bZ[W̐ݒ
		objMessage.setMessage( strMessage );
		// G[^Cv̐ݒ
		objMessage.setMessageType( MessageData.ERR_TYPE );

		try {
			Environment objEnv = new Environment();
			String strSystemURL = objEnv.getSystemURL();
			// G[URL̍쐬
			String strURL = strSystemURL + ERR_URL + "?message=" + java.net.URLEncoder.encode( strMessage, "UTF-8");
			// G[URL̐ݒ
			objMessage.setURL( strURL );
		}
		catch( Exception e ) {
		}

		return objMessage;
	}

	/**
	 * LO̊ǗATCAwKATC󋵂𒲂ׂ܂B<BR>
	 * ǗATCAwKATCĂꍇ̓p[^œnHastableɈȉ̂悤ɏi[܂B
	 * <PRE>
	 *              KEY      | ǗATC | wKATC |
	 *       MANAGE_ASSIGN   |            |              |
	 *       LEARNER_ASSIGN  |              |            |
	 * </PRE>
	 * @param htbParam i[pHashtable
	 */
	private void checkAssign( Hashtable htbParam )
		throws LOException
	{
		try {
			// getMenuList̗vZbgAbvڂ̏ꍇ͏͍sȂ
			String strSetUp = (String)htbParam.get( SETUP_STATUS );
			if( strSetUp != null ) {
				return;
			}

			// [UID̎擾
			String strUserID = (String)htbParam.get( USER );
			// LOID̎擾
			String strLoID = (String)htbParam.get( LOID );

			if( strUserID == null || strLoID == null ) {
				// [UIDLOID̂ǂ炩ݒ肳ĂȂꍇ͏͍sȂ
				return;
			}

			if( strUserID.equals( XMOPropertyDef.ROOT_USER ) ) {
				// [g[Ȕꍇ͊ǗATCAwKATCݒ肷
				htbParam.put( MANAGE_ASSIGN, "on" );
				htbParam.put( LEARNER_ASSIGN, "on" );
				return;
			}

			// w肵LoID̃ATC󋵂ċAIɒׂ܂B
			checkAssignRef( htbParam, strLoID );

		}
		catch( LOException le ) {
			throw le;
		}
		catch( Exception e ) {
			throw new LOException( SYSTEM_ERR );
		}
	}

	/**
	 * ċAĂяop̃\bh<BR>
	 * [UIDLOID󂯎ATC擾܂B
	 * @param htbParam i[pHashtable
	 * @param strLoID ΏۂLOID
	 */
	private void checkAssignRef( Hashtable htbParam, String strLoID )
		throws LOException, Exception
	{
		// ǗATCAwKATCoB
		String strManageAssign = (String)htbParam.get( MANAGE_ASSIGN );
		String strLearnerAssign = (String)htbParam.get( LEARNER_ASSIGN );
		// łɊǗATCAwKATC񂪐ݒ肳Ăꍇ͏sȂ
		if( strManageAssign != null &&
			strLearnerAssign != null ) {
			return;
		}

		// [UID̎擾
		String strUserID = (String)htbParam.get( USER );

		// [UIDMemberShipID擾
		StringBuffer sbSubQuery = new StringBuffer();
		sbSubQuery.append( "(SELECT " );
		sbSubQuery.append( GroupAndPeopleTable.MEMBER_SHIP_ID );
		sbSubQuery.append( " FROM " );
		sbSubQuery.append( GroupAndPeopleTable.TABLE_NAME );
		sbSubQuery.append( " WHERE " );
		sbSubQuery.append( GroupAndPeopleTable.CHILD_ID );
		sbSubQuery.append( "='" + StringEscapeUtils.escapeSql(strUserID) +"') " );

		// LOIDqIDɐݒ肵āAeID擾
		LoRelationClient objLoRelation = new LoRelationClient();
		objLoRelation.setChildID( strLoID );
		// s
		if( !objLoRelation.select() ) {
			// Ɏsꍇ
			throw new LOException( objLoRelation.getMessage() );
		}

		// ʂ̎擾
		while( objLoRelation.next() ) {
			String strParentID = objLoRelation.getParentID();

			String strMaterialID = strParentID + strLoID;

			// Assignmentš
			AssignmentsClient objAss = new AssignmentsClient();
			// 쐬
			String strCondition = AssignmentsTable.MATERIAL_ID + "='" + StringEscapeUtils.escapeSql(strMaterialID) + "' AND " + AssignmentsTable.MEMBER_SHIP_ID + " in " + sbSubQuery.toString();
			// ݒ肷
			objAss.setCondition( strCondition );
			// s
			if( !objAss.select() ) {
				// Ɏsꍇ
				throw new LOException( objAss.getMessage() );
			}

			// ʂ̎擾
			while( objAss.next() ) {
				// ǗATC̎擾
				strManageAssign = objAss.getManagementAuthority();
				if( strManageAssign.equals( "1" ) ) {
					// nbVe[uɐݒ肷
					htbParam.put( MANAGE_ASSIGN, strManageAssign );
				}
				// wKATC̎擾
				strLearnerAssign = objAss.getLearnAuthority();
				if( strLearnerAssign.equals( "1" ) ) {
					// nbVe[uɐݒ肷
					htbParam.put( LEARNER_ASSIGN, strLearnerAssign );
				}
			}

			// eLOIDŏL̏ċAIɌJԂB
			checkAssignRef( htbParam, strParentID );
		}
	}

	/**
	 * wKƃOQƌ̗L𒲂ׂ܂
	 * <PRE>
	 *              KEY      | wK | OQƌ |
	 *       LEARN_AUTH      |        |              |
	 *       LOG_AUTH        |          |            |
	 * </PRE>
	 */
	private void checkAuth( Hashtable htbParam )
		throws LOException
	{
		try {
			// [UID̎擾
			String strUserID = (String)htbParam.get( USER );
			if( strUserID == null ) {
				return;
			}

// ̃`FbNŁAOWv̏ꍇ́A^[QbgƂȂ
// O[vE[UID(TARGET_ID) p[^擾C
// ̌łĂO[v肷B
// [Ȕꍇ́A̐eO[vw肷B		
			String strTargetID = (String)htbParam.get( TARGET_ID );
			String strRoleGroupID = null;
			if( strTargetID != null &&
				strTargetID.length() > 2 )
			{ 
				if( strTargetID.substring(0,2).equals( "PE" ) ) {
					strRoleGroupID = (String)htbParam.get( TARGET_PARENT_ID );						
				}
				else {
					strRoleGroupID = strTargetID;	
				}
			}		
// 擾\bhɍî݂߂̃O[vID̈ǉ
// null̏ꍇ̓[UɊĂ邷ׂĂXMOIDXg擾B
// ̈nullƂȂꍇ́AOQƈȊÕj[퓗̂΂B
			// [UɊĂXMOIDXg擾܂
			Vector vecXmoList = getAssignXmoList( strUserID, strRoleGroupID );
			XMSBaseClient objXmoBase = new XMSBaseClient();
			for( int i = 0; i < vecXmoList.size(); i++ ) {
				String strXmoID = (String)vecXmoList.get(i);
				objXmoBase.clear();
				// ̐ݒ
				objXmoBase.setWhereXmoID( strXmoID );
				// 
				if( !objXmoBase.select() ) {
					// s
					throw new LOException( objXmoBase.getMessage() );
				}

				if( objXmoBase.next() ) {
					String strClassName = objXmoBase.getClassName();
					// wK̏ꍇ
					if( strClassName.equals( XMOPropertyDef.LEARN_XMO ) ) {
						// wKHashtableɓ܂
						htbParam.put( LEARN_AUTH, "on" );
					}
					// OQƌ̏ꍇ
					else if( strClassName.equals( XMOPropertyDef.LOG_XMO ) ) {
						// OQƌHashtableɓ܂
						htbParam.put( LOG_AUTH, "on" );
					}
				}
			}
		}
		catch( LOException le ) {
			throw le;
		}
		catch( Exception e ) {
			throw new LOException( SYSTEM_ERR );
		}
	}

	/**
	 * [UɊ蓖ĂĂXMOID̃Xg擾܂B
	 * @param strUserID [UID
	 * @param strRoleGroupID wO[vɍsgł錠ɍi荞ޏꍇɎw肷B
	 *                        null ̏ꍇ́A[ÛׂĂ̌擾B
	 * @return Vector XmoID̃Xg
	 */
	private Vector getAssignXmoList( String strUserID, String strRoleGroupID )
		throws LOException, Exception
	{
// RoleAssignmentsXMOXMOXg擾R[悤ɕύX
// ͎̏w肵[UɊĂRoleɓWJC
// ̃XgԂBO[vIDw肷Ƃ̃O[v܂ޏʂ̃O[vɑ΂錠擾B
		// 烆[UɊ蓖ĂĂ錠擾
		RoleAssignmentsClient objRoleAss = new RoleAssignmentsClient();

		if( !objRoleAss.searchXmoList( strUserID, strRoleGroupID ) ) {
			throw new LOException( objRoleAss.getMessage() );
		}

		// ʊi[pxN^[
		Vector vecXmoList = new Vector();

		String[] strTemp = objRoleAss.getXmoList();

		for( int i = 0; i < strTemp.length; i++ ) {
			vecXmoList.add( strTemp[i] );	
		}
		return vecXmoList;
	}


	/**
	 * LÕRs[
	 *
	 * @param Hashtable p[^Xg
	 * @return Vector bZ[Wf[^
	 */
	public Vector doCopy(Hashtable htbParam)
	{
		Vector vecRet     = new Vector(2);
		MessageData objMd = null;

		vecRet.add(0, objMd);
		return vecRet;
	}



	/**
	 * LONXԋp܂
	 * @param strLoType LO^Cv
	 * @return LoServer LOCX^X
	 */
	private LoServer getLoInstance( String strLoType ) throws LOException {

		String	strClassName = "";
		Vector	vecLoList;

		if( strLoType == null ){
			throw new LOException( "LO^Cv݂܂B" );
		}
		try{
			Environment	objEnv = new Environment();
			vecLoList = objEnv.getLoClassName();
		}catch(Exception e){
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			throw new LOException( SYSTEM_ERR );
		}

		boolean bFound = false;
		for(int i=0; i<vecLoList.size(); i++ ){
			String[] LoInfo = (String[])vecLoList.get(i);
			if ( LoInfo[0].equals(strLoType) == true ){
				strClassName = LoInfo[1];
				bFound = true;
				break;
			}
		}
		if ( bFound != true ){
			throw new LOException( "LO^CvɊYLONX܂B" );
		}

		/* NXɊYNX𐶐 */
		Class classObject;
		try {
			classObject = Class.forName(strClassName);
		} catch(ClassNotFoundException ex) {
			DebugLog.write( this.getClass(), ex, DebugLog.HIGHT );
			throw new LOException( SYSTEM_ERR );
		}

		/* CX^X𐶐 */
		LoServer objLoServer = null;
		try {
			objLoServer = (LoServer)((Class)classObject).newInstance();
		} catch(IllegalAccessException e) {
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			throw new LOException( SYSTEM_ERR );
		} catch(InstantiationException e) {
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			throw new LOException( SYSTEM_ERR );
		} catch(ClassCastException e) {
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			throw new LOException( SYSTEM_ERR );
		}
		return objLoServer;
	}

	/**
	 * ލ\t@C擾<BR>
	 * <PR>
	 *	ލ\t@C̒g擾郁\bh(hNXꍇ
	 *  hNX̃\bhI[o[Ch܂
	 * </PR>
	 * @param Hashtable p[^Xg
	 * @return Vector bZ[Wf[^Ƌލ\t@C
	 */
	public Vector getMaterialStructFile(Hashtable htbParams)
	{
		Vector vecRet     = new Vector();
		Object objRet     = null;
		MessageData objMd = null;
		vecRet.add(objMd);
		vecRet.add(objRet);
		return vecRet;
	}

	/**
	 * ʃO(CSV)擾
	 *
	 * @param Hashtable p[^Xg
	 * @return Vector bZ[Wf[^ƃOR[hXg
	 */
	public Vector getIndividualLogCSV(Hashtable htbParam)
	{
		Vector vecRet     = new Vector();
		Object objRet     = null;
		MessageData objMd = null;
		vecRet.add(objMd);
		vecRet.add(objRet);
		return vecRet;
	}
	/**
	 * wK\ǂ̔s܂B<BR>
	 * ȉ̃p^[Hashtableɒlݒ肵܂B<BR>
	 * <PRE>
	 *     wKEs
	 *      1. Õ`FbN
	 *              Oݒ肳Ăꍇ̂݃`FbNB
	 *      2. ATC̗LE`FbN
	 *      3. L1, 2 ̌ʂ̘awKEsƂȂB
	 *
	 *                            key               value
	 *     wK\ȏꍇ       PRERE_FLG         "on"
	 *     wKs\ȏꍇ     PRERE_FLG         "off"
	 * </PRE>
	 * : key PRERE_FLG=Ô݂ӎɂȂĂ̂́A
	 * ATC̗L肪̊JŔ̂ł邽߁B<BR>
	 * ̃L[ύXƑSLOɏC邽߁AύXȂƂƂB
	 *
	 * @param htbParam i[pHashtable
	 */
	private void checkPossibleLearn( Hashtable htbParam )
		throws LOException
	{
		try {
			// [UID̎擾
			String strUserID = (String)htbParam.get( USER );
			// LOID̎擾
			String strLoID = (String)htbParam.get( LOID );
			// O̎擾
			String strPrere = (String)htbParam.get(PRERE);

			if( strUserID == null || strLoID == null ) {
				// [UIDLOID̂ǂ炩ݒ肳ĂȂꍇ͏͍sȂ
				return;
			}

			// --------------------------------------
			// O𖞂Ă邩A肵܂B
			// --------------------------------------
			boolean posibleLearn = true;
			if(strPrere != null && !strPrere.equals("")){
				// ONXCX^X
				Prerequisite objPrerequisite = new Prerequisite(	strPrere,
																	strUserID,
																	strLoID );
				// Op[X
				objPrerequisite.parse();
				posibleLearn = objPrerequisite.isPrerequisited();
			}
			
			// --------------------------------------
			// ATC̗LE𔻒肵܂B
			// X[p[Ȕꍇ͖ŗLƂB
			// OĂꍇ̂݃`FbN
			// --------------------------------------
			if( posibleLearn ) {
				if( !strUserID.equals( XMOPropertyDef.ROOT_USER ) ) {
					AssignmentsClient client = new AssignmentsClient();
					
					// AssignmentsXMÕATCLE`FbN֐R[
					// ڍׂAssignmentsClientQ
					Map res = client.checkAssignUsable( 
									strUserID, null, strLoID, 
									AssignmentsClient.SELF);
									
					AssignUsableList usable = (AssignUsableList)res.get(strLoID);
					
					if( usable == null ) {
						// w肵LOɑΉ񂪓Ȃꍇfalse
						posibleLearn = false;	
					}
					posibleLearn = usable.isUsable();
				}
			}
			
			// O𖞂Ăꍇ́AOtOonɂB
			if(posibleLearn){
				htbParam.put( PRERE_FLG, "on" );
			}
			// O𖞂ĂȂꍇ́AOtOoffɂB
			else{
				htbParam.put( PRERE_FLG, "off" );
			}

		}
		catch( PrerequisiteParseException pp ) {
			throw new LOException( pp.getMessage() );
		}
		catch( PrerequisiteException pe ) {
			throw new LOException( pe.getMessage() );
		}
		catch( Exception e ) {
			throw new LOException( SYSTEM_ERR );
		}
	}
}
