/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

//
// OfflineLO OXVNX
//			ύX
//				2004.01.08	VK쐬	񞊁@q
//
package jp.co.ntt.lms.lo.Offline;


// Java API
import java.util.*;
import java.text.*;
import java.net.URL;
import java.io.IOException;
import java.sql.SQLException;

// xml API
import org.xml.sax.SAXException;

// XMS API
import jp.co.ntt.lms.xmo.util.*;
import jp.co.ntt.lms.xmo.*;
import jp.co.ntt.lms.lo.*;
import jp.co.ntt.lms.lo.Offline.Aicc.*;
import jp.co.ntt.lms.Common.status.*;
import jp.co.ntt.lms.xmo.Lo.LoClient;

/**
 * OfflineOXVNX
 * {NX͒PƂThreadƂĎs܂B
 */
public class OfflineLoLogControl extends Thread
	implements OfflineLoPropertyDef
{

	/** [UIDێ܂ */
	private String mstrUserID = null;
	/** LOIDێ܂B */
	private String mstrLoID = null;
	/** IDق܂B */
	private String mstrMaterialID = null;
	/** Õt@CpXێ܂B */
	private String mstrLogPath = null;

	/** f[^ANZXNXێ܂B */
	private DataAccess mobjDataAccess = null;

	// AiccCoree[ũf[^ANZXNX
	AiccCoreDataAccess mobjAiccCoreDataAccess = new AiccCoreDataAccess();
	// SectionLoge[ũf[^ANZXNX
	SectionLogDataAccess mobjSectionLogDataAccess = new SectionLogDataAccess();
	// AiccInteractione[ũf[^ANZXNX
	AiccInteractionDataAccess mobjInteractionDataAccess = new AiccInteractionDataAccess();
	// AiccCommente[ũf[^ANZXNX
	AiccCommentDataAccess mobjCommentDataAccess = new AiccCommentDataAccess();
	// AiccObjectivese[ũf[^ANZXNX
	AiccObjectivesDataAccess mobjObjectivesDataAccess = new AiccObjectivesDataAccess();
	// LoLoge[ũf[^ANZXNX
	LoLogDataAccess mobjLoLogDataAccess = new LoLogDataAccess();
	// LologSessione[ũf[^ANZXNX
	LoLogSessionDataAccess mobjLoLogSessionDataAccess = new LoLogSessionDataAccess();

	// Ot@Co
	private static final String LOG_PRE = "OfflineLO:OAbv[h:OXV:";
	private static final String START_INF_LOG = LOG_PRE + "Jn܂B:";
	private static final String END_INF_LOG = LOG_PRE + "I܂B:";
	private static final String PARAM_ERR_LOG = LOG_PRE + "p[^słB:";
	private static final String FILEIO_ERR_LOG = LOG_PRE + "Ot@C̓ǂݍ݂Ɏs܂B:";
	private static final String FILEDELETE_ERR_LOG = LOG_PRE + "Ot@C̍폜Ɏs܂B:";
	private static final String PARSE_ERR_LOG = LOG_PRE + "p[XG[:";
	private static final String SYSTEM_ERR_LOG = LOG_PRE + "VXeG[܂B:";
	private static final String DB_ERR_LOG = LOG_PRE + "f[^x[XG[܂B:";

	/**
	 * RXgN^łB
	 * @param strUserID [UID
	 * @param strLoID LOID
	 * @param strSessionID ZbVID
	 */
	public OfflineLoLogControl( String strUserID, String strLoID, String strMaterialID, String strLogPath ) {
		mstrUserID = strUserID;
		mstrLoID = strLoID;
		mstrMaterialID = strMaterialID;
		mstrLogPath = strLogPath;
	}

	/**
	 * Xbhs\bh
	 */
	public void run() {
		// p[^`FbN
		if( mstrUserID == null ||
			mstrLoID == null ||
			mstrMaterialID == null ||
			mstrLogPath == null )
		{
			// @LOG >err >1 OfflineLO:OAbv[h:OXV:p[^G[
			DebugLog.write( this.getClass(),
							PARAM_ERR_LOG +
							mstrUserID + ":" + mstrLoID + ":" + mstrMaterialID + ":" + mstrLogPath,
								DebugLog.HIGHT);

			// I
			return;
		}

		// @LOG >info >5 AD:hCݒԍݒ肳Ă܂B
		DebugLog.write( this.getClass(),
						START_INF_LOG +
						mstrUserID + ":" + mstrLoID + ":" + mstrMaterialID + ":" + mstrLogPath,
							DebugLog.MID);

		mobjDataAccess = new DataAccess();
		try {
			// gUNV̊Jn
			mobjDataAccess.trans();

			insertLog();

			// gUNV̏I
			mobjDataAccess.commit();

			// @LOG >info >5
			DebugLog.write( this.getClass(),
							END_INF_LOG +
							mstrUserID + ":" + mstrLoID + ":" + mstrMaterialID + ":" + mstrLogPath,
								DebugLog.MID);

		}
		catch(IOException ie) {
			// [obN
			try { mobjDataAccess.rollback(); } catch(Exception e) {}

			// Os̓Oɏo
			// @LOG >err >1
			DebugLog.write( this.getClass(),
							FILEIO_ERR_LOG +
							mstrUserID + ":" + mstrLoID + ":" + mstrMaterialID + ":" + mstrLogPath,
								DebugLog.HIGHT);
			DebugLog.write( this.getClass(), ie, DebugLog.HIGHT );
		}
		catch(AiccParseException ae) {
			// [obN
			try { mobjDataAccess.rollback(); } catch(Exception e) {}

			// Os̓Oɏo
			// @LOG >err >1
			DebugLog.write( this.getClass(),
							PARSE_ERR_LOG + ae.getMessage() + ":" +
							mstrUserID + ":" + mstrLoID + ":" + mstrMaterialID + ":" + mstrLogPath,
								DebugLog.HIGHT);
			DebugLog.write( this.getClass(), ae, DebugLog.HIGHT );
		}
		catch(SAXException sae) {
			// [obN
			try { mobjDataAccess.rollback(); } catch(Exception e) {}

			// XMLp[XG[̓Oɏo
			// @LOG >err >1
			DebugLog.write( this.getClass(),
							PARSE_ERR_LOG + sae.getMessage() + ":" +
							mstrUserID + ":" + mstrLoID + ":" + mstrMaterialID + ":" + mstrLogPath,
								DebugLog.HIGHT);
			DebugLog.write( this.getClass(), sae, DebugLog.HIGHT );
		}
		catch( SQLException se ) {
			// [obN
			try { mobjDataAccess.rollback(); } catch(Exception e) {}

			// SQLG[
			// @LOG >err >1
			DebugLog.write( this.getClass(),
							DB_ERR_LOG +
							mstrUserID + ":" + mstrLoID + ":" + mstrMaterialID + ":" + mstrLogPath,
								DebugLog.HIGHT);
			DebugLog.write( this.getClass(), se, DebugLog.HIGHT );
		}
		catch( LOException le ) {
			// [obN
			try { mobjDataAccess.rollback(); } catch(Exception e) {}

			// LOŗLG[
			// @LOG >err >1
			DebugLog.write( this.getClass(),
							SYSTEM_ERR_LOG + le.getMessage() + ":" +
							mstrUserID + ":" + mstrLoID + ":" + mstrMaterialID + ":" + mstrLogPath,
								DebugLog.HIGHT);
			DebugLog.write( this.getClass(), le, DebugLog.HIGHT );
		}

		catch( Exception ex ) {
			// [obN
			try { mobjDataAccess.rollback(); } catch(Exception e) {}

			// LOŗLG[
			// @LOG >err >1
			DebugLog.write( this.getClass(),
							SYSTEM_ERR_LOG + ex.getMessage() + ":" +
							mstrUserID + ":" + mstrLoID + ":" + mstrMaterialID + ":" + mstrLogPath,
								DebugLog.HIGHT);
			DebugLog.write( this.getClass(), ex, DebugLog.HIGHT );
		}


		// Ot@C̍폜s܂B
		try {
			// Ot@C̍폜
			deleteLogFile();

		}
		catch( IOException ie ) {
			// @LOG >err >1
			DebugLog.write( this.getClass(),
							FILEDELETE_ERR_LOG +
							mstrUserID + ":" + mstrLoID + ":" + mstrMaterialID + ":" + mstrLogPath,
								DebugLog.HIGHT);
			DebugLog.write( this.getClass(), ie, DebugLog.HIGHT );
		}
		catch( Exception ex ) {
			// @LOG >err >1
			DebugLog.write( this.getClass(),
							FILEDELETE_ERR_LOG +
							mstrUserID + ":" + mstrLoID + ":" + mstrMaterialID + ":" + mstrLogPath,
								DebugLog.HIGHT);
			DebugLog.write( this.getClass(), ex, DebugLog.HIGHT );
		}

	}

	/**
	 * AiccO͂āAAicc̊ee[uɓo^s܂B
	 *
	 * eFXe[^XONX
	 *           f[^ݒ肷B
	 * @exception LOException LoŗL̗OG[
	 */
	public void insertLog()
		throws LOException, SQLException, AiccParseException, SAXException, IOException, Exception
	{

		///////////////////////////////////////////////////////////////
		// ʃOe[u̒ǉ
		///////////////////////////////////////////////////////////////

		// AiccORo[gNXCX^X܂
		AiccLogConverter objConvert = new AiccLogConverter( mstrUserID, mstrLoID, mstrMaterialID, mstrLogPath );

		// p[Xs܂
		objConvert.parse();

		// OR[h폜܂B
		deleteLog(mstrUserID, mstrLoID);

		// AiccCoree[u̓o^
		if( objConvert.getAiccCoreRecords() != null ) {
			mobjAiccCoreDataAccess.insert( objConvert.getAiccCoreRecords(), mobjDataAccess );
		}

		// SectionLoge[u̓o^
		if( objConvert.getSectionLogRecords() != null ) {
			mobjSectionLogDataAccess.insert( objConvert.getSectionLogRecords(), mobjDataAccess );
		}

		// AiccInteractione[u̓o^
		if( objConvert.getAiccInteractionRecords() != null ) {
			mobjInteractionDataAccess.insert( objConvert.getAiccInteractionRecords(), mobjDataAccess );
		}

		// AiccCommente[u̓o^
		if( objConvert.getAiccCommentRecords() != null ) {
			mobjCommentDataAccess.insert( objConvert.getAiccCommentRecords(), mobjDataAccess );
		}

		// AiccObjectivese[u̓o^
		if( objConvert.getAiccObjectivesRecords() != null ) {
			mobjObjectivesDataAccess.insert( objConvert.getAiccObjectivesRecords(), mobjDataAccess );
		}

		// LoLogSessione[u̓o^
		LoLogSessionRecord[] objSessions = objConvert.getLoLogSessionRecords();
		if( objSessions == null ) {
			throw new LOException( "ZbVO擾s" );
		}

		for( int i = 0; i < objSessions.length; i++ ) {
			insertLoLogSession( objSessions[i] );
		}

		///////////////////////////////////////////////////////////////
		// LoLogXe[^XOe[u̍XV
		///////////////////////////////////////////////////////////////
		LoLogRecord objRecord = objConvert.getLoLogRecord();

		if( objRecord == null ) {
			throw new LOException( "LOLog擾s" );
		}

		// LoLogSession̈ԑ傫highscoreݒ
		objRecord.setHighScore( mobjLoLogSessionDataAccess.getMaxHighScore( mstrUserID, mstrLoID, mobjDataAccess ) );
		// LoLogSession̈ԏlowscoreݒ
		objRecord.setLowScore( mobjLoLogSessionDataAccess.getMinLowScore( mstrUserID, mstrLoID, mobjDataAccess ) );
		// ߂execise_pointݒ
		objRecord.setExecisePoint( mobjLoLogSessionDataAccess.getNewestExcisePoint( mstrUserID, mstrLoID, mobjDataAccess ) );
		// LoLogSession̈ԑ傫fullScoreݒ
		objRecord.setFullScore( mobjLoLogSessionDataAccess.getMaxFullScore( mstrUserID, mstrLoID, mobjDataAccess ) );
		// it̎擾
		objRecord.setPassday( mobjLoLogSessionDataAccess.getFirstPassDay( mstrUserID, mstrLoID, mobjDataAccess ) );
		// t̎擾
		objRecord.setStudyEndDate( mobjLoLogSessionDataAccess.getFirstStudyEndDate( mstrUserID, mstrLoID, mobjDataAccess ) );
		// ŏIANZX̎擾
		String[] dateList = null;
		dateList = mobjLoLogSessionDataAccess.getStudyDateList( mstrUserID, mstrLoID, mobjDataAccess );
		objRecord.setLastAccess( dateList[0] );

		// LoLoge[u̍XV
		// o^܂͍XVs܂
		mobjLoLogDataAccess.insertUpdate(	objRecord,
											mstrUserID,
											mstrLoID,
											mobjDataAccess );

		// QLOIDXg擾܂
		LoClient objLoClient = new LoClient();
		if(!objLoClient.getListFromRealLOID( mstrLoID )){
			new LOException("QLOIDXg̎擾s܂B");
		}

		String[] strRefList = objLoClient.getRefListResult();

		// QƃXgXe[^X`d
		for(int i = 0; i < strRefList.length; i++){
			// Xe[^X`
			StatusPropagation objStatus = new StatusPropagation( mstrUserID, strRefList[i] );
			PropagateControl.getInstance().addPropagate(objStatus);
		}
	}

	/**
	 * LoLogSessione[uɃR[hǉ܂B
	 * @param objSession LoLogSessionR[hf[^
	 * @exception SQLException
	 */
	private void insertLoLogSession( LoLogSessionRecord objSession )
		throws SQLException
	{

		String strSessionID = objSession.getSessionID();

		// _WvĊi[
		// ō_̐ݒ
		String strMaxScore = mobjAiccCoreDataAccess.getSumMaxScore(mstrUserID, mstrLoID, strSessionID, mobjDataAccess);
		// Œᓾ_̐ݒ
		String strMinScore = mobjAiccCoreDataAccess.getSumMinScore(mstrUserID, mstrLoID, strSessionID, mobjDataAccess);
		// _̐ݒ
		String strRawScore = mobjAiccCoreDataAccess.getSumRawScore(mstrUserID, mstrLoID, strSessionID, mobjDataAccess);
		// _̐ݒ
		String strFullScore = mobjAiccCoreDataAccess.getFullScore( mstrUserID, mstrLoID, strSessionID, mobjDataAccess );


		// ō_̐ݒ
		if( strMaxScore != null &&
			!strMaxScore.equals( "" ) )
		{
			objSession.setHighScore( strMaxScore );
		}
		// Œᓾ_̐ݒ
		if( strMinScore != null &&
			!strMinScore.equals( "" ) )
		{
			objSession.setLowScore( strMinScore );
		}
		// _̐ݒ
		if( strRawScore != null &&
			!strRawScore.equals( "" ) )
		{
			objSession.setExecisePoint( strRawScore );
		}
		// _̐ݒ
		if( strFullScore != null &&
			!strFullScore.equals( "" ) )
		{
			objSession.setFullScore( strFullScore );
		}

		// o^
		mobjLoLogSessionDataAccess.insertUpdate( objSession, mstrUserID, mstrLoID, strSessionID, mobjDataAccess );
	}

	/**
	 * [UIDLOIDŃOf[^폜܂B
	 * <PRE>
	 *   폜e[u͈ȉ̂
	 *     LoLog
	 *     LoLogSession
	 *     OL_AiccCore
	 *     OL_AiccInteraction
	 *     OL_AiccComments
	 *     OL_AiccObjectives
	 * </PRE>
	 * @param strUserID [UID
	 * @param strLoID LOID
	 * @param
	 * @exceptin SQLException DBANZXO
	 */
	private void deleteLog( String strUserID, String strLoID )
		throws SQLException
	{
		// OL_AiccCoree[u̓L[f[^폜
		mobjAiccCoreDataAccess.delete( strUserID, strLoID, null, mobjDataAccess );
		// OL_SectionLoge[u̓L[f[^폜
		mobjSectionLogDataAccess.delete( strUserID, strLoID, null, mobjDataAccess );
		// OL_AiccInteractione[u̓L[f[^폜
		mobjInteractionDataAccess.delete( strUserID, strLoID, null, mobjDataAccess );
		// OL_AiccCommente[u̓L[f[^폜
		mobjCommentDataAccess.delete( strUserID, strLoID, null, mobjDataAccess );
		// OL_AiccObjectivese[u̓L[f[^폜
		mobjObjectivesDataAccess.delete( strUserID, strLoID, null, mobjDataAccess );
		// LoLoge[u̓L[f[^폜
		mobjLoLogDataAccess.delete( strUserID, strLoID, mobjDataAccess );
		// LoLogSessione[u̓L[f[^폜
		mobjLoLogSessionDataAccess.delete( strUserID, strLoID, mobjDataAccess );
	}

	/**
	 * Ot@C̍폜s܂B
	 * AAOx10͍̎폜s܂
	 * @exception IOException t@CIOG[
	 * @exception Exception VXeG[
	 */
	private void deleteLogFile()
		throws IOException, Exception
	{
		// ݒt@Cǂݍ݃NXCX^X
		Environment objEnv = new Environment();

		// Ox̎擾
		String strLogLevel = objEnv.getLogLevel();
		int intLogLevelTemp = new Integer( strLogLevel ).intValue();

		if( intLogLevelTemp == 10 ) {
			return;
		}

		// t@C폜
		FileControl.delete( mstrLogPath );
	}
}
