/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/
package jp.co.ntt.lms.installer.core.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.logging.Logger;

import jp.co.ntt.lms.installer.core.InstallerException;
import jp.co.ntt.lms.installer.core.InstallerValues;
import jp.co.ntt.lms.installer.util.LoggerUtil;
import jp.co.ntt.lms.installer.util.StringUtil;

/**
 * Wo͂Ɋւ郆[eBeBENXB
 * @author T.Nishiki
 */
public class InstallerUiUtil {
	/**
	 * Oo̓IuWFNgB
	 */
	private static Logger _logger;

	/**
	 * X^eBbNECjVCUB<br>
	 * Oo̓IuWFNg擾܂B
	 */
	static {
		_logger = LoggerUtil.getLogger(InstallerUiUtil.class);
	}

	/**
	 * bZ[WL[F͂̏ꍇ̃ftHgl\郁bZ[WB
	 */
	public static final String KEY_OUTPUT_DEFALUT_VALUE
		= "common.input.defaultvalue";

	/**
	 * bZ[WL[F̓vvgB
	 */
	public static final String KEY_OUTPUT_PROMPT = "common.input.prompt";

	/**
	 * ẂiL[{[h́jPsǂݍ݂܂B
	 * W͂ɂEnterL[܂ő҂A
	 * EnterL[ꂽ炻̒O̕擾܂B
	 * @return W͂œ͂ĂPsB
	 * @throws InstallerException ǍɎsꍇB
	 */
	public static String readLine() throws InstallerException {
		BufferedReader reader = null;
		String line = null;
		try {
			reader = new BufferedReader(new InputStreamReader(System.in));
			line = reader.readLine();
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}
		// null͋󕶎ƂĖ߂B
		if (line == null) {
			line = "";
		}
		return line;
	}

	/**
	 * bZ[Wo͂܂B
	 * bZ[Wo͑Oɉs܂B<br>
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @param key 擾ĕ\郁bZ[W̃L[B
	 */
	public static void outputMessageAsTitle(
			InstallerValues values, String key) {
		System.out.println();
		System.out.println("-----------------------------------------------");
		outputMessage(values, key, null, true);
	}

	/**
	 * bZ[Wo͂܂B
	 * bZ[Wo͑Oɉs܂B<br>
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @param key 擾ĕ\郁bZ[W̃L[B
	 */
	public static void outputConfirmTitle(
			InstallerValues values, String key) {
		System.out.println();
		outputMessage(values, key, null, true);
	}

	/**
	 * bZ[Wo͂܂B
	 * bZ[Wo͌ɉs܂B<br>
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @param key 擾ĕ\郁bZ[W̃L[B
	 */
	public static void outputMessage(
			InstallerValues values, String key) {
		outputMessage(values, key, null, false);
	}

	/**
	 * bZ[Wo͂܂B
	 * bZ[Wo͌ɉs܂B<br>
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @param key 擾ĕ\郁bZ[W̃L[B
	 * @param messageParams bZ[WEp[^B
	 */
	public static void outputMessage(
			InstallerValues values, String key, Object[] messageParams) {
		outputMessage(values, key, messageParams, false);
	}

	/**
	 * bZ[Wo͂܂B<br>
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @param key 擾ĕ\郁bZ[W̃L[B
	 * @param newLine o͌sꍇtrueAsȂꍇfalsen܂B
	 */
	public static void outputMessage(
			InstallerValues values, String key, boolean newLine) {
		outputMessage(values, key, null, newLine);
	}

	/**
	 * bZ[Wo͂܂B<br>
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @param key 擾ĕ\郁bZ[W̃L[B
	 * @param newLine o͌sꍇtrueAsȂꍇfalsen܂B
	 * @param messageParams bZ[WEp[^B
	 */
	public static void outputMessage(
			InstallerValues values, String key,
			Object[] messageParams, boolean newLine) {
		String message = values.getMessage(key);
		// bZ[W擾łAAp[^nĂꍇA
		// bZ[WEtH[}bgĂAo
		if (messageParams != null && StringUtil.isEmpty(message) == false) {
			String outputMessage
				= MessageFormat.format(message, messageParams);
			System.out.print(outputMessage);
		}
		else {
			System.out.print(message);
		}
		if ( newLine ) {
			System.out.println();
		}
	}

	/**
	 * bZ[Wo͂܂B
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @param key 擾ĕ\郁bZ[W̃L[B
	 * @param variable bZ[Wɑĕ\lB
	 */
	public static void outputConfirm(
			InstallerValues values, String key, String variable) {
		// bZ[W
		outputMessage(values, key);
		// vvg
		outputMessage(values, KEY_OUTPUT_PROMPT);
		// l
		System.out.println(variable);
	}

	/**
	 * bZ[Wo͂܂B
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @param key 擾ĕ\郁bZ[W̃L[B
	 * @param messageParams bZ[WEp[^B
	 * @param variable bZ[Wɑĕ\lB
	 */
	public static void outputConfirm(
			InstallerValues values, String key,
			Object[] messageParams, String variable) {
		// bZ[W
		outputMessage(values, key, messageParams);
		// vvg
		outputMessage(values, KEY_OUTPUT_PROMPT);
		// l
		System.out.println(variable);
	}

	/**
	 * [Uɓ͂߂vvg\A͂l߂܂B
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @param key 擾ĕ\郁bZ[W̃L[B
	 * @return [U͂lA܂̓ftHglB
	 * @throws InstallerException ǍɗOꍇB
	 */
	public static String askUserInput(
			InstallerValues values, String key)
			throws InstallerException {
		// ̃\bh̖߂lB
		String line = null;
		try {
			line = askUserInput(values, key, null, null);
		}
		catch (InstallerException e) {
			throw e;
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}
		return line;
	}

	/**
	 * [Uɓ͂߂vvg\A͂l߂܂B
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @param key 擾ĕ\郁bZ[W̃L[B
	 * @param defaultValue ͂̏ꍇ̃ftHglB
	 *                      ftHglȂꍇAnull܂͋󕶎B
	 * @return [U͂lA܂̓ftHglB
	 * @throws InstallerException ǍɗOꍇB
	 */
	public static String askUserInput(
			InstallerValues values, String key, String defaultValue)
			throws InstallerException {
		// ̃\bh̖߂lB
		String line = null;
		try {
			line = askUserInput(values, key, null, defaultValue);
		}
		catch (InstallerException e) {
			throw e;
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}
		return line;
	}

	/**
	 * [Uɓ͂߂vvg\A͂l߂܂B
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @param key 擾ĕ\郁bZ[W̃L[B
	 * @param messageParams bZ[WEp[^B
	 * @param defaultValue ͂̏ꍇ̃ftHglB
	 *                      ftHglȂꍇAnull܂͋󕶎B
	 * @return [U͂lA܂̓ftHglB
	 * @throws InstallerException ǍɗOꍇB
	 */
	public static String askUserInput(
			InstallerValues values, String key,
			Object[] messageParams, String defaultValue)
			throws InstallerException {
		// ̃\bh̖߂lB
		String line = null;
		try {
			outputPrompt(values, key, messageParams, defaultValue);
			line = InstallerUiUtil.readLine();
			// ͂ŃftHglꍇA̒l̗p
			if (StringUtil.isEmpty(line) == true
					&& StringUtil.isEmpty(defaultValue) == false) {
				line = defaultValue;
			}
		}
		catch (InstallerException e) {
			throw e;
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}
		return line;
	}

	/**
	 * [Uɓ͂߂vvg\A͂l߂܂B
	 * l͂܂ŌJԂ͂߂܂B
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @param key 擾ĕ\郁bZ[W̃L[B
	 * @return [U͂lB
	 * @throws InstallerException ǍɗOꍇB
	 */
	public static int askUserInputInteger(
		InstallerValues values, String key) throws InstallerException {

		int returnValue = 0;
		try {
			while (true) {
				String line = askUserInput(values, key);
				try {
					returnValue = Integer.parseInt(line);
				}
				catch (Exception e) {
					continue;
				}
				break;
			}
		}
		catch (InstallerException e) {
			throw e;
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}
		return returnValue;
	}

	/**
	 * [Uyn͂߂vvg\A͂l߂܂B
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @param key 擾ĕ\郁bZ[W̃L[B
	 * @return y͂trueAn͂falseB
	 * @throws InstallerException ǍɗOꍇB
	 */
	public static boolean askUserConfirm(
			InstallerValues values, String key)
			throws InstallerException {
		// ̃\bh̖߂lB
		boolean confirm = false;
		try {
			System.out.println();
			while (true) {
				String confirmInputed
					= InstallerUiUtil.askUserInput( values, key );
				if (confirmInputed.equals("y")) {
					confirm = true;
					break;
				}
				if (confirmInputed.equals("n")) {
					confirm = false;
					break;
				}
			}
		}
		catch (InstallerException e) {
			throw e;
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}
		return confirm;
	}

	/**
	 * [Uyn͂߂vvg\A͂l߂܂B
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @param key 擾ĕ\郁bZ[W̃L[B
	 * @param messageParams bZ[WEp[^B
	 * @return y͂trueAn͂falseB
	 * @throws InstallerException ǍɗOꍇB
	 */
	public static boolean askUserConfirm(
			InstallerValues values, String key, Object[] messageParams)
			throws InstallerException {
		// ̃\bh̖߂lB
		boolean confirm = false;
		try {
			System.out.println();
			while (true) {
				String confirmInputed = InstallerUiUtil.askUserInput(
					values, key, messageParams, null);
				if (confirmInputed.equals("y")) {
					confirm = true;
					break;
				}
				if (confirmInputed.equals("n")) {
					confirm = false;
					break;
				}
			}
		}
		catch (InstallerException e) {
			throw e;
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}
		return confirm;
	}

	/**
	 * booleanmF͂̕ɕϊ܂B<br>
	 * @param confirm ϊ̒lB
	 * @return confirmtrueȂ&quot;y&quot;AfalseȂ&quot;n&quot;B
	 */
	public static String convertBoolToConfirmString(boolean confirm) {
		if ( confirm ) {
			return "y";
		}
		return "n";
	}

	/**
	 * ͗pvvg\܂B<br>
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @param key 擾ĕ\郁bZ[W̃L[B
	 * @param messageParams bZ[WEp[^B
	 * @param defaultValue ͂̏ꍇ̃ftHglB
	 *                      ftHglȂꍇAnull܂͋󕶎B
	 */
	private static void outputPrompt(
			InstallerValues values, String key,
			Object[] messageParams, String defaultValue) {
		// bZ[Wo
		outputMessage(values, key, messageParams);
		// ftHgl
		if (StringUtil.isEmpty(defaultValue) == false) {
			String message = values.getMessage(KEY_OUTPUT_DEFALUT_VALUE);
			Object[] formatFields = new Object[]{
				defaultValue
			};
			String defaultMessage = MessageFormat.format(message, formatFields);
			System.out.print(defaultMessage);
		}
		// vvg
		outputMessage(values, KEY_OUTPUT_PROMPT);
	}
}
