//
// CopyRight (C) 2002, IPA, eLC, NTT Resonant Inc. All rights reserved.
//
//	Progress
//
//	ύX
//		2002.12.25  VK쐬
//

package jp.co.ntt.lms.lo.scorm.kernel;

import java.math.BigDecimal;

import jp.co.ntt.lms.lo.scorm.kernel.exception.SystemException;
import jp.co.ntt.lms.lo.scorm.util.CachedNode;
import jp.co.ntt.lms.lo.scorm.util.XMLUtil;
import jp.co.ntt.lms.lo.scorm.util.XPathUtil;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/**
* Progress class<BR>
* ActivityƂProgress\NX<BR>
*/
public class Progress {
	/** 0.0000BigDecimal */
	private static final BigDecimal zero = new BigDecimal("0.0").setScale(4, BigDecimal.ROUND_HALF_UP);

	/** 1.0000BigDecimal */
	private static final BigDecimal one = new BigDecimal("1.0").setScale(4, BigDecimal.ROUND_HALF_UP);

	/** activity progress status */
	private boolean activityProgressStatus;

	/** activity absolute duration */
	private Duration activityAbsoluteDuration;

	/** activity experienced duration */
	private Duration activityExperiencedDuration;

	/** activity attempt count */
	private int activityAttemptCount;

	/** attempt progress status */
	private boolean attemptProgressStatus;

	/** attempt completion amount */
	private BigDecimal attemptCompletionAmount;

	/** attempt completion status */
	private boolean attemptCompletionStatus;

	/** attempt absolute duration */
	private Duration attemptAbsoluteDuration;

	/** attempt experienced duration */
	private Duration attemptExperiencedDuration;

	/** Oattempt attempt progress status */
	private boolean previousAttemptProgressStatus[] = { false, false };

	/** Oattempt attempt completion amount */
	private BigDecimal previousAttemptCompletionAmount[] = { zero, zero };

	/** Oattempt attempt completion status */
	private boolean previousAttemptCompletionStatus[] = { false, false };

	/** Oattempt attempt absolute duration */
	private Duration previousAttemptAbsoluteDuration[] = { new Duration(0), new Duration(0)};

	/** Oattempt attempt experienced duration */
	private Duration previousAttemptExperiencedDuration[] = { new Duration(0), new Duration(0)};

	/** activity */
	private Activity activity;

	/**
	 * ftHgRXgN^
	 */
	public Progress() {}

	/**
	 * RXgN^<BR>
	 * @param activity	ProgressActivityw肷<BR>
	 * @param manifestNode	ލ\m[h<BR>
	 */
	public Progress(Activity activity, CachedNode manifestNode) throws SystemException {
		this.activity = activity;

		activityProgressStatus = false;
		activityAbsoluteDuration = new Duration(0);
		activityExperiencedDuration = new Duration(0);
		activityAttemptCount = 0;

		attemptProgressStatus = false;
		attemptCompletionAmount = zero;
		attemptCompletionStatus = false;
		attemptAbsoluteDuration = new Duration(0);
		attemptExperiencedDuration = new Duration(0);
	}

	/**
	 * f擾<BR>
	 *
	 * @return progress̒f̕<BR>
	 */
	public void save(Document doc, Element parent, boolean traceLog) throws SystemException {
		try {
			boolean activityProgressStatus;
			String activityAbsoluteDuration = "";
			String activityExperiencedDuration = "";
			String activityAttemptCount = "";

			if (!traceLog) {
				activityProgressStatus = this.activityProgressStatus;
				if (activityProgressStatus) {
					activityAbsoluteDuration = this.activityAbsoluteDuration.toString();
					activityExperiencedDuration = this.activityExperiencedDuration.toString();
					activityAttemptCount = Integer.toString(this.activityAttemptCount);
				}
			}
			else {
				activityProgressStatus = getActivityProgressStatus();
				if (activityProgressStatus) {
					activityAbsoluteDuration = getActivityAbsoluteDuration().toString();
					activityExperiencedDuration = getActivityExperiencedDuration().toString();
					activityAttemptCount = Integer.toString(getActivityAttemptCount());
				}
			}

			boolean attemptProgressStatus;
			String attemptCompletionAmount = "";
			String attemptCompletionStatus = "";
			String attemptAbsoluteDuration = "";
			String attemptExperiencedDuration = "";

			if (!traceLog) {
				attemptProgressStatus = this.attemptProgressStatus;
				attemptCompletionAmount = this.attemptCompletionAmount.toString();
				if (attemptProgressStatus) {
					attemptCompletionStatus = Boolean.toString(this.attemptCompletionStatus);
				}
				attemptAbsoluteDuration = this.attemptAbsoluteDuration.toString();
				attemptExperiencedDuration = this.attemptExperiencedDuration.toString();
			}
			else {
				attemptProgressStatus = getAttemptProgressStatus();
				if (attemptProgressStatus) {
					attemptCompletionAmount = getAttemptCompletionAmount().toString();
					attemptCompletionStatus = Boolean.toString(getAttemptCompletionStatus());
					attemptAbsoluteDuration = getAttemptAbsoluteDuration().toString();
					attemptExperiencedDuration = getAttemptExperiencedDuration().toString();
				}
			}

			XMLUtil.append(
				doc,
				parent,
				"progress",
				new Element[] {
					XMLUtil.createElement(doc, "activityprogressstatus", Boolean.toString(activityProgressStatus)),
					XMLUtil.createElement(doc, "activityabsoluteduration", activityAbsoluteDuration),
					XMLUtil.createElement(doc, "activityexperiencedduration", activityExperiencedDuration),
					XMLUtil.createElement(doc, "activityattemptcount", activityAttemptCount),
					XMLUtil.createElement(doc, "attemptprogressstatus", Boolean.toString(attemptProgressStatus)),
					XMLUtil.createElement(doc, "attemptcompletionamount", attemptCompletionAmount),
					XMLUtil.createElement(doc, "attemptcompletionstatus", attemptCompletionStatus),
					XMLUtil.createElement(doc, "attemptabsoluteduration", attemptAbsoluteDuration),
					XMLUtil.createElement(doc, "attemptexperiencedduration", attemptExperiencedDuration),
					XMLUtil.createElement(
						doc,
						"previous",
						new Element[] {
							XMLUtil.createElement(
								doc,
								"attemptprogressstatus",
								Boolean.toString(previousAttemptProgressStatus[0])),
							XMLUtil.createElement(
								doc,
								"attemptcompletionamount",
								previousAttemptCompletionAmount[0].toString()),
							XMLUtil.createElement(
								doc,
								"attemptcompletionstatus",
								(!previousAttemptProgressStatus[0])
									? null
									: Boolean.toString(previousAttemptCompletionStatus[0])),
							XMLUtil.createElement(
								doc,
								"attemptabsoluteduration",
								previousAttemptAbsoluteDuration[0].toString()),
							XMLUtil.createElement(
								doc,
								"attemptexperiencedduration",
								previousAttemptExperiencedDuration[0].toString()),
							}),
					XMLUtil.createElement(
						doc,
						"candidateprevious",
						new Element[] {
							XMLUtil.createElement(
								doc,
								"attemptprogressstatus",
								Boolean.toString(previousAttemptProgressStatus[1])),
							XMLUtil.createElement(
								doc,
								"attemptcompletionamount",
								previousAttemptCompletionAmount[1].toString()),
							XMLUtil.createElement(
								doc,
								"attemptcompletionstatus",
								(!previousAttemptProgressStatus[1])
									? null
									: Boolean.toString(previousAttemptCompletionStatus[1])),
							XMLUtil.createElement(
								doc,
								"attemptabsoluteduration",
								previousAttemptAbsoluteDuration[1].toString()),
							XMLUtil.createElement(
								doc,
								"attemptexperiencedduration",
								previousAttemptExperiencedDuration[1].toString()),
							}),
					});
		}
		catch (Exception ex) {
			throw new SystemException("save failed [ActivityID:" + activity.getIdentifier() + "]", ex);
		}
	}

	/**
	 * Progress̏<BR>
	 */
	public void initializeProgressInformation(CachedNode parent) throws SystemException {
		// ANeBreB̏
		initializeActivityProgressInformation();

		// ANeBreB̊wK̏
		initializeAttemptProgressInformation();

		if (parent == null) {
			return;
		}

		try {
			Node progressNode = XPathUtil.selectSingleChildNode(parent.getNode(), "progress");

			// activity progress status
			activityProgressStatus =
				Boolean
					.valueOf(
						XPathUtil
							.selectSimpleSingleNode(progressNode, "activityprogressstatus/text()")
							.getNodeValue())
					.booleanValue();

			if (activityProgressStatus) {
				// activity absolute duration
				activityAbsoluteDuration =
					new Duration(
						XPathUtil
							.selectSimpleSingleNode(progressNode, "activityabsoluteduration/text()")
							.getNodeValue());

				// activity experienced duration
				activityExperiencedDuration =
					new Duration(
						XPathUtil
							.selectSimpleSingleNode(progressNode, "activityexperiencedduration/text()")
							.getNodeValue());

				// activity attempt count
				activityAttemptCount =
					Integer.parseInt(
						XPathUtil.selectSimpleSingleNode(progressNode, "activityattemptcount/text()").getNodeValue());
			}

			// activity attempt progress status
			attemptProgressStatus =
				Boolean
					.valueOf(
						XPathUtil
							.selectSimpleSingleNode(progressNode, "attemptprogressstatus/text()")
							.getNodeValue())
					.booleanValue();

			// activity attempt completion amount
			attemptCompletionAmount =
				new BigDecimal(
					XPathUtil.selectSimpleSingleNode(progressNode, "attemptcompletionamount/text()").getNodeValue());

			if (attemptProgressStatus) {
				// activity attempt completion status
				attemptCompletionStatus =
					Boolean
						.valueOf(
							XPathUtil
								.selectSimpleSingleNode(progressNode, "attemptcompletionstatus/text()")
								.getNodeValue())
						.booleanValue();
			}

			// activity attempt absolute duration
			attemptAbsoluteDuration =
				new Duration(
					XPathUtil.selectSimpleSingleNode(progressNode, "attemptabsoluteduration/text()").getNodeValue());

			// activity attempt experienced duration
			attemptExperiencedDuration =
				new Duration(
					XPathUtil
						.selectSimpleSingleNode(progressNode, "attemptexperiencedduration/text()")
						.getNodeValue());

			Node previousNode = XPathUtil.selectSingleChildNode(progressNode, "previous");

			previousAttemptProgressStatus[0] =
				Boolean
					.valueOf(
						XPathUtil
							.selectSimpleSingleNode(previousNode, "attemptprogressstatus/text()")
							.getNodeValue())
					.booleanValue();

			previousAttemptCompletionAmount[0] =
				new BigDecimal(
					XPathUtil.selectSimpleSingleNode(previousNode, "attemptcompletionamount/text()").getNodeValue());

			if (previousAttemptProgressStatus[0]) {
				previousAttemptCompletionStatus[0] =
					Boolean
						.valueOf(
							XPathUtil
								.selectSimpleSingleNode(previousNode, "attemptcompletionstatus/text()")
								.getNodeValue())
						.booleanValue();
			}

			previousAttemptAbsoluteDuration[0] =
				new Duration(
					XPathUtil.selectSimpleSingleNode(previousNode, "attemptabsoluteduration/text()").getNodeValue());

			previousAttemptExperiencedDuration[0] =
				new Duration(
					XPathUtil
						.selectSimpleSingleNode(previousNode, "attemptexperiencedduration/text()")
						.getNodeValue());

			Node candidatePreviousNode = XPathUtil.selectSingleChildNode(progressNode, "candidateprevious");

			previousAttemptProgressStatus[1] =
				Boolean
					.valueOf(
						XPathUtil
							.selectSimpleSingleNode(candidatePreviousNode, "attemptprogressstatus/text()")
							.getNodeValue())
					.booleanValue();

			previousAttemptCompletionAmount[1] =
				new BigDecimal(
					XPathUtil
						.selectSimpleSingleNode(candidatePreviousNode, "attemptcompletionamount/text()")
						.getNodeValue());

			if (previousAttemptProgressStatus[1]) {
				previousAttemptCompletionStatus[1] =
					Boolean
						.valueOf(
							XPathUtil
								.selectSimpleSingleNode(candidatePreviousNode, "attemptcompletionstatus/text()")
								.getNodeValue())
						.booleanValue();
			}

			previousAttemptAbsoluteDuration[1] =
				new Duration(
					XPathUtil
						.selectSimpleSingleNode(candidatePreviousNode, "attemptabsoluteduration/text()")
						.getNodeValue());

			previousAttemptExperiencedDuration[1] =
				new Duration(
					XPathUtil
						.selectSimpleSingleNode(candidatePreviousNode, "attemptexperiencedduration/text()")
						.getNodeValue());
		}
		catch (SystemException ex) {
			throw ex;
		}
		catch (Exception ex) {
			throw new SystemException(
				"initializeProgressInformation failed [ActivityID:" + activity.getIdentifier() + "]",
				ex);
		}
	}

	/**
	 * s̏<BR>
	 */
	public void initializeAttemptInformation() throws SystemException {
		try {
			// ANeBreB̊wK̏
			initializeAttemptProgressInformation();
		}
		catch (SystemException ex) {
			throw ex;
		}
		catch (Exception ex) {
			throw new SystemException(
				"initializeAttemptInformation failed [ActivityID:" + activity.getIdentifier() + "]",
				ex);
		}
	}

	/**
	 * ANeBreB̐ȉ<BR>
	 */
	private void initializeActivityProgressInformation() {
		activityProgressStatus = false;
		activityAbsoluteDuration = new Duration(0);
		activityExperiencedDuration = new Duration(0);
		activityAttemptCount = 0;
	}

	/*
	 * useCurrentAttempẗׂ̌lXV
	 */
	public void setCandidatePreviousValue() throws SystemException {
		// Oattempt̕ۑ
		previousAttemptProgressStatus[1] = getAttemptProgressStatus();
		if (previousAttemptProgressStatus[1]) {
			previousAttemptCompletionAmount[1] = getAttemptCompletionAmount();
			previousAttemptCompletionStatus[1] = getAttemptCompletionStatus();
			previousAttemptAbsoluteDuration[1] = getAttemptAbsoluteDuration();
			previousAttemptExperiencedDuration[1] = getAttemptExperiencedDuration();
		}
	}

	/**
	 * ANeBreB̊wK̐ȉ<BR>
	 */
	private void initializeAttemptProgressInformation() throws SystemException {
		try {
			// Oattempt̍XV
			previousAttemptProgressStatus[0] = previousAttemptProgressStatus[1];
			if (previousAttemptProgressStatus[0]) {
				previousAttemptCompletionAmount[0] = previousAttemptCompletionAmount[1];
				previousAttemptCompletionStatus[0] = previousAttemptCompletionStatus[1];
				previousAttemptAbsoluteDuration[0] = previousAttemptAbsoluteDuration[1];
				previousAttemptExperiencedDuration[0] = previousAttemptExperiencedDuration[1];
			}

			attemptProgressStatus = false;
			attemptCompletionAmount = zero;
			attemptCompletionStatus = false;
			attemptAbsoluteDuration = new Duration(0);
			attemptExperiencedDuration = new Duration(0);
		}
		catch (Exception ex) {
			throw new SystemException(
				"initializeAttemptProgressInformation failed [ActivityID:" + activity.getIdentifier() + "]",
				ex);
		}
	}

	/**
	 * I
	 */
	public void termiante() {
		activity = null;
	}

	/**
	 * Activity Progress Status̃Zbg
	 *
	 * @param result
	 */
	public void setActivityProgressStatus(boolean result) {
		activityProgressStatus = result;
	}

	/**
	 * activity progress status ̎擾<BR>
	 *
	 * @return boolean	 true L<BR>
	 *					 false <BR>
	 */
	public boolean getActivityProgressStatus() throws SystemException {
		if (!activity.getSequencing().getDeliveryControlFlag("tracked")) {
			return false;
		}

		return activityProgressStatus;
	}

	/**
	 * Activity Absolute DuratioñZbg
	 *
	 * @param duration
	 */
	public void setActivityAbsoluteDuration(Duration duration) {
		activityAbsoluteDuration = duration;
	}

	/**
	 *  activity absolute duration ̎擾<BR>
	 *
	 *  @return duration activity absolute duration<BR>
	 */
	public Duration getActivityAbsoluteDuration() {
		return activityAbsoluteDuration;
	}

	/**
	 * Activity Experienced duratioñZbg
	 *
	 * @param duration
	 */
	public void setActivityExperiencedDuration(Duration duration) {
		activityExperiencedDuration = duration;
	}

	/**
	 * activity experienced duration ̎擾<BR>
	 *
	 * @return duration activity experienced duration<BR>
	 */
	public Duration getActivityExperiencedDuration() throws SystemException {
		return activityExperiencedDuration;
	}

	/**
	 * activity attemp count ̃Zbg
	 *
	 * @param count	JEg
	 */
	public void setActivityAttemptCount(int count) {
		activityAttemptCount = count;
	}

	/**
	 * activity attempt count ̎擾<BR>
	 *
	 * @return activity attempt count<BR>
	 */
	public int getActivityAttemptCount() {
		return activityAttemptCount;
	}

	/**
	 * Activity attempt progress status ̃Zbg
	 *
	 * @param status	true:L, false:
	 */
	public void setAttemptProgressStatus(boolean status) {
		attemptProgressStatus = status;
	}

	/**
	 * attempt progress status̎擾<BR>
	 *
	 * @return boolean 
	 *		 true	activity attempt completion status, amountL<BR>
	 *		 false	activity attempt completion status, amount<BR>
	 */
	public boolean getAttemptProgressStatusForEvaluation() throws SystemException {
		try {
			if (!activity.isRoot()
				&& !activity.getParent().getSequencing().getControlModeFlag("useCurrentAttemptProgressInfo")) {
				return previousAttemptProgressStatus[0];
			}

			return getAttemptProgressStatus();
		}
		catch (SystemException ex) {
			throw ex;
		}
		catch (Exception ex) {
			throw new SystemException(
				"getAttemptProgressStatusForEvaluation failed [ActivityID:" + activity.getIdentifier() + "]",
				ex);
		}
	}

	/**
	 * attempt progress status ̎擾<BR>
	 * ( use current attempt completion status ɂȂ )<BR>
	 *
	 * @return boolean	true L<BR>
	 *					false <BR>
	 */
	public boolean getAttemptProgressStatus() throws SystemException {
		try {
			if (!activity.getSequencing().getDeliveryControlFlag("tracked")) {
				return false;
			}

			if ((!activity.hasChildren()) && (!activity.hasAvailableChildren())) {
				if (activity.getCommunicationModule().getAttemptProgressStatus().booleanValue()) {
					return true;
				}
			}

			return attemptProgressStatus;
		}
		catch (SystemException ex) {
			throw ex;
		}
		catch (Exception ex) {
			throw new SystemException(
				"getAttemptProgressStatus failed [ActivityID:" + activity.getIdentifier() + "]",
				ex);
		}
	}

	/**
	 * attempt progress status ̎擾<BR>
	 * 
	 *
	 * @return boolean	true L<BR>
	 *					false <BR>
	 */
	public boolean getAttemptProgressStatus(boolean isCurrent) throws SystemException {
		try {
			if (activity.isRoot())
			{
				return attemptProgressStatus;
			}
			
			if(!activity.getParent().getSequencing().getControlModeFlag("useCurrentAttemptProgressInfo")) {
				return getAttemptProgressStatus();
			}else{
				if(isCurrent){
					return getAttemptProgressStatus();
				}
				else // false̎͏falseԂ
				{
					return false;
				}
			}
		}
		catch (SystemException ex) {
			throw ex;
		}
		catch (Exception ex) {
			throw new SystemException(
				"getAttemptProgressStatusForEvaluation failed [ActivityID:" + activity.getIdentifier() + "]",
				ex);
		}
	}

	/**
	 * attempt completion amount̃Zbg<BR>
	 *
	 * @param amount 0.0`1.0̏Ŏw肷<BR>
	 */
	public void setAttemptCompletionAmount(BigDecimal amount) {
		attemptCompletionAmount = amount.setScale(4, BigDecimal.ROUND_HALF_UP);
	}

	/**
	 * attempt completion amount ̎擾<BR>
	 *
	 * @return	<BR>
	 *			0.01.0̏<BR>
	 */
	public BigDecimal getAttemptCompletionAmountForEvaluation() throws SystemException {
		try {
			if (!activity.isRoot()
				&& !activity.getParent().getSequencing().getControlModeFlag("useCurrentAttemptProgressInfo")) {
				return previousAttemptCompletionAmount[0];
			}

			return getAttemptCompletionAmount();
		}
		catch (SystemException ex) {
			throw ex;
		}
		catch (Exception ex) {
			throw new SystemException(
				"getAttemptCompletionAmountForEvaluation failed [ActivityID:" + activity.getIdentifier() + "]",
				ex);
		}
	}

	/**
	 * attempt completion amount ̎擾<BR>
	 * ( use current attempt completion status ɂȂ )<BR>
	 *
	 * @return	x<BR>
	 *			0.01.0̏<BR>
	 */
	public BigDecimal getAttemptCompletionAmount() throws SystemException {
		try {
			if (activity.hasAvailableChildren()) {
				return attemptCompletionAmount;
			}

			return getAttemptCompletionStatus() ? one : zero;
		}
		catch (SystemException ex) {
			throw ex;
		}
		catch (Exception ex) {
			throw new SystemException(
				"getAttemptCompletionAmount failed [ActivityID:" + activity.getIdentifier() + "]",
				ex);
		}
	}

	/**
	 * attempt completion status̃Zbg<BR>
	 *
	 * @param status	true:wK<BR>
	 *					false:wK<BR>
	 */
	public void setAttemptCompletionStatus(boolean status) {
		attemptCompletionStatus = status;
	}

	/**
	 * attempt completion status ̎擾<BR>
	 *
	 * @return boolean	attempt completion status Ԃ<BR>
	 *					true : <BR>
	 *					false : <BR>
	 */
	public boolean getAttemptCompletionStatusForEvaluation() throws SystemException {
		try {
			if (!activity.isRoot()
				&& !activity.getParent().getSequencing().getControlModeFlag("useCurrentAttemptProgressInfo")) {
				return previousAttemptCompletionStatus[0];
			}

			return getAttemptCompletionStatus();
		}
		catch (SystemException ex) {
			throw ex;
		}
		catch (Exception ex) {
			throw new SystemException(
				"getAttemptCompletionStatusForEvaluation failed [ActivityID:" + activity.getIdentifier() + "]",
				ex);
		}
	}

	/**
	 * attempt completion status ̎擾<BR>
	 *
	 * @return boolean	attempt completion status Ԃ<BR>
	 *					true : <BR>
	 *					false : <BR>
	 */
	public boolean getAttemptCompletionStatus(boolean isCurrent) throws SystemException {
		try {
			if (activity.isRoot()){
				return getAttemptCompletionStatus();
			}
			
			if(!activity.getParent().getSequencing().getControlModeFlag("useCurrentAttemptProgressInfo")) {
				return getAttemptCompletionStatus();
			}
			else
			{
				if(isCurrent){
					return getAttemptCompletionStatus();
				}
				else // false̎͏falseԂ
				{
					return false;
				}
			}

			
		}
		catch (SystemException ex) {
			throw ex;
		}
		catch (Exception ex) {
			throw new SystemException(
				"getAttemptCompletionStatusForEvaluation failed [ActivityID:" + activity.getIdentifier() + "]",
				ex);
		}
	}
	/**
	 * attempt completion status ̎擾<BR>
	 * ( use current attempt completion status ɂȂ)<BR>
	 *
	 * @return boolean	true wKԂɂ<BR>
	 *					false wKԂɂ<BR>
	 */
	public boolean getAttemptCompletionStatus() throws SystemException {
		try {
			if ((!activity.hasChildren()) && (!activity.hasAvailableChildren())) {
				Boolean result = activity.getCommunicationModule().getAttemptCompletionStatus();

				if (result != null) {
					return result.booleanValue();
				}
			}

			return attemptCompletionStatus;
		}
		catch (SystemException ex) {
			throw ex;
		}
		catch (Exception ex) {
			throw new SystemException(
				"getAttemptCompletionStatus failed [ActivityID:" + activity.getIdentifier() + "]",
				ex);
		}
	}

	/**
	 * attempt absolute duration ւ̃Zbg
	 *
	 * @param duration attempt absolute duration<BR>
	 */
	public void setAttemptAbsoluteDuration(Duration duration) {
		attemptAbsoluteDuration = duration;
	}

	/**
	 *  attempt absolute duration ̎擾<BR>
	 *
	 *  @return activity attempt absolute duration<BR>
	 */
	public Duration getAttemptAbsoluteDurationForEvaluation() throws SystemException {
		try {
			if (!activity.isRoot()
				&& !activity.getParent().getSequencing().getControlModeFlag("useCurrentAttemptProgressInfo")) {
				return previousAttemptAbsoluteDuration[0];
			}

			return getAttemptAbsoluteDuration();
		}
		catch (SystemException ex) {
			throw ex;
		}
		catch (Exception ex) {
			throw new SystemException(
				"getAttemptAbsoluteDurationForEvaluation failed [ActivityID:" + activity.getIdentifier() + "]",
				ex);
		}
	}

	/**
	 *  attempt absolute duration ̎擾<BR>
	 *
	 *  @return activity attempt absolute duration<BR>
	 */
	public Duration getAttemptAbsoluteDuration() {
		return attemptAbsoluteDuration;
	}

	/**
	 * attempt experienced duration ̃Zbg<BR>
	 *
	 * @param  duration activity attempt experienced duration<BR>
	 */
	public void setAttemptExperiencedDuration(Duration duration) {
		attemptExperiencedDuration = duration;
	}

	/**
	 * attempt experienced duration ̎擾<BR>
	 *
	 *  @return duration ANeBreB̊wK񖈂̎wK<BR>
	 */
	public Duration getAttemptExperiencedDurationForEvaluation() throws SystemException {
		try {
			if (!activity.isRoot()
				&& !activity.getParent().getSequencing().getControlModeFlag("useCurrentAttemptProgressInfo")) {
				return previousAttemptExperiencedDuration[0];
			}

			return getAttemptExperiencedDuration();
		}
		catch (SystemException ex) {
			throw ex;
		}
		catch (Exception ex) {
			throw new SystemException(
				"getAttemptExperiencedDurationForEvaluation failed [ActivityID:" + activity.getIdentifier() + "]",
				ex);
		}
	}

	/**
	 * attempt experienced duration ̎擾<BR>
	 *
	 *  @return duration ANeBreB̊wK񖈂̎wK<BR>
	 */
	public Duration getAttemptExperiencedDuration() {
		return attemptExperiencedDuration;
	}
}
