/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

//
//	Offline AICCOp[XNX
//			ύX
//				2004.01.08	VK쐬	񞊁@q
//
package jp.co.ntt.lms.lo.Offline.Aicc;


import java.io.*;
import java.util.*;
import java.util.StringTokenizer;
import org.xml.sax.SAXException;

import jp.co.ntt.lms.Common.RDF.*;
import jp.co.ntt.lms.xmo.util.*;
import jp.co.ntt.lms.lo.Offline.OfflineLog.*;
import jp.co.ntt.lms.lo.*;
import jp.co.ntt.lms.lo.Offline.OfflineLoEnv;


/**
 * AICCOp[XNX
 * <PRE>
 * eF͂ꂽAiccLogXMLf[^p[XADB̃R[h
 * NXɕϊB
 * </PRE>
 */

public class AiccLogConverter
{

	//////////////////////////////////////////////////////////
	//	NXϐ
	//////////////////////////////////////////////////////////

	/** LOID */
	private String mstrLoID = null;

	/** USERID */
	private String mstrUserID = null;

	/** IDێ܂B */
	private String mstrMaterialID = null;

	/** Õt@CpXێ܂B */
	private String mstrLogPath = null;

	/** OfflineO p[XW[ */
	private OfflineDocument mobjOfflineDoc = null;

	/** Offline O Course^Of[^ */
	private OfflineCourse mobjCourse = null;

	/** Offline O items^Of[^ */
	private OfflineItems mobjItems = null;

	/** Offline O loms^Of[^ */
	private OfflineLoms mobjLoms = null;

	/** LOLogRecord */
	private LoLogRecord mobjLoLogRecord = null;

	/** LOLogSessionRecord */
	private LoLogSessionRecord[] mobjLoLogSessionRecords = null;

	/** AiccCoreRecord */
	private AiccCoreRecord[] mobjAiccCoreRecords = null ;

	/** SectionLogRecord */
	private SectionLogRecord[] mobjSectionLogRecords = null ;

	/** AiccInteractionRecord */
	private AiccInteractionRecord[] mobjAiccInteractionRecords = null;

	/** AiccCommentRecord */
	private AiccCommentRecord[] mobjAiccCommentRecords = null;

	/** AiccObjectivesRecord */
	private AiccObjectivesRecord[] mobjAiccObjectivesRecords = null;

	/** Aicc̋ID */
	private String mstrCourseID = null;

	/** AiccBLOCKID */
	private String mstrBlockID = null;

	/** Aicc̃bXID */
	private String mstrLessonID = null;

	/** AiccUID */
	private String mstrUid = null;

	/** ލ\ێ܂ */
	private RDFNode mobjRDFNode = null;

	/** ZbVID[mcnt](wK)L[ɂāAێ܂B */
	private Hashtable mhtbSessionID = new Hashtable();

	//G[bZ[W
	private static final String WRONG_ARGUMENT = "p[^słB";
	private static final String FAIL_PARSE = "p[XɎs܂B";
	private static final String NO_EXIST_COURSE = "course^O݂܂B";
	private static final String NO_EXIST_ITEMS = "items^O݂܂B";
	private static final String NO_EXIST_LOMS = "loms^O݂܂B";
	private static final String FAIL_LOLOGSESSION = "LOLogSessionR[h1쐬ł܂łB";

	// Ot@Co
	private static final String LOG_PRE = "OfflineLO:OAbv[h:p[X:";
	private static final String START_INF_LOG = LOG_PRE + "Jn܂B:";
	private static final String END_INF_LOG = LOG_PRE + "I܂B:";

	/**
	*	RXgN^<br>
	*	XMLf[^p[XăCX^X𐶐܂B
	*	@param strFilePath Ot@CpX
	*/
	public AiccLogConverter( String strUserID, String strLoID, String strMaterialID, String strLogPath ){
		mstrUserID = strUserID;
		mstrLoID = strLoID;
		mstrMaterialID = strMaterialID;
		mstrLogPath = strLogPath;
	}


	/**
	 *	XMLf[^p[X܂B<BR>
	 *	R[h쐬܂̂ŁAOLoID,SessionID,UesrIDݒ肵ĂB
	 *	@exception SAXException p[XɎsꍇ
	 *	@exception IOException f[^ǂݍ݂Ɏsꍇ
	 *	@exception AiccParseException ُ̏ꍇ
	 */
	public void parse() throws SAXException,AiccParseException,IOException
	{
		if ( mstrLogPath == null || mstrLoID == null || mstrUserID == null || mstrMaterialID == null ){
			throw new AiccParseException(WRONG_ARGUMENT);
		}

		// @debug P̃eXgpf[^쐬
		DebugLog.write( this.getClass(), START_INF_LOG + mstrLogPath, DebugLog.MID );

		mobjOfflineDoc = new OfflineDocument();

		try {
			mobjOfflineDoc.parse(mstrLogPath);
		}
		catch( OfflineLogParseException oe ) {
			DebugLog.write( this.getClass(), oe.getMessage(), DebugLog.HIGHT );
			DebugLog.write( this.getClass(), oe, DebugLog.HIGHT );
			throw new AiccParseException( FAIL_PARSE );
		}

		try {

			OfflineLoEnv objEnv = new OfflineLoEnv();

			String strMaterialPath = objEnv.getMaterialPath() + "/" + mstrMaterialID + "/" + mstrMaterialID + ".xml";

			// ލ\ǂݍ
			RDFDocument objDoc = new RDFDocument();
			mobjRDFNode = objDoc.load( strMaterialPath );
			// ID̐ݒ
			mstrCourseID = mobjRDFNode.getID();
		}
		catch( LOException le ) {
			// @log
			DebugLog.write( this.getClass(), le, DebugLog.HIGHT );
			throw new AiccParseException( le.getMessage() );
		}
		catch( RDFParseException rp ) {
			// @log
			DebugLog.write( this.getClass(), rp, DebugLog.HIGHT );
			throw new AiccParseException(rp.getMessage());
		}

		// ItCOcourse擾܂B擾łȂꍇ̓G[Ƃ܂B
		mobjCourse = mobjOfflineDoc.getCourse();
		if( mobjCourse == null ) {
			// @log
			DebugLog.write( this.getClass(), NO_EXIST_COURSE, DebugLog.HIGHT );
			throw new AiccParseException( FAIL_PARSE );
		}

		// ItCOitems擾܂B擾łȂꍇ̓G[Ƃ܂B
		mobjItems = mobjOfflineDoc.getItems();
		if( mobjItems == null ) {
			// @log
			DebugLog.write( this.getClass(), NO_EXIST_ITEMS, DebugLog.HIGHT );
			throw new AiccParseException( FAIL_PARSE );
		}

		// ItCOloms擾܂B擾łȂꍇ̓G[Ƃ܂B
		mobjLoms = mobjOfflineDoc.getLoms();
		if( mobjLoms == null ) {
			// @log
			DebugLog.write( this.getClass(), NO_EXIST_LOMS, DebugLog.HIGHT );
			throw new AiccParseException( FAIL_PARSE );
		}

		// LoLogSession쐬܂B
		mobjLoLogSessionRecords = makeLoLogSessionRecords();

		// LoLogSessionR[h1쐬łȂꍇ̓G[Ƃ
		if( mobjLoLogSessionRecords.length == 0 ) {
			throw new AiccParseException( FAIL_LOLOGSESSION );
		}

		// LoLog쐬܂B
		mobjLoLogRecord = makeLoLogRecord();

		// OL_AiccCore쐬܂B
		mobjAiccCoreRecords = makeAiccCoreRecords();

		// OL_AiccInteraction쐬܂B
		mobjAiccInteractionRecords = makeAiccInteractionRecords();

		// OL_AiccComments 쐬܂B
		mobjAiccCommentRecords = makeAiccCommentRecords();

		// OL_AiccObjectives 쐬܂B
		mobjAiccObjectivesRecords = makeAiccObjectivesRecords();

		// OL_SelcionLog 쐬܂B
		mobjSectionLogRecords = makeSectionLogRecords();

		// @LOG >info >5
		DebugLog.write( this.getClass(), END_INF_LOG + mstrLogPath, DebugLog.MID );
	}



	/**
	*	AiccCoreRecordzԋp܂B<br>
	*	R[h݂Ȃꍇ́Anullԋp܂B
	*	@return AiccCoreRecord[] AiccCoreRecordz
	*/
	public AiccCoreRecord[] getAiccCoreRecords()
	{
		return mobjAiccCoreRecords;
	}

	/**
	*	SectionLogRecordzԋp܂B<br>
	*	R[h݂Ȃꍇ́Anullԋp܂B
	*	@return SectionLogRecord[] SectionLogRecordz
	*/
	public SectionLogRecord[] getSectionLogRecords()
	{
		return mobjSectionLogRecords;
	}

	/**
	*	AiccInteractionRecordzԋp܂B<br>
	*	R[h݂Ȃꍇ́Anullԋp܂B
	*	@return AiccCoreRecord[] AiccInteractionRecordz
	*/
	public AiccInteractionRecord[] getAiccInteractionRecords()
	{
		return mobjAiccInteractionRecords;
	}

	/**
	*	AiccCommentRecordzԋp܂B<br>
	*	R[h݂Ȃꍇ́Anullԋp܂B
	*	@return AiccCommentRecord[] AiccCommentRecordz
	*/
	public AiccCommentRecord[] getAiccCommentRecords()
	{
		return mobjAiccCommentRecords;
	}

	/**
	*	AiccObjectivesRecordzԋp܂B<br>
	*	R[h݂Ȃꍇ́Anullԋp܂B
	*	@return AiccObjectivesRecord[] AiccObjectivesRecordz
	*/
	public AiccObjectivesRecord[] getAiccObjectivesRecords()
	{
		return mobjAiccObjectivesRecords;
	}

	/**
	 * LoLogRecordԋp܂
	 * @return LoLogRecord
	 */
	public LoLogRecord getLoLogRecord() {
		return mobjLoLogRecord;
	}

	/**
	 * LoLogSessionzԋp܂
	 * @return LoLogSessionRecord[]
	 */
	public LoLogSessionRecord[] getLoLogSessionRecords() {
		return mobjLoLogSessionRecords;
	}


	/**
	 * LoLogSessionR[h𐶐܂
	 * @exception AiccParseException Oŝ߁AR[hłȂꍇ
	 */
	private LoLogSessionRecord[] makeLoLogSessionRecords()
		throws AiccParseException
	{
		// ZbVR[h擾B
		int intSesCount = mobjCourse.getSesLength();

		// ZbVID쐬
		int intSessionID = 1;

		Vector vecSesRecord = new Vector();

		for( int i = 0; i < intSesCount; i++ ) {

			// ItCOcourse-org-ses擾
			OfflineCourseSes objSes = mobjCourse.getSes(i);

			// wK񐔂擾
			int intMCNT = objSes.getMCNT();

			// wK񐔂ݒ肳Ă( 0 ȏ )̂݃R[h쐬
			if( intMCNT >= 0 ) {

				// ZbVID̍쐬
				String strSessionID = Integer.toString( intSessionID );

				// wK񐔂L[ɂSessionIDۑ
				mhtbSessionID.put( new Integer( intMCNT ), strSessionID );

				// CX^X
				LoLogSessionRecord objSesRecord = new LoLogSessionRecord();

				// [UID̐ݒ
				objSesRecord.setUserID( mstrUserID );
				// LOID̐ݒ
				objSesRecord.setLoID( mstrLoID );
				// SessionID̐ݒ
				objSesRecord.setSessionID( strSessionID );

				// wKJnt̐ݒ
				if( objSes.getSDDate() != null ) {
					objSesRecord.setStudyStartDate( XMODate.parseTime( objSes.getSDDate() ) );
				}

				// ݐϑ؍ݎԂ̐ݒ
				if( objSes.getSTLong() >= 0 ) {
					objSesRecord.setResidanceTime( Long.toString( objSes.getSTLong() ) );
				}

				// iEt̐ݒ
				char chrStatus = objSes.getStatusChar();

				// Xe[^XiȂAiE
				if( chrStatus == OfflineLogConst.PASSED_STATUS ) {
					if( objSes.getEDDate() != null ) {
						objSesRecord.setPassday( XMODate.parseTime( objSes.getEDDate() ) );
						objSesRecord.setStudyEndDate( XMODate.parseTime( objSes.getEDDate() ) );
					}
				}
				// Xe[^XȂA
				else if( chrStatus == OfflineLogConst.COMPLETED_STATUS ) {
					if( objSes.getEDDate() != null ) {
						objSesRecord.setStudyEndDate( XMODate.parseTime( objSes.getEDDate() ) );
					}
				}

				// R[hxN^[ɒǉ
				vecSesRecord.add( objSesRecord );

				// ZbVIDvX
				intSessionID++;
			}
		}

		LoLogSessionRecord[] objSesRecord = new LoLogSessionRecord[vecSesRecord.size()];
		vecSesRecord.copyInto( objSesRecord );

		return objSesRecord;

	}

	/**
	 * LoLogR[h쐻܂B
	 * @exception AiccParseException Oŝ߁AR[hłȂꍇ
	 */
	private LoLogRecord makeLoLogRecord()
		throws AiccParseException
	{
		LoLogRecord objLoLogRecord = new LoLogRecord();

		// [UID̐ݒ
		objLoLogRecord.setUserID( mstrUserID );
		// LOID̐ݒ
		objLoLogRecord.setLoID( mstrLoID );

		// wKJnԂ̐ݒ
		objLoLogRecord.setStudyStartDate( XMODate.parseTime( mobjCourse.getSDDate() ) );

		// ݐϑ؍ݎԂ̐ݒ
		if( mobjCourse.getTTLong() >= 0 ) {
			objLoLogRecord.setResidanceTime( Long.toString( mobjCourse.getTTLong() ) );
		}

		// ANZX񐔂̐ݒ
		objLoLogRecord.setAccessCnt( Integer.toString(mobjCourse.getSesLength()) );

		return objLoLogRecord;
	}

	/**
	 * ׂĂAiccCoreR[h𐶐܂B
	 * @exception AiccParseException Oŝ߁AR[hłȂꍇ
	 */
	private AiccCoreRecord[] makeAiccCoreRecords()
		throws AiccParseException
	{
		// ZbVR[h擾B
		int intSesCount = mobjCourse.getSesLength();

		Vector vecAiccCoreRecord = new Vector();

		// lomR[h擾B
		int intLomCount = mobjLoms.getLomLength();

		// ZbVR[hCoreR[h𐶐B
		for( int i = 0; i < intSesCount; i++ ) {

			// lom^O[vB
			for( int j = 0; j < intLomCount; j++ ) {

				// ꌏCoreR[h쐻
				AiccCoreRecord objTempRecord = makeAiccCoreRecord( i, j );
				if( objTempRecord != null ) {
					vecAiccCoreRecord.add( objTempRecord );
				}
			}
		}

		// zւ̃Rs[
		AiccCoreRecord[] objRecList = new AiccCoreRecord[vecAiccCoreRecord.size()];
		vecAiccCoreRecord.copyInto( objRecList );

		return objRecList;
	}

	/**
	 *	AiccLogvfz̑SInteractionR[h܂B<br>
	 * @exception AiccParseException Oŝ߁AR[hłȂꍇ
	 */
	private AiccInteractionRecord[] makeAiccInteractionRecords()
		throws AiccParseException
	{
		Vector vecAiccInteractionRecord = new Vector();

		// lomR[h擾B
		int intLomCount = mobjLoms.getLomLength();

		// lomR[h[v
		for( int i = 0; i < intLomCount; i++ ) {

			OfflineLom objLom = mobjLoms.getLom( i );

			int intBkCount= objLom.getBkLength();

			// lom^O[vB
			for( int j = 0; j < intBkCount; j++ ) {

				OfflineBk objBk = objLom.getBk(j);

				int intBkLogCount = objBk.getBkLogLength();

				for( int n = 0; n < intBkLogCount; n++ ) {
					OfflineBkLog objBkLog = objBk.getBkLog( n );
					// ꌏCoreR[h쐻
					AiccInteractionRecord objTempRecord = makeAiccInteractionRecord( objLom, objBk, objBkLog );

					if( objTempRecord != null ) {
						vecAiccInteractionRecord.add( objTempRecord );
					}
				}
			}
		}

		// zւ̃Rs[
		AiccInteractionRecord[] objRecList = new AiccInteractionRecord[vecAiccInteractionRecord.size()];
		vecAiccInteractionRecord.copyInto( objRecList );

		return objRecList;
	}

	/**
	 * ׂĂAiccCommentR[h𐶐܂B
	 * @exception AiccParseException Oŝ߁AR[hłȂꍇ
	 */
	private AiccCommentRecord[] makeAiccCommentRecords()
		throws AiccParseException
	{

		Vector vecAiccCommentRecord = new Vector();

		// lomR[h擾B
		int intLomCount = mobjLoms.getLomLength();

		// course-sesmcnt̍ől擾
		int intMaxMcnt = mobjCourse.getMaxMcnt();

		// ől擾łȂꍇ0̔zԂB
		if( intMaxMcnt == -1 ) {
			return new AiccCommentRecord[0];
		}

		// lom^O[vB
		for( int i = 0; i < intLomCount; i++ ) {

			OfflineLom objLom = mobjLoms.getLom(i);
			OfflineCmi objCmi = objLom.getCmi();

			// Rg^O݂ꍇ̂ݍ쐬
			if( objCmi.getComments() != null ) {
				// ꌏCommentR[h쐻
				AiccCommentRecord objTempRecord = makeAiccCommentRecord( objLom, intMaxMcnt );
				// nullł͖ꍇ̂Vectorɒǉ
				if( objTempRecord != null ) {
					vecAiccCommentRecord.add( objTempRecord );
				}
			}
		}

		// zւ̃Rs[
		AiccCommentRecord[] objRecList = new AiccCommentRecord[vecAiccCommentRecord.size()];
		vecAiccCommentRecord.copyInto( objRecList );

		return objRecList;
	}

	/**
	 *	AiccLogvfz̑SObjectivesR[h܂B<br>
 	 *	@param Element AiccLogPvf
	 *	@param Vector  Objectivesi[Vector
	 *
	 */
	private AiccObjectivesRecord[] makeAiccObjectivesRecords()
		throws AiccParseException
	{


		Vector vecAiccObjectivesRecord = new Vector();

		// lomR[h擾B
		int intLomCount = mobjLoms.getLomLength();

		// course-sesmcnt̍ől擾
		int intMaxMcnt = mobjCourse.getMaxMcnt();

		// ől擾łȂꍇ0̔zԂB
		if( intMaxMcnt == -1 ) {
			return new AiccObjectivesRecord[0];
		}

		// lom^O[vB
		for( int i = 0; i < intLomCount; i++ ) {

			OfflineLom objLom = mobjLoms.getLom(i);

			OfflineCmi objCmi = objLom.getCmi();
			OfflineCmiObjectives objObjectives = objCmi.getObjectives();

			if( objObjectives != null ) {

				int intObjCount = objObjectives.getObjectivesLogLength();

				for( int j = 0; j < intObjCount; j++ ) {

					OfflineCmiObjectivesLog objObjectivesLog = objObjectives.getObjectivesLog(j);
					// ꌏObjectivesR[h쐬
					AiccObjectivesRecord objTempRecord = makeAiccObjectivesRecord( objLom, objObjectivesLog, intMaxMcnt );
					// nullł͖ꍇ̂VectorɊi[
					if( objTempRecord != null ) {
						vecAiccObjectivesRecord.add( objTempRecord );
					}
				}
			}
		}

		// zւ̃Rs[
		AiccObjectivesRecord[] objRecList = new AiccObjectivesRecord[vecAiccObjectivesRecord.size()];
		vecAiccObjectivesRecord.copyInto( objRecList );

		return objRecList;
	}



	/**
	 * CoreR[h𐶐܂B<br>
	 * @param intSesIndex ZbVCfbNX
	 * @param intLomIndex lomCfbNX
	 * @return AiccCoreRecord R[h
	 * @exception AiccParseException Oŝ߁AR[hłȂꍇ
	 */
	private AiccCoreRecord makeAiccCoreRecord(	int intSesIndex,
												int intLomIndex
												)
		throws AiccParseException
	{
		// ItCÕZbV擾
		OfflineCourseSes objCourseSes = mobjCourse.getSes( intSesIndex );

		int intMCNT = objCourseSes.getMCNT();

		// ZbVID擾
		String strSessionID = (String)mhtbSessionID.get( new Integer( intMCNT ) );

		// ZbVID擾łȂꍇnullԂB
		if( strSessionID == null ) {
			return null;
		}

		// ZbVID݂ꍇ̂ݍ쐬

		// lomf[^擾
		OfflineLom objLom = mobjLoms.getLom( intLomIndex );
		String strElementID = objLom.getID();

		// cmif[^擾
		OfflineCmi objCmi = objLom.getCmi();

		// CoreR[h̃CX^X
		AiccCoreRecord result = new AiccCoreRecord();

		// [UID̐ݒ
		result.setUserID(mstrUserID);

		// LOID̐ݒ
		result.setLoID(mstrLoID);

		// ZbVID̐ݒ
		result.setSessionID(strSessionID);

		// UID̐ݒ
		// ލ\YGgIDm[h擾
		String strUid = getUid( strElementID );
		if( strUid == null ) {
			// UID擾łȂꍇ̓R[h쐬Ȃ
			return null;
		}
		result.setUid( strUid );

	   	// Yitem-org-ses擾
		OfflineItem objItem = mobjItems.getItemFromID( strElementID );

		// LessonStatus̐ݒ
		if( objItem != null ){
			String strStatus = objItem.getStatus( intMCNT );
			//LessonStatus0̏ꍇAK₵ĂȂGg̈OL_AiccCoree[uɃZbgȂB
			if( strStatus == null ){
				return null;
			}
			result.setLessonStatus( strStatus );
		}

		// raw̐ݒ
		if( objItem != null ){
			String strRawScore = objItem.getRawScore( intMCNT );
			result.setRawScore( strRawScore );
		}

		// max̐ݒ
		if( objItem != null ){
			String strMaxScore = objItem.getMaxScore( intMCNT );
			result.setMaxScore( strMaxScore );
		}

		// min̐ݒ
		if( objItem != null ){
			String strMinScore = objItem.getMinScore( intMCNT );
			result.setMinScore( strMinScore );
		}


		// 擾łꍇ̂ݍvԂ擾
		if( objItem != null ) {
			// Y񐔂̍vԂ擾
			String strTime = objItem.getTotalSt( intMCNT );
			result.setStayTime( strTime );
		}

		// Lesson_Location̐ݒ
		result.setLessonLocation( objCmi.getLessonLocation() );

		// exit̐ݒ
		result.setExist( objCmi.getExit() );

		return result;
	}


	/**
	 * ׂĂSectionLogR[h𐶐܂B<br>
	 * @return 擾m[hBm[h擾łȂꍇnullԂB
	 * @exception AiccParseException Oŝ߁AR[hłȂꍇ
	 */
	private SectionLogRecord[] makeSectionLogRecords()
		throws AiccParseException
	{
		Vector vecSectionLogRecord = new Vector();

		// item擾
		int intItemCount = mobjItems.getItemLength();

		// ZNVR[h쐬
		for( int i = 0; i < intItemCount; i++ ) {

			OfflineItem objItem = mobjItems.getItem(i);

			char chrType = objItem.getTypeChar();

			// ubNvf̂SectionLogR[h쐬
			if( chrType == OfflineLogConst.BLOCK_TYPE ) {

				// item̃ZbV擾
				int intSesCount = objItem.getSesLength();


				for( int j = 0; j < intSesCount; j++ ) {

					OfflineItemSes objSes = objItem.getSes(j);

					// 1SectionLogR[h쐬
					SectionLogRecord objTempRecord = makeSectionLogRecord( objItem, objSes );

					if( objTempRecord != null ) {
						vecSectionLogRecord.add( objTempRecord );
					}
				}

			}
		}

		// zւ̃Rs[
		SectionLogRecord[] objRecList = new SectionLogRecord[vecSectionLogRecord.size()];
		vecSectionLogRecord.copyInto( objRecList );

		return objRecList;
	}

	/**
	 * CoursẽZbV񂩂1SectionLogR[h𐶐܂B<br>
	 * @param objSes Course-ses
	 * @return 擾m[h
	 * @exception AiccParseException Oŝ߁AR[hłȂꍇ
	 */
	private SectionLogRecord makeSectionLogRecord( OfflineItem objItem, OfflineItemSes objSes )
		throws AiccParseException
	{
		// wK񐔂̎擾
		int intMCNT = objSes.getMCNT();

		// SessionID擾
		String strSessionID = (String)mhtbSessionID.get( new Integer( intMCNT ) );

		// ZbVID擾łȂꍇnullԂB
		if( strSessionID == null ) {
			return null;
		}

		// R[h̃CX^X
		SectionLogRecord result = new SectionLogRecord();

		// [UID̐ݒ
		result.setUserID(mstrUserID);
		// LOID̐ݒ
		result.setLoID(mstrLoID);

		// ZbVID̐ݒ
		result.setSessionID( strSessionID );

		// Uid̐ݒ(R[XIDݒ肷)
		String strUid = getUid( objItem.getID() );
		if( strUid == null ) {
			// UID擾łȂꍇ̓R[h쐬Ȃ
			return null;
		}
		result.setUid( strUid );

		// Lesson_Status̐ݒ
		result.setLessonStatus( objSes.getStatus() );

		// time̐ݒ
		result.setTime( objSes.getST() );

		return result;
	}

	/**
	 * InteractionR[h𐶐܂B<br>
	 * @param childElementName Gg<br>
	 * @param objLom Lom
	 * @param objBk Bk
	 * @return AiccInteractionRecord 擾m[h
	 * @exception AiccParseException Oŝ߁AR[hłȂꍇ
	 */
	private AiccInteractionRecord makeAiccInteractionRecord( OfflineLom objLom, OfflineBk objBk, OfflineBkLog objBkLog )
		throws AiccParseException
	{

		AiccInteractionRecord result = new AiccInteractionRecord();

		// wK
		int intMCNT = objBk.getMCNT();
		// \
		int intNCNT = objBk.getNCNT();

		// ZbVID擾
		String strSessionID = (String)mhtbSessionID.get( new Integer( intMCNT ) );

		// ZbVID擾łȂꍇnullԂB
		if(strSessionID == null ) {
			return null;
		}

		// [UID̐ݒ
		result.setUserID(mstrUserID);

		// LOID̐ݒ
		result.setLoID(mstrLoID);

		// ZbVID̐ݒ
		result.setSessionID( strSessionID );

		// course_id̐ݒ
		result.setCourseID( mstrCourseID );

		// UID̐ݒ
		String strElementID = objLom.getID();
		String strUid = getUid( strElementID );
		if( strUid == null ) {
			// UID擾łȂꍇ̓R[h쐬Ȃ
			return null;
		}
		result.setUid( strUid );

		// student_id̐ݒ
		result.setStudentID( mobjCourse.getSID() );

		// lesson_id̐ݒ
		result.setLessonID( strElementID );

		// response_times̐ݒ
		result.setResponseTimes( Integer.toString( objBkLog.getTagNo() ) );

		// tƎԂ̐ݒ
		OfflineItemSes objItemSes = mobjItems.getSesFromIdMcntNcnt( strElementID, intMCNT, intNCNT );
		// ݂ꍇ̂ݐݒ肷
		if( objItemSes != null ) {
			String strSD = objItemSes.getSD();
			String strDate = null;
			String strTime = null;
			if( strSD != null && strSD.indexOf( " " ) >= 0 ) {
				strDate = strSD.substring( 0, strSD.indexOf( ' ' ) );
				// t':''/'ɕϊւ
				strDate = strDate.replace( ':', '/' );
				strTime = strSD.substring( strSD.indexOf( ' ' ) + 1, strSD.length() );
			}
			// t̐ݒ
			result.setDate( strDate );
			// Ԃ̐ݒ
			result.setTime( strTime );
		}

		// interaction_id ̐ݒ
		result.setInteractionID( objBkLog.getID() );

		// objective_id̐ݒ
		result.setObjectiveID( objBkLog.getObjectivesID() );

		// type_interaction̐ݒ
		result.setTypeInteraction( objBkLog.getType()  );

		// correct_response̐ݒ
		result.setCorrectResponse( objBkLog.getCorrectResponse() );

		// student_response̐ݒ
		result.setStudentResponse( objBkLog.getStudentResponse() );

		// result̐ݒ
		result.setResult( objBkLog.getResult() );

		// weighting ̐ݒ
		result.setWeighting( objBkLog.getWeighting() );

		// latency ̐ݒ
		result.setLatency( objBkLog.getLatency() );

		return result;
	}





	/**
	 * 1CommentR[h𐶐܂B<br>
	 * @param objLom lomGgf[^
	 * @int intMaxMcnt ő̊wK
	 * @return 擾m[h
	 * @exception AiccParseException Oŝ߁AR[hłȂꍇ
	 */
	private AiccCommentRecord makeAiccCommentRecord( OfflineLom objLom, int intMaxMcnt )
		throws AiccParseException
	{

		// ZbVID擾
		String strSessionID = (String)mhtbSessionID.get( new Integer( intMaxMcnt ) );

		// ZbVID擾łȂꍇnullԂB
		if( strSessionID == null ) {
			return null;
		}

		AiccCommentRecord result = new AiccCommentRecord();

		// cmi擾
		OfflineCmi objCmi = objLom.getCmi();

		// [UIDݒ肵܂B
		result.setUserID(mstrUserID);

		// LOIDݒ肵܂B
		result.setLoID(mstrLoID);

		// ZbVIDݒ肵܂B
		result.setSessionID( strSessionID );

		// course_idݒ肷
		result.setCourseID( mstrCourseID );

		// student_idݒ肷
		result.setStudentID( mobjCourse.getSID() );

		// uidݒ肷
		String strUid = getUid( objLom.getID() );
		if( strUid == null ) {
			// UID擾łȂꍇ̓R[h쐬Ȃ
			return null;
		}
		result.setUid( strUid );

		// lesson_idݒ肷
		result.setLessonID( objLom.getID() );

		// DateTime̐ݒ
		OfflineItemSes objItemSes = mobjItems.getSesFromIdMcntNcnt( objLom.getID(), intMaxMcnt, 1 );
		// 擾łꍇ̂ݐݒ肷
		if( objItemSes != null ) {

			String strSD = objItemSes.getSD();
			String strDate = null;
			String strTime = null;
			if( strSD != null && strSD.indexOf( " " ) >= 0 ) {
				strDate = strSD.substring( 0, strSD.indexOf( ' ' ) );
				// t':''/'ɕϊւ
				strDate = strDate.replace( ':', '/' );
				strTime = strSD.substring( strSD.indexOf( ' ' ) + 1, strSD.length() );
			}
			result.setDate( strDate );
			result.setTime( strTime );
		}

		// comment̐ݒ
		result.setComment( objCmi.getComments() );


		return result;
	}





	/**
	 * 1ObjectivesR[h𐶐܂B<br>
	 * @param objLom lomGgf[^
	 * @param objObjectives objectivesGgf[^
	 * @int intMaxMcnt ő̊wK
	 * @return 擾m[h
	 * @exception AiccParseException Oŝ߁AR[hłȂꍇ
	 *
	 */
	private AiccObjectivesRecord makeAiccObjectivesRecord(
			OfflineLom objLom,
			OfflineCmiObjectivesLog objObjectives,
			int intMaxMcnt )
		throws AiccParseException
	{

		// ZbVID擾
		String strSessionID = (String)mhtbSessionID.get( new Integer(intMaxMcnt) );

		// ZbVID擾łȂꍇnullԂB
		if( strSessionID == null ) {
			return null;
		}

		AiccObjectivesRecord result = new AiccObjectivesRecord();

		// [UID̐ݒ
		result.setUserID(mstrUserID);

		// LOID̐ݒ
		result.setLoID(mstrLoID);

		// SessionID̐ݒ
		result.setSessionID( strSessionID );

		// uid̐ݒ
		String strUid = getUid( objLom.getID() );
		if( strUid == null ) {
			// UID擾łȂꍇ̓R[h쐬Ȃ
			return null;
		}
		result.setUid( strUid );

		// course_id̐ݒ
		result.setCourseID( mstrCourseID );

		// student_id̐ݒ
		result.setStudentID( mobjCourse.getSID() );

		// lesson_id̐ݒ
		result.setLessonID( objLom.getID() );

		// DateTime̐ݒ
		OfflineItemSes objItemSes = mobjItems.getSesFromIdMcntNcnt( objLom.getID(), intMaxMcnt, 1 );
		// 擾łꍇ̂ݐݒ肷
		if( objItemSes != null ) {

			String strSD = objItemSes.getSD();
			String strDate = null;
			String strTime = null;
			if( strSD != null && strSD.indexOf( " " ) >= 0 ) {
				strDate = strSD.substring( 0, strSD.indexOf( ' ' ) );
				// t':''/'ɕϊւ
				strDate = strDate.replace( ':', '/' );
				strTime = strSD.substring( strSD.indexOf( ' ' ) + 1, strSD.length() );
			}
			result.setDate( strDate );
			result.setTime( strTime );
		}

		// objective_id̐ݒ
		result.setObjectiveID( objObjectives.getID() );

		// raw̐ݒ
		result.setRawScore( objObjectives.getRaw() );

		// max̐ݒ
		result.setMaxScore( objObjectives.getMax() );

		// min̐ݒ
		result.setMinScore( objObjectives.getMin() );

		// status̐ݒ
		result.setStatus( objObjectives.getStatus() );

		return result;
	}


	/**
	 * ލ\YGgIDUID擾B
	 * @param strElementID GgID
	 * @return String UID
	 * @exception AiccParseException YGg݂Ȃꍇ
	 */
	private String getUid( String strSystemID )
		throws AiccParseException
	{
		if( strSystemID == null || strSystemID.equals( "" ) ) {
			return null;
		}

		RDFNode objTempNode = mobjRDFNode.searchNodeFromSystemID(strSystemID);
		// ȂꍇnullԂB
		if( objTempNode == null ) {
			return null;
		}
		String strUid = objTempNode.getID();

		return strUid;
	}

}

