/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB
uIWiR[hv́uJҁv́A{dMdbЂłB
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004
{dMdb łB
SĂ̌ۂ܂B
uRgr[^vF_____________________________________


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION.
All Rights Reserved.

Contributor(s) ______________________________________.
*/

//
//	ScormLoDataAccess
//	ύX
//		2004.02.01	VK쐬
//		2004.09.14	M004	A.Shimoma
//

package jp.co.ntt.lms.lo.scorm;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;

import jp.co.ntt.lms.lo.LOException;
import jp.co.ntt.lms.lo.LoDataAccess;
import jp.co.ntt.lms.lo.LoLogEnvironment;
import jp.co.ntt.lms.lo.LoPropertyDef;
import jp.co.ntt.lms.lo.util.IndividualLogSQLMaker;
import jp.co.ntt.lms.xmo.DataAccess;
import jp.co.ntt.lms.xmo.MessageData;
import jp.co.ntt.lms.xmo.Lo.lom.LomDataAccess;
import jp.co.ntt.lms.xmo.util.ChangeEncode;
import jp.co.ntt.lms.xmo.util.DebugLog;

/**
 * SCORM LO  ʃe[u(SCORMLOe[u)ւ̃ANZXNXB<BR>
 * @author T.Nishiki
 */
// 2004.09.14 M004 MOD start NTTR(N)
public class ScormLoDataAccess extends LoDataAccess implements LoPropertyDef {
// 2004.09.14 M004 MOD end
	/**
	 * \nbVL[B
	 */
	public static final String CONDITION_KEY = "condition_key";

	/**
	 * e[úB
	 */
	public static final String TABLE_NAME = "SCORMLO";

	/**
	 * RXgN^B
	 **/
	public ScormLoDataAccess() {
	}

// 2004.09.14 M004 ADD start NTTR(N)

	/**
	 * Scormʃe[ǔs܂
	 *
	 * @param htbParam f[^
	 * @return
	 * @exception LOException LOƎO
	 */
	public synchronized Vector select( Hashtable htbParam ) throws LOException {

		Vector vecRet = new Vector();
		DataAccess objDataAccess = new DataAccess();

		try {
			// gUNV̊Jn
			objDataAccess.trans();
			// NG[ID̎擾
			String strQueryID = ( String ) htbParam.get( LoPropertyDef.QUERY_ID );
			if ( strQueryID == null ) {
				throw new LOException( "NG[IDw肵ĂB" );
			}
			// NG[̎擾
			Vector vecQueryCondition = ( Vector ) htbParam.get( LoPropertyDef.LOG_CONDITION );
			if ( vecQueryCondition == null ) {
				// w肳ĂȂꍇAVector쐬܂B
				vecQueryCondition = new Vector();
			}
			LoLogEnvironment objEnv = LoLogEnvironment.getInstance();
			String strQuery = objEnv.getQueryString( strQueryID );
			PreparedStatement objStatement = objDataAccess.prepareStatement( strQuery );
			// ̐ݒ
			for ( int i = 0; i < vecQueryCondition.size(); i++ ) {
				objStatement.setString( i + 1, ( String ) vecQueryCondition.get( i ) );
			}
			// NG[̎s
			ResultSet rs = objStatement.executeQuery();
			ResultSetMetaData meta = rs.getMetaData();
			int intColCount = meta.getColumnCount();
			Vector vecResult = new Vector();
			while ( rs.next() ) {
				String[] strResult = new String[intColCount];
				for ( int i = 0; i < intColCount; i++ ) {
					strResult[i] = ChangeEncode.setChar( rs.getString( i + 1 ) );
				}
				vecResult.add( strResult );
			}

			String[][] strResult = new String[vecResult.size()][intColCount];
			vecResult.copyInto( strResult );
			// R~bg
			objDataAccess.commit();
			// ʂi[
			vecRet.add( strResult );

		} catch ( SQLException e ) {
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			// [obN
			try {
				objDataAccess.rollback();
			} catch ( Exception ex ) {
			}
			// f[^x[XG[ݒ
			throw new LOException( e.getMessage() );
		}
		return vecRet;
	}

	/**
	 * Scormʃe[ǔs܂
	 *
	 * @param htbParam f[^
	 * @return
	 * @exception LOException LOƎO
	 */
	public synchronized Vector selectCSV( Hashtable htbParam )
		throws LOException {

		Vector vecRet = new Vector();
		DataAccess objDataAccess = new DataAccess();

		try {
			// gUNV̊Jn
			objDataAccess.trans();
			// NG[ID̎擾
			String strQueryID = ( String ) htbParam.get( QUERY_ID );
			if ( strQueryID == null ) {
				throw new LOException( "NG[IDw肵ĂB" );
			}
			// NG[̎擾
			Vector vecQueryCondition = ( Vector ) htbParam.get( LOG_CONDITION );
			if ( vecQueryCondition == null ) {
				// w肳ĂȂꍇAVector쐬܂B
				vecQueryCondition = new Vector();
			}
			LoLogEnvironment objEnv = LoLogEnvironment.getInstance();
			// NG[
			String strQuery = objEnv.getQueryString( strQueryID );
			// [UXg
			String[] strUserID = ( String[] ) htbParam.get( USERID_LIST );
			// UIDXg
			String[] strUID = ( String[] ) htbParam.get( UID_LIST );
			// INɗpJ([UXg)
			String inGroupColumn = ( String ) htbParam.get( IN_COLUMN_USER_LIST );
			// INɗpJ(UIDXg)
			String inUIDColumn = ( String ) htbParam.get( IN_COLUMN_UID_LIST );
			IndividualLogSQLMaker objSqlMaker 
				= new IndividualLogSQLMaker( strQuery, strUserID, strUID, inGroupColumn, inUIDColumn );
			strQuery = objSqlMaker.makeQuery();

			// NG[̎s
			PreparedStatement objStatement = objDataAccess.prepareStatement( strQuery );

			// ̐ݒ
			for ( int i = 0; i < vecQueryCondition.size(); i++ ) {
				objStatement.setString( i + 1, ( String ) vecQueryCondition.get( i ) );
			}

			ResultSet rs = objStatement.executeQuery();
			ResultSetMetaData meta = rs.getMetaData();
			int intColCount = meta.getColumnCount();
			Vector vecResult = new Vector();
			while ( rs.next() ) {
				String[] strResult = new String[intColCount];
				for ( int i = 0; i < intColCount; i++ ) {
					strResult[i] = ChangeEncode.setChar( rs.getString( i + 1 ) );
				}
				vecResult.add( strResult );
			}
			String[][] strResult = new String[vecResult.size()][intColCount];
			vecResult.copyInto( strResult );
			// R~bg
			objDataAccess.commit();
			// ʂi[
			vecRet.add( strResult );

		} catch ( SQLException e ) {
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			// [obN
			try {
				objDataAccess.rollback();
			} catch ( Exception ex ) {
			}
			// f[^x[XG[ݒ
			throw new LOException( e.getMessage() );
		}
		return vecRet;
	}

// 2004.09.14 M004 ADD end

	/**
	 * SCORM LO ތʃe[uɃf[^}܂B<br>
	 * ̃\bhŃgUNV̊JnȂтɏIsĂ܂B<br>
	 *
	 * @param params p[^B<br>
	 * ȉ̒lݒ肳Ă邱Ƃ҂Ă܂B<br>
	 * <table border="1">
	 * 	<tr>
	 * 		<th>L[</th>
	 * 		<th>l</th>
	 * 	</tr>
	 * 	<tr>
	 * 		<td>LOID</td>
	 * 		<td>}郌R[hLOID</td>
	 * 	</tr>
	 * 	<tr>
	 * 		<td>LoPropertyDef.MATERIALID</td>
	 * 		<td>}郌R[h̋ID</td>
	 * 	</tr>
	 * 	<tr>
	 * 		<td>LoPropertyDef.WINHEIGHT</td>
	 * 		<td>}郌R[h̃EBhETCY(c)</td>
	 * 	</tr>
	 * 	<tr>
	 * 		<td>LoPropertyDef.WINWIDTH</td>
	 * 		<td>}郌R[h̃EBhETCY()</td>
	 * 	</tr>
	 * </table><br>
	 * @throws LOException f[^}ŃG[ꍇB
	 */
	public synchronized void insert(Hashtable params) throws LOException {
		// \bhJnO
		DebugLog.write(
			this.getClass(),
			"HEAD insert(" + params + ")",
			DebugLog.ROW);

		// f[^ANZXNX
		DataAccess dataAccess = null;

		try {
			dataAccess = new DataAccess(TABLE_NAME);
			// =================================================================
			// gUNVJn
			dataAccess.trans(params);
			// =================================================================
			// ID̑݃`FbNs܂
			if (dataAccess.isExit(params, LoPropertyDef.MATERIALID)) {
				MessageData message =
					new MessageData(
						"IDdĂ܂B",
						MessageData.WAR_TYPE);
				throw new LOException(message);
			}
			// }
			insertAction(params, dataAccess);
// ADD 2005/02/23 START SUGAWARA [scorm荞]
			LomDataAccess lomAccess = new LomDataAccess();
			lomAccess.enrollEntryData(dataAccess, params);
// ADD 2005/02/23 END SUGAWARA [scorm荞]

			// R~bg
			dataAccess.commit();
		}
		catch (LOException e) {
			DebugLog.write(this.getClass(), e, DebugLog.HIGHT);
			// [obN
			try {
				dataAccess.rollback();
			}
			catch (Exception ex) {
			}
			throw e;
		}
		catch (Exception e) {
			DebugLog.write(this.getClass(), e, DebugLog.HIGHT);
			// [obN
			try {
				dataAccess.rollback();
			}
			catch (Exception ex) {
			}
			throw new LOException(e.getMessage());
		}

		// \bhIO
		DebugLog.write(
			this.getClass(),
			"TAIL insert(" + params + ")",
			DebugLog.ROW);
	}

	/**
	 * SCORM LO ތʃe[ũR[hXV܂B
	 * ̃\bhŃgUNV̊JnȂтɏIsĂ܂B
	 *
	 * @param params p[^B<br>
	 * ȉ̒lݒ肳Ă邱Ƃ҂Ă܂B<br>
	 * <table border="1">
	 * 	<tr>
	 * 		<th>L[</th>
	 * 		<th>l</th>
	 * 	</tr>
	 * 	<tr>
	 * 		<td>LOID</td>
	 * 		<td>XV郌R[hLOID</td>
	 * 	</tr>
	 * 	<tr>
	 * 		<td>LoPropertyDef.MATERIALID</td>
	 * 		<td>XV郌R[h̋ID</td>
	 * 	</tr>
	 * 	<tr>
	 * 		<td>LoPropertyDef.WINHEIGHT</td>
	 * 		<td>XV郌R[h̃EBhETCY(c)</td>
	 * 	</tr>
	 * 	<tr>
	 * 		<td>LoPropertyDef.WINWIDTH</td>
	 * 		<td>XV郌R[h̃EBhETCY()</td>
	 * 	</tr>
	 * </table><br>
	 * @throws LOException f[^XVŃG[ꍇB
	 */
	public synchronized void update(Hashtable params) throws LOException {
		// \bhJnO
		DebugLog.write(
			this.getClass(),
			"HEAD update(" + params + ")",
			DebugLog.ROW);

		// f[^ANZXNX
		DataAccess dataAccess = null;

		try {
			dataAccess = new DataAccess(TABLE_NAME);
			// gUNVJn
			dataAccess.trans(params);
			// XV
			updateAction(params, dataAccess);
			// R~bg
			dataAccess.commit();
		}
		catch (SQLException e) {
			DebugLog.write(this.getClass(), e, DebugLog.HIGHT);
			// [obN
			try {
				dataAccess.rollback();
			}
			catch (Exception ex) {
			}
			throw new LOException(e.getMessage());
		}

		// \bhIO
		DebugLog.write(
			this.getClass(),
			"TAIL update(" + params + ")",
			DebugLog.ROW);
	}

	/**
	 * SCORM LO ތʃe[u烌R[h폜܂B<br>
	 * ̃\bhŃgUNV̊JnȂтɏIsĂ܂B<br>
	 *
	 * @param params p[^B<br>
	 * ȉ̒lݒ肳Ă邱Ƃ҂Ă܂B<br>
	 * <table border="1">
	 * 	<tr>
	 * 		<th>L[</th>
	 * 		<th>l</th>
	 * 	</tr>
	 * 	<tr>
	 * 		<td>CONDITION_KEY</td>
	 * 		<td>폜郌R[h̏ƂȂWHEREB</td>
	 * 	</tr>
	 * 	<tr>
	 * 		<td>LoPropertyDef#LOID</td>
	 * 		<td>
	 * 			폜郌R[hLOIDB
	 * 			CONDITION_KEYݒ肳ĂȂꍇɎgpB
	 * 		</td>
	 * 	</tr>
	 * </table><br>
	 * @throws LOException f[^폜ŃG[ꍇB
	 */
	public synchronized void delete(Hashtable params) throws LOException {
		// \bhJnO
		DebugLog.write(
			this.getClass(),
			"HEAD delete(" + params + ")",
			DebugLog.ROW);

		// f[^ANZXNX
		DataAccess dataAccess = null;

		try {
			dataAccess = new DataAccess(TABLE_NAME);
			// gUNVJn
			dataAccess.trans(params);
			// 폜
			deleteAction(params, dataAccess);
			// R~bg
			dataAccess.commit();
		}
		catch (Exception e) {
			DebugLog.write(this.getClass(), e, DebugLog.HIGHT);
			// [obN
			try {
				dataAccess.rollback();
			}
			catch (Exception ex) {
			}
			throw new LOException(e.getMessage());
		}

		// \bhIO
		DebugLog.write(
			this.getClass(),
			"TAIL delete(" + params + ")",
			DebugLog.ROW);
	}

	/**
	 * SCORM LOʃe[u烌R[h擾܂B<br>
	 *
	 * @param params p[^B<br>
	 * ȉ̒lݒ肳Ă邱Ƃ҂Ă܂B<br>
	 * <table border="1">
	 * 	<tr>
	 * 		<th>L[</th>
	 * 		<th>l</th>
	 * 	</tr>
	 * 	<tr>
	 * 		<td>CONDITION_KEY</td>
	 * 		<td>郌R[h̏ƂȂWHEREB</td>
	 * 	</tr>
	 * 	<tr>
	 * 		<td>LoPropertyDef#LOID</td>
	 * 		<td>
	 * 			郌R[hLOIDB
	 * 			CONDITION_KEYݒ肳ĂȂꍇɎgpB
	 * 		</td>
	 * 	</tr>
	 * </table><br>
	 * @return ɊYLOf[^̔zB
	 *          YLOf[^ȂꍇAvfO̔z߂܂B
	 * @throws LOException f[^ŃG[ꍇB
	 */
	public ScormLoData[] getLoData(Hashtable params) throws LOException {
		// \bhJnO
		DebugLog.write(
			this.getClass(),
			"HEAD getLoData(" + params + ")",
			DebugLog.ROW);

		// ̃\bh̖߂lB
		ScormLoData[] records = null;
		// f[^ANZXNX
		DataAccess dataAccess = null;
		try {
			dataAccess = new DataAccess(TABLE_NAME);
			// gUNVJn
			dataAccess.trans(params);
			records = getLoData(params, dataAccess);
			// =================================================================
			// R~bg
			dataAccess.commit();
		}
		catch (SQLException e) {
			DebugLog.write(ScormLoDataAccess.class, e, DebugLog.HIGHT);
			// [obN
			try {
				dataAccess.rollback();
			}
			catch (Exception ex) {
			}
			throw new LOException(e.getMessage());
		}
		catch (LOException e) {
			DebugLog.write(ScormLoDataAccess.class, e, DebugLog.HIGHT);
			// [obN
			try {
				dataAccess.rollback();
			}
			catch (Exception ex) {
			}
			throw e;
		}

		// \bhIO
		DebugLog.write(
			this.getClass(),
			"TAIL getLoData(" + params + ") return " + records,
			DebugLog.ROW);

		return records;
	}


	/**
	 * SCORM LOʃe[u烌R[h擾܂B<br>
	 * @param params p[^B<br>
	 * ȉ̒lݒ肳Ă邱Ƃ҂Ă܂B<br>
	 * <table border="1">
	 * 	<tr>
	 * 		<th>L[</th>
	 * 		<th>l</th>
	 * 	</tr>
	 * 	<tr>
	 * 		<td>CONDITION_KEY</td>
	 * 		<td>郌R[h̏ƂȂWHEREB</td>
	 * 	</tr>
	 * 	<tr>
	 * 		<td>LoPropertyDef#LOID</td>
	 * 		<td>
	 * 			郌R[hLOIDB
	 * 			CONDITION_KEYݒ肳ĂȂꍇɎgpB
	 * 		</td>
	 * 	</tr>
	 * </table><br>
	 * @param dataAccess f[^ANZXNXB
	 *                    ̃\bhł̓gUNV𑀍삵Ă܂B
	 * @return ɊYLOf[^̔zB
	 *          YLOf[^ȂꍇAvfO̔z߂܂B
	 * @throws LOException f[^ŃG[ꍇB
	 */
	public static ScormLoData[] getLoData(
			Hashtable params, DataAccess dataAccess) throws LOException {
		// \bhJnO
		DebugLog.write(
			ScormLoDataAccess.class,
			"HEAD getLoData(" + params
			+ "," + "DataAccess[" + dataAccess + "])",
			DebugLog.ROW);

		ScormLoData[] records = null;

		// =====================================================================
		// NG[̑gݗ
		// ̎擾
		String condition = (String) params.get(CONDITION_KEY);
		// 擾ĂȂꍇ
		if (condition == null) {
			String loID = (String) params.get(LoPropertyDef.LOID);
			if (loID != null) {
				condition =
					" WHERE " + LoPropertyDef.LOID + "='" + loID + "'";
			}
			else {
				condition = "";
			}
		}
		String strSQL =
			"SELECT * FROM " + TABLE_NAME + condition;

		// ʃZbg
		ResultSet rs = null;
		// ʃtO
		boolean success = false;
		try {
			// NG[s
			rs = dataAccess.executeQuery(strSQL);
			// =================================================================
			// f[^̎擾
			Vector recordList = new Vector();
			while (rs.next()) {
				ScormLoData record = new ScormLoData();
				// ZbVR[hɃRs[
				record.setLoID(
					ChangeEncode.setChar(
						rs.getString(LoPropertyDef.LOID)));
				record.setMaterialID(
					ChangeEncode.setChar(
						rs.getString(LoPropertyDef.MATERIALID)));
				record.setWinHeight(
					ChangeEncode.setChar(
						rs.getString(LoPropertyDef.WINHEIGHT)));
				record.setWinWidth(
					ChangeEncode.setChar(
						rs.getString(LoPropertyDef.WINWIDTH)));

				// ʊi[pVectorɊi[
				recordList.add(record);
			}
			// =================================================================
			// zɕϊ
			records = new ScormLoData[recordList.size()];
			recordList.copyInto(records);
			// tryubN̍Ō܂ŏ΁AB
			success = true;
		}
		catch (SQLException e) {
			throw new LOException(e.getMessage());
		}
		finally {
			// ʃZbgB
			// tOƂȂĂꍇ̂݁AĂяoɃX[
			if (rs != null) {
				try {
					rs.close();
				}
				catch (Exception e) {
					if (success) {
						DebugLog.write(
							ScormLoDataAccess.class, e, DebugLog.HIGHT);
						throw new LOException(e.getMessage());
					}
				}

			}
		}

		// \bhIO
		DebugLog.write(
			ScormLoDataAccess.class,
			"TAIL getLoData("
				+ params + "," + "DataAccess[" + dataAccess + "])"
			+ " return " + records,
			DebugLog.ROW);

		return records;
	}

	/**
	 * SCORM LO ތʃe[uɃR[h}܂B<br>
	 * ̃\bhł̓gUNV̊Jn܂͏I͍s܂B
	 *
	 * @param params p[^B<br>
	 * ȉ̒lݒ肳Ă邱Ƃ҂Ă܂B<br>
	 * <table border="1">
	 * 	<tr>
	 * 		<th>L[</th>
	 * 		<th>l</th>
	 * 	</tr>
	 * 	<tr>
	 * 		<td>PropertyDef.LOID</td>
	 * 		<td>}郌R[hLOID</td>
	 * 	</tr>
	 * 	<tr>
	 * 		<td>LoPropertyDef.MATERIALID</td>
	 * 		<td>}郌R[h̋ID</td>
	 * 	</tr>
	 * 	<tr>
	 * 		<td>PropertyDef.WINHEIGHT</td>
	 * 		<td>}郌R[h̃EBhETCY(c)</td>
	 * 	</tr>
	 * 	<tr>
	 * 		<td>LoPropertyDef.WINWIDTH</td>
	 * 		<td>}郌R[h̃EBhETCY()</td>
	 * 	</tr>
	 * </table><br>
	 * @param dataAccess f[^ANZXEIuWFNgB
	 * @throws SQLException f[^}ŃG[ꍇB
	 */
	private void insertAction(Hashtable params, DataAccess dataAccess)
		throws SQLException {

		// nbVKvȃf[^̂ݒo
		Hashtable htbData = extractValues(params);
		// o^pSQL𐶐܂
		String query = dataAccess.getInsertSQL(htbData);

		// o^s
		dataAccess.execute(query);
	}

	/**
	 * SCORM LO ތʃe[u烌R[h폜܂B<br>
	 * ̃\bhł̓gUNV̊Jn܂͏I͍s܂B
	 *
	 * @param params p[^B<br>
	 * ȉ̒lݒ肳Ă邱Ƃ҂Ă܂B<br>
	 * <table border="1">
	 * 	<tr>
	 * 		<th>L[</th>
	 * 		<th>l</th>
	 * 	</tr>
	 * 	<tr>
	 * 		<td>CONDITION_KEY</td>
	 * 		<td>폜郌R[h̏ƂȂWHEREB</td>
	 * 	</tr>
	 * 	<tr>
	 * 		<td>LOID</td>
	 * 		<td>
	 * 			폜郌R[hLOIDB
	 * 			CONDITION_KEYݒ肳ĂȂꍇɎgpB
	 * 		</td>
	 * 	</tr>
	 * </table><br>
	 * @param dataAccess f[^ANZXEIuWFNgB
	 * @throws SQLException f[^XVŃG[ꍇB
	 */
	private void deleteAction(Hashtable params, DataAccess dataAccess)
		throws SQLException {

		// ̎擾
		String strCondition = (String) params.get(CONDITION_KEY);

		// 擾ĂȂꍇALOIDɗpB
		if (strCondition == null) {
			String strLoID = (String) params.get(LoPropertyDef.LOID);
			if (strLoID != null) {
				strCondition =
					" WHERE " + LoPropertyDef.LOID + "='" + strLoID + "'";
			}
		}
		if (strCondition == null) {
			strCondition = "";
		}
		// 폜pSQL
		String strSQL =
			"DELETE FROM " + TABLE_NAME + " " + strCondition;

		// 폜s
		dataAccess.execute(strSQL);
	}
	/**
	 * }܂͍XVŃR[h̒lݒɗpL[^l𒊏o܂B<br>
	 * @param params oƂȂnbVe[uB
	 *                ȉ̃L[ƒl܂܂Ă邱Ƃ҂Ă܂B<br>
	 * <table border="1">
	 * 	<tr>
	 * 		<th>L[</th>
	 * 		<th>l</th>
	 * 	</tr>
	 * 	<tr>
	 * 		<td>LOID</td>
	 * 		<td>}܂͍XVLOID</td>
	 * 	</tr>
	 * 	<tr>
	 * 		<td>LoPropertyDef.MATERIALID</td>
	 * 		<td>}܂͍XV鋳ID</td>
	 * 	</tr>
	 * 	<tr>
	 * 		<td>LoPropertyDef.WINHEIGHT</td>
	 * 		<td>}܂͍XVEBhETCY(c)</td>
	 * 	</tr>
	 * 	<tr>
	 * 		<td>LoPropertyDef.WINWIDTH</td>
	 * 		<td>}܂͍XVEBhETCY()</td>
	 * 	</tr>
	 * </table><br>
	 * @return params\̃L[ŒolÃL[Ŋi[nbVe[uB
	 *          paramsɓo^ĂȂꍇ́Ao^ȂB
	 */
	private Hashtable extractValues(Hashtable params) {
		// \bhJnO
		DebugLog.write(
			this.getClass(),
			"HEAD extractValues(" + params + ")",
			DebugLog.ROW);

		Hashtable returned = new Hashtable();
		String[] keys = new String[] {
			// LOID
			LoPropertyDef.LOID,
			// ID
			LoPropertyDef.MATERIALID,
			// WindowTCY(c)
			LoPropertyDef.WINHEIGHT,
			// WindowTCY()
			LoPropertyDef.WINWIDTH,
		};
		ScormLoUtil.copyValues(returned, params, keys);

		// \bhIO
		DebugLog.write(
			this.getClass(),
			"TAIL extractValues(" + params + ") return " + returned,
			DebugLog.ROW);
		return returned;
	}

	/**
	 * o^AXṼf[^gݗĂ܂.
	 * @see jp.co.ntt.lms.lo.LoDataAccess#changeData(java.util.Hashtable)
	 */
	protected Hashtable changeData( Hashtable htbParam ) {

		return extractValues( htbParam );
	}
}
