/////////////////////////////////////////////////////////////////
//Copyright (C) 2005 NTT CORPORATION.
//
//Loge[uf[^ANZXNX
//
//ύX
//2005.02.10  VK쐬   F
//
//@\
//
//OLMSJX^}CYɔLoge[uf[^ANZXNXłB
//
/////////////////////////////////////////////////////////////////

package jp.co.ntt.lms.xmo.Lo.LoExtend;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;

import jp.co.ntt.lms.xmo.Lo.LoTable;
import jp.co.ntt.lms.xmo.Message.Message;
import jp.co.ntt.lms.xmo.MessageData;
import jp.co.ntt.lms.xmo.util.DebugLog;
import jp.co.ntt.lms.xmo.util.ChangeEncode;
import jp.co.ntt.lms.xmo.DataAccess;
import jp.co.ntt.lms.lo.LOException;

/**
 * OLMS@\JX^}CYFLOge[uf[^ANZXNX
 * @author Katsuhiko Kagami(UNITEC)
 * @version 1.0
 */
public class LoExtendDataAccess
	implements LoExtendMessage, LoTable, LoExtendTable 
{

	/**
     * ftHgRXgN^
     */
    public LoExtendDataAccess()
	{
    }

	/**
	 * LoExtende[u֌s܂B<BR>
	 * ȉ̏HashtableɊi[ēnĂB
	 * <PRE>
	 *             key                     
	 *          ---------------------------------------------
	 *             CONDITION_KEY           
	 *          ---------------------------------------------
	 * </PRE>
	 * @param htData 
	 * @return String (Iꍇ̂)
	 * @exception LOException f[^x[XG[ꍇ
	 */
	public Vector select( Hashtable htData )
		throws LOException
	{
		// f[^null̂Ƃ
		if( htData == null ) {
			throw new LOException( getMessageData( PARAM_WAR ) );
		}

		// ߂l
		Vector vecReturn = new Vector();
		// f[^ANZXNXCX^X܂
		DataAccess objDataAccess = new DataAccess(LOEXTEND_TABLE_NAME);
		try {
			// gUNVJn
			objDataAccess.trans();
			// s\bh
			vecReturn = selectAction( htData, objDataAccess );
			// R~bg
			objDataAccess.commit();
		}
		catch( SQLException e ) {
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			// f[^x[XG[ݒ
			throw new LOException( getMessageData( DB_ERR ) );
		}
		return vecReturn;
	}

	/**
	 * s\bhłB<BR>
	 * p[^̃`FbNуgUNV̊Ǘ
	 * ʃ\bhōsĂB<BR>
	 * @param htbParam 
	 * @return Vector 
	 * @exception SQLException DBG[ꍇ
	 */
	private Vector selectAction( Hashtable htbParam, DataAccess objDataAccess )
		throws SQLException
	{

		// SQL̑gݗ
		StringBuffer sbSQL = new StringBuffer();
		sbSQL.append( "SELECT * FROM " + LOEXTEND_TABLE_NAME );
		// ̎擾
		String strCondition = (String)htbParam.get( CONDITION_KEY );
		if( strCondition != null ) {
			sbSQL.append( strCondition );
		}

		// NG[s܂
		ResultSet rs = objDataAccess.executeQuery(sbSQL.toString());

		Vector vecReturn = new Vector();
		while(rs.next()) {
			String strLoID = ChangeEncode.setChar( rs.getString( LO_ID ) );
			String strBuy = ChangeEncode.setChar( rs.getString( LOEXTEND_BUY ) );
			String strKeyword1 = ChangeEncode.setChar( rs.getString( LOEXTEND_KEYWORD1 ) );
			String strKeyword2 = ChangeEncode.setChar( rs.getString( LOEXTEND_KEYWORD2 ) );
			String strKeyword3 = ChangeEncode.setChar( rs.getString( LOEXTEND_KEYWORD3 ) );
			String strKeyword4 = ChangeEncode.setChar( rs.getString( LOEXTEND_KEYWORD4 ) );
			String strKeyword5 = ChangeEncode.setChar( rs.getString( LOEXTEND_KEYWORD5 ) );

			LoExtendRecord objData = new LoExtendRecord(strLoID, strBuy, 
					strKeyword1, strKeyword2, strKeyword3, strKeyword4, strKeyword5);
			vecReturn.add( objData );
		}

		return vecReturn;
	}
	
	/**
	 * LoExtende[u֓o^s܂B<BR>
	 * ȉ̏HashtableɊi[ēnĂB<BR>
	 * Ȃe[u̎L[ȊOȗꍇ͏ȗtB[hɂ
	 * Nullli[܂B
	 * <PRE>
	 *             key                     
	 *          ---------------------------------------------
	 *             LOID                    LoID
	 *             LOEXTEND_BUY            wXe[^X
	 *             LOEXTEND_KEYWORD1       LOL[[h1
	 *             LOEXTEND_KEYWORD2       LOL[[h2
	 *             LOEXTEND_KEYWORD3       LOL[[h3
	 *             LOEXTEND_KEYWORD4       LOL[[h4
	 *             LOEXTEND_KEYWORD5       LOL[[h5
	 *          ---------------------------------------------
	 * </PRE>
	 * @param htData o^
	 * @exception LOException f[^x[XG[ꍇ
	 */
	synchronized public void insert( Hashtable htData )
		throws LOException
	{
		// ]f[^null̂Ƃ
		if( htData == null ) {
			// p[^G[X[
			throw new LOException( getMessageData( PARAM_WAR ) );
		}

		// f[^ANZXNXCX^X܂
		DataAccess objDataAccess = new DataAccess(LOEXTEND_TABLE_NAME);
		try {
			// gUNVJn
			objDataAccess.trans();

			// o^s܂
			insertAction( htData, objDataAccess );

			// R~bg
			objDataAccess.commit();
		}
		catch( SQLException e ) {
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			// f[^x[XG[ݒ
			throw new LOException( getMessageData( DB_ERR ) );
		}

		return;
	}

	/**
	 * o^s\bhłB<BR>
	 * ̃e[uɓo^sAGroupAndPeopleǗXMO
	 * ɐeq֌Wo^܂B
	 * p[^̃`FbNуgUNV̊Ǘ
	 * ʃ\bhōsĂB<BR>
	 * @param htbParam o^
	 * @exception LOException p[^G[ꍇ
	 * @exception SQLException DBG[ꍇ
	 */
	private void insertAction( Hashtable htbParam, DataAccess objDataAccess )
		throws SQLException, LOException
	{
		String strLoID = (String)htbParam.get( LO_ID );
		if( strLoID != null ) {
			// R[hɑ݂ꍇ͗O𔭐B
			if( objDataAccess.isExit(htbParam, LO_ID, LOEXTEND_TABLE_NAME) ) {
				throw new LOException( getMessageData( EXIST_RECORD_WAR ) );
			}
		}
		
		// o^p̃f[^Zbg܂
		Hashtable htbData = getData( htbParam );
		// o^pSQL𐶐܂
		String strSQL = objDataAccess.getInsertSQL(htbData);
		// o^s
		objDataAccess.execute( strSQL );
	}
	
	/**
	 * LoExtende[u֍XVs܂B<BR>
	 * ȉ̏HashtableɊi[ēnĂB<BR>
	 * ȗtB[h͍XV܂B
	 * <PRE>
	 *             key                     
	 *          ---------------------------------------------
	 *             LOID                    LoID
	 *             LOEXTEND_BUY            wXe[^X
	 *             LOEXTEND_KEYWORD1       LOL[[h1
	 *             LOEXTEND_KEYWORD2       LOL[[h2
	 *             LOEXTEND_KEYWORD3       LOL[[h3
	 *             LOEXTEND_KEYWORD4       LOL[[h4
	 *             LOEXTEND_KEYWORD5       LOL[[h5
	 *          ---------------------------------------------
	 *             CONDITION_KEY           XV
	 *          ---------------------------------------------
	 * </PRE>
	 * @param htData XV
	 * @exception LOException f[^x[XG[ꍇ
	 */
	synchronized public void update( Hashtable htData )
		throws LOException
	{
		// f[^null̂Ƃ
		if( htData == null ) {
			// p[^G[X[
			throw new LOException( getMessageData( PARAM_WAR ) );
		}

		// f[^ANZXNXCX^X܂
		DataAccess objDataAccess = new DataAccess(LOEXTEND_TABLE_NAME);
		try {

			// gUNVJn
			objDataAccess.trans();

			// XVs܂
			updateAction( htData, objDataAccess );

			// R~bg
			objDataAccess.commit();
		}
		catch( SQLException e ) {
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			// f[^x[XG[ݒ
			throw new LOException( getMessageData( DB_ERR ) );
		}

		return;
	}

	/**
	 * XVs\bhłB<BR>
	 * p[^̃`FbNуgUNV̊Ǘ
	 * ʃ\bhōsĂB<BR>
	 * @param htbParam XV
	 * @exception LOException DBG[ꍇ
	 * @exception SQLException DBG[ꍇ
	 */
	private void updateAction( Hashtable htbParam, DataAccess objDataAccess  )
		throws SQLException, LOException
	{
		///////////////////////////////////////////////////////
		// XVΏۃR[h̑݃`FbNs܂
		///////////////////////////////////////////////////////
		String strCondition = (String)htbParam.get( CONDITION_KEY );
		if( strCondition != null ) {
			if( !objDataAccess.isExit( strCondition ) ) {
				throw new LOException( getMessageData( NOEXIST_RECORD_WAR ) );
			}
		}
		// XV郌R[h擾܂
		Vector vecSelect = selectAction( htbParam, objDataAccess );
		// o^p̃f[^Zbg܂
		Hashtable htbData = getData( htbParam );
		
		String strSQL = objDataAccess.getUpdateSQL(htbData);
		// ̐ݒ
		if( strCondition != null ) {
			strSQL += strCondition;
		}
		
		// o^s
		objDataAccess.execute( strSQL );
	}
	
	/**
	 * LoExtende[u֍폜s܂B<BR>
	 * ȉ̏HashtableɊi[ēnĂB
	 * <PRE>
	 *             key                     
	 *          ---------------------------------------------
	 * 	@@@@@@DELETE_LOID             폜ΏۂLOID
	 *          ---------------------------------------------
	 *             CONDITION_KEY           폜
	 *          ---------------------------------------------
	 * </PRE>
	 * @param htData 폜
	 * @return String (Iꍇ̂)
	 * @exception LOException f[^x[XG[ꍇ
	 */
	synchronized public void delete( Hashtable htData )
		throws LOException
	{
		// f[^ANZXNXCX^X܂
		DataAccess objDataAccess = new DataAccess(LOEXTEND_TABLE_NAME);
		try {
			// gUNVJn
			objDataAccess.trans();
			// 폜s\bhs܂
			deleteAction( htData, objDataAccess );
			// R~bg
			objDataAccess.commit();
		}
		catch( SQLException e ) {
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			// f[^x[XG[ݒ
			throw new LOException( getMessageData( DB_ERR ) );
		}
		return;
	}

	/**
	 * 폜s\bhłB<BR>
	 * p[^̃`FbNуgUNV̊Ǘ
	 * ʃ\bhōsĂB<BR>
	 * @param htbParam 폜
	 * @exception LOException p[^G[ꍇ
	 * @exception SQLException DBG[ꍇ
	 * MOD 2005/02/25 START
	 */
	synchronized public void deleteAction( Hashtable htbParam, DataAccess objDataAccess )
		throws LOException, SQLException
	{
		///////////////////////////////////////////////////////
		// 폜ΏۃR[h̑݃`FbNs܂
		///////////////////////////////////////////////////////
		String strCondition = (String)htbParam.get( CONDITION_KEY );
		if( strCondition != null ) {
			if( !objDataAccess.isExit( strCondition ) ) {
				throw new LOException( getMessageData( NOEXIST_RECORD_WAR ) );
			}
		}

		// LOLoge[uf[^폜pSQL̑gݗ
		StringBuffer sbSQL = new StringBuffer();
		sbSQL.append( "DELETE FROM " );
		sbSQL.append( LOEXTEND_TABLE_NAME );
		if (strCondition != null) {
			sbSQL.append( " " );
			sbSQL.append( strCondition );
		}

		// SQLs
		objDataAccess.execute( sbSQL.toString() );
	}
	
	/**
	 * o^AXṼf[^gݗĂ܂
	 * @param htData
	 * @return Hashtable
	 */
	private Hashtable getData( Hashtable htbParam ) {
		Hashtable htbData = new Hashtable();
		putData( htbData, htbParam, LO_ID );
		putData( htbData, htbParam, LOEXTEND_BUY );
		putData( htbData, htbParam, LOEXTEND_KEYWORD1 );
		putData( htbData, htbParam, LOEXTEND_KEYWORD2 );
		putData( htbData, htbParam, LOEXTEND_KEYWORD3 );
		putData( htbData, htbParam, LOEXTEND_KEYWORD4 );
		putData( htbData, htbParam, LOEXTEND_KEYWORD5 );
		return htbData;
	}

	/**
	 * SHashtableɒǉ郁\bhł
	 */
	private void putData( Hashtable htbData,  Hashtable htbParam, String strKey ) {
		String strValue = (String)htbParam.get( strKey );
		if( strValue != null ) {
			htbData.put( strKey, strValue );
		}
	}

	/**
	 * bZ[WIuWFNg쐬܂
	 * @param strMessageID bZ[WID
	 * @return MessageData bZ[WIuWFNg OnullԂ܂
	 */
	private MessageData getMessageData( String strMessageID) {
		MessageData objMessage = null;
		try {
			objMessage = Message.getInstance().getMessageData( strMessageID, MSG_FIEL_PATH, MSG_FILE_NAME );
		}
		catch( Exception e ) {

		}
		return objMessage;
	}

}
