/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

//
//	[M XMO ev[gǗNX
//			ύX
//				2004.01.08	VK쐬		Hm
//
package jp.co.ntt.lms.xmo.Mail;

import java.util.*;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

import jp.co.ntt.lms.xmo.util.DebugLog;
import jp.co.ntt.lms.xmo.util.FileControl;

import jp.co.ntt.lms.xmo.Assignments.AssignmentsEnv;
import jp.co.ntt.lms.xmo.Lo.LoEnv;
import jp.co.ntt.lms.xmo.LumpInsert.LumpInsertEnv;
import jp.co.ntt.lms.xmo.People.PeopleEnv;

/**
 * [M XMO ev[gǗNXłB<BR>
 */
public class TemplateControl {

	// G[bZ[W`
	// ev[gt@CȂ
	private static final String ERR_MSG_NOFILE 
		= "i[tH_A܂̓[ev[gt@C݂Ȃ";

	// ev[gtH_Ȃ
	private static final String ERR_MSG_NODIR 
		= "[ev[g̊i[wȂ";

	// ATCev[gt@CꗗiLbVpj
	private static ArrayList mobjAssignTemplateList = new ArrayList();

	// WXgev[gt@CꗗiLbVpj
	private static ArrayList mobjRegistTemplateList = new ArrayList();

	// ꊇo^ev[gt@CꗗiLbVpj
	private static ArrayList mobjLumpTemplateList = new ArrayList();

	// ev[gt@CꗗiLbVpj
	private static ArrayList mobjStimulateTemplateList = new ArrayList();

	// SingltonƂē삷邽߂Ɏ̃CX^Xێ܂ 
	private static TemplateControl objTempCtrl = new TemplateControl();

	/**
	 * CX^Xԋp܂
	 * @param objTempCtrl 
	 */
	public static TemplateControl getInstance() {
		return objTempCtrl;
	}

	/**
	 * [ev[g̃t@CXg擾B<BR>
	 * [ev[gt@C݂ȂꍇA
	 * Xgێ܂B
	 * @return ϊ㕶
	 */
	public	void setTemplateFileList() throws Exception {

		// ev[gʖɑΉtH_z̃ev[gt@C
		// ꗗ擾B
		// t@CAyу^CgNListŃLbVB
		// List̓ev[gʖɕێB
		
		// [Uo^^XVp̃[ev[gt@CXg擾܂B
		PeopleEnv objEnv = PeopleEnv.getInstance();
		String strUserPath = objEnv.getSendMailPath();
		mobjRegistTemplateList = this.getTemplateFile(strUserPath);

		// ꊇo^p̃[ev[gt@CXg擾܂B
		LumpInsertEnv objLumpEnv = LumpInsertEnv.getInstance();
		String strLumpPath = objLumpEnv.getSendMailPath();
		mobjLumpTemplateList = this.getTemplateFile(strLumpPath);

		// ATCp̃[ev[gt@CXg擾܂B
		AssignmentsEnv objAssignEnv = AssignmentsEnv.getInstance();
		String strAssignPath = objAssignEnv.getSendMailPath();
		mobjAssignTemplateList = this.getTemplateFile(strAssignPath);

		// p̃[ev[gt@CXg擾܂B
		LoEnv objStimEnv = LoEnv.getInstance();
		String strStimPath = objStimEnv.getSendMailPath();
		mobjStimulateTemplateList = this.getTemplateFile(strStimPath);

		return;
	}
	
	/**
	 * w肵[ʂ̃ev[gt@Cꗗ擾܂B<BR>
	 * @param srcMailType [
	 * @return boolean t@CꍇTrueAȂ
	 */
	public Vector getTemplateList(String strMailType)
	{

		// t@CAyу^Cg͋NListŃLbVĂ܂A
		// N̓ւ̂ŁAt@C̑݃`FbNA^CX^v
		// rsAList̍ڂƓƂ܂B
		Vector vcTemplateList = new Vector();
		try {

			String strTemplatePath = "";
			
			// [ʂɂev[gt@C̎擾ύX܂B
			if ( strMailType.compareTo( MailConst.TYPE_LUMP ) == 0 )
			{	// [ʂuꊇo^v̏ꍇ
				// ꊇo^p̃[ev[gt@Ci[pXw肵܂B
				LumpInsertEnv objEnv = LumpInsertEnv.getInstance();
				strTemplatePath = objEnv.getSendMailDir();
				synchronized (mobjLumpTemplateList)
				{
					refresh(mobjLumpTemplateList, strTemplatePath);
					for( int i=0; i<mobjLumpTemplateList.size(); i++ )
					{
						vcTemplateList.add(mobjLumpTemplateList.get(i));
					}
				}
			}
			else if ( strMailType.compareTo( MailConst.TYPE_ASSIGNMENTS ) == 0)
			{	// [ʂuATCv̏ꍇ
				// ATCp̃[ev[gt@Ci[pXw肵܂B
				AssignmentsEnv objEnv = AssignmentsEnv.getInstance();
				strTemplatePath = objEnv.getSendMailDir();
				synchronized (mobjAssignTemplateList)
				{
					refresh(mobjAssignTemplateList, strTemplatePath);
					// Vectorɓĕԋp܂B
					for( int i=0; i<mobjAssignTemplateList.size(); i++ )
					{
						vcTemplateList.add(mobjAssignTemplateList.get(i));
					}
				}
			}
			else if ( strMailType.compareTo( MailConst.TYPE_STIMULATE ) == 0)
			{	// [ʂuv̏ꍇ
				// p̃[ev[gt@Ci[pXw肵܂B
				LoEnv objEnv = LoEnv.getInstance();
				strTemplatePath = objEnv.getSendMailDir();
				synchronized (mobjStimulateTemplateList)
				{
					refresh(mobjStimulateTemplateList, strTemplatePath);
					// Vectorɓĕԋp܂B
					for( int i=0; i<mobjStimulateTemplateList.size(); i++ )
					{
						vcTemplateList.add(mobjStimulateTemplateList.get(i));
					}
				}
				
			}
			else if ( strMailType.compareTo( MailConst.TYPE_REGIST ) == 0)
			{	// [ʂuWXgv̏ꍇ
				// WXgp̃[ev[gt@Ci[pXw肵܂B
				PeopleEnv objEnv = PeopleEnv.getInstance();
				strTemplatePath = objEnv.getSendMailDir();
				synchronized (mobjRegistTemplateList)
				{
					refresh(mobjRegistTemplateList, strTemplatePath);
					for( int i=0; i<mobjRegistTemplateList.size(); i++ )
					{
						vcTemplateList.add(mobjRegistTemplateList.get(i));
					}
				}
			}
			return( vcTemplateList );
		}
		catch( Exception ex )
		{
			// G[R[hԋp
			DebugLog.write( this.getClass(), ex, DebugLog.HIGHT );
			return vcTemplateList;
		}
	}
	
	/**
	 * w肵[ev[gt@C̏擾܂B<BR>
	 * @param strTemplatePath ev[gt@C
	 * @return	ev[g
	 */
	public MailTemplateVO getTemplateInfo(String strTemplatePath)
		throws Exception
	{
		MailTemplateVO voMailInfo = null;

		try {
			voMailInfo = new MailTemplateVO();

			try {
				
				// [ev[gǂݍ݃CX^X𐶐܂B
				MailParser objParser = new MailParser( strTemplatePath );
		
				// ev[g擾܂B
				String strSubject = objParser.getSubject();	// 薼擾
				String strBody = objParser.getBody();			// {擾
				String strFrom = objParser.getFrom();			// M擾
		
				voMailInfo.setSubject( strSubject );
				voMailInfo.setBody( strBody );
				voMailInfo.setFromAddress( strFrom );
		
				voMailInfo.setErrCode( MailConst.RESULT_SUCCESS );
				return voMailInfo;
					
			}
			catch( FileNotFoundException ex )
			{
				// ev[gt@C݂ȂG[bZ[Wԋp
				voMailInfo.setErrCode( MailConst.RESULT_TEMPEXIST_ERR );
				return voMailInfo;
			}
			catch( IOException ex )
			{
				// ev[gt@Cǂݍ݃G[̏ꍇ
				voMailInfo.setErrCode( MailConst.RESULT_TEMPREAD_ERR );
				return voMailInfo;
			}
			catch( Exception ex ){
				// G[R[hԋp
				DebugLog.write( this.getClass(), ex, DebugLog.HIGHT );
				voMailInfo.setErrCode( MailConst.RESULT_INTERNAL_ERR );
				return voMailInfo;
			}
		}
		catch ( Exception ex ){
			// G[R[hԋp
			DebugLog.write( this.getClass(), ex, DebugLog.HIGHT );
			voMailInfo = new MailTemplateVO();
			voMailInfo.setErrCode( MailConst.RESULT_INTERNAL_ERR );
			return voMailInfo;
		}

	}

	/**
	 * ev[gꗗɕύXꍇALbVXgXV܂B<BR>
	 * @param objTemplateList LbVXg
	 * @param strTemplatePath ev[gt@Ci[pX
	 * @return	Ȃ
	 */
	private void refresh( ArrayList objTemplateList, String strTemplatePath )
		throws Exception
	{

		// ev[gt@C̑݃`FbNAyу^CX^v̔rs܂B
		checkTemplatePathStatus( strTemplatePath, objTemplateList );

		// ev[gꗗɕύXꍇALbVXgXV܂B
		refreshCacheList( objTemplateList );

	}

	/**
	 * ev[gt@C̑݃`FbNsAɃLbV
	 * ǂݍłev[gt@CXgƂ̓Ƃ܂B<BR>
	 * @param strTemplateFolder ev[gt@Ci[
	 * @param objTemplateList  Ƃ郁[ʃev[g
	 * 							LbVXg
	 * @return	Ȃ
	 */
	private void checkTemplatePathStatus( String strTemplateFolder, ArrayList objTemplateList )
			throws Exception
	{
		// ݂̃t@Cꗗ擾܂B
		ArrayList objCurrTempList = getTemplateFile( strTemplateFolder );

		int iCacheSize = objTemplateList.size();
		for( int i = iCacheSize-1; i >= 0; i-- )
		{
			// LbVt@C擾A݃`FbNs܂B
			TemplateListVO voCachePath = 
				(TemplateListVO)objTemplateList.get(i);
			String strPath = voCachePath.getTemplatePath();
	
			// LbṼt@CA擾t@Cꗗɑ݂邩
			// mF܂B
			int j = 0;
			for( ; j < objCurrTempList.size(); j++ )
			{
				TemplateListVO voNowPath = 
					(TemplateListVO)objCurrTempList.get(j);
	
				// ** ev[gt@C̑݃`FbN **
				if ( strPath.compareTo(voNowPath.getTemplatePath()) == 0 )
				{	// ev[gt@C݂ꍇ
	
					// ** ^CX^v̔r **
					long lTimeStump = voCachePath.getLastModified();
					if ( lTimeStump != voNowPath.getLastModified() )
					{	// ^CX^vXVĂꍇ
	
						// LbV̏XV܂B
						// iύXLbVɂ́AXVtO𗧂Ă܂Bj
						voCachePath.setLastModified( 
								voNowPath.getLastModified());
					}
					break;
				}
			}
			if ( j != objCurrTempList.size() )
			{
				// vt@CɂẮA擾ꗗ폜܂B
				objCurrTempList.remove(j);
			}
			else
			{	// 擾ꗗƈvȂev[gLbVXgɂꍇ
	
				// t@C݂ȂꍇALbVXg폜܂B
				File objFilePath = new File(strPath);
				if(objFilePath.exists() == false)
				{
					objTemplateList.remove(i);
				}
			}
		}
	
		// 擾ꗗɎcev[gt@CXgɂẮAVKt@C
		// ƂăLbVXgɒǉ܂B
		for( int j = 0; j < objCurrTempList.size(); j++ )
		{
			TemplateListVO voNowPath = (TemplateListVO)objCurrTempList.get(j);
			objTemplateList.add(voNowPath);
		}
		return;
	}

	/**
	 * w肵tH_A݂ev[gt@C
	 * SĎ擾܂B<BR>
	 * @param strFolderName ev[gt@Ci[
	 * @return	ArrayList ev[gt@Cꗗ
	 */
	private ArrayList getTemplateFile( String strFolderName ) 
			throws Exception
	{
		try {
			ArrayList objTempLateList = new ArrayList();

			if ( (strFolderName == null) || 
				(strFolderName.equals("") == true) )
			{	// i[悪w肳ĂȂꍇ

				// ̃ev[gXgԋp܂B
				DebugLog.write( this.getClass(), 
					ERR_MSG_NODIR, DebugLog.HIGHT );
				return objTempLateList;
			}

			
			String[] strTempList = 
				FileControl.getFileList(strFolderName,FileControl.FILE_LIST);
			if(strTempList.length == 0)
			{	// i[悪݂Ȃꍇ

				// ̃ev[gXgԋp܂B
				DebugLog.write( this.getClass(), ERR_MSG_NOFILE,
					DebugLog.HIGHT );
				return objTempLateList;
			}

			for(int i=0; i<strTempList.length; i++)
			{
				File objFilePath = new File(strTempList[i]);
				long lTime = objFilePath.lastModified();

				// 擾t@CgqoB
				String exp = strTempList[i].substring(strTempList[i].length()-4);
				if (exp.equalsIgnoreCase(".xml") == true)
				{	// ogqXMLt@C̏ꍇ
					String strTemplatePath = strFolderName + strTempList[i];

					// ev[gꗗVO𐶐܂B
					TemplateListVO template = new TemplateListVO();
					template.setTemplatePath(strTemplatePath);
					// ev[gt@Cݒ
					template.setTemplateFileName(strTempList[i]);
					template.setLastModified(lTime);

					// ԋpXgɎ擾ev[gt@CXg
					// i[܂B
					if (strTempList[i].equalsIgnoreCase(MailConst.DEFAULT_XML_NAME) == true)
					{	// ftHg̃ev[gXMLXg̐擪Ɋi[܂B
						objTempLateList.add(0, template);
					}
					else
					{	// ̑̃ev[gXML͏XgɊi[܂B
						objTempLateList.add(template);
					}
				}
			}
			// Default.xml݂ȂꍇÃev[gXg̐擪ɐݒ肵܂B
			String fileName = ((TemplateListVO)objTempLateList.get(0)).getTemplateFileName();
			if (!fileName.equals(MailConst.DEFAULT_XML_NAME)) {
				objTempLateList.add(0, new TemplateListVO());
			}

			return objTempLateList;
		}
		catch( Exception ex )
		{
			return new ArrayList();
		}
	}
	
	/**
	 * w胊Xg̓eXV܂B
	 * Xg̗vfɍ폜tOĂꍇ́Avf폜܂B
	 * XVtOĂꍇ́Aēxev[g̓ep[X܂B
	 * @param  vcTempList ev[gXg
	 */
	private void refreshCacheList( ArrayList objTemplateList ) 
			throws Exception
	{

		try
		{
			// w胊Xg̓eXV܂B
			int iCacheSize = objTemplateList.size();
			for( int i = iCacheSize-1; i >= 0; i-- )
			{
				TemplateListVO voCachePath =
					(TemplateListVO)objTemplateList.get(i);
				if ( voCachePath.isUpdate() == true )
				{	// XVĂ̂́Aēxf[^p[X܂B

					try
					{
						// [ev[gǂݍ݃CX^X𐶐܂B
						MailParser objParser = 
							new MailParser(voCachePath.getTemplatePath());

						// ev[g^Cg擾܂B
						String strTitle = objParser.getTitle();	// ^Cg^O薼擾
						voCachePath.setTitle( strTitle );
					}
					catch( FileNotFoundException ex )
					{	// LbVXg̍XVɃt@CȂG[ꍇ
						// LbVXg炻̃t@C폜܂B
						objTemplateList.remove(i);
					}
					catch( IOException ex )
					{	// LbVXg̍XVIOG[ꍇ
						// LbVXg炻̃t@C폜܂B
						objTemplateList.remove(i);
					}
				}
			}
		}
		catch ( Exception ex )
		{
			throw ex;
		}
	}

	/**
	 * [ʖɑΉtH_pX擾B<BR>
	 * @param  strMailType	[
	 * @return strTemplateDirectoryPath ev[gtH_pX
	 */
	public String getTemplateDirectoryPath(String strMailType) {

		String strTemplateDirectoryPath = null;

		try {
			// [Uo^^XVp̃[ev[gt@CXg擾܂B
			if ( strMailType.equals( MailConst.TYPE_REGIST ) ) {
				PeopleEnv objEnv = PeopleEnv.getInstance();
				strTemplateDirectoryPath = objEnv.getSendMailDir();
	
			// ꊇo^p̃[ev[gt@CXg擾܂B
			} else if ( strMailType.equals( MailConst.TYPE_LUMP ) ) {
				LumpInsertEnv objLumpEnv = LumpInsertEnv.getInstance();
				strTemplateDirectoryPath = objLumpEnv.getSendMailDir();
	
			// ATCp̃[ev[gt@CXg擾܂B		
			} else if ( strMailType.equals( MailConst.TYPE_ASSIGNMENTS ) ) {
				AssignmentsEnv objAssignEnv = AssignmentsEnv.getInstance();
				strTemplateDirectoryPath = objAssignEnv.getSendMailDir();
	
			// p̃[ev[gt@CXg擾܂B
			} else if ( strMailType.equals( MailConst.TYPE_STIMULATE ) ) {
				LoEnv objStimEnv = LoEnv.getInstance();
				strTemplateDirectoryPath = objStimEnv.getSendMailDir();
			}
		} catch (Exception ex) {
			return null;
		}
		return strTemplateDirectoryPath;
	}

}