//
// CopyRight (C) 2002, IPA All rights reserved.
//
//	Objective
//
//	ύX
//		2002.12.25  VK쐬
//

package jp.co.ntt.lms.lo.scorm.kernel;

import java.math.BigDecimal;

import jp.co.ntt.lms.lo.scorm.kernel.exception.SystemException;

/**
 * Objective class
 * Objective\NX<BR>
 */
public abstract class Objective {
	/** 0.0000BigDecimal */
	protected static final BigDecimal zero = new BigDecimal("0.0").setScale(4, BigDecimal.ROUND_HALF_UP);

	/** objective identifier */
	protected String objectiveID;

	/** objective progress status */
	protected boolean objectiveProgressStatus;

	/** objective satisfied status */
	protected boolean objectiveSatisfiedStatus;

	/** objective measure status */
	protected boolean objectiveMeasureStatus;

	/** objective normalized measure */
	protected BigDecimal objectiveNormalizedMeasure;

	// 20040801 ADD NTTR
	/* primaryObjectIDǂ */
	protected boolean hasPrimaryID = false;
	
	/**
	 * ftHgRXgN^
	 */
	public Objective() {
		initializeObjective();
	}

	/**
	 * Objectivȅ<BR>
	 */
	public void initializeObjective() {
		this.initializeObjectiveProgress();
		this.initializeObjectiveMeasure();
	}

	/**
	 * objectivȅ̏<BR>
	 */
	private void initializeObjectiveProgress() {
		objectiveProgressStatus = false;
		objectiveSatisfiedStatus = false;
	}

	/**
	 * objectivȅ̏<BR>
	 */
	private void initializeObjectiveMeasure() {
		objectiveMeasureStatus = false;
		objectiveNormalizedMeasure = zero;
	}

	/**
	 * I<BR>
	 */
	public void terminate() throws SystemException {}

	/**
	 * objectiveID̎擾
	 *
	 * @return ObjectiveID
	 */
	public String getObjectiveID() {
		return objectiveID;
	}

	/**
	 * objectiveID̐ݒ<BR>
	 *
	 * @param id ݒ肷ID<BR>
	 */
	public void setObjectiveID(String id) {
		objectiveID = id;
	}

	/**
	 * Objective Progress Status ̃Zbg
	 *
	 * @param result true/false
	 */
	public void setObjectiveProgressStatus(boolean result) throws SystemException {
		objectiveProgressStatus = result;
	}

	/**
	 * Objective satisfied status ̃Zbg
	 *
	 * @param result true/false
	 */
	public void setObjectiveSatisfiedStatus(boolean result) throws SystemException {
		objectiveSatisfiedStatus = result;
	}

	/**
	 * Objective Measure status ̃Zbg
	 *
	 * @param result true/false
	 */
	public void setObjectiveMeasureStatus(boolean result) throws SystemException {
		objectiveMeasureStatus = result;
	}

	/**
	 * objective normalized measurẽZbg
	 *
	 * @param measure
	 */
	public void setObjectiveNormalizedMeasure(BigDecimal measure) throws SystemException {
		objectiveNormalizedMeasure = measure;
	}

	/**
	 * Objective progress Status̎擾
	 *
	 * @return boolean true/false
	 */
	public boolean getObjectiveProgressStatus() throws SystemException {
		return objectiveProgressStatus;
	}

	/**
	 * objective satisfied status ̎擾
	 *
	 * @return boolean true/false
	 */
	public boolean getObjectiveSatisfiedStatus() throws SystemException {
		return objectiveSatisfiedStatus;
	}

	/**
	 * objective measure status̎擾
	 *
	 * @return boolean true/false
	 */
	public boolean getObjectiveMeasureStatus() throws SystemException {
		return objectiveMeasureStatus;
	}

	/**
	 * objective normalized meadsure̎擾
	 *
	 * @return BigDecimal normalized measure̎擾
	 */
	public BigDecimal getObjectiveNormalizedMeasure() throws SystemException {
		return objectiveNormalizedMeasure;
	}
	
	//	20040801 ADD NTTR
	/**
	 * primaryObjectiveID邩Ȃ̎擾
	 *
	 * @return IDǂ̃tOԋp
	 */
	public boolean getHasObjectiveID() throws SystemException {
		return hasPrimaryID;
	}
	
	/**
	 * primaryObjectiveIDȂƂZbg
	 *
	 * @return IDĂȂƂZbg
	 */
	public void setHasObjectiveID() throws SystemException {
		hasPrimaryID = true;	
	}
}
