#! /bin/sh

# ソースをコンパイルしてインストールする
main() {

# 引数取得
# ソースが格納されたディレクトリ
src_dir=$1
# ファイル名
filename=$2
# 展開先
dest_dir=$3
# インストール先
install_dir=$4

# インストール
cd ${src_dir}
gzip -dc ${filename} | tar xvf -
cd ${dest_dir}
./configure --prefix=${install_dir}/apache2 \
--disable-actions \
--disable-autoindex \
--disable-cgi \
--disable-include \
--disable-userdir \
--enable-headers=shared \
--enable-usertrack=shared \
--enable-rewrite=shared \
--with-mpm=prefork
#--enable-ssl=shared \
make
make install

# 後始末
rm -Rf ${dest_dir}

}

main $*
