#! /bin/sh

main() {

##### 初期設定 #####
LOG=jboss-shutdown.log
LOOP_NUM=12
NOPAUSE=y

##### 引数取得 #####
JBOSS_ESB_HOME=$1
JBOSS_HOME=$2
JBOSS_CONFIG_NAME=$3
TMP_DIR=$4

##### 初期処理 #####
JBOSS_HOME=${JBOSS_HOME}/
TMP_DIR=${TMP_DIR}/

##### JBossの強制終了を試みる #####
"${JBOSS_HOME}bin/shutdown.sh" -S 2> /dev/nul
EXIT_CODE=$?
if [ "${EXIT_CODE}" = "0" ]; then
	rm -f "${TMP_DIR}${LOG}"
	for i in `seq 1 ${LOOP_NUM}`; do
		sleep 5
		"${JBOSS_HOME}bin/shutdown.sh" -S 2>> "${TMP_DIR}${LOG}"
		grep 'Connection refused' "${TMP_DIR}${LOG}" > /dev/nul
		EXIT_CODE=$?
		if [ "${EXIT_CODE}" = "0" ]; then
			echo JBossの終了確認ができました。
			break
		else
			if [ "${i}" = "${LOOP_NUM}" ]; then
				echo JBossの終了確認ができませんでした。
				break
			fi
			echo "JBossの終了確認ができないためリトライします。(${i})"
		fi
	done
	rm -f "${TMP_DIR}${LOG}"
else
	echo JBossは起動していません。
fi

##### アンインストール #####
rm -f ${JBOSS_HOME}*.*
rm -Rf "${JBOSS_ESB_HOME}"
rm -Rf "${JBOSS_HOME}server/esb"
rm -f ${JBOSS_HOME}bin/run-${JBOSS_CONFIG_NAME}.sh

}

main $*
