#! /bin/sh

main() {

##### 初期設定 #####
BIN_DIR=bin
MODULES_DIR=modules
MOD_JK_FILE_NAME=mod_jk.so
HTTPD_EXE=apachectl

##### 引数取得 #####
PRODUCT_NAME=$1
PRODUCT_VER=$2
ARC_DIR=$3
ARC_FILENAME=$4
SRC_DIR=$5
DEST_DIR=$6
APACHE_HOME=$7

##### 初期処理 #####
ARC_DIR=${ARC_DIR}/
SRC_DIR=${SRC_DIR}/
DEST_DIR=${DEST_DIR}/
APACHE_HOME=${APACHE_HOME}/

##### 存在チェック #####
cd "${APACHE_HOME}${MODULES_DIR}"
if [ ! -f "${MOD_JK_FILE_NAME}" ]; then
	echo ${PRODUCT_NAME}は、インストールされていません。
	exit 0
fi
cd "${APACHE_HOME}${BIN_DIR}"
if [ ! -f "apxs" ]; then
	echo Apacheがインストールされていないためコンパイルできません。
	exit 0
fi

##### アップデート #####
echo "${PRODUCT_NAME}のアップデート処理をします。(Ver.${PRODUCT_VER})"
# ここにアップデート処理を記述する(パッチ当てなど)

rm -f "${APACHE_HOME}${MODULES_DIR}/${MOD_JK_FILE_NAME}"
cd "${APACHE_HOME}${BIN_DIR}"
if [ -f "${HTTPD_EXE}" ]; then
	"${HTTPD_EXE}" stop
fi
mkdir -p "${SRC_DIR}"
cp -p -f "${ARC_DIR}${ARC_FILENAME}" "${SRC_DIR}"
cd "${SRC_DIR}"
gzip -dc "${ARC_FILENAME}" | tar xvf -
rm -f "${ARC_FILENAME}"
cd "${DEST_DIR}/native"
./configure --with-apxs="${APACHE_HOME}${BIN_DIR}/apxs"
make
make install

}

main $*
