#! /bin/sh

main() {

##### 初期設定 #####
LOOP_NUM=12
ROOT_PASSWORD=root

##### 引数取得 #####
SRC_DIR=$1
FILENAME=$2
INSTALL_DIR=$3
DEST_DIR=$4

##### 初期処理 #####
SRC_DIR=${SRC_DIR}/
INSTALL_DIR=${INSTALL_DIR}/

##### インストール ######
cd ${INSTALL_DIR}
cp -pf ${SRC_DIR}${FILENAME} ${INSTALL_DIR}
cd ${INSTALL_DIR}
# TODO S.Fujii 本来ここで消すべきではない(特にdataディレクトリ)
rm -rf ${DEST_DIR}
tar -xzvf ${FILENAME}
rm -rf ${FILENAME}
cd ${DEST_DIR}

##### MySQLセットアップ #####
rm -f /usr/local/mysql
ln -s ${INSTALL_DIR}${DEST_DIR} /usr/local/mysql
cd /usr/local/mysql
chown -R mysql:mysql .

./scripts/mysql_install_db --user=mysql
chown -R root .
chown -R mysql data

##### rootユーザーパスワード変更 #####
/usr/local/mysql/bin/mysqld_safe --user=mysql 1> /dev/nul 2> /dev/nul &
for i in `seq 1 ${LOOP_NUM}`; do
	sleep 5
	/usr/local/mysql/bin/mysqladmin -u root status > /dev/nul
	EXIT_CODE=$?
	if [ "${EXIT_CODE}" = "0" ]; then
		echo MySQLの起動確認ができました。
		break
	else
		if [ "${i}" = "${LOOP_NUM}" ]; then
			echo MySQLの起動確認ができませんでした。
			break
		fi
		echo "MySQLの起動確認ができないためリトライします。(${i})"
	fi
done
/usr/local/mysql/bin/mysqladmin -u root password ${ROOT_PASSWORD}
/usr/local/mysql/bin/mysqladmin -u root -p${ROOT_PASSWORD} shutdown

}

main $*
