#! /bin/sh

main() {

##### 初期設定 #####
BIN_DIR=bin
MYSQL_EXE=mysqld

##### 引数取得 #####
PRODUCT_NAME=$1
PRODUCT_VER=$2
MYSQL_HOME=$3

##### 初期処理 #####
MYSQL_HOME=${MYSQL_HOME}/

##### バージョンチェック #####
cd "${MYSQL_HOME}${BIN_DIR}"
if [ ! -f "${MYSQL_EXE}" ]; then
	echo ${PRODUCT_NAME}は、インストールされていません。
	exit 0
fi
INSTALLED_VER=`"./${MYSQL_EXE}" -V | grep 'MySQL' | awk '{print $3;}'`
if [ "${INSTALLED_VER}" = "${PRODUCT_VER}" ]; then
	echo "${PRODUCT_NAME}は、最新版がインストールされています。(Ver.${INSTALLED_VER})"
	exit 0
fi
if [ "${INSTALLED_VER}" = "5.0.x" ]; then
	echo "処理なし" > /dev/nul
else
	echo "${PRODUCT_NAME}は、アップデート対象のバージョンではありません。(Ver.${INSTALLED_VER})"
	exit 0
fi

##### アップデート #####
echo "${PRODUCT_NAME}のアップデート処理をします。(Ver.${INSTALLED_VER} -> Ver.${PRODUCT_VER})"
# ここにアップデート処理を記述する(パッチ当てなど)

}

main $*
